/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.biolegato.gdesupport.canvas.GDECanvas;
import org.biolegato.gdesupport.canvas.GDECanvasObject;
import org.biolegato.gdesupport.data.ClipboardWrapper;
import org.biolegato.gdesupport.data.ColourMask;
import org.biolegato.gdesupport.data.Dataset;
import org.biolegato.gdesupport.data.Seq;
import org.biolegato.gdesupport.files.DataFormat;
import org.biolegato.main.BLMain;

public class GDETextArea
extends JComponent
implements ListDataListener,
GDECanvasObject,
KeyListener,
MouseMotionListener,
MouseListener {
    protected int rowHeight = 1;
    protected int columnWidth = 1;
    private GDECanvas canvas = null;
    protected boolean insertMode = false;
    protected boolean selectionMove = false;
    protected boolean selectionMouse = false;
    protected int row = 0;
    protected int column = 0;
    private int sx = 0;
    private int sy = 0;
    private int minsx = 0;
    private int minsy = 0;
    private int maxsx = 0;
    private int maxsy = 0;
    protected JPopupMenu popup = new JPopupMenu();
    protected Dataset datamodel;
    public final GDETextArea blTextAreaSelf = this;
    private int longestline = 0;
    public static final Color SELECTFG = Color.WHITE;
    public static final Color SELECTBG = Color.BLUE;
    public static final long serialVersionUID = 7526472295622777004L;

    public GDETextArea(GDECanvas canvas, Dataset datamodel) {
        this.datamodel = datamodel;
        this.canvas = canvas;
        datamodel.addListDataListener(this.blTextAreaSelf);
        this.addKeyListener(this.blTextAreaSelf);
        this.addMouseListener(this.blTextAreaSelf);
        this.addMouseMotionListener(this.blTextAreaSelf);
        this.popup.add(new JMenuItem(canvas.cutAction));
        this.popup.add(new JMenuItem(canvas.copyAction));
        this.popup.add(new JMenuItem(canvas.pasteAction));
        this.setFont(canvas.currentFont);
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.setFocusTraversalKeysEnabled(false);
        this.refreshSize();
        this.setDoubleBuffered(true);
        this.repaint();
    }

    public void copyClipboard() {
        StringBuffer originalSequence = null;
        StringBuffer currentSequence = new StringBuffer();
        Seq current = null;
        int countseq = 0;
        int ylength = this.maxsy - this.minsy + 1;
        Seq[] result = null;
        if (!this.isSelectionEmpty()) {
            result = new Seq[ylength];
            for (int count = this.minsy; count <= this.maxsy; ++count) {
                int lineLength = this.getLineLength(count);
                if (this.minsx >= lineLength || (current = this.datamodel.getLine(count)) == null) continue;
                if (!this.isSelectionEmpty()) {
                    originalSequence = current.getSequence();
                    int xstart = this.minsx;
                    int xlength = (originalSequence.length() > this.maxsx ? this.maxsx : originalSequence.length()) - xstart + 1;
                    if (xstart >= 0 && xlength > 0) {
                        currentSequence.append(originalSequence.subSequence(xstart, xlength));
                    }
                    current = new Seq(current.getType(), current.getName(), currentSequence, current.getDirection(), current.getTopology(), current.getStrandedness());
                } else {
                    current = (Seq)current.clone();
                }
                result[countseq] = current;
                ++countseq;
            }
            if (countseq < ylength) {
                Seq[] temp = new Seq[countseq];
                System.arraycopy(result, 0, temp, 0, countseq);
                result = temp;
            }
        } else {
            result = new Seq[]{};
        }
        ClipboardWrapper.setClipboard(result);
    }

    public void paintComponent(Graphics gfx) {
        try {
            int maxrows = this.datamodel.getSize();
            Rectangle area = gfx.getClipBounds();
            int startcol = area.x / this.columnWidth;
            int startrow = area.y / this.rowHeight;
            int collength = area.width / this.columnWidth + 2;
            int numrows = area.height / this.rowHeight + 2;
            int endcol = startcol + collength;
            int endrow = startrow + area.height / this.rowHeight + 2;
            int stoprow = endrow < maxrows ? endrow : maxrows - 1;
            int fontcenterXmod = this.columnWidth / 2;
            int fontcenterYmod = -5;
            int xstartfill = startcol * this.columnWidth;
            int ystartfill = startrow * this.rowHeight;
            int xstart = xstartfill + fontcenterXmod;
            int ystart = ystartfill + -5 + this.rowHeight;
            int startSelectX = this.columnWidth * this.minsx + fontcenterXmod;
            int endSelectX = this.columnWidth * this.maxsx + fontcenterXmod;
            int selectXlength = endSelectX - startSelectX;
            int cursorX = this.column * this.columnWidth;
            int cursorY = this.row * this.rowHeight;
            int minsxcol = Math.max(0, this.minsx - startcol);
            int maxsxcol = Math.max(0, this.maxsx - startcol);
            int sxlength = maxsxcol - minsxcol;
            int drawrow = -1;
            int drawend = -1;
            int drawcolend = -1;
            int sequenceLength = -1;
            char[] print = new char[collength];
            Seq currentLine = null;
            ColourMask mask = null;
            try {
                gfx.setFont(this.getFont());
                gfx.setColor(this.getBackground());
                gfx.fillRect(startcol * this.columnWidth, startrow * this.rowHeight, collength * this.columnWidth, numrows * this.rowHeight);
                if (this.maxsx > startcol && this.minsx < endcol && this.maxsy > startrow && this.minsy < stoprow) {
                    gfx.setColor(SELECTBG);
                    gfx.fillRect(startSelectX, Math.max(startrow, this.minsy) * this.rowHeight - -2, selectXlength, Math.min(stoprow, this.maxsy - this.minsy + 1) * this.rowHeight);
                }
                int rowcount = startrow;
                int currenty = ystart;
                while (rowcount <= stoprow) {
                    currentLine = this.datamodel.getLine(rowcount);
                    sequenceLength = currentLine.getSequence().length();
                    drawend = endcol < sequenceLength ? endcol : sequenceLength;
                    drawcolend = drawend - startcol;
                    if (drawcolend > 0) {
                        currentLine.getSequence().getChars(startcol, drawend, print, 0);
                        mask = currentLine.getMask();
                        if (rowcount >= this.minsy && rowcount <= this.maxsy) {
                            if (minsxcol > 0) {
                                if (mask != null) {
                                    mask.drawString(gfx, print, xstart, currenty, 0, minsxcol);
                                } else {
                                    gfx.setColor(ColourMask.FOREG);
                                    gfx.drawChars(print, 0, Math.min(drawcolend, minsxcol), xstart, currenty);
                                }
                            }
                            if (this.maxsx > startcol && this.minsx < drawend) {
                                gfx.setColor(SELECTFG);
                                gfx.drawChars(print, minsxcol, Math.min(drawcolend, maxsxcol) - minsxcol, startSelectX, currenty);
                            }
                            if (maxsxcol < drawcolend) {
                                if (mask != null) {
                                    mask.drawString(gfx, print, endSelectX, currenty, maxsxcol, drawcolend - maxsxcol);
                                } else {
                                    gfx.setColor(ColourMask.FOREG);
                                    gfx.drawChars(print, maxsxcol, drawcolend - maxsxcol, endSelectX, currenty);
                                }
                            }
                        } else if (mask != null) {
                            mask.drawString(gfx, print, xstart, currenty, 0, drawcolend);
                        } else {
                            gfx.setColor(ColourMask.FOREG);
                            gfx.drawChars(print, 0, drawcolend, xstart, currenty);
                        }
                    }
                    ++rowcount;
                    currenty += this.rowHeight;
                }
                if (this.hasFocus() && gfx.hitClip(cursorX, cursorY, 1, this.rowHeight)) {
                    gfx.setColor(this.getForeground());
                    gfx.drawLine(cursorX, cursorY, cursorX, cursorY + this.rowHeight);
                }
            }
            catch (Throwable th) {
                System.err.println("---- Printing failed! ----");
                System.err.println("    maxrows: " + maxrows);
                System.err.println("    startcol: " + startcol);
                System.err.println("    startrow: " + startrow);
                System.err.println("    collength: " + collength);
                System.err.println("    numrows: " + numrows);
                System.err.println("    endcol: " + endcol);
                System.err.println("    endrow: " + endrow);
                System.err.println("    stoprow: " + stoprow);
                System.err.println("    fontcenterXmod: " + fontcenterXmod);
                System.err.println("    fontcenterYmod: -5");
                System.err.println("    xstartfill: " + xstartfill);
                System.err.println("    ystartfill: " + ystartfill);
                System.err.println("    xstart: " + xstart);
                System.err.println("    ystart: " + ystart);
                System.err.println("    startSelectX: " + startSelectX);
                System.err.println("    endSelectX: " + endSelectX);
                System.err.println("    selectXlength: " + selectXlength);
                System.err.println("    cursorX: " + cursorX);
                System.err.println("    cursorY: " + cursorY);
                System.err.println("    minsxcol: " + minsxcol);
                System.err.println("    maxsxcol: " + maxsxcol);
                System.err.println("    sxlength: " + sxlength);
                System.err.println("    drawrow: " + drawrow);
                System.err.println("    drawend: " + drawend);
                System.err.println("    drawcolend: " + drawcolend);
                System.err.println("    sequenceLength: " + sequenceLength);
                System.err.println("    print: " + print);
                System.err.println("    print.length: " + print.length);
                System.err.println("    currentLine: " + currentLine);
                System.err.println("    mask: " + mask);
                th.printStackTrace(System.err);
            }
        }
        catch (Throwable th) {
            System.err.println("---- Variable initialization failed! ----");
            th.printStackTrace(System.err);
        }
    }

    public final void setFont(Font font) {
        super.setFont(font);
        this.columnWidth = this.getFontMetrics(font).charWidth('G');
        this.rowHeight = this.getFontMetrics(font).getHeight();
        this.refreshSize();
        this.repaint();
    }

    public void keyTyped(KeyEvent event) {
        boolean canInsert = true;
        try {
            switch (event.getKeyChar()) {
                case '\b': 
                case '\u007f': {
                    break;
                }
                case '\n': {
                    if (this.row + 1 < this.datamodel.getSize()) {
                        this.changePosition(false, this.column, this.row + 1);
                    }
                    break;
                }
                case '\uffff': {
                    break;
                }
                default: {
                    if (!this.isSelectionEmpty()) {
                        this.gdeleteSection();
                    } else if (this.insertMode && this.datamodel.getSize() > 0 && this.getLineLength(0) > 0) {
                        canInsert = this.delete(this.column, this.row, 1, 0);
                    }
                    if (this.isSelectionEmpty() || !this.insertMode || canInsert) {
                        this.insert(this.column, this.row, new char[]{event.getKeyChar()}, true);
                        this.changePosition(false, this.column + 1, this.row);
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        event.consume();
    }

    public void keyPressed(KeyEvent event) {
        int backspacecol = 0;
        try {
            switch (event.getKeyChar()) {
                case '\b': {
                    if (!this.isSelectionEmpty()) {
                        this.gdeleteSection();
                        break;
                    }
                    if (this.row > 0 || this.column > 0) {
                        if (this.column <= 0 && this.row > 0) {
                            backspacecol = this.getLineLength(this.row - 1);
                        }
                        if (this.column - 1 >= 0 && this.delete(this.column - 1, this.row, 1, 0)) {
                            if (this.column <= 0 && this.row > 0) {
                                this.changePosition(false, backspacecol, this.row - 1);
                                break;
                            }
                            this.changePosition(false, this.column - 1, this.row);
                        }
                    }
                    break;
                }
                case '\u007f': {
                    if (!this.isSelectionEmpty()) {
                        this.gdeleteSection();
                        break;
                    }
                    if (this.datamodel.getSize() > 0 && this.getLineLength(0) > 0) {
                        this.delete(this.column, this.row, 1, 0);
                    }
                    break;
                }
                case '\uffff': {
                    switch (event.getKeyCode()) {
                        case 16: {
                            this.selectionMove = true;
                            break;
                        }
                        case 37: {
                            if (this.column > 0) {
                                this.changePosition(this.selectionMove, this.column - 1, this.row);
                                break;
                            }
                            if (this.row <= 0) break;
                            this.changePosition(this.selectionMove, this.getLineLength(this.row), this.row - 1);
                            break;
                        }
                        case 39: {
                            if (this.column + 1 <= this.getLineLength(this.row)) {
                                this.changePosition(this.selectionMove, this.column + 1, this.row);
                                break;
                            }
                            if (this.row + 1 >= this.datamodel.getSize()) break;
                            this.changePosition(this.selectionMove, 0, this.row + 1);
                            break;
                        }
                        case 38: {
                            if (this.row <= 0) break;
                            this.changePosition(this.selectionMove, this.column, this.row - 1);
                            break;
                        }
                        case 40: {
                            if (this.row + 1 >= this.datamodel.getSize()) break;
                            this.changePosition(this.selectionMove, this.column, this.row + 1);
                            break;
                        }
                        case 36: {
                            this.changePosition(this.selectionMove, 0, this.row);
                            break;
                        }
                        case 35: {
                            this.changePosition(this.selectionMove, this.getLineLength(this.row), this.row);
                            break;
                        }
                        case 65485: {
                            this.canvas.copyAction.actionPerformed(new ActionEvent(this, 1001, "copy"));
                            break;
                        }
                        case 65489: {
                            this.canvas.cutAction.actionPerformed(new ActionEvent(this, 1001, "copy"));
                            break;
                        }
                        case 65487: {
                            this.canvas.pasteAction.actionPerformed(new ActionEvent(this, 1001, "copy"));
                            break;
                        }
                        case 155: {
                            this.insertMode = !this.insertMode;
                            this.canvas.insertionMode(this.insertMode);
                            break;
                        }
                        default: {
                            if (!BLMain.debug) break;
                            BLMain.warning((String)("Unhandled key pressed --- getKeyChar() = " + event.getKeyChar() + "\tgetKeyCode() = " + event.getKeyCode()), (String)"BLTextArea");
                        }
                    }
                    if (this.column >= this.getLineLength(this.row)) {
                        this.changePosition(this.selectionMove, this.getLineLength(this.row), this.row);
                    }
                    break;
                }
                default: {
                    this.gdeleteSection();
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        event.consume();
    }

    public void keyReleased(KeyEvent event) {
        try {
            block1 : switch (event.getKeyChar()) {
                case '\uffff': {
                    switch (event.getKeyCode()) {
                        case 16: {
                            this.selectionMove = false;
                            break block1;
                        }
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        event.consume();
    }

    public void mouseClicked(MouseEvent event) {
        if (!event.isPopupTrigger()) {
            this.changePosition(this.selectionMove, Math.round(event.getX() / this.columnWidth), Math.round(event.getY() / this.rowHeight));
            this.requestFocus();
            this.requestFocusInWindow();
        }
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(this, event.getX(), event.getY());
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX(), event.getY());
        } else {
            this.selectionMouse = false;
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseDragged(MouseEvent event) {
        if (!event.isPopupTrigger() || !this.isSelectionEmpty()) {
            this.changePosition(this.selectionMouse || this.selectionMove, Math.round(event.getX() / this.columnWidth), Math.round(event.getY() / this.rowHeight));
            this.selectionMouse = true;
            this.requestFocus();
            this.requestFocusInWindow();
        }
    }

    public void mouseMoved(MouseEvent event) {
    }

    protected final void refreshSize() {
        int width = (this.longestline + 1) * this.columnWidth;
        int height = this.rowHeight * this.datamodel.getSize();
        this.setSize(width, height);
        this.setPreferredSize(this.getSize());
        this.revalidate();
    }

    public void paste() {
        Seq[] data = ClipboardWrapper.getClipboard();
        int minlength = Math.min(data.length, this.datamodel.getSize() - this.row);
        this.deleteSelection();
        for (int count = 0; count < minlength; ++count) {
            if (data[count] == null) continue;
            this.insert(this.column, this.row + count, data[count].getSequence().toString().toCharArray(), false);
        }
        if (minlength < data.length) {
            Seq[] temp = new Seq[data.length - minlength];
            System.arraycopy(data, minlength, temp, 0, data.length - minlength);
            this.datamodel.addSequences(minlength, Arrays.asList(temp));
        }
    }

    public void changeCase() {
        String data = null;
        StringBuffer sequence = null;
        if (!this.isSelectionEmpty()) {
            for (int y = this.minsy; y <= this.maxsy; ++y) {
                sequence = this.datamodel.getLine(y).getSequence();
                int slength = sequence.length();
                if (this.minsx >= slength) continue;
                int writelen = this.maxsx < slength ? this.maxsx : slength - 1;
                data = sequence.substring(this.minsx, writelen);
                if (Character.isUpperCase(data.charAt(this.minsx))) {
                    data.toLowerCase();
                } else {
                    data.toUpperCase();
                }
                sequence.replace(this.minsx, writelen, data);
            }
        }
    }

    public void insert(int x, int y, char[] text, boolean groupinsert) {
        Seq current = this.datamodel.getLine(y);
        int[] group = this.datamodel.getgroup(current.getGroupID());
        StringBuffer sequence = current.getSequence();
        if (groupinsert && group != null) {
            for (int number : group) {
                this.insert(x, number, text, false);
            }
        } else if (x < sequence.length() && !this.isProtectionsOn(current.getType(), current.getProtectAlignment(), current.getProtectAmbiguous(), current.getProtectUnambiguous(), text, 0, text.length)) {
            sequence.insert(x, text);
            current.modified();
            int xstart = x * this.columnWidth;
            int xwidth = (text.length + 1) * this.columnWidth;
            int ystart = this.row2Y(this.row);
            this.updateLength(this.row, this.row);
            this.getGraphics().copyArea(xstart, ystart, this.getWidth(), this.rowHeight, xwidth, 0);
            this.repaint(xstart, ystart, xwidth, this.rowHeight);
        }
    }

    public boolean delete(int x, int y, int w, int h) {
        boolean result = false;
        Seq current = null;
        int max = y + h;
        for (int count = y; count <= max; ++count) {
            int[] group;
            current = this.datamodel.getLine(count);
            if (current != null && (group = this.datamodel.getgroup(current.getGroupID())) != null) {
                for (int gln : group) {
                    if ((gln < y || gln > max) && gln < this.datamodel.getSize()) {
                        result |= this.pdelete(x, gln, w, 0);
                        continue;
                    }
                    if (gln < this.datamodel.getSize()) continue;
                    BLMain.error((String)("Invalid row number: " + gln), (String)"boolean GDETextArea.insert (char)");
                }
            }
            result |= this.pdelete(x, count, w, 0);
        }
        return result;
    }

    public boolean pdelete(int x, int y, int w, int h) {
        boolean result;
        char[] text = null;
        Seq current = null;
        int xend = x + w;
        boolean bl = result = this.datamodel.getSize() == 0 && y == 0 && x == 0 && w == 0;
        if (!result && this.datamodel.getSize() > 0 && y >= 0 && y + h < this.datamodel.getSize() && x >= 0 && w > 0) {
            text = new char[w];
            for (int count = y; count <= y + h; ++count) {
                current = this.datamodel.getLine(count);
                StringBuffer sequence = current.getSequence();
                int slength = sequence.length();
                if (x + 1 >= slength) continue;
                int copylength = xend < slength ? xend : slength - 1;
                sequence.getChars(x, copylength, text, 0);
                if (this.isProtectionsOn(current.getType(), current.getProtectAlignment(), current.getProtectAmbiguous(), current.getProtectUnambiguous(), text, 0, copylength + 1)) continue;
                sequence.delete(x, x + w);
                current.modified();
                result = true;
            }
        } else if (w == 0) {
            result = true;
        }
        return result;
    }

    public boolean gdeleteSection() {
        int x = this.minsx;
        int y = this.minsy;
        int w = this.maxsx - x;
        int h = this.maxsy - y;
        boolean result = false;
        if (!this.isSelectionEmpty() && this.delete(x, y, w, h)) {
            this.changePosition(false, x, y);
            result = true;
        }
        return result;
    }

    public void deleteSelection() {
        int x = this.minsx;
        int y = this.minsy;
        int w = this.maxsx - x;
        int h = this.maxsy - y;
        if (!this.isSelectionEmpty() && this.pdelete(x, y, w, h)) {
            this.changePosition(false, x, y);
        }
    }

    public int getLineLength(int line) {
        Seq seq = this.datamodel.getLine(line);
        return seq != null ? seq.getSequence().length() : 0;
    }

    public boolean isProtectionsOn(Seq.Type type, boolean protect_align, boolean protect_ambig, boolean protect_uambig, char[] test, int start, int end) {
        boolean protect;
        block10: {
            block11: {
                protect = false;
                if (!protect_ambig && !protect_uambig && !protect_align) break block10;
                if (type != Seq.Type.DNA && type != Seq.Type.RNA) break block11;
                block8: for (int count = start; !protect && count < end; ++count) {
                    switch (Character.toLowerCase(test[count])) {
                        case 'b': 
                        case 'd': 
                        case 'h': 
                        case 'i': 
                        case 'k': 
                        case 'm': 
                        case 'n': 
                        case 'r': 
                        case 's': 
                        case 'v': 
                        case 'w': 
                        case 'y': {
                            protect = protect_ambig;
                            continue block8;
                        }
                        case 'a': 
                        case 'c': 
                        case 'g': 
                        case 't': 
                        case 'u': {
                            protect = protect_uambig;
                            continue block8;
                        }
                        default: {
                            protect = protect_align;
                        }
                    }
                }
                break block10;
            }
            if (type != Seq.Type.PROTEIN) break block10;
            block9: for (int count = start; !protect && count < end; ++count) {
                switch (Character.toLowerCase(test[count])) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '-': {
                        protect = protect_align;
                        continue block9;
                    }
                    case '*': 
                    case 'b': 
                    case 'x': 
                    case 'z': {
                        protect = protect_ambig;
                        continue block9;
                    }
                    default: {
                        protect = protect_uambig;
                    }
                }
            }
        }
        return protect;
    }

    public void intervalAdded(ListDataEvent e) {
        this.updateLength(e.getIndex0(), e.getIndex1());
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(e.getIndex0());
        int dy = this.row2Y(e.getIndex1() + 1);
        int h = (int)this.getSize().getHeight() - y;
        this.getGraphics().copyArea(0, y, w, h, 0, dy);
        this.repaint(0, y, w, dy - y);
    }

    public void contentsChanged(ListDataEvent e) {
        this.updateLength(e.getIndex0(), e.getIndex1());
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(e.getIndex0());
        int h = this.row2Y(e.getIndex1() + 1);
        this.repaint(0, y, w, h);
    }

    public void intervalRemoved(ListDataEvent e) {
        this.updateLength(e.getIndex0(), e.getIndex1());
        this.refreshSize();
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(e.getIndex1() + 1);
        int dy = this.row2Y(e.getIndex0());
        int h = (int)this.getSize().getHeight() - y;
        this.getGraphics().copyArea(0, y, w, h, 0, dy);
    }

    protected void changePosition(boolean select, int newx, int newy) {
        int maxlines = this.datamodel.getSize() - 1;
        int oldx = this.column;
        int oldy = this.row;
        this.row = Math.max(0, Math.min(newy, maxlines));
        this.column = Math.max(0, Math.min(newx, this.getLineLength(newy)));
        if (select || oldx != this.sx || oldy != this.sy) {
            int x = Math.min(oldx, this.minsx) * this.columnWidth;
            int y = Math.min(oldy, this.minsy) * this.rowHeight;
            int w = (Math.max(oldx, this.maxsx) + 1) * this.columnWidth - x;
            int h = (Math.max(oldy, this.maxsy) + 1) * this.rowHeight - y;
            if (!select) {
                this.sx = this.column;
                this.sy = this.row;
            }
            this.repaint(x, y, w, h);
        } else {
            this.sx = this.column;
            this.sy = this.row;
            this.repaint(oldx * this.columnWidth, oldy * this.rowHeight, this.columnWidth, this.rowHeight);
        }
        this.canvas.cursorChange(this.column, this.row);
        this.scrollRectToVisible(new Rectangle(this.column * this.columnWidth, this.row * this.rowHeight, 1, 1));
        if (select && this.canvas != null) {
            this.canvas.selectionMade(this);
        }
        if (this.sx > this.column) {
            this.minsx = this.column;
            this.maxsx = this.sx;
        } else {
            this.minsx = this.sx;
            this.maxsx = this.column;
        }
        if (this.sy > this.row) {
            this.minsy = this.row;
            this.maxsy = this.sy;
        } else {
            this.minsy = this.sy;
            this.maxsy = this.row;
        }
        this.repaint();
    }

    public final void clearSelection() {
        this.changePosition(false, this.column, this.row);
    }

    public final boolean isSelectionEmpty() {
        return this.sx == this.column;
    }

    protected final int row2Y(int r) {
        return r * this.rowHeight;
    }

    public int rowSize() {
        return this.rowHeight;
    }

    public int columnSize() {
        return this.columnWidth;
    }

    public void updateLength(int start, int end) {
        end = Math.min(this.datamodel.getSize() - 1, end);
        start = Math.min(start, end);
        Math.max(0, start);
        for (int count = start; count <= end; ++count) {
            int newlength;
            Seq line = this.datamodel.getLine(count);
            if (line == null || (newlength = line.getSequence().length() + 1) <= this.longestline) continue;
            this.longestline = newlength;
        }
        this.refreshSize();
    }

    public void writeOut(DataFormat format, Appendable dest) throws IOException {
        int length = this.maxsx - this.minsx;
        for (int lineNumber = this.minsy; lineNumber <= this.maxsy; ++lineNumber) {
            format.translateTo(dest, this.datamodel.getLine(lineNumber), this.minsx, length);
        }
    }
}

