/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import org.biolegato.gdesupport.data.Seq;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataset
extends AbstractListModel {
    private final List<Seq> lines = new ArrayList<Seq>();
    private int maxGroup = 0;
    private Set<Seq>[] group2seq = new Set[30];
    private static final int DEFAULT_MAX_GROUPS = 30;

    public boolean addSequence(int y, Seq seq) {
        boolean result = false;
        if (seq != null && y >= 0 && y <= this.getSize()) {
            this.lines.add(y, seq);
            this.fireIntervalAdded(this, y, y);
            result = true;
        }
        return result;
    }

    public boolean addSequences(int y, Collection<Seq> seqs) {
        boolean result = false;
        if (seqs != null && seqs.size() > 0 && y >= 0 && y <= this.getSize()) {
            this.lines.addAll(y, seqs);
            this.fireIntervalAdded(this, y, y + seqs.size() - 1);
            result = true;
        }
        return result;
    }

    public void removeSequences(int[] lineNumbers) {
        Arrays.sort(lineNumbers);
        if (!this.lines.isEmpty() && lineNumbers != null) {
            int highindex;
            for (int lowindex = highindex = lineNumbers.length - 1; lowindex >= 0; --lowindex) {
                highindex = lowindex;
                while (lowindex > 0 && lineNumbers[lowindex - 1] == lineNumbers[lowindex] - 1) {
                    this.ungroup(this.lines.remove(lineNumbers[lowindex]));
                    --lowindex;
                }
                this.ungroup(this.lines.remove(lineNumbers[lowindex]));
                this.fireIntervalRemoved(this, lineNumbers[lowindex], lineNumbers[highindex]);
            }
        }
    }

    @Override
    public int getSize() {
        return this.lines.size();
    }

    public Seq getLine(int number) {
        return number >= 0 && number < this.getSize() ? this.lines.get(number) : null;
    }

    void sequenceChanged(int index) {
        this.fireContentsChanged(this, index, index);
    }

    public void group(int[] sequences) {
        int maxGroupStart = this.maxGroup;
        while (this.group2seq[this.maxGroup] != null) {
            ++this.maxGroup;
            this.maxGroup %= this.group2seq.length - 1;
            if (this.maxGroup != maxGroupStart) continue;
            Set[] temp = new Set[this.group2seq.length + 30];
            System.arraycopy(this.group2seq, 0, temp, 0, this.group2seq.length);
            this.group2seq = temp;
            break;
        }
        this.group2seq[this.maxGroup] = new HashSet<Seq>();
        for (int y : sequences) {
            Seq seq = this.lines.get(y);
            this.ungroup(seq);
            seq.groupID = this.maxGroup + 1;
            this.sequenceChanged(this.lines.indexOf(seq));
            this.group2seq[this.maxGroup].add(seq);
        }
    }

    public void ungroup(int[] sequences) {
        for (int y : sequences) {
            Seq seq = this.lines.get(y);
            this.ungroup(seq);
            seq.groupID = 0;
            this.sequenceChanged(this.lines.indexOf(seq));
        }
    }

    private void ungroup(Seq seq) {
        Set<Seq> group = null;
        if (seq != null && seq.groupID > 0 && seq.groupID <= this.group2seq.length && (group = this.group2seq[seq.groupID - 1]) != null) {
            group.remove(seq);
            if (group.size() <= 0) {
                this.group2seq[seq.groupID - 1] = null;
            }
        }
    }

    public int[] getgroup(int groupNumber) {
        int count = 0;
        int[] result = null;
        if (groupNumber > 0 && groupNumber <= this.group2seq.length && this.group2seq[groupNumber - 1] != null) {
            Set<Seq> group = this.group2seq[groupNumber - 1];
            result = new int[group.size()];
            for (Seq c : group) {
                result[count] = this.lines.indexOf(c);
                ++count;
            }
        }
        return result;
    }

    @Override
    public Object getElementAt(int index) {
        StringBuilder name = new StringBuilder();
        Seq seq = this.getLine(index);
        if (seq != null) {
            if (seq.groupID > 0) {
                name.append(seq.groupID).append(" ");
            } else {
                name.append("_ ");
            }
            name.append(seq.getName());
        }
        return name;
    }
}

