/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.files;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import org.biolegato.gdesupport.data.ColourMask;

public class CharacterColourMaskReader
extends FileFilter {
    public boolean accept(File f) {
        return true;
    }

    public String getDescription() {
        return "Character-based colour mask file";
    }

    public static ColourMask readColourMaskFile(File file) throws IOException {
        int tabIndex = 0;
        char[] characterArray = null;
        String line = "";
        String maskname = null;
        Color colour = Color.BLACK;
        BufferedReader reader = null;
        Color[] hash = new Color[36];
        reader = new BufferedReader(new FileReader(file.getPath()));
        do {
            if ((line = reader.readLine()) == null || "aa\tcolour".equals(line = line.trim().toLowerCase()) && "aa\tcolor".equals(line) || (tabIndex = line.indexOf(9)) < 0) continue;
            characterArray = line.substring(0, tabIndex).trim().toCharArray();
            colour = CharacterColourMaskReader.string2Colour(line.substring(tabIndex + 1).trim().toCharArray());
            for (char character : characterArray) {
                int hashpos = ColourMask.hash(character);
                if (hashpos < 0) continue;
                hash[hashpos] = colour;
            }
        } while (line != null);
        maskname = file.getName().toLowerCase();
        if (maskname.endsWith(".csv")) {
            maskname = maskname.substring(0, maskname.length() - 4);
        }
        return new ColourMask(ColourMask.MaskType.CHARACTER, maskname, hash);
    }

    private static Color string2Colour(char[] array) {
        int count = array.length >= 1 && array[0] == '#' ? 1 : 0;
        Color result = Color.BLACK;
        if (array.length - count >= 6) {
            int red = CharacterColourMaskReader.hex2dec(array[count + 0]) * 16 + CharacterColourMaskReader.hex2dec(array[count + 1]);
            int green = CharacterColourMaskReader.hex2dec(array[count + 2]) * 16 + CharacterColourMaskReader.hex2dec(array[count + 3]);
            int blue = CharacterColourMaskReader.hex2dec(array[count + 4]) * 16 + CharacterColourMaskReader.hex2dec(array[count + 5]);
            result = new Color(red, green, blue);
        }
        return result;
    }

    private static int hex2dec(char c) {
        int result = 0;
        if (c >= '1' && c <= '9') {
            result = 1 + (c - 49);
        } else if (c >= 'A' && c <= 'F') {
            result = 10 + (c - 65);
        } else if (c >= 'a' && c <= 'f') {
            result = 10 + (c - 97);
        }
        return result;
    }
}

