/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.biolegato.gdesupport.data.Dataset;
import org.biolegato.gdesupport.data.Seq;
import org.biolegato.gdesupport.files.DataFormat;
import org.biolegato.main.BLMain;

public class GDEFile
extends DataFormat {
    public void translateTo(Appendable result, Seq seq, int offset, int length) throws IOException {
        if (seq != null) {
            result.append("{\nname            \"").append(GDEFile.quote(seq.getName())).append("\"\ncreation-date   \"").append(new SimpleDateFormat("MM/dd/yy kk:mm:ss").format(new Date())).append("\"\ndirection       ").append(Seq.Direction.FROM5TO3.equals((Object)seq.getDirection()) ? "1" : "-1").append("\nstrandedness    ").append(Seq.Strandedness.SINGLE.equals((Object)seq.getStrandedness()) ? "1" : "2").append("\ntype            ").append(GDEFile.blTypetoGDE(seq.getType())).append("\n").append(Seq.Topology.CIRCULAR.equals((Object)seq.getTopology()) ? "circular        1\n" : "").append("offset          0\ngroupID         ").append(Integer.toString(Math.min(0, seq.getGroupID() - 1))).append("\ncreator         \"").append(GDEFile.quote("")).append("\"\ndescrip         \"").append(GDEFile.quote(seq.getDescription())).append("\"\nsequence        \"").append(GDEFile.quote(seq.getSequence().substring(offset, length))).append("\"\n}\n");
        }
    }

    public void translateFrom(Dataset datamodel, BufferedReader data) throws IOException {
        int y = datamodel.getSize();
        int groupID = 0;
        Seq.Type type = Seq.Type.DNA;
        String name = "";
        String sequence = "";
        Seq.Direction direction = Seq.Direction.FROM5TO3;
        Seq.Strandedness strandedness = Seq.Strandedness.SINGLE;
        Seq.Topology topology = Seq.Topology.LINEAR;
        String description = null;
        String line = "";
        String fname = "";
        String fvalue = "";
        while ((line = data.readLine()) != null) {
            if ("".equals(line = line.trim())) continue;
            if (line.contains("}")) {
                datamodel.addSequence(y, new Seq(type, name, new StringBuffer(sequence), direction, topology, strandedness, groupID, description));
                ++y;
                line = line.substring(line.indexOf(123) + 1).trim();
                groupID = 0;
                type = Seq.Type.DNA;
                name = "";
                sequence = "";
                direction = Seq.Direction.FROM5TO3;
                strandedness = Seq.Strandedness.SINGLE;
                topology = Seq.Topology.LINEAR;
                description = null;
            }
            if (line.contains(" ") && (!line.contains("\t") || line.indexOf(32) < line.indexOf(9))) {
                fname = line.substring(0, line.indexOf(32)).trim();
                fvalue = line.substring(line.indexOf(32) + 1).trim();
            } else if (line.contains("\t")) {
                fname = line.substring(0, line.indexOf(9)).trim();
                fvalue = line.substring(line.indexOf(9) + 1).trim();
            } else {
                fname = "";
                fvalue = "";
            }
            if (fvalue.startsWith("\"")) {
                StringBuffer fvalueBuffer = new StringBuffer();
                fvalue = fvalue.substring(1);
                fvalueBuffer.append(fvalue);
                while (fvalue != null && !fvalue.contains("\"")) {
                    fvalue = data.readLine();
                    fvalueBuffer.append(fvalue);
                }
                fvalue = fvalueBuffer.toString();
                fvalue = fvalue.substring(0, fvalue.indexOf(34));
            }
            if ("".equals(fname) && "".equals(fvalue)) continue;
            if ("type".equals(fname)) {
                if ("RNA".equalsIgnoreCase(fvalue)) {
                    type = Seq.Type.RNA;
                    continue;
                }
                if ("PROTEIN".equalsIgnoreCase(fvalue)) {
                    type = Seq.Type.PROTEIN;
                    continue;
                }
                if ("TEXT".equalsIgnoreCase(fvalue)) {
                    type = Seq.Type.TEXT;
                    continue;
                }
                if ("MASK".equalsIgnoreCase(fvalue)) {
                    type = Seq.Type.MASK;
                    continue;
                }
                type = Seq.Type.DNA;
                continue;
            }
            if ("groupID".equals(fname)) {
                if (!BLMain.testNumber((String)fvalue.trim())) continue;
                try {
                    groupID = Integer.parseInt(fvalue);
                }
                catch (Exception ex) {}
                continue;
            }
            if ("circular".equals(fname)) {
                if ("0".equals(fvalue)) {
                    topology = Seq.Topology.LINEAR;
                    continue;
                }
                topology = Seq.Topology.CIRCULAR;
                continue;
            }
            if ("direction".equals(fname)) {
                if ("-1".equals(fvalue)) {
                    direction = Seq.Direction.FROM3TO5;
                    continue;
                }
                direction = Seq.Direction.FROM5TO3;
                continue;
            }
            if ("strandedness".equals(fname)) {
                if ("1".equals(fvalue)) {
                    strandedness = Seq.Strandedness.SINGLE;
                    continue;
                }
                strandedness = Seq.Strandedness.DOUBLE;
                continue;
            }
            if ("name".equals(fname)) {
                name = fvalue;
                continue;
            }
            if ("descrip".equals(fname)) {
                description = fvalue;
                continue;
            }
            if ("sequence".equals(fname)) {
                sequence = fvalue;
                continue;
            }
            if (!BLMain.debug) continue;
            BLMain.warning((String)("Unsupported attribute (" + fname + " )"), (String)"GDEFile plugin");
        }
        if (name != null) {
            datamodel.addSequence(y, new Seq(type, name, new StringBuffer(sequence)));
            ++y;
        }
    }

    public boolean accept(File file) {
        return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".gde");
    }

    public String getDescription() {
        return "GDE file (*.gde)";
    }

    public static String quote(String input) {
        return input.replaceAll("\"", "'").replaceAll("\\{", "\\[").replaceAll("\\}", "\\]");
    }

    private static String blTypetoGDE(Seq.Type type) {
        String result = "DNA";
        switch (type) {
            case RNA: {
                result = "RNA";
                break;
            }
            case PROTEIN: {
                result = "PROTEIN";
                break;
            }
            case MASK: {
                result = "MASK";
                break;
            }
            case TEXT: {
                result = "TEXT";
            }
        }
        return result;
    }

    public boolean isFormat(Reader test) {
        int check = 32;
        try {
            while (check == 32 || check == 9 || check == 10 || check == 13) {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        return check == 123;
    }
}

