/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.menu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.main.OrderedHash;
import org.biolegato.core.menu.EZMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDEMenuParser {
    public static void readGDEMenuFile(File file) {
        GDEMenuParser.readGDEMenuFile("File", file);
    }

    public static void readGDEMenuFile(String menuName, File file) {
        String line = "";
        String fname = "";
        String fvalue = "";
        String itemName = "";
        String runCommand = null;
        String helpCommand = null;
        BufferedReader reader = null;
        EZMenuItem jmitemp = null;
        LinkedList<String> argList = new LinkedList<String>();
        LinkedList<String> fileVariables = new LinkedList<String>();
        OrderedHash<String, Object> currentItem = null;
        OrderedHash<String, String> choices = new OrderedHash<String, String>();
        HashMap<String, String> infile = new HashMap<String, String>();
        HashMap<String, String> outfile = new HashMap<String, String>();
        HashMap<String, Object> arg = new HashMap<String, Object>();
        if (file.exists() && file.isFile() && file.canRead()) {
            try {
                reader = new BufferedReader(new FileReader(file));
                do {
                    fname = "";
                    fvalue = "";
                    line = reader.readLine();
                    if (!(line == null || "".equals(line) || line.indexOf(58) < 0 || !line.startsWith("#@") && line.startsWith("#"))) {
                        if (line.startsWith("#@")) {
                            line = line.substring(2);
                        }
                        fname = line.substring(0, line.indexOf(58)).trim().toLowerCase();
                        fvalue = line.substring(line.indexOf(58) + 1).trim();
                    }
                    if (currentItem != null) {
                        if ((line == null || "item".equals(fname) || "arg".equals(fname) || "in".equals(fname) || "menu".equals(fname)) && infile.containsKey("name")) {
                            infile.put("type", "tempfile");
                            infile.put("source", "selection");
                            currentItem.put('%' + (String)infile.get("name"), infile);
                            fileVariables.add(((String)infile.get("name")).toLowerCase());
                            infile = new HashMap();
                        }
                        if ((line == null || "item".equals(fname) || "arg".equals(fname) || "out".equals(fname) || "menu".equals(fname)) && outfile.containsKey("name")) {
                            outfile.put("type", "tempfile");
                            outfile.put("dest", "newseq");
                            currentItem.put('%' + (String)outfile.get("name"), outfile);
                            fileVariables.add(((String)outfile.get("name")).toLowerCase());
                            outfile = new HashMap();
                        }
                        if ((line == null || "item".equals(fname) || "arg".equals(fname) || "menu".equals(fname)) && arg.containsKey("name")) {
                            if (!choices.isEmpty() && arg.containsKey("default") && BLMain.testNumber(((String)arg.get("default")).toCharArray())) {
                                try {
                                    arg.put("default", choices.getKey(Integer.parseInt((String)arg.get("default"))));
                                }
                                catch (Throwable nfe) {
                                    nfe.printStackTrace();
                                }
                            }
                            arg.put("choices", choices);
                            if (arg.containsKey("name") && arg.containsKey("type")) {
                                currentItem.put('%' + ((String)arg.get("name")).toLowerCase(), new HashMap(arg));
                                argList.add(((String)arg.get("name")).toLowerCase());
                            }
                            choices = new OrderedHash();
                            arg = new HashMap();
                        }
                    }
                    if (line == null || "item".equals(fname)) {
                        itemName = fvalue;
                        if (currentItem != null) {
                            GDEMenuParser.GDE2BLArgs(argList, fileVariables, currentItem);
                            if (runCommand != null) {
                                currentItem.put("%Run", GDEMenuParser.createGDEButton("Run", GDEMenuParser.GDE2BLArgs(argList, fileVariables, runCommand), true));
                            }
                            if (helpCommand != null) {
                                currentItem.put("%Help", GDEMenuParser.createGDEButton("Help", GDEMenuParser.GDE2BLArgs(argList, fileVariables, helpCommand), false));
                            }
                        }
                        if (line != null) {
                            currentItem = new OrderedHash<String, Object>();
                            currentItem.put("name", itemName);
                            jmitemp = new EZMenuItem(currentItem);
                            BLMain.addMenuItem(menuName, jmitemp);
                            fileVariables.clear();
                            argList.clear();
                        }
                        runCommand = null;
                        helpCommand = null;
                        continue;
                    }
                    if ("".equals(fname)) continue;
                    if ("menu".equals(fname)) {
                        menuName = fvalue;
                        BLMain.addMenuHeading(menuName);
                        continue;
                    }
                    if (currentItem != null) {
                        if ("itemmeta".equals(fname) && fvalue.length() >= 1) {
                            if (fvalue.charAt(0) >= 'a' && fvalue.charAt(0) <= 'z' || fvalue.charAt(0) < 'A' || fvalue.charAt(0) > 'Z') continue;
                            continue;
                        }
                        if ("itemlabel".equals(fname) || "itemopen".equals(fname)) continue;
                        if ("itemhelp".equals(fname)) {
                            helpCommand = BLMain.getProperty("GDE.help.viewer") + " " + BLMain.envreplace(BLMain.getProperty("GDE.help.path")) + File.separator + fvalue;
                            continue;
                        }
                        if ("itemmethod".equals(fname)) {
                            runCommand = fvalue;
                            continue;
                        }
                        if ("arg".equals(fname)) {
                            arg.put("name", fvalue);
                            continue;
                        }
                        if ("argtype".equals(fname)) {
                            arg.put("type", fvalue);
                            continue;
                        }
                        if ("arglabel".equals(fname)) {
                            arg.put("label", fvalue);
                            continue;
                        }
                        if ("argmin".equals(fname)) {
                            try {
                                arg.put("min", Integer.parseInt(fvalue));
                            }
                            catch (NumberFormatException nfe) {
                                BLMain.error("Invalid GDE field value (item: " + itemName + "): " + fname + " = " + fvalue, "GDEMenu plugin");
                            }
                            continue;
                        }
                        if ("argmax".equals(fname)) {
                            try {
                                arg.put("max", Integer.parseInt(fvalue));
                            }
                            catch (NumberFormatException nfe) {
                                BLMain.error("Invalid GDE field value (item: " + itemName + "): " + fname + " = " + fvalue, "GDEMenu plugin");
                            }
                            continue;
                        }
                        if ("argvalue".equals(fname) || "argtext".equals(fname)) {
                            arg.put("default", fvalue);
                            continue;
                        }
                        if ("argchoice".equals(fname)) {
                            if (fvalue.indexOf(58) >= 0) {
                                choices.put(fvalue.substring(0, fvalue.indexOf(58)), fvalue.substring(fvalue.indexOf(58) + 1));
                                continue;
                            }
                            choices.put(fvalue, "");
                            BLMain.warning("Badly formed argchoice field: " + fvalue, "GDEMenu");
                            continue;
                        }
                        if ("in".equals(fname)) {
                            infile.put("name", fvalue);
                            continue;
                        }
                        if ("informat".equals(fname)) {
                            infile.put("format", fvalue);
                            continue;
                        }
                        if ("inmask".equals(fname)) {
                            BLMain.warning("Warning unsupported GDE menu field \"inmask\" -- ignoring", "GDEMenu");
                            continue;
                        }
                        if ("insave".equals(fname)) {
                            infile.put("save", "true");
                            continue;
                        }
                        if ("out".equals(fname)) {
                            outfile.put("name", fvalue);
                            continue;
                        }
                        if ("outformat".equals(fname)) {
                            outfile.put("format", fvalue);
                            continue;
                        }
                        if ("outsave".equals(fname)) {
                            outfile.put("save", "true");
                            continue;
                        }
                        if ("outoverwrite".equals(fname)) {
                            outfile.put("overwrite", "true");
                            continue;
                        }
                        BLMain.error("Invalid GDE field (item: " + itemName + "): " + fname + " = " + fvalue, "GDEMenu plugin");
                        continue;
                    }
                    BLMain.error("Invalid GDE location or field value (item: " + itemName + "): " + fname + " = " + fvalue, "GDEMenu plugin");
                } while (line != null);
                reader.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, Object> createGDEButton(String label, String command, boolean closeWindow) {
        HashMap<String, Object> button = new HashMap<String, Object>();
        button.put("label", label);
        button.put("type", "button");
        if (closeWindow) {
            button.put("closewindow", "true");
        } else {
            button.put("closewindow", "false");
        }
        button.put("command", command);
        return button;
    }

    private static String GDE2BLArgs(List<String> argList, List<String> fileVariables, String runCommand) {
        int start = -1;
        int end = -1;
        String name = "";
        String value = "";
        Object[] argArray = argList.toArray(new String[0]);
        String smallrun = runCommand.toLowerCase();
        String test = null;
        Arrays.sort(argArray);
        while ((start = runCommand.indexOf(36, start)) >= 0) {
            for (end = start + 1; end < runCommand.length() && (BLMain.isDigit(runCommand.charAt(end)) || runCommand.charAt(end) == '_'); ++end) {
            }
            test = runCommand.substring(start + 1, end).toLowerCase();
            if (Arrays.binarySearch(argArray, test) >= 0) {
                runCommand = (start == 0 ? "" : runCommand.substring(0, start)) + '%' + test + '%' + (end > runCommand.length() ? "" : runCommand.substring(end));
            }
            ++start;
        }
        smallrun = runCommand.toLowerCase();
        for (String file : fileVariables) {
            boolean searchCount = false;
            start = -1;
            end = -1;
            if (file == null || "".equals(file)) continue;
            while ((start = smallrun.indexOf(file, end + 1)) >= 0) {
                end = start + file.length();
                if (start != 0 && !BLMain.notDigit(runCommand.charAt(start - 1)) || end < runCommand.length() && !BLMain.notDigit(runCommand.charAt(end))) continue;
                runCommand = (start == 0 ? "" : runCommand.substring(0, start)) + '%' + file + '%' + (end > runCommand.length() ? "" : runCommand.substring(end));
                smallrun = runCommand.toLowerCase();
            }
        }
        return runCommand;
    }

    private static void GDE2BLArgs(List<String> argList, List<String> fileVariables, Map<String, Object> map) {
        for (String akey : argList) {
            Map arg = (Map)map.get('%' + akey);
            if (!arg.containsKey("choices")) continue;
            for (Map.Entry e : ((Map)arg.get("choices")).entrySet()) {
                ((Map)arg.get("choices")).put(e.getKey(), GDEMenuParser.GDE2BLArgs(argList, fileVariables, (String)e.getValue()));
            }
        }
    }
}

