/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.menu.variables;

import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biolegato.core.menu.variables.EZWidgetVariable;

public class EZSlider
extends EZWidgetVariable
implements ChangeListener {
    private JSlider slider = null;
    private JSpinner spinner = null;
    private static final long serialVersionUID = 7526472295622776161L;

    public EZSlider(Map data) {
        super(data);
        int defaultValue = 0;
        int minimum = 0;
        int maximum = 5000;
        if (data.containsKey("label")) {
            this.add(new JLabel(data.get("label").toString() + ":"));
        }
        if (data.containsKey("min") && data.get("min") instanceof Integer) {
            minimum = (Integer)data.get("min");
        }
        if (data.containsKey("max") && data.get("max") instanceof Integer) {
            maximum = (Integer)data.get("max");
        }
        if (data.containsKey("default")) {
            try {
                defaultValue = Integer.parseInt(data.get("default").toString());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        minimum = Math.max(0, minimum);
        maximum = Math.max(minimum, maximum);
        defaultValue = Math.max(Math.min(defaultValue, maximum), minimum);
        this.spinner = new JSpinner(new SpinnerNumberModel(defaultValue, minimum, maximum, 1));
        this.spinner.addChangeListener(this);
        this.add(this.spinner);
        this.add(new JLabel("" + minimum));
        this.slider = new JSlider(0, minimum, maximum, defaultValue);
        this.slider.addChangeListener(this);
        this.add(this.slider);
        this.add(new JLabel("" + maximum));
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JSpinner) {
            this.slider.setValue(((Number)this.spinner.getValue()).intValue());
        } else {
            this.spinner.setValue(this.slider.getValue());
        }
    }

    public static String getType() {
        return "slider";
    }

    public Object getValue() {
        return this.spinner.getValue().toString();
    }
}

