/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.pcdmenu;

import java.io.File;
import java.io.FileInputStream;
import javax.swing.JMenuItem;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.pcdmenu.parser.PCDFile;
import org.biolegato.core.pcdmenu.parser.ParseException;

public class PCDMenu {
    public static void loadMenu() {
        String[] paths = null;
        try {
            if (System.getenv("BL_MENUS") != null) {
                for (String path : paths = System.getenv("BL_MENUS").split(File.pathSeparator)) {
                    PCDMenu.readDirectory(new File(path));
                }
            } else {
                BLMain.warning("BL_MENUS not set!  Defaulting to " + BLMain.PROGRAM_DIR + File.separator + "menus", "PCD Menu plugin");
                PCDMenu.readDirectory(new File(BLMain.PROGRAM_DIR + File.separator + "menus"));
            }
        }
        catch (Throwable th) {
            BLMain.error("Reading BioLegato menus failed!");
            th.printStackTrace();
        }
    }

    public static void readDirectory(File directory) {
        String dirname = null;
        String filename = null;
        FileInputStream filebuffer = null;
        PCDFile fileparser = null;
        try {
            if (directory != null && directory.exists() && directory.isDirectory()) {
                for (File file : directory.listFiles()) {
                    if (!file.exists() || !file.canRead()) continue;
                    if (file.isDirectory()) {
                        PCDMenu.readDirectory(file.getAbsoluteFile());
                        continue;
                    }
                    dirname = directory.getAbsolutePath();
                    if (dirname.lastIndexOf(File.separatorChar) >= 0) {
                        dirname = dirname.substring(dirname.lastIndexOf(File.separatorChar) + 1);
                    }
                    if ((filename = file.getAbsolutePath()).lastIndexOf(File.separatorChar) >= 0) {
                        filename = filename.substring(filename.lastIndexOf(File.separatorChar) + 1);
                    }
                    try {
                        filebuffer = new FileInputStream(file);
                        if (fileparser == null) {
                            fileparser = new PCDFile(filebuffer);
                        } else {
                            fileparser.ReInit(filebuffer);
                        }
                        JMenuItem item = fileparser.Parse();
                        System.out.println(item.getName());
                        BLMain.addMenuItem(dirname, item);
                    }
                    catch (ParseException pe) {
                        BLMain.error("parse error in file: " + file.getAbsolutePath());
                        pe.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }
}

