/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.pcdmenu.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.main.OrderedHash;
import org.biolegato.core.pcdmenu.CommandButton;
import org.biolegato.core.pcdmenu.ExecMenuItem;
import org.biolegato.core.pcdmenu.PCDMenuItem;
import org.biolegato.core.pcdmenu.TabWidget;
import org.biolegato.core.pcdmenu.TempFile;
import org.biolegato.core.pcdmenu.WidgetContainer;
import org.biolegato.core.pcdmenu.parser.PCDFileConstants;
import org.biolegato.core.pcdmenu.parser.PCDFileTokenManager;
import org.biolegato.core.pcdmenu.parser.ParseException;
import org.biolegato.core.pcdmenu.parser.SimpleCharStream;
import org.biolegato.core.pcdmenu.parser.Token;
import org.biolegato.core.pcdmenu.widgets.ChoiceList;
import org.biolegato.core.pcdmenu.widgets.Chooser;
import org.biolegato.core.pcdmenu.widgets.ComboBoxWidget;
import org.biolegato.core.pcdmenu.widgets.DecimalWidget;
import org.biolegato.core.pcdmenu.widgets.NumberWidget;
import org.biolegato.core.pcdmenu.widgets.TextWidget;
import org.biolegato.core.pcdmenu.widgets.Widget;

public class PCDFile
implements PCDFileConstants {
    private String name = null;
    private String icon = null;
    private String tooltip = null;
    private boolean systemTokenParsed = false;
    private boolean systemSupported = true;
    public PCDFileTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[26];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[14];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public final JMenuItem Parse() throws ParseException {
        PCDMenuItem pcditem = null;
        JMenuItem item = null;
        Object param = null;
        String exec = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 38: 
                case 39: 
                case 40: 
                case 51: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block12;
                }
            }
            this.PCDOption();
        }
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                exec = this.Text();
                item = new ExecMenuItem(exec, this.name, this.icon, this.tooltip);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                if (this.jj_2_3(1)) {
                    pcditem = new PCDMenuItem(this.name, this.icon, this.tooltip);
                    item = pcditem;
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 52: {
                                this.Param(0, pcditem);
                                break;
                            }
                            default: {
                                this.jj_la1[2] = this.jj_gen;
                                if (this.jj_2_1(1)) {
                                    this.Tab(0, pcditem);
                                    break;
                                }
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (!this.jj_2_2(1)) break block6;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(0);
        return item;
    }

    public final void PCDOption() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                this.inorsp(1);
                Token t = this.jj_consume_token(55);
                this.jj_consume_token(59);
                if (this.name != null) {
                    throw new ParseException("Duplicate \"name\" field on line: " + t.beginLine);
                }
                this.name = t.image;
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                this.inorsp(1);
                Token t = this.jj_consume_token(55);
                this.jj_consume_token(59);
                if (this.icon != null) {
                    throw new ParseException("Duplicate \"icon\" field on line: " + t.beginLine);
                }
                this.icon = t.image;
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                this.inorsp(1);
                Token t = this.jj_consume_token(55);
                this.jj_consume_token(59);
                if (this.tooltip != null) {
                    throw new ParseException("Duplicate \"tip\" field on line: " + t.beginLine);
                }
                this.tooltip = t.image;
                break;
            }
            case 39: {
                Token t = this.jj_consume_token(39);
                if (this.systemTokenParsed) {
                    throw new ParseException("Duplicate \"system\" field on line: " + t.beginLine);
                }
                this.systemTokenParsed = true;
                this.systemSupported = false;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 59: {
                        block13: while (true) {
                            this.jj_consume_token(59);
                            this.assertIndent(1);
                            this.SystemName();
                            this.jj_consume_token(59);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 59: {
                                    continue block13;
                                }
                            }
                            break;
                        }
                        this.jj_la1[4] = this.jj_gen;
                        break block0;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 48: {
                        this.SystemName();
                        this.jj_consume_token(59);
                        break block0;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void SystemName() throws ParseException {
        boolean osSupported = true;
        boolean archSupported = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                this.jj_consume_token(48);
                osSupported = true;
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                osSupported = BLMain.CURRENT_OS == BLMain.OS.LINUX;
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                osSupported = BLMain.CURRENT_OS == BLMain.OS.OSX;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                osSupported = BLMain.CURRENT_OS == BLMain.OS.SOLARIS;
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                osSupported = !BLMain.CURRENT_OS.isWindows();
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                osSupported = BLMain.CURRENT_OS.isWindows();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 16: 
            case 17: 
            case 48: {
                archSupported = this.ArchList();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        this.systemSupported = this.systemSupported || archSupported && osSupported;
    }

    public final boolean ArchList() throws ParseException {
        boolean temp = false;
        boolean archSupport = false;
        archSupport = this.ArchName();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 54: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(54);
            temp = this.ArchName();
            archSupport = archSupport || temp;
        }
        return archSupport;
    }

    public final boolean ArchName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                this.jj_consume_token(48);
                return true;
            }
            case 15: {
                this.jj_consume_token(15);
                return BLMain.CURRENT_ARCH == BLMain.ARCH.X86 || BLMain.CURRENT_ARCH == BLMain.ARCH.AMD64;
            }
            case 16: {
                this.jj_consume_token(16);
                return BLMain.CURRENT_ARCH == BLMain.ARCH.AMD64;
            }
            case 17: {
                this.jj_consume_token(17);
                return BLMain.CURRENT_ARCH == BLMain.ARCH.SPARC;
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void Tab(int scope, WidgetContainer wcontainer) throws ParseException {
        TabWidget tabw = new TabWidget();
        String tabName = "";
        LinkedList widgetList = new LinkedList();
        do {
            this.jj_consume_token(53);
            tabName = this.Text();
            this.jj_consume_token(59);
            do {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 52: {
                        this.Param(scope + 1, tabw);
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        if (this.jj_2_4(1)) {
                            this.Tab(scope + 1, tabw);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            } while (this.testIndent(scope + 1));
        } while (this.testIndent(scope));
        wcontainer.addWidget(this.name, tabw);
    }

    public final void Param(int scope, WidgetContainer wcontainer) throws ParseException {
        Widget parameter = null;
        this.assertIndent(scope);
        this.jj_consume_token(52);
        String name = this.Text();
        this.jj_consume_token(59);
        this.assertIndent(scope + 1);
        this.jj_consume_token(35);
        this.inorsp(scope + 2);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                this.jj_consume_token(59);
                parameter = this.buttonFields(scope + 1);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                this.jj_consume_token(59);
                parameter = this.listFields(scope + 1);
                break;
            }
            case 2: {
                this.jj_consume_token(2);
                this.jj_consume_token(59);
                parameter = this.chooserFields(scope + 1);
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                this.jj_consume_token(59);
                parameter = this.comboFields(scope + 1);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                this.jj_consume_token(59);
                parameter = this.textFields(scope + 1);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                this.jj_consume_token(59);
                parameter = this.numberFields(scope + 1);
                break;
            }
            case 4: {
                this.jj_consume_token(4);
                this.jj_consume_token(59);
                parameter = this.decimalFields(scope + 1);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                this.jj_consume_token(59);
                parameter = this.tempfileFields(scope + 1);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        wcontainer.addWidget(name, parameter);
    }

    public final Widget buttonFields(int scope) throws ParseException {
        String label = "";
        String shell = "";
        boolean close = false;
        this.assertIndent(scope);
        this.jj_consume_token(50);
        this.inorsp(scope + 1);
        label = this.Text();
        this.jj_consume_token(59);
        this.assertIndent(scope);
        this.jj_consume_token(37);
        this.inorsp(scope + 1);
        shell = this.Text();
        this.jj_consume_token(59);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.assertIndent(scope);
                this.jj_consume_token(27);
                this.inorsp(scope + 1);
                close = this.Bool();
                this.jj_consume_token(59);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        return new CommandButton(label, shell, close);
    }

    public final Widget chooserFields(int scope) throws ParseException {
        String label = "";
        String value = "";
        OrderedHash<String, String> choices = new OrderedHash<String, String>();
        this.assertIndent(scope);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                this.inorsp(scope + 1);
                label = this.Text();
                this.jj_consume_token(59);
                this.assertIndent(scope);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                this.jj_consume_token(49);
                this.inorsp(scope + 1);
                value = this.Text();
                this.jj_consume_token(59);
                this.assertIndent(scope);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
        this.jj_consume_token(59);
        do {
            String choiceName = this.Text();
            this.jj_consume_token(59);
            this.assertIndent(scope + 2);
            String choiceValue = this.Text();
            this.jj_consume_token(59);
            choices.put(choiceName, choiceValue);
        } while (this.testIndent(scope + 1));
        return new Chooser(label, choices, value);
    }

    public final Widget comboFields(int scope) throws ParseException {
        String label = "";
        String value = "";
        OrderedHash<String, String> choices = new OrderedHash<String, String>();
        this.assertIndent(scope);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                this.inorsp(scope + 1);
                label = this.Text();
                this.jj_consume_token(59);
                this.assertIndent(scope);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                this.jj_consume_token(49);
                this.inorsp(scope + 1);
                value = this.Text();
                this.jj_consume_token(59);
                this.assertIndent(scope);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
        this.jj_consume_token(59);
        do {
            String choiceName = this.Text();
            this.jj_consume_token(59);
            this.assertIndent(scope + 2);
            String choiceValue = this.Text();
            this.jj_consume_token(59);
            choices.put(choiceName, choiceValue);
        } while (this.testIndent(scope + 1));
        return new ComboBoxWidget(label, choices, value);
    }

    public final Widget listFields(int scope) throws ParseException {
        String label = "";
        String value = "";
        OrderedHash<String, String> choices = new OrderedHash<String, String>();
        this.assertIndent(scope);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                this.inorsp(scope + 1);
                label = this.Text();
                this.jj_consume_token(59);
                this.assertIndent(scope);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                this.jj_consume_token(49);
                this.inorsp(scope + 1);
                value = this.Text();
                this.jj_consume_token(59);
                this.assertIndent(scope);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
        this.jj_consume_token(59);
        do {
            String choiceName = this.Text();
            this.jj_consume_token(59);
            this.assertIndent(scope + 2);
            String choiceValue = this.Text();
            this.jj_consume_token(59);
            choices.put(choiceName, choiceValue);
        } while (this.testIndent(scope + 1));
        return new ChoiceList(label, choices, value);
    }

    public final Widget textFields(int scope) throws ParseException {
        String label = "";
        String value = "";
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            this.assertIndent(scope);
            this.jj_consume_token(50);
            this.inorsp(scope + 1);
            label = this.Text();
            this.jj_consume_token(59);
        }
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            this.assertIndent(scope);
            this.jj_consume_token(49);
            this.inorsp(scope + 1);
            this.Text();
            this.jj_consume_token(59);
        }
        return new TextWidget(label, value);
    }

    public final Widget numberFields(int scope) throws ParseException {
        String label = "";
        this.assertIndent(scope);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                this.inorsp(scope + 1);
                label = this.Text();
                this.jj_consume_token(59);
                this.assertIndent(scope);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.jj_consume_token(32);
        this.inorsp(scope + 1);
        int min = this.Number();
        this.jj_consume_token(59);
        this.assertIndent(scope);
        Token current = this.jj_consume_token(31);
        this.inorsp(scope + 1);
        int max = this.Number();
        this.jj_consume_token(59);
        if (min > max) {
            throw new ParseException("Field 'min' is greater than field 'max' on line: " + current.endLine);
        }
        int value = min;
        if (this.jj_2_7(Integer.MAX_VALUE)) {
            this.assertIndent(scope);
            current = this.jj_consume_token(49);
            this.inorsp(scope + 1);
            value = this.Number();
            this.jj_consume_token(59);
            if (value > max) {
                throw new ParseException("The default value is greater than the maximum value on line: " + current.endLine);
            }
            if (value < min) {
                throw new ParseException("The default value is less than the minimum value on line: " + current.endLine);
            }
        }
        return new NumberWidget(label, min, max, value);
    }

    public final Widget decimalFields(int scope) throws ParseException {
        String label = "";
        this.assertIndent(scope);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                this.inorsp(scope + 1);
                label = this.Text();
                this.jj_consume_token(59);
                this.assertIndent(scope);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        this.jj_consume_token(32);
        this.inorsp(scope + 1);
        double min = this.Decimal();
        this.jj_consume_token(59);
        this.assertIndent(scope);
        Token current = this.jj_consume_token(31);
        this.inorsp(scope + 1);
        double max = this.Decimal();
        this.jj_consume_token(59);
        if (min > max) {
            throw new ParseException("Field 'min' is greater than field 'max' on line: " + current.endLine);
        }
        double value = min;
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            this.assertIndent(scope);
            current = this.jj_consume_token(49);
            this.inorsp(scope + 1);
            value = this.Decimal();
            this.jj_consume_token(59);
            if (value > max) {
                throw new ParseException("The default value is greater than the maximum value on line: " + current.endLine);
            }
            if (value < min) {
                throw new ParseException("The default value is less than the minimum value on line: " + current.endLine);
            }
        }
        return new DecimalWidget(label, min, max, value);
    }

    public final Widget tempfileFields(int scope) throws ParseException {
        String input = null;
        String output = null;
        boolean save = false;
        boolean overwrite = false;
        String format = null;
        if (this.jj_2_9(Integer.MAX_VALUE)) {
            this.assertIndent(scope);
            this.jj_consume_token(30);
            this.inorsp(scope + 1);
            input = this.Text();
            this.jj_consume_token(59);
        }
        if (this.jj_2_10(Integer.MAX_VALUE)) {
            this.assertIndent(scope);
            this.jj_consume_token(33);
            this.inorsp(scope + 1);
            output = this.Text();
            this.jj_consume_token(59);
        }
        if (this.jj_2_11(Integer.MAX_VALUE)) {
            this.assertIndent(scope);
            this.jj_consume_token(36);
            this.inorsp(scope + 1);
            save = this.Bool();
            this.jj_consume_token(59);
        }
        if (this.jj_2_12(Integer.MAX_VALUE)) {
            this.assertIndent(scope);
            this.jj_consume_token(34);
            this.inorsp(scope + 1);
            overwrite = this.Bool();
            this.jj_consume_token(59);
        }
        if (this.jj_2_13(Integer.MAX_VALUE)) {
            this.assertIndent(scope);
            this.jj_consume_token(29);
            this.inorsp(scope + 1);
            format = this.Text();
            this.jj_consume_token(59);
        }
        if (this.jj_2_14(Integer.MAX_VALUE)) {
            this.assertIndent(scope);
            this.jj_consume_token(28);
            this.inorsp(scope + 1);
            this.ContentValue();
            this.jj_consume_token(59);
        }
        return new TempFile("selection".equalsIgnoreCase(input), "newseq".equalsIgnoreCase(output), save, overwrite, format);
    }

    public final void ContentValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String Ident() throws ParseException {
        Token t = null;
        t = this.jj_consume_token(58);
        return t.image;
    }

    public final String Text() throws ParseException {
        Token t = null;
        t = this.jj_consume_token(55);
        return t.image.substring(1, t.image.length() - 1);
    }

    public final double Decimal() throws ParseException {
        double value = 0.0;
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                t = this.jj_consume_token(56);
                try {
                    value = Double.parseDouble(t.image);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid decimal number on line: " + t.endLine);
                }
            }
            case 57: {
                value = this.Number();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final int Number() throws ParseException {
        int value = 0;
        Token t = null;
        t = this.jj_consume_token(57);
        try {
            value = Integer.parseInt(t.image);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Invalid number on line: " + t.endLine);
        }
        return value;
    }

    public final boolean Bool() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                return true;
            }
            case 18: {
                this.jj_consume_token(18);
                return false;
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void inorsp(int scope) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                this.assertIndent(scope);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
    }

    public final void assertIndent(int scope) throws ParseException {
        if (!this.testIndent(scope)) {
            throw new ParseException("Indentation error on line: " + this.getToken((int)1).beginLine + " with an indentation of " + this.token_source.getIndent() * 4 + " spaces (expected " + scope * 4 + " spaces)");
        }
    }

    public final boolean testIndent(int scope) throws ParseException {
        this.getToken(1);
        return this.token_source.getIndent() == scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    private boolean jj_3R_12() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_13() {
        if (this.jj_3R_14()) {
            return true;
        }
        return this.jj_scan_token(52);
    }

    private boolean jj_3_3() {
        Token xsp;
        if (this.jj_3_2()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_2());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_10() {
        Token xsp;
        if (this.jj_3R_12()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_12());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3_5() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3_8() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3_14() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3_7() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3_13() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3_12() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3_11() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3_10() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3_9() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_4() {
        return this.jj_3R_10();
    }

    private boolean jj_3R_14() {
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_10();
    }

    private boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_11()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_1()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_11() {
        return this.jj_3R_13();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 31744, 0, 31744, 229376, 0, 229376, 0, 990, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 786432, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0x8000000, 524736, 0x100000, 32, 0x8000000, 0x8010000, 524736, 65536, 65536, 0x400000, 65536, 0x100000, 0, 0, 262144, 131072, 262144, 131072, 262144, 131072, 262144, 262144, 1536, 0x3000000, 0, 0x8000000};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public PCDFile(InputStream stream) {
        this(stream, null);
    }

    public PCDFile(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new PCDFileTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PCDFile(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PCDFileTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PCDFile(PCDFileTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PCDFileTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 26; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[69];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 26; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 69; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 14; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        PCDFile.jj_la1_init_0();
        PCDFile.jj_la1_init_1();
        PCDFile.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

