/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.pcdmenu.widgets;

import java.awt.Component;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.pcdmenu.widgets.ListWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxWidget
extends ListWidget {
    protected JComboBox combobox = null;
    public final BasicComboBoxUI comboboxUI = new BasicComboBoxUI(){

        protected ComboPopup createPopup() {
            BasicComboPopup uipopup = new BasicComboPopup(this.comboBox){

                protected JScrollPane createScroller() {
                    return new JScrollPane(this.list, 20, 30);
                }
            };
            return uipopup;
        }
    };
    private static final long serialVersionUID = 7526472295622776158L;

    public ComboBoxWidget(String label, Map<String, String> choices, String value) {
        super(label, choices, value);
    }

    @Override
    public Component display() {
        Box result = new Box(2);
        boolean defaultEntry = false;
        Object orderChoices = null;
        if (this.label != null) {
            result.add(new JLabel(this.label));
        }
        this.combobox = new JComboBox<Object>(this.choices.keySet().toArray());
        if (this.value != null) {
            for (Map.Entry e : this.choices.entrySet()) {
                if (!((String)e.getValue()).equalsIgnoreCase(this.value)) continue;
                this.combobox.setSelectedItem(e.getKey());
            }
        } else {
            BLMain.error("Invalid argument (missing choice list)", "BLComboBox");
        }
        this.combobox.setUI(this.comboboxUI);
        this.combobox.updateUI();
        return this.combobox;
    }

    public static String getType() {
        return "choice_menu";
    }

    public Object getNewDefault() {
        return this.combobox.getSelectedItem();
    }

    @Override
    public Object getValue() {
        return this.choices.get(this.combobox.getSelectedItem().toString());
    }

    @Override
    public void close() {
        this.combobox = null;
    }
}

