/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.pcdmenu.widgets;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biolegato.core.pcdmenu.widgets.Widget;

public class DecimalWidget
implements Widget,
ChangeListener {
    private double min;
    private double max;
    private double value;
    private String label = null;
    private JSpinner spinner = null;
    private static final long serialVersionUID = 7526472295622776161L;

    public DecimalWidget(String label, double min, double max, double value) {
        this.label = label;
        this.min = min;
        this.max = max;
        this.value = value;
    }

    public void stateChanged(ChangeEvent e) {
        this.value = ((Number)this.spinner.getValue()).intValue();
    }

    public static String getType() {
        return "slider";
    }

    public Component display() {
        Box container = new Box(2);
        if (this.spinner == null) {
            this.spinner = new JSpinner(new SpinnerNumberModel(this.value, this.min, this.max, 1.0));
            this.spinner.addChangeListener(this);
            container.add(this.spinner);
            container.add(new JLabel("" + this.min));
        }
        container.add(new JLabel("" + this.max));
        return container;
    }

    public void close() {
        this.spinner = null;
    }

    public Object getValue() {
        return this.value;
    }
}

