/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

import JSci.maths.SpecialMath;
import MAANOVA.ProbabilityDistribution;

public final class BetaDistribution
extends ProbabilityDistribution {
    private double p;
    private double q;

    public BetaDistribution(double dgrP, double dgrQ) {
        if (dgrP <= 0.0 || dgrQ <= 0.0) {
            throw new IllegalArgumentException("The degrees of freedom must be greater than zero.");
        }
        this.p = dgrP;
        this.q = dgrQ;
    }

    public double getDegreesOfFreedomP() {
        return this.p;
    }

    public double getDegreesOfFreedomQ() {
        return this.q;
    }

    public double probability(double X) {
        this.checkRange(X);
        if (X == 0.0 || X == 1.0) {
            return 0.0;
        }
        return Math.exp(-SpecialMath.logBeta((double)this.p, (double)this.q) + (this.p - 1.0) * Math.log(X) + (this.q - 1.0) * Math.log(1.0 - X));
    }

    public double cumulative(double X) {
        this.checkRange(X);
        return SpecialMath.incompleteBeta((double)X, (double)this.p, (double)this.q);
    }

    public double inverse(double probability) {
        this.checkRange(probability);
        if (probability == 0.0) {
            return 0.0;
        }
        if (probability == 1.0) {
            return 1.0;
        }
        return this.findRoot(probability, 0.5, 0.0, 1.0);
    }
}

