/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

import MAANOVA.AbstractGraphModel;
import MAANOVA.DataSeries;
import MAANOVA.Graph2DModel;
import java.util.Vector;

public final class DefaultGraph2DModel
extends AbstractGraphModel
implements Graph2DModel {
    private float[] defaultXAxis = new float[0];
    private final Vector xData = new Vector();
    private final Vector series = new Vector();
    private int pos = 0;
    private float[] curXAxis = null;
    private DataSeries curSeries = null;

    public void setXAxis(float[] x) {
        if (this.defaultXAxis.length != x.length) {
            this.defaultXAxis = new float[x.length];
        }
        System.arraycopy(x, 0, this.defaultXAxis, 0, x.length);
        this.fireDataChanged();
    }

    public void setXAxis(double[] x) {
        if (this.defaultXAxis.length != x.length) {
            this.defaultXAxis = new float[x.length];
        }
        int i = 0;
        while (i < x.length) {
            this.defaultXAxis[i] = (float)x[i];
            ++i;
        }
        this.fireDataChanged();
    }

    public void setXAxis(float a, float b, int n) {
        if (this.defaultXAxis.length != n) {
            this.defaultXAxis = new float[n];
        }
        int i = 0;
        while (i < n) {
            this.defaultXAxis[i] = (b - a) * (float)i / (float)(n - 1) + a;
            ++i;
        }
        this.fireDataChanged();
    }

    public float[] getXAxis() {
        return this.defaultXAxis;
    }

    public void addSeries(float[] newSeries) {
        this.addSeries(this.defaultXAxis, newSeries);
    }

    public void addSeries(double[] newSeries) {
        this.xData.addElement(this.defaultXAxis);
        this.series.addElement(new DataSeries(newSeries));
        this.fireDataChanged();
    }

    public void addSeries(float[] newXAxis, float[] newSeries) {
        this.xData.addElement(newXAxis);
        this.series.addElement(new DataSeries(newSeries));
        this.fireDataChanged();
    }

    public void changeSeries(int i, float[] newSeries) {
        this.series.setElementAt(new DataSeries(newSeries), i);
        this.fireDataChanged();
    }

    public void changeSeries(int i, double[] newSeries) {
        this.series.setElementAt(new DataSeries(newSeries), i);
        this.fireDataChanged();
    }

    public void removeSeries(int i) {
        this.xData.removeElementAt(i);
        this.series.removeElementAt(i);
        this.fireDataChanged();
    }

    public DataSeries getSeries(int i) {
        return (DataSeries)this.series.elementAt(i);
    }

    public void setSeriesVisible(int i, boolean flag) {
        ((DataSeries)this.series.elementAt(i)).setVisible(flag);
        this.fireDataChanged();
    }

    public float getXCoord(int i) {
        return this.curXAxis[i];
    }

    public float getYCoord(int i) {
        return this.curSeries.getValueAt(i);
    }

    public int seriesLength() {
        return this.curSeries.length();
    }

    public void firstSeries() {
        this.curSeries = (DataSeries)this.series.elementAt(0);
        this.pos = 0;
        while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1) {
            this.curSeries = (DataSeries)this.series.elementAt(++this.pos);
        }
        this.curXAxis = (float[])this.xData.elementAt(this.pos);
    }

    public boolean nextSeries() {
        if (this.pos == this.series.size() - 1) {
            return false;
        }
        do {
            this.curSeries = (DataSeries)this.series.elementAt(++this.pos);
        } while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1);
        this.curXAxis = (float[])this.xData.elementAt(this.pos);
        return this.curSeries.isVisible();
    }
}

