/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

import Jama.Matrix;
import MAANOVA.AnovaObject;
import MAANOVA.DataObject;
import MAANOVA.ModelObject;
import MAANOVA.MyMatlab;

public class FitMaAnova {
    public AnovaObject Apply(DataObject DO, ModelObject MO, int make_table) {
        AnovaObject AO = new AnovaObject();
        MyMatlab MatLab = new MyMatlab();
        long timestart = System.currentTimeMillis();
        Matrix data = DO.getAdjData();
        int narrays = DO.getNarrays();
        int ngenes = DO.getNgenes();
        int nspots = DO.getNspots();
        int rep = DO.getNreps();
        double[] colmeans = DO.getColMeans();
        int fitVG = MO.getFitVG();
        int fitDG = MO.getFitDG();
        int fitAG = MO.getFitAG();
        int[] varid = MO.getVarid();
        int nvars = MO.getNvars();
        int[] varcount = MO.getVarcount();
        int even = MO.getEvenFlag();
        int latsq = MO.getLatsqFlag();
        int VDCon_flag = MO.getVDConFlag();
        Matrix X = MO.getX();
        Matrix A = MO.getA();
        Matrix Q = MO.getQ();
        Matrix R = MO.getR();
        AO.setDF(X.getRowDimension() - X.getColumnDimension());
        Matrix table = new Matrix(8, 4, 0.0);
        Matrix sdata = data.minus(MatLab.RepMatVert(colmeans, ngenes * rep));
        AO.AllocateStorage(ngenes, nvars, narrays, rep);
        Matrix AG = new Matrix(ngenes, nspots, 0.0);
        System.out.println("ngenes=" + ngenes);
        int sdatacoldim = sdata.getColumnDimension();
        int Xcoldim = X.getColumnDimension();
        Matrix Qtr = Q.transpose();
        Matrix b = new Matrix(Xcoldim, 1, 1.0);
        int AGdim = AG.getColumnDimension();
        int AOYHATdim = AO.getYhat().getColumnDimension();
        Matrix YH = AO.getYhat();
        long timeL0 = System.currentTimeMillis();
        long timeSolve = 0L;
        long s1 = 0L;
        long s2 = 0L;
        long loopstart = 0L;
        long loopend = 0L;
        long looprest = 0L;
        int i = ngenes - 1;
        while (i >= 0) {
            loopstart = System.currentTimeMillis();
            Matrix y = sdata.getMatrix(i * rep, (i + 1) * rep - 1, 0, sdatacoldim - 1);
            double[] yvec = y.getColumnPackedCopy();
            Matrix yvecm = new Matrix(yvec, yvec.length);
            Matrix Qtry = Qtr.times(yvecm);
            s1 = System.currentTimeMillis();
            try {
                b = R.solve(Qtry);
            }
            catch (IllegalArgumentException e) {
                System.out.println("IllegalArgumentException: Matrix R-" + e.getMessage() + "\n");
            }
            catch (RuntimeException e) {
                System.out.println("RunTimeException: Matrix R-" + e.getMessage() + " \n");
            }
            catch (Exception e) {
                System.out.println("General Exception: Matrix R-" + e.getMessage() + " \n");
            }
            s2 = System.currentTimeMillis();
            timeSolve += s2 - s1;
            Matrix yfit = X.times(b);
            Matrix yvecm_yfit = yvecm.minus(yfit);
            AO.setRss(yvecm_yfit.transpose().times(yvecm_yfit), i);
            YH.setMatrix(i * rep, i * rep + rep - 1, 0, AOYHATdim - 1, MatLab.Reshape(yfit, rep, 2 * narrays));
            loopend = System.currentTimeMillis();
            Matrix a = A.times(b);
            double[] av = a.getColumnPackedCopy();
            int avlength = av.length;
            AO.setG(i, av[0]);
            int next = 1;
            int next1 = 0;
            boolean next2 = false;
            double[] a1v = new double[av.length - 2];
            if (fitVG == 1) {
                double[] a1vcopy = new double[nvars];
                System.arraycopy(av, next, a1vcopy, 0, nvars);
                AO.setVG(i, a1vcopy, nvars);
                next = nvars + 1;
            }
            if (fitDG == 1) {
                double[] a2vcopy = new double[2];
                System.arraycopy(av, next, a2vcopy, 0, 2);
                AO.setDG(i, a2vcopy, 2);
                next1 = 2;
            }
            if (fitAG == 1) {
                double[] a3vcopy = new double[av.length - next1 - next];
                System.arraycopy(av, next1 + next, a3vcopy, 0, av.length - next1 - next);
                Matrix a21 = new Matrix(a3vcopy, av.length - next - next1);
                Matrix a4 = a21.transpose();
                Matrix RM2 = MatLab.Reshape(a4, rep, narrays);
                AO.setAG(i, i + rep - 1, RM2);
            }
            looprest += loopend - s2;
            --i;
        }
        AO.setYhat(YH);
        long timeL1 = System.currentTimeMillis();
        AO.setYhat(AO.getYhat().plus(MatLab.RepMatVert(colmeans, ngenes * rep)));
        int[] model = new int[]{fitVG, fitDG, fitAG};
        AO.setModel(model);
        if (make_table == 1) {
            Matrix indx;
            int[] arr;
            Matrix tm1;
            double[] tmv;
            Matrix tm;
            int AGrows;
            double dfDG = fitDG == 1 ? (double)(ngenes - 1) : 0.0;
            double dfAG = fitAG == 1 ? (double)((narrays * rep - 1) * (ngenes - 1)) : 0.0;
            double dfVG = fitVG == 1 ? (double)((nvars - 1) * (ngenes - 1)) : 0.0;
            double[] array = new double[]{0.0, 0.0, 0.0, 0.0};
            Matrix ar0 = new Matrix(array, 1);
            table.setMatrix(0, 0, 0, 3, ar0);
            AO.setTable(0, ar0);
            double dfADV = 2 * narrays - 1;
            double ssADV = (double)(ngenes * rep * 1) * MatLab.SumResSq(colmeans);
            double ss = ssADV / dfADV;
            double[] array1 = new double[]{0.0, dfADV, ssADV, ss};
            Matrix ar1 = new Matrix(array1, 1);
            table.setMatrix(1, 1, 0, 3, ar1);
            AO.setTable(1, ar1);
            AO.setLeft(1, "ADV");
            double dfG = ngenes - 1;
            double ssG = (double)(2 * narrays * rep) * MatLab.SumSq(AO.getG());
            double[] array2 = new double[]{0.0, dfG, ssG, ssG / dfG};
            Matrix ar2 = new Matrix(array2, 1);
            table.setMatrix(2, 2, 0, 3, ar2);
            AO.setTable(2, ar2);
            AO.setLeft(2, "G");
            if (latsq == 1) {
                System.out.println("Inside latsq==1 \n");
                AO.setLeft(3, "VG");
                if (fitVG == 1) {
                    double[] VGarr = AO.getVG().getColumnPackedCopy();
                    double ssVG = (double)(2 * rep) * MatLab.SumSq(VGarr);
                    double[] array3 = new double[]{0.0, dfVG, ssVG, ssVG / dfVG};
                    Matrix ar3 = new Matrix(array3, 1);
                    table.setMatrix(3, 3, 0, 3, ar3);
                    AO.setTable(3, ar3);
                } else {
                    double[] array3 = new double[]{0.0, 0.0, 0.0, 0.0};
                    Matrix ar3 = new Matrix(array3, 1);
                    table.setMatrix(3, 3, 0, 3, ar3);
                    AO.setTable(3, ar3);
                }
                AO.setLeft(4, "AG");
                if (fitAG == 1) {
                    double[] AGarr = AO.getAG().getColumnPackedCopy();
                    double ssAG = 2.0 * MatLab.SumSq(AGarr);
                    double[] array4 = new double[]{0.0, dfAG, ssAG, ssAG / dfAG};
                    Matrix ar4 = new Matrix(array4, 1);
                    table.setMatrix(4, 4, 0, 3, ar4);
                    AO.setTable(4, ar4);
                } else {
                    double[] array4 = new double[]{0.0, 0.0, 0.0, 0.0};
                    Matrix ar4 = new Matrix(array4, 1);
                    table.setMatrix(4, 4, 0, 3, ar4);
                    AO.setTable(4, ar4);
                }
                AO.setLeft(5, "DG");
                if (fitDG == 1) {
                    double[] DGarr = AO.getDG().getColumnPackedCopy();
                    double ssDG = (double)(narrays * rep) * MatLab.SumSq(DGarr);
                    double[] array5 = new double[]{0.0, dfDG, ssDG, ssDG / dfDG};
                    Matrix ar5 = new Matrix(array5, 1);
                    table.setMatrix(5, 5, 0, 3, ar5);
                    AO.setTable(5, ar5);
                } else {
                    double[] array5 = new double[]{0.0, 0.0, 0.0, 0.0};
                    Matrix ar5 = new Matrix(array5, 1);
                    table.setMatrix(5, 5, 0, 3, ar5);
                    AO.setTable(5, ar5);
                }
                AO.setLeft(6, "error");
                double dfE = (double)data.getColumnPackedCopy().length - dfADV - dfG - dfVG - dfAG - dfDG - 1.0;
                double ssE = MatLab.Sum(AO.getRss().getColumnPackedCopy());
                double[] array6 = new double[]{0.0, dfE, ssE, ssE / dfE};
                Matrix ar6 = new Matrix(array6, 1);
                table.setMatrix(6, 6, 0, 3, ar6);
                AO.setTable(6, ar6);
                AO.setLeft(7, "total");
                double dfT = data.getColumnPackedCopy().length - 1;
                double[] datarr = data.getColumnPackedCopy();
                double ssT = MatLab.SumResSq(datarr);
                double[] array7 = new double[]{0.0, dfT, ssT, 0.0};
                Matrix ar7 = new Matrix(array7, 1);
                table.setMatrix(7, 7, 0, 3, ar7);
                AO.setTable(7, ar7);
            } else if (even == 1) {
                Matrix dg;
                double[] dgarr;
                System.out.println("Inside even==1 \n");
                double dfVGAG = dfVG + dfAG;
                AG = AO.getAG();
                AGrows = AG.getRowDimension() - 1;
                tm = AG.getMatrix(0, AGrows, 0, rep - 1);
                tmv = tm.getColumnPackedCopy();
                Matrix reAG = MatLab.HorzCat(tmv, tmv);
                int k = 1;
                while (k < narrays) {
                    tm = AG.getMatrix(0, AGrows, (k - 1) * rep + 1, k * rep);
                    tmv = tm.getColumnPackedCopy();
                    tm1 = MatLab.HorzCat(tmv, tmv);
                    reAG = MatLab.HorzCat(reAG, tm1);
                    ++k;
                }
                arr = new int[ngenes];
                i = 0;
                while (i < ngenes) {
                    arr[i] = i;
                    ++i;
                }
                indx = MatLab.RepMatVert(arr, rep);
                double[] indxArr = indx.getColumnPackedCopy();
                int[] indxArrInt = new int[indxArr.length];
                int m = 0;
                while (m < indxArr.length) {
                    indxArrInt[m] = (int)indxArr[m];
                    ++m;
                }
                Matrix VG = AO.getVG();
                int[] varidMatlab = new int[varid.length];
                i = 0;
                while (i < varid.length) {
                    varidMatlab[i] = varid[i] - 1;
                    ++i;
                }
                Matrix reVG = VG.getMatrix(indxArrInt, varidMatlab);
                AO.setLeft(3, "VG,AG");
                double[] reAGv = reAG.getColumnPackedCopy();
                double[] reVGv = reVG.getColumnPackedCopy();
                int l = reAGv.length;
                double[] reVGAGv = new double[l];
                i = 0;
                while (i < reAGv.length) {
                    reVGAGv[i] = reVGv[i] + reAGv[i];
                    ++i;
                }
                double ssVGAG = MatLab.SumSq(reVGAGv);
                double[] ssv = new double[]{0.0, dfVGAG, ssVGAG, ssVGAG / dfVGAG};
                Matrix ssM = new Matrix(ssv, 1);
                table.setMatrix(3, 3, 0, 3, ssM);
                AO.setTable(3, ssM);
                AO.setLeft(4, "DG");
                if (fitDG == 1) {
                    double ssDG = (double)(narrays * rep) * MatLab.SumSq(AO.getDG().getColumnPackedCopy());
                    dgarr = new double[]{0.0, dfDG, ssDG, ssDG / dfDG};
                    dg = new Matrix(dgarr, 1);
                    table.setMatrix(4, 4, 0, 3, dg);
                    AO.setTable(4, dg);
                } else {
                    dgarr = new double[]{0.0, 0.0, 0.0, 0.0};
                    dg = new Matrix(dgarr, 1);
                    table.setMatrix(4, 4, 0, 3, dg);
                    AO.setTable(4, dg);
                }
                AO.setLeft(5, "error");
                double dfE = (double)data.getColumnPackedCopy().length - dfADV - dfG - dfVGAG - dfDG - 1.0;
                double ssE = MatLab.Sum(AO.getRss().getColumnPackedCopy());
                double[] ssEv = new double[]{0.0, dfE, ssE, ssE / dfE};
                Matrix ssEM = new Matrix(ssEv, 1);
                table.setMatrix(5, 5, 0, 3, ssEM);
                AO.setTable(5, ssEM);
                AO.setLeft(6, "total");
                double dfT = data.getColumnPackedCopy().length - 1;
                double ssT = MatLab.SumResSq(data.getColumnPackedCopy());
                double[] ssTv = new double[]{0.0, dfT, ssT, 0.0};
                Matrix ssTM = new Matrix(ssTv, 1);
                table.setMatrix(6, 6, 0, 3, ssTM);
                AO.setTable(6, ssTM);
            } else {
                Matrix reDG;
                System.out.println("Inside else: designs in which D and V are partially confounded \n");
                double dfVGAGDG = dfDG + dfAG + dfVG;
                AG = AO.getAG();
                AGrows = AG.getRowDimension() - 1;
                tm = AG.getMatrix(0, AGrows, 0, rep - 1);
                tmv = tm.getColumnPackedCopy();
                Matrix reAG = MatLab.HorzCat(tmv, tmv);
                int k = 1;
                while (k < narrays) {
                    tm = AG.getMatrix(0, AGrows, (k - 1) * rep + 1, k * rep);
                    tmv = tm.getColumnPackedCopy();
                    tm1 = MatLab.HorzCat(tmv, tmv);
                    reAG = MatLab.HorzCat(reAG, tm1);
                    ++k;
                }
                arr = new int[ngenes];
                i = 0;
                while (i < ngenes) {
                    arr[i] = i;
                    ++i;
                }
                indx = MatLab.RepMatVert(arr, rep);
                double[] indxArr = indx.getColumnPackedCopy();
                int[] indxArrInt = new int[indxArr.length];
                int m = 0;
                while (m < indxArr.length) {
                    indxArrInt[m] = (int)indxArr[m];
                    ++m;
                }
                Matrix VG = AO.getVG();
                int[] varidMatlab = new int[varid.length];
                i = 0;
                while (i < varid.length) {
                    varidMatlab[i] = varid[i] - 1;
                    ++i;
                }
                Matrix reVG = VG.getMatrix(indxArrInt, varidMatlab);
                int[] dgarr = new int[]{1, 2};
                Matrix dg1 = MatLab.RepMatHorz(dgarr, narrays);
                double[] dg1arr = dg1.getRowPackedCopy();
                int[] dg1int = new int[dg1arr.length];
                i = 0;
                while (i < dg1arr.length - 1) {
                    dg1int[i] = (int)dg1arr[i];
                    ++i;
                }
                Matrix DG = AO.getDG();
                try {
                    reDG = DG.getMatrix(indxArrInt, dg1int);
                }
                catch (Exception e) {
                    System.out.println("Exception in table construction:DG matrix is underscaled.");
                    reDG = new Matrix(indxArr.length, 2 * narrays, 0.0);
                }
                AO.setLeft(3, "VG,AG, DG");
                double[] reAGv1 = reAG.getColumnPackedCopy();
                double[] reVGv1 = reVG.getColumnPackedCopy();
                double[] reDGv = reDG.getColumnPackedCopy();
                int l = reAGv1.length;
                double[] reVGAGv = new double[l];
                i = 0;
                while (i < reAGv1.length) {
                    reVGAGv[i] = reVGv1[i] + reAGv1[i] + reDGv[i];
                    ++i;
                }
                double ssVGAGDG = MatLab.SumSq(reVGAGv);
                double[] ssVGAGDGv = new double[]{0.0, dfVGAGDG, ssVGAGDG, ssVGAGDG / dfVGAGDG};
                Matrix ssVGAGDGm = new Matrix(ssVGAGDGv, 1);
                AO.setTable(3, ssVGAGDGm);
                AO.setLeft(4, "error");
                double dfE = (double)data.getColumnPackedCopy().length - dfADV - dfG - dfVGAGDG - 1.0;
                double ssE = MatLab.Sum(AO.getRss().getColumnPackedCopy());
                double[] ssEv = new double[]{0.0, dfE, ssE, ssE / dfE};
                Matrix ssEM = new Matrix(ssEv, 1);
                table.setMatrix(4, 4, 0, 3, ssEM);
                AO.setTable(4, ssEM);
                AO.setLeft(5, "total");
                double dfT = data.getColumnPackedCopy().length - 1;
                double ssT = MatLab.SumResSq(data.getColumnPackedCopy());
                double[] ssTv = new double[]{0.0, dfT, ssT, 0.0};
                Matrix ssTM = new Matrix(ssTv, 1);
                table.setMatrix(5, 5, 0, 3, ssTM);
                AO.setTable(5, ssTM);
            }
        } else {
            Matrix def = new Matrix(1, 1, 0.0);
            Matrix def1 = MatLab.RepMatHorz(def, 4);
            table.setMatrix(0, 0, 0, 3, def1);
            AO.setTable(7, def1);
        }
        long timeend = System.currentTimeMillis();
        System.out.println("Timing : total =" + (timeend - timestart));
        System.out.println("Timing : loop =" + (timeL1 - timeL0));
        System.out.println("Timing : timeSolve =" + timeSolve);
        System.out.println("Timing : looprest =" + looprest);
        return AO;
    }
}

