/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

import Jama.Matrix;
import Jama.QRDecomposition;
import MAANOVA.DataObject;
import MAANOVA.MyMatlab;
import java.util.Arrays;

public class ModelObject {
    private int fitVG;
    private int fitDG;
    private int fitAG;
    private int[] varid;
    private int nvars;
    private int[] varcount;
    private int even_flag;
    private int latsq_flag;
    private int VDCon_flag;
    private Matrix X;
    private Matrix A;
    private Matrix Q;
    private Matrix R;

    public int getFitVG() {
        return this.fitVG;
    }

    public int getFitDG() {
        return this.fitDG;
    }

    public int getFitAG() {
        return this.fitAG;
    }

    public int[] getVarid() {
        return this.varid;
    }

    public int getNvars() {
        return this.nvars;
    }

    public int[] getVarcount() {
        return this.varcount;
    }

    public int getEvenFlag() {
        return this.even_flag;
    }

    public int getLatsqFlag() {
        return this.latsq_flag;
    }

    public int getVDConFlag() {
        return this.VDCon_flag;
    }

    public Matrix getX() {
        return this.X;
    }

    public Matrix getA() {
        return this.A;
    }

    public Matrix getQ() {
        return this.Q;
    }

    public Matrix getR() {
        return this.R;
    }

    public ModelObject(DataObject DObject, int[] varid, int[] anova_model) {
        QRDecomposition QR;
        boolean VDconfound;
        int[] temp;
        int rep = DObject.getNreps();
        int narrays = DObject.getNarrays();
        int ngenes = DObject.getNgenes();
        int nspots = DObject.getNspots();
        this.fitVG = anova_model[0];
        this.fitDG = anova_model[1];
        this.fitAG = anova_model[2];
        this.varid = varid;
        int VIDlength = varid.length;
        if (VIDlength != narrays * 2) {
            throw new IllegalArgumentException("Variety ID length does not match the data!");
        }
        MyMatlab MatLab = new MyMatlab();
        int[] copyvarid = new int[VIDlength];
        System.arraycopy(varid, 0, copyvarid, 0, VIDlength);
        Arrays.sort(copyvarid);
        this.nvars = copyvarid[VIDlength - 1];
        int i = 0;
        while (i < this.nvars) {
            if (MatLab.IsMember(i + 1, varid) == 0) {
                throw new IllegalArgumentException("Variety IDs missing any ID for ");
            }
            ++i;
        }
        Matrix varcount = new Matrix(1, this.nvars, 0.0);
        int i2 = 0;
        while (i2 < VIDlength) {
            varcount.set(0, varid[i2] - 1, varcount.get(0, varid[i2] - 1) + 1.0);
            ++i2;
        }
        int even = 1;
        int i3 = 0;
        int j = 0;
        while (even == 1 && i3 < this.nvars) {
            temp = MatLab.FindInt(varid, ++i3);
            int l = temp.length;
            int countodd = 0;
            int counteven = 0;
            j = 0;
            while (j < l) {
                if (temp[j] % 2 != 0) {
                    ++countodd;
                } else {
                    ++counteven;
                }
                ++j;
            }
            if (countodd == counteven) continue;
            even = 0;
        }
        int latsq = 1;
        if (even != 0 && this.nvars == 2) {
            i3 = 0;
            while (i3 < narrays) {
                if (varid[2 * i3 + 1] == varid[2 * i3]) {
                    latsq = 0;
                }
                ++i3;
            }
        } else {
            latsq = 0;
        }
        int tyu = 11;
        if (even == 0) {
            VDconfound = true;
            i3 = 0;
            while (VDconfound && i3 < this.nvars) {
                if (MatLab.SumInt(MatLab.ModInt(temp = MatLab.FindInt(varid, ++i3), 2), 0) <= 0 || MatLab.SumInt(MatLab.ModInt(temp, 2), 1) <= 0) continue;
                VDconfound = false;
            }
        } else {
            VDconfound = false;
        }
        if (VDconfound && this.fitDG == 1 && this.fitVG == 1) {
            throw new IllegalArgumentException("V and D are completely confounded. DG cannot be fitted. You have to deselect fitDG ");
        }
        this.X = new Matrix(2 * narrays * rep, 1, 1.0);
        if (this.fitVG == 1) {
            Matrix variety = MatLab.RepMatVert(varid, rep);
            Matrix tmp = MatLab.RepMatVert(varid, rep);
            double[] varietyCol = variety.getColumnPackedCopy();
            double[] tmpCol = tmp.getColumnPackedCopy();
            i3 = 1;
            while (i3 <= this.nvars - 1) {
                j = 1;
                while (j <= varietyCol.length) {
                    tmpCol[j - 1] = (double)(varietyCol[j - 1] == (double)i3 ? 1 : 0) / varcount.get(0, i3 - 1) - (double)(varietyCol[j - 1] == (double)this.nvars ? 1 : 0) / varcount.get(0, this.nvars - 1);
                    ++j;
                }
                Matrix tmp1 = new Matrix(tmpCol, tmpCol.length);
                this.X = MatLab.HorzCat(this.X, tmp1);
                ++i3;
            }
            boolean sss = true;
        }
        boolean sss = true;
        if (this.fitDG == 1) {
            Matrix dye1 = new Matrix(1, 1, 1.0);
            Matrix dye2 = new Matrix(1, 1, 2.0);
            Matrix dye = MatLab.RepMatVert(MatLab.VertCat(MatLab.RepMatVert(dye1, rep), MatLab.RepMatVert(dye2, rep)), narrays);
            int rowX = this.X.getRowDimension();
            Matrix tmpX = new Matrix(rowX, dye.getColumnDimension(), 1.0);
            i3 = 0;
            while (i3 < rowX) {
                tmpX.set(i3, 0, (double)((dye.get(i3, 0) == 1.0 ? 1 : 0) - (dye.get(i3, 0) == 2.0 ? 1 : 0)));
                ++i3;
            }
            this.X = MatLab.HorzCat(this.X, tmpX);
        }
        if (this.fitAG == 1) {
            Matrix r = new Matrix(rep, 1, 1.0);
            i3 = 0;
            while (i3 < rep) {
                r.set(i3, 0, (double)(i3 + 1));
                ++i3;
            }
            Matrix replicate = MatLab.RepMatVert(r, 2 * narrays);
            double[] replicateV = replicate.getColumnPackedCopy();
            Matrix n = new Matrix(1, narrays, 1.0);
            i3 = 0;
            while (i3 < narrays) {
                n.set(0, i3, (double)(i3 + 1));
                ++i3;
            }
            Matrix array = MatLab.RepMatVert(n, 2 * rep);
            double[] arrayV = array.getColumnPackedCopy();
            double[] spotV = new double[arrayV.length];
            i3 = 0;
            while (i3 < arrayV.length) {
                spotV[i3] = (double)rep * (arrayV[i3] - 1.0) + replicateV[i3];
                ++i3;
            }
            Matrix tmpA = new Matrix(spotV.length, 1, 1.0);
            i3 = 1;
            while (i3 <= nspots - 1) {
                j = 0;
                while (j < spotV.length) {
                    tmpA.set(j, 0, (double)((spotV[j] == (double)i3 ? 1 : 0) - (spotV[j] == (double)nspots ? 1 : 0)));
                    ++j;
                }
                this.X = MatLab.HorzCat(this.X, tmpA);
                ++i3;
            }
            boolean Y = false;
        }
        if ((QR = new QRDecomposition(this.X)).isFullRank()) {
            System.out.println("QR has full rank \n");
        } else {
            System.out.println("QR has no full rank!!! \n");
        }
        this.Q = QR.getQ();
        this.R = QR.getR();
        double Rcond = this.R.cond();
        double Qcond = this.Q.cond();
        this.A = new Matrix(1, 1, 1.0);
        if (this.fitVG == 1) {
            int[] h = new int[]{-1};
            Matrix tmpVG = MatLab.VertCat(MatLab.Eye(this.nvars - 1), MatLab.RepMatHorz(h, this.nvars - 1));
            int tmprow = tmpVG.getRowDimension();
            i3 = 0;
            while (i3 <= this.nvars - 1) {
                j = 0;
                while (j < tmprow - 1) {
                    tmpVG.set(i3, j, tmpVG.get(i3, j) / varcount.get(0, i3));
                    ++j;
                }
                ++i3;
            }
            this.A = MatLab.BlkDiag(this.A, tmpVG);
        }
        if (this.fitDG == 1) {
            double[] dga = new double[]{1.0, -1.0};
            Matrix dg = new Matrix(dga, 2);
            this.A = MatLab.BlkDiag(this.A, dg);
        }
        if (this.fitAG == 1) {
            int[] h = new int[]{-1};
            this.A = MatLab.BlkDiag(this.A, MatLab.VertCat(MatLab.Eye(nspots - 1), MatLab.RepMatHorz(h, nspots - 1)));
        }
        this.even_flag = even;
        this.latsq_flag = latsq;
    }
}

