/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

public abstract class ProbabilityDistribution {
    public abstract double probability(double var1);

    public abstract double cumulative(double var1);

    public abstract double inverse(double var1);

    protected void checkRange(double x, double lo, double hi) {
        if (x < lo || x > hi) {
            throw new IllegalArgumentException("The argument of the distribution method should be between " + lo + " and " + hi + ".");
        }
    }

    protected void checkRange(double x) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("The argument of the distribution method should be between 0 and 1.");
        }
    }

    protected double findRoot(double prob, double guess, double xLo, double xHi) {
        double accuracy = 1.0E-10;
        int maxIteration = 150;
        double x = guess;
        double xNew = guess;
        double dx = 1000.0;
        int i = 0;
        while (Math.abs(dx) > 1.0E-10 && i++ < 150) {
            double error = this.cumulative(x) - prob;
            if (error < 0.0) {
                xLo = x;
            } else {
                xHi = x;
            }
            double pdf = this.probability(x);
            if (pdf != 0.0) {
                dx = error / pdf;
                xNew = x - dx;
            }
            if (xNew < xLo || xNew > xHi || pdf == 0.0) {
                xNew = (xLo + xHi) / 2.0;
                dx = xNew - x;
            }
            x = xNew;
        }
        return x;
    }
}

