/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementTags;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Section;
import com.lowagie.text.StringCompare;
import com.lowagie.text.Table;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;

public class XmlWriter
extends DocWriter
implements DocListener {
    public static final byte[] PROLOG = DocWriter.getISOBytes((String)"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
    public static final byte[] DOCTYPE = DocWriter.getISOBytes((String)"<!DOCTYPE ITEXT SYSTEM \"");
    public static final byte[] DTD = DocWriter.getISOBytes((String)"http://www.lowagie.com/iText/itext.dtd");
    private static final String[] xmlCode = new String[256];
    private TreeMap itext = new TreeMap(new StringCompare());

    protected XmlWriter(Document document, OutputStream outputStream) {
        super(document, outputStream);
        this.document.addDocListener((DocListener)this);
        try {
            outputStream.write(PROLOG);
            outputStream.write(DOCTYPE);
            outputStream.write(DTD);
            outputStream.write(34);
            outputStream.write(62);
            outputStream.write(10);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter((Exception)iOException);
        }
    }

    protected XmlWriter(Document document, OutputStream outputStream, String string) {
        super(document, outputStream);
        this.document.addDocListener((DocListener)this);
        try {
            outputStream.write(PROLOG);
            outputStream.write(DOCTYPE);
            outputStream.write(DocWriter.getISOBytes((String)string));
            outputStream.write(34);
            outputStream.write(62);
            outputStream.write(10);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter((Exception)iOException);
        }
    }

    public static XmlWriter getInstance(Document document, OutputStream outputStream) {
        return new XmlWriter(document, outputStream);
    }

    public static XmlWriter getInstance(Document document, OutputStream outputStream, String string) {
        return new XmlWriter(document, outputStream, string);
    }

    public boolean add(Element element) throws DocumentException {
        if (this.pause) {
            return false;
        }
        try {
            switch (element.type()) {
                case 1: {
                    this.itext.put("title", ((Meta)element).content());
                    return true;
                }
                case 2: {
                    this.itext.put("subject", ((Meta)element).content());
                    return true;
                }
                case 3: {
                    this.itext.put("keywords", ((Meta)element).content());
                    return true;
                }
                case 4: {
                    this.itext.put("author", ((Meta)element).content());
                    return true;
                }
            }
            this.write(element, 1);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void open() {
        super.open();
        try {
            this.itext.put("producer", "iTextXML by lowagie.com");
            this.itext.put("creationdate", new Date().toString());
            this.writeStart("itext");
            Iterator iterator = this.itext.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.write(string, (String)this.itext.get(string));
            }
            this.os.write(62);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter((Exception)iOException);
        }
    }

    public boolean newPage() throws DocumentException {
        if (this.pause || !this.open) {
            return false;
        }
        try {
            this.writeStart("newpage");
            this.writeEnd();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void close() {
        try {
            this.os.write(10);
            this.writeEnd("itext");
            super.close();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter((Exception)iOException);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void write(Element var1_1, int var2_2) throws IOException {
        switch (var1_1.type()) {
            case 10: {
                var3_3 = (Chunk)var1_1;
                try {
                    var4_16 = var3_3.getImage();
                    this.write((Element)var4_16, var2_2);
                    return;
                }
                catch (NullPointerException var4_17) {
                    this.addTabs(var2_2);
                    var4_18 = var3_3.getAttributes();
                    if (var3_3.font().isStandardFont() && var4_18 == null && !DocWriter.hasMarkupAttributes((Element)var3_3)) {
                        this.write(XmlWriter.encode(var3_3.content(), var2_2));
                        return;
                    }
                    if (var4_18 != null && var4_18.get("NEWPAGE") != null) {
                        this.writeStart("newpage");
                        this.writeEnd();
                        return;
                    }
                    this.writeStart("chunk");
                    if (!var3_3.font().isStandardFont()) {
                        this.write(var3_3.font());
                    }
                    if (var4_18 == null) ** GOTO lbl31
                    var5_27 = var4_18.keySet().iterator();
                    ** while (var5_27.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    var6_30 = (String)var5_27.next();
                    if (var6_30.equals("LOCALGOTO") || var6_30.equals("LOCALDESTINATION") || var6_30.equals("GENERICTAG")) {
                        var7_32 = (String)var4_18.get(var6_30);
                        this.write(var6_30.toLowerCase(), var7_32);
                    }
                    if (!var6_30.equals("SUBSUPSCRIPT")) continue;
                    this.write(var6_30.toLowerCase(), String.valueOf((Float)var4_18.get(var6_30)));
                    continue;
                }
lbl31:
                // 2 sources

                if (DocWriter.hasMarkupAttributes((Element)var3_3)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_3);
                }
                this.os.write(62);
                this.write(XmlWriter.encode(var3_3.content(), var2_2));
                this.writeEnd("chunk");
                return;
            }
            case 11: {
                var3_4 = (Phrase)var1_1;
                this.addTabs(var2_2);
                this.writeStart("phrase");
                this.write("leading", String.valueOf(var3_4.leading()));
                this.write(var3_4.font());
                if (DocWriter.hasMarkupAttributes((Element)var3_4)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_4);
                }
                this.os.write(62);
                var4_19 = var3_4.iterator();
                while (var4_19.hasNext()) {
                    this.write((Element)var4_19.next(), var2_2 + 1);
                }
                this.addTabs(var2_2);
                this.writeEnd("phrase");
                return;
            }
            case 17: {
                var3_5 = (Anchor)var1_1;
                this.addTabs(var2_2);
                this.writeStart("anchor");
                this.write("leading", String.valueOf(var3_5.leading()));
                this.write(var3_5.font());
                if (var3_5.name() != null) {
                    this.write("name", var3_5.name());
                }
                if (var3_5.reference() != null) {
                    this.write("reference", var3_5.reference());
                }
                if (DocWriter.hasMarkupAttributes((Element)var3_5)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_5);
                }
                this.os.write(62);
                var4_20 = var3_5.iterator();
                while (var4_20.hasNext()) {
                    this.write((Element)var4_20.next(), var2_2 + 1);
                }
                this.addTabs(var2_2);
                this.writeEnd("anchor");
                return;
            }
            case 12: {
                var3_6 = (Paragraph)var1_1;
                this.addTabs(var2_2);
                this.writeStart("paragraph");
                this.write("leading", String.valueOf(var3_6.leading()));
                this.write(var3_6.font());
                this.write("align", ElementTags.getAlignment((int)var3_6.alignment()));
                if (var3_6.indentationLeft() != 0.0f) {
                    this.write("indentationleft", String.valueOf(var3_6.indentationLeft()));
                }
                if (var3_6.indentationRight() != 0.0f) {
                    this.write("indentationright", String.valueOf(var3_6.indentationRight()));
                }
                if (DocWriter.hasMarkupAttributes((Element)var3_6)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_6);
                }
                this.os.write(62);
                var4_21 = var3_6.iterator();
                while (var4_21.hasNext()) {
                    this.write((Element)var4_21.next(), var2_2 + 1);
                }
                this.addTabs(var2_2);
                this.writeEnd("paragraph");
                return;
            }
            case 13: {
                var3_7 = (Section)var1_1;
                this.addTabs(var2_2);
                this.writeStart("section");
                this.writeSection(var3_7, var2_2);
                this.writeEnd("section");
                return;
            }
            case 16: {
                var3_8 = (Chapter)var1_1;
                this.addTabs(var2_2);
                this.writeStart("chapter");
                if (DocWriter.hasMarkupAttributes((Element)var3_8)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_8);
                }
                this.writeSection((Section)var3_8, var2_2);
                this.writeEnd("chapter");
                return;
            }
            case 14: {
                var3_9 = (List)var1_1;
                this.addTabs(var2_2);
                this.writeStart("list");
                this.write("numbered", String.valueOf(var3_9.isNumbered()));
                this.write("symbolindent", String.valueOf(var3_9.symbolIndent()));
                if (var3_9.first() != 1) {
                    this.write("first", String.valueOf(var3_9.first()));
                }
                if (var3_9.indentationLeft() != 0.0f) {
                    this.write("indentationleft", String.valueOf(var3_9.indentationLeft()));
                }
                if (var3_9.indentationRight() != 0.0f) {
                    this.write("indentationright", String.valueOf(var3_9.indentationRight()));
                }
                if (!var3_9.isNumbered()) {
                    this.write("listsymbol", var3_9.symbol().content());
                }
                this.write(var3_9.symbol().font());
                if (DocWriter.hasMarkupAttributes((Element)var3_9)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_9);
                }
                this.os.write(62);
                var4_22 = var3_9.getItems().iterator();
                while (var4_22.hasNext()) {
                    this.write((Element)var4_22.next(), var2_2 + 1);
                }
                this.addTabs(var2_2);
                this.writeEnd("list");
                return;
            }
            case 15: {
                var3_10 = (ListItem)var1_1;
                this.addTabs(var2_2);
                this.writeStart("listitem");
                this.write("leading", String.valueOf(var3_10.leading()));
                this.write(var3_10.font());
                this.write("align", ElementTags.getAlignment((int)var3_10.alignment()));
                if (var3_10.indentationLeft() != 0.0f) {
                    this.write("indentationleft", String.valueOf(var3_10.indentationLeft()));
                }
                if (var3_10.indentationRight() != 0.0f) {
                    this.write("indentationright", String.valueOf(var3_10.indentationRight()));
                }
                if (DocWriter.hasMarkupAttributes((Element)var3_10)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_10);
                }
                this.os.write(62);
                var4_23 = var3_10.iterator();
                while (var4_23.hasNext()) {
                    this.write((Element)var4_23.next(), var2_2 + 1);
                }
                this.addTabs(var2_2);
                this.writeEnd("listitem");
                return;
            }
            case 20: {
                var3_11 = (Cell)var1_1;
                this.addTabs(var2_2);
                this.writeStart("cell");
                this.write((Rectangle)var3_11);
                this.write("horizontalalign", ElementTags.getAlignment((int)var3_11.horizontalAlignment()));
                this.write("verticalalign", ElementTags.getAlignment((int)var3_11.verticalAlignment()));
                if (var3_11.cellWidth() != null) {
                    this.write("width", var3_11.cellWidth());
                }
                if (var3_11.colspan() != 1) {
                    this.write("colspan", String.valueOf(var3_11.colspan()));
                }
                if (var3_11.rowspan() != 1) {
                    this.write("rowspan", String.valueOf(var3_11.rowspan()));
                }
                if (var3_11.header()) {
                    this.write("header", String.valueOf(true));
                }
                if (var3_11.noWrap()) {
                    this.write("nowrap", String.valueOf(true));
                }
                if (var3_11.leading() != -1.0f) {
                    this.write("leading", String.valueOf(var3_11.leading()));
                }
                if (DocWriter.hasMarkupAttributes((Element)var3_11)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_11);
                }
                this.os.write(62);
                var4_24 = var3_11.getElements();
                while (var4_24.hasNext()) {
                    this.write((Element)var4_24.next(), var2_2 + 1);
                }
                this.addTabs(var2_2);
                this.writeEnd("cell");
                return;
            }
            case 21: {
                var3_12 = (Row)var1_1;
                this.addTabs(var2_2);
                this.writeStart("row");
                if (DocWriter.hasMarkupAttributes((Element)var3_12)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_12);
                }
                this.os.write(62);
                var5_28 = 0;
                while (var5_28 < var3_12.columns()) {
                    var4_25 = (Element)var3_12.getCell(var5_28);
                    if (var4_25 != null) {
                        this.write(var4_25, var2_2 + 1);
                    }
                    ++var5_28;
                }
                this.addTabs(var2_2);
                this.writeEnd("row");
                return;
            }
            case 22: {
                var3_13 = (Table)var1_1;
                var3_13.complete();
                this.addTabs(var2_2);
                this.writeStart("table");
                this.write("columns", String.valueOf(var3_13.columns()));
                this.os.write(32);
                this.write("width");
                this.os.write(61);
                this.os.write(34);
                if (!"".equals(var3_13.absWidth())) {
                    this.write(var3_13.absWidth());
                } else {
                    this.write(String.valueOf(var3_13.widthPercentage()));
                    this.write("%");
                }
                this.os.write(34);
                this.write("align", ElementTags.getAlignment((int)var3_13.alignment()));
                this.write("cellpadding", String.valueOf(var3_13.cellpadding()));
                this.write("cellspacing", String.valueOf(var3_13.cellspacing()));
                this.os.write(32);
                this.write("widths");
                this.os.write(61);
                this.os.write(34);
                var4_26 = var3_13.getProportionalWidths();
                this.write(String.valueOf(var4_26[0]));
                var5_29 = 1;
                while (var5_29 < var4_26.length) {
                    this.write(";");
                    this.write(String.valueOf(var4_26[var5_29]));
                    ++var5_29;
                }
                this.os.write(34);
                this.write((Rectangle)var3_13);
                if (DocWriter.hasMarkupAttributes((Element)var3_13)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_13);
                }
                this.os.write(62);
                var7_33 = var3_13.iterator();
                while (var7_33.hasNext()) {
                    var6_31 = (Row)var7_33.next();
                    this.write((Element)var6_31, var2_2 + 1);
                }
                this.addTabs(var2_2);
                this.writeEnd("table");
                return;
            }
            case 29: {
                var3_14 = (Annotation)var1_1;
                this.addTabs(var2_2);
                this.writeStart("annotation");
                if (var3_14.title() != null) {
                    this.write("title", var3_14.title());
                }
                if (var3_14.content() != null) {
                    this.write("content", var3_14.content());
                }
                if (DocWriter.hasMarkupAttributes((Element)var3_14)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_14);
                }
                this.writeEnd();
                return;
            }
            case 31: 
            case 32: 
            case 33: {
                var3_15 = (Image)var1_1;
                if (var3_15.url() == null) {
                    return;
                }
                this.addTabs(var2_2);
                this.writeStart("image");
                this.write("url", var3_15.url().toString());
                if ((var3_15.alignment() & 2) > 0) {
                    this.write("align", "Left");
                } else if ((var3_15.alignment() & 1) > 0) {
                    this.write("align", "Right");
                } else if ((var3_15.alignment() & 3) > 0) {
                    this.write("align", "Middle");
                }
                if ((var3_15.alignment() & 8) > 0) {
                    this.write("underlying", String.valueOf(true));
                }
                if ((var3_15.alignment() & 4) > 0) {
                    this.write("textwrap", String.valueOf(true));
                }
                if (var3_15.alt() != null) {
                    this.write("alt", var3_15.alt());
                }
                if (var3_15.hasAbsolutePosition()) {
                    this.write("absolutex", String.valueOf(var3_15.absoluteX()));
                    this.write("absolutey", String.valueOf(var3_15.absoluteY()));
                }
                this.write("plainwidth", String.valueOf(var3_15.plainWidth()));
                this.write("plainheight", String.valueOf(var3_15.plainHeight()));
                if (DocWriter.hasMarkupAttributes((Element)var3_15)) {
                    this.writeMarkupAttributes((MarkupAttributes)var3_15);
                }
                this.writeEnd();
                return;
            }
        }
    }

    private void writeSection(Section section, int n) throws IOException {
        Iterator iterator;
        this.write("numberdepth", String.valueOf(section.numberDepth()));
        this.write("depth", String.valueOf(section.depth()));
        this.write("indent", String.valueOf(section.indentation()));
        if (section.indentationLeft() != 0.0f) {
            this.write("indentationleft", String.valueOf(section.indentationLeft()));
        }
        if (section.indentationRight() != 0.0f) {
            this.write("indentationright", String.valueOf(section.indentationRight()));
        }
        this.os.write(62);
        if (section.title() != null) {
            this.addTabs(n + 1);
            this.writeStart("title");
            this.write("leading", String.valueOf(section.title().leading()));
            this.write("align", ElementTags.getAlignment((int)section.title().alignment()));
            if (section.title().indentationLeft() != 0.0f) {
                this.write("indentationleft", String.valueOf(section.title().indentationLeft()));
            }
            if (section.title().indentationRight() != 0.0f) {
                this.write("indentationright", String.valueOf(section.title().indentationRight()));
            }
            this.write(section.title().font());
            this.os.write(62);
            iterator = section.title().iterator();
            if (section.depth() > 0) {
                iterator.next();
            }
            while (iterator.hasNext()) {
                this.write((Element)iterator.next(), n + 2);
            }
            this.addTabs(n + 1);
            this.writeEnd("title");
        }
        iterator = section.iterator();
        while (iterator.hasNext()) {
            this.write((Element)iterator.next(), n + 1);
        }
        this.addTabs(n);
    }

    private void write(Rectangle rectangle) throws IOException {
        if (rectangle.borderWidth() != -1.0f) {
            this.write("borderwidth", String.valueOf(rectangle.borderWidth()));
            if (rectangle.hasBorder(4)) {
                this.write("left", String.valueOf(true));
            }
            if (rectangle.hasBorder(8)) {
                this.write("right", String.valueOf(true));
            }
            if (rectangle.hasBorder(1)) {
                this.write("top", String.valueOf(true));
            }
            if (rectangle.hasBorder(2)) {
                this.write("bottom", String.valueOf(true));
            }
        }
        if (rectangle.borderColor() != null) {
            this.write("red", String.valueOf(rectangle.borderColor().getRed()));
            this.write("green", String.valueOf(rectangle.borderColor().getGreen()));
            this.write("blue", String.valueOf(rectangle.borderColor().getBlue()));
        }
        if (rectangle.backgroundColor() != null) {
            this.write("bgred", String.valueOf(rectangle.backgroundColor().getRed()));
            this.write("bggreen", String.valueOf(rectangle.backgroundColor().getGreen()));
            this.write("bgblue", String.valueOf(rectangle.backgroundColor().getBlue()));
        }
        if (rectangle.grayFill() > 0.0f) {
            this.write("grayfill", String.valueOf(rectangle.grayFill()));
        }
    }

    static final String encode(String string, int n) {
        int n2 = string.length();
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n2) {
            char c = string.charAt(n4);
            switch (c) {
                case ' ': {
                    if (n4 - n3 > 60) {
                        n3 = n4;
                        stringBuffer.append("\n");
                        XmlWriter.addTabs(stringBuffer, n);
                        break;
                    }
                }
                default: {
                    stringBuffer.append(xmlCode[c]);
                }
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    static final void addTabs(StringBuffer stringBuffer, int n) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\t");
            ++n2;
        }
    }

    private void write(Font font) throws IOException {
        this.write("font", font.getFamilyname());
        if (font.size() != -1.0f) {
            this.write("size", String.valueOf(font.size()));
        }
        if (font.style() != -1) {
            this.os.write(32);
            this.write("fontstyle");
            this.os.write(61);
            this.os.write(34);
            switch (font.style() & 3) {
                case 0: {
                    this.write("normal");
                    break;
                }
                case 1: {
                    this.write("bold");
                    break;
                }
                case 2: {
                    this.write("italic");
                    break;
                }
                case 3: {
                    this.write("bold");
                    this.write(", ");
                    this.write("italic");
                }
            }
            if ((font.style() & 4) > 0) {
                this.write(", ");
                this.write("underline");
            }
            if ((font.style() & 8) > 0) {
                this.write(", ");
                this.write("line-through");
            }
            this.os.write(34);
        }
        if (font.color() != null) {
            this.write("red", String.valueOf(font.color().getRed()));
            this.write("green", String.valueOf(font.color().getGreen()));
            this.write("blue", String.valueOf(font.color().getBlue()));
        }
    }

    static {
        int n = 0;
        while (n < 10) {
            XmlWriter.xmlCode[n] = "&#00" + n + ";";
            ++n;
        }
        int n2 = 10;
        while (n2 < 32) {
            XmlWriter.xmlCode[n2] = "&#0" + n2 + ";";
            ++n2;
        }
        int n3 = 32;
        while (n3 < 128) {
            XmlWriter.xmlCode[n3] = String.valueOf((char)n3);
            ++n3;
        }
        XmlWriter.xmlCode[10] = "<newline />\n";
        XmlWriter.xmlCode[34] = "&quot;";
        XmlWriter.xmlCode[39] = "&apos;";
        XmlWriter.xmlCode[38] = "&amp;";
        XmlWriter.xmlCode[60] = "&lt;";
        XmlWriter.xmlCode[62] = "&gt;";
        int n4 = 128;
        while (n4 < 256) {
            XmlWriter.xmlCode[n4] = "&#" + n4 + ";";
            ++n4;
        }
    }
}

