/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.tigr.util.StringSplitter;

public class MevFileParser {
    public static final int UNSUPPORTED_FILE = 0;
    public static final int MEV_FILE = 1;
    public static final String UNIQUE_ID_STRING = "UID";
    public static final boolean WITH_HEADER = true;
    private Vector columnHeaders;
    private Vector rawLines;
    private IntVector dataLinesMap;
    private boolean mevFileLoaded;

    public MevFileParser() {
    }

    public MevFileParser(String mevFileName) {
        this.loadFile(new File(mevFileName));
    }

    public static File selectFile(Component dialogParent) {
        return MevFileParser.selectFile(new File(System.getProperty("user.dir")), dialogParent);
    }

    public static File selectFile(File defaultDirectory, Component dialogParent) {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.setDialogTitle("Select an mev file");
        chooser.setCurrentDirectory(defaultDirectory);
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                String extension = "";
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".mev");
            }

            public String getDescription() {
                return "TIGR MeV Files (*.mev)";
            }
        });
        if (chooser.showOpenDialog(dialogParent) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static int validate(File targetFile) {
        return 0;
    }

    public void loadFile(File targetFile) {
        this.dataLinesMap = new IntVector();
        this.rawLines = new Vector();
        this.columnHeaders = new Vector();
        String currentLine = new String();
        BufferedReader reader = null;
        boolean readHeaders = false;
        try {
            reader = new BufferedReader(new FileReader(targetFile));
            int lineCount = 0;
            while ((currentLine = reader.readLine()) != null) {
                this.rawLines.add(currentLine);
                if (!currentLine.startsWith("#")) {
                    if (!readHeaders) {
                        readHeaders = true;
                        StringTokenizer st = new StringTokenizer(currentLine, "\t");
                        while (st.hasMoreTokens()) {
                            this.columnHeaders.add(st.nextToken());
                        }
                    } else {
                        this.dataLinesMap.add(lineCount);
                    }
                }
                ++lineCount;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.mevFileLoaded = false;
            return;
        }
        this.mevFileLoaded = true;
    }

    public boolean isMevFileLoaded() {
        return this.mevFileLoaded;
    }

    public Vector getColumnHeaders() {
        return this.columnHeaders;
    }

    public Vector getColumnAt(int targetColumn) {
        return this.getColumnAt(targetColumn, false);
    }

    public Vector getColumnAt(int targetColumn, boolean withHeaders) {
        Vector columnVector = new Vector(this.dataLinesMap.size() + (withHeaders ? 1 : 0));
        if (withHeaders) {
            columnVector.add(this.columnHeaders.elementAt(targetColumn));
        }
        int i = 0;
        while (i < this.dataLinesMap.size()) {
            StringTokenizer st = new StringTokenizer(this.getElementAtIndex(i));
            int j = 0;
            while (j < targetColumn) {
                st.nextToken();
                ++j;
            }
            columnVector.add(st.nextToken());
            ++i;
        }
        return columnVector;
    }

    public Vector getColumnNamed(String columnName) {
        return this.getColumnNamed(columnName, false);
    }

    public Vector getColumnNamed(String columnName, boolean withHeaders) {
        Vector columnHeaders = this.getColumnHeaders();
        if (columnHeaders.contains(columnName)) {
            return this.getColumnAt(columnHeaders.indexOf(columnName), withHeaders);
        }
        return null;
    }

    public String getLineAt(int rawTargetLine) {
        return (String)this.rawLines.elementAt(rawTargetLine);
    }

    public String getElementAtIndex(int index) {
        return this.getLineAt(this.dataLinesMap.intElementAt(index));
    }

    public String getElementAtRC(int row, int column) {
        return new String();
    }

    public String getElementById(String id) {
        return this.getElementByField(UNIQUE_ID_STRING, id);
    }

    public String getElementByField(String fieldName, String value) {
        Vector targetColumn = this.getColumnNamed(fieldName);
        int i = 0;
        while (i < targetColumn.size()) {
            if (((String)targetColumn.elementAt(i)).equals(value)) {
                return this.getElementAtIndex(i);
            }
            ++i;
        }
        return null;
    }

    public Vector getDataLinesMap() {
        return this.dataLinesMap;
    }

    public String[][] getDataMatrix() {
        return this.getDataMatrix(false);
    }

    public String[][] getDataMatrix(boolean withHeaders) {
        int i;
        Vector columnHeaders = this.getColumnHeaders();
        int hc = withHeaders ? 1 : 0;
        String[][] matrix = new String[this.dataLinesMap.size() + hc][columnHeaders.size()];
        if (withHeaders) {
            i = 0;
            while (i < columnHeaders.size()) {
                matrix[0][i] = (String)columnHeaders.elementAt(i);
                ++i;
            }
        }
        i = hc;
        while (i < matrix.length) {
            String currentLine = this.getElementAtIndex(i - hc);
            StringSplitter st = new StringSplitter(currentLine, "\t");
            int j = 0;
            while (j < matrix[i].length) {
                matrix[i][j] = st.nextToken();
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public Vector getDataVector() {
        return this.getDataVector(false);
    }

    public Vector getDataVector(boolean withHeaders) {
        int i;
        Vector<String> aLine;
        Vector columnHeaders = this.getColumnHeaders();
        int hc = withHeaders ? 1 : 0;
        Vector vec = new Vector(this.dataLinesMap.size() + hc);
        if (withHeaders) {
            aLine = new Vector<String>(columnHeaders.size());
            i = 0;
            while (i < columnHeaders.size()) {
                aLine.add((String)columnHeaders.elementAt(i));
                ++i;
            }
            vec.add(aLine);
        }
        i = hc;
        while (i < vec.capacity()) {
            String currentLine = this.getElementAtIndex(i - hc);
            StringTokenizer st = new StringTokenizer(currentLine, "\t");
            aLine = new Vector(columnHeaders.size());
            while (st.hasMoreTokens()) {
                aLine.add(st.nextToken());
            }
            vec.add(aLine);
            ++i;
        }
        return vec;
    }

    private class IntVector
    extends Vector {
        private IntVector() {
        }

        public void add(int element) {
            super.add(new Integer(element));
        }

        public int intElementAt(int index) {
            return (Integer)super.elementAt(index);
        }
    }
}

