/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.tigr.microarray.MevAttributes;
import org.tigr.microarray.converter.Converter;
import org.tigr.microarray.converter.MevConverter;
import org.tigr.util.FileReading;
import org.tigr.util.MyTimer;
import org.tigr.util.io.IOUtil;

public class ArrayVersionMev
extends MevConverter
implements MevAttributes {
    final String AREA = "Area - mm2";
    final String BKGD = "Bkgd";
    final String DATA_1 = "Data 1";
    final String DATA_2 = "Data 2";
    final String FLAG = "Flag";
    final String SPOT_LABEL = "Spot labels";
    final String VOL = "VOL - Levels x mm2";
    final String AR_VOL = "AR VOL - Levels x mm2";
    final int M_VOL = 0;
    final int M_AR_VOL = 1;
    final int M_DENS = 2;
    final int M_MTM_DENS = 3;
    final int M_ARM_DNES = 4;
    final int M_MED_DENS = 5;
    int gMeasureType;
    String title;
    String[] gChannelNames;

    public ArrayVersionMev(Vector inNames, Vector mfNames, String barTitle) {
        this.inFileNames = inNames;
        this.outFileNames = mfNames;
        this.title = barTitle;
    }

    public void run() {
        boolean noSpotArea = false;
        String aLine = new String("");
        String bgA = new String("");
        String bgB = new String("");
        String densA = new String("");
        String densB = new String("");
        String flagA = new String("");
        String flagB = new String("");
        String medA = new String("0");
        String medB = new String("0");
        StringBuffer mevLine = new StringBuffer(150);
        int spAreaA = 0;
        int spAreaB = 0;
        BufferedWriter mevWriter = null;
        FileOutputStream mevFileOut = null;
        this.taskEnd = this.determineTaskEnd();
        if (this.taskEnd == 1) {
            return;
        }
        this.counter = 0;
        int numOfFiles = this.inFileNames.size();
        int i = 0;
        while (i < numOfFiles) {
            String[] avFile;
            String mevFileName;
            block24: {
                this.inFileNamePath = (String)this.inFileNames.elementAt(i);
                mevFileName = (String)this.outFileNames.elementAt(i);
                try {
                    FileReading fileReader = new FileReading(this.inFileNamePath, 1);
                    if (fileReader.done) {
                        avFile = fileReader.getFileContentAsArray();
                        break block24;
                    }
                    Converter.fetalError = true;
                    System.out.println(fileReader.getProcessMessage());
                    this.msg = this.msg + "**********\n";
                    this.msg = this.msg + fileReader.getProcessMessage() + "\n";
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
                catch (IOException e) {
                    Converter.fetalError = true;
                    this.msg = this.msg + "**********\n";
                    this.msg = this.msg + e.getMessage() + "\n";
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
            }
            int hLine = 2;
            int fSize = avFile.length;
            aLine = avFile[0];
            this.gChannelNames = this.separateLine(aLine);
            aLine = avFile[1];
            String[] colNames = this.separateLine(aLine);
            int flag1Index = this.findRightCol(colNames, "Flag", "Data 1");
            int flag2Index = this.findRightCol(colNames, "Flag", "Data 2");
            int inten1Addr = this.determineMeasureType(colNames, "Data 1");
            if (inten1Addr < 0) {
                Converter.fetalError = true;
                this.msg = this.msg + "**********************\n";
                this.msg = this.msg + "Converter could not recognize the Principal Measurement from which \nthe data file was generated.  Please contact the developer at jli@tigr.org.";
                return;
            }
            int inten2Addr = inten1Addr;
            if (this.gMeasureType == 0) {
                inten2Addr = this.findRightCol(colNames, "VOL - Levels x mm2", "Data 2");
            } else if (this.gMeasureType == 1) {
                inten2Addr = this.findRightCol(colNames, "AR VOL - Levels x mm2", "Data 2");
            }
            int sa1Addr = this.findRightCol(colNames, "Area - mm2", "Data 1");
            int sa2Addr = this.findRightCol(colNames, "Area - mm2", "Data 2");
            if (sa1Addr == 0 || sa2Addr == 0) {
                noSpotArea = true;
            }
            int bg1Addr = this.findRightCol(colNames, "Bkgd", "Data 1");
            int bg2Addr = this.findRightCol(colNames, "Bkgd", "Data 2");
            int labelIndex = this.findRightCol(colNames, "Spot labels", 0);
            try {
                mevFileOut = new FileOutputStream(mevFileName);
                mevWriter = new BufferedWriter(new OutputStreamWriter(mevFileOut));
                String avFileName = IOUtil.extractFileNameFromPath(this.inFileNamePath);
                String[] mevFileHeader = this.generateHeader(avFileName, fSize - hLine, noSpotArea);
                int j = 0;
                while (j < mevFileHeader.length) {
                    mevWriter.write(mevFileHeader[j]);
                    mevWriter.newLine();
                    mevWriter.flush();
                    ++j;
                }
                j = hLine;
                int k = 0;
                while (j < fSize) {
                    aLine = avFile[j];
                    String[] colValues = this.separateLine(aLine);
                    flagA = this.getFlagValue(flagA, Integer.parseInt(colValues[flag1Index]));
                    flagB = this.getFlagValue(flagB, Integer.parseInt(colValues[flag2Index]));
                    if (!noSpotArea) {
                        spAreaA = this.calculateSpotArea(colValues, sa1Addr);
                        spAreaB = this.calculateSpotArea(colValues, sa2Addr);
                    }
                    bgA = this.calculateBackground(colValues, bg1Addr);
                    bgB = this.calculateBackground(colValues, bg2Addr);
                    mevLine.append(colValues[labelIndex]).append("\t");
                    if (this.gBkgCorrect) {
                        densA = this.calculateIntegrateDensity(colValues, inten1Addr, bg1Addr, true);
                        densB = this.calculateIntegrateDensity(colValues, inten2Addr, bg2Addr, true);
                        if (!noSpotArea) {
                            medA = this.calculateMedianIntensity(colValues, inten1Addr, bg1Addr, sa1Addr, true);
                            medB = this.calculateMedianIntensity(colValues, inten2Addr, bg2Addr, sa2Addr, true);
                        }
                    } else {
                        densA = this.calculateIntegrateDensity(colValues, inten1Addr, bg1Addr, false);
                        densB = this.calculateIntegrateDensity(colValues, inten2Addr, bg2Addr, false);
                        if (!noSpotArea) {
                            medA = this.calculateMedianIntensity(colValues, inten1Addr, bg1Addr, sa1Addr, false);
                            medB = this.calculateMedianIntensity(colValues, inten2Addr, bg2Addr, sa2Addr, false);
                        }
                    }
                    if (this.gUseMedian) {
                        mevLine.append(medA).append("\t").append(medB);
                        aLine = densA + "\t" + densB;
                    } else {
                        mevLine.append(densA).append("\t").append(densB);
                        aLine = medA + "\t" + medB;
                    }
                    if (noSpotArea) {
                        mevLine.append("\t").append(bgA).append("\t").append(bgB).append("\t");
                        mevLine.append(flagA).append("\t").append(flagB).append("\t").append(aLine);
                    } else {
                        mevLine.append("\t").append(bgA).append("\t").append(bgB).append("\t");
                        mevLine.append(flagA).append("\t").append(flagB).append("\t").append(spAreaA);
                        mevLine.append("\t").append(spAreaB).append("\t").append(aLine);
                    }
                    mevWriter.write(mevLine.toString());
                    mevWriter.newLine();
                    mevWriter.flush();
                    mevLine.delete(0, mevLine.length());
                    ++this.counter;
                    ++j;
                    ++k;
                }
                mevWriter.close();
            }
            catch (IOException ie) {
                Converter.fetalError = true;
                Converter.ready = false;
                System.out.println("Error in writing file: " + ie.getMessage());
                this.msg = this.msg + "**********\n";
                this.msg = this.msg + "Error in writing file: " + ie.getMessage() + "\n";
                return;
            }
            catch (Exception e) {
                Converter.fetalError = true;
                Converter.ready = false;
                this.msg = this.msg + "**********\n";
                this.msg = this.msg + "Error: " + e.getMessage() + ". Please report the developer.\n";
                return;
            }
            ++i;
        }
        Converter.ready = true;
        this.counter = this.taskEnd;
    }

    private String calculateBackground(String[] tuple, int backg) {
        String bg = new String("");
        try {
            float bkg = Float.parseFloat(tuple[backg]);
            bg = bg + (int)bkg;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            bg = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value for Bkgd;\n";
            this.msg = this.msg + "and the background was set to null.\n";
        }
        return bg;
    }

    private String calculateIntegrateDensity(String[] tuple, int volIndx, int bkgIndx, boolean bgSub) {
        String den = new String("");
        try {
            float vol = Float.parseFloat(tuple[volIndx]);
            float bg = Float.parseFloat(tuple[bkgIndx]);
            float temp = bgSub ? vol - bg : vol;
            den = den + (int)temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            den = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate intensity; and the intensity was set to null.\n";
        }
        return den;
    }

    private String calculateMedianIntensity(String[] tuple, int volIndx, int bkgIndx, int areaIndx, boolean bgSub) {
        String den = new String("");
        try {
            float vol = Float.parseFloat(tuple[volIndx]);
            float bg = Float.parseFloat(tuple[bkgIndx]);
            float area = Float.parseFloat(tuple[areaIndx]) * 10000.0f;
            float temp = bgSub ? (vol - bg) / area : vol / area;
            den = den + (int)temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            den = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate intensity; and the intensity was set to null.\n";
        }
        return den;
    }

    private int calculateSpotArea(String[] tuple, int indx) {
        float fPix = Float.parseFloat(tuple[indx]);
        int temp = (int)(fPix * 10000.0f);
        return temp;
    }

    private int determineMeasureType(String[] hd, String channel) {
        int addr = -1;
        addr = this.findRightCol(hd, "VOL - Levels x mm2", channel);
        if (addr != 0) {
            this.gMeasureType = 0;
        } else {
            addr = this.findRightCol(hd, "AR VOL - Levels x mm2", channel);
            if (addr != 0) {
                this.gMeasureType = 1;
            } else {
                addr = -1;
            }
        }
        return addr;
    }

    private int findRightCol(String[] str, String key, int start) {
        int addr = 0;
        int i = start;
        while (i < str.length) {
            if (str[i].equalsIgnoreCase(key)) {
                addr = i;
                i = str.length;
            }
            ++i;
        }
        return addr;
    }

    private int findRightCol(String[] str, String key, String chName) {
        int addr = this.findRightCol(str, key, 0);
        String temp = this.gChannelNames[addr];
        if (temp.equalsIgnoreCase(chName)) {
            return addr;
        }
        addr = this.findRightCol(str, key, addr + 1);
        return addr;
    }

    private String[] generateHeader(String fName, int numRow, boolean noSA) {
        String[] tempHeader = new String[8];
        String bkgVal = this.gBkgCorrect ? "ON" : "OFF";
        tempHeader[0] = new String("# version: V1.0");
        tempHeader[1] = new String("# format_version:V4.0");
        tempHeader[2] = new String("# date: " + MyTimer.getCurrentDate('.'));
        tempHeader[3] = new String("# created by: " + this.title);
        tempHeader[4] = new String("# row_count:" + numRow);
        tempHeader[5] = new String("# converted from ArrayVersion file: " + fName);
        tempHeader[6] = new String("# background_correction:" + bkgVal);
        tempHeader[7] = noSA ? (this.gUseMedian ? "UID\tMedA\tMedB\tBkgA\tBkgB\tFlagA\tFlagB\tIA\tIB" : "UID\tIA\tIB\tBkgA\tBkgB\tFlagA\tFlagB\tMedA\tMedB") : (this.gUseMedian ? "UID\tMedA\tMedB\tBkgA\tBkgB\tFlagA\tFlagB\tSAA\tSAB\tIA\tIB" : "UID\tIA\tIB\tBkgA\tBkgB\tFlagA\tFlagB\tSAA\tSAB\tMedA\tMedB");
        return tempHeader;
    }

    private String getFlagValue(String f, int val) {
        f = val == 0 ? "B" : "X";
        return f;
    }
}

