/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.IOException;
import java.util.Vector;
import org.tigr.microarray.converter.ExpressConverter;
import org.tigr.util.FileReading;
import org.tigr.util.StringSplitter;
import org.tigr.util.io.MyIni;

public class Converter
extends Thread {
    public static boolean ready;
    public static boolean fetalError;
    public static boolean minorError;
    protected final int NUM_SORT = 3;
    protected final int ROW = 1;
    protected final int COL = 2;
    protected Vector inFileNames;
    protected Vector outFileNames;
    protected String msg = new String("");
    protected String inFileNamePath = new String("");
    protected String[] outFile;
    protected boolean wantSort = true;
    protected int taskEnd;
    protected int counter;
    protected int[][] sortKeys;
    protected int[] sorted;
    protected int[][] oneGroup;

    public Converter() {
        ready = false;
        fetalError = false;
        minorError = false;
    }

    public int getCurrent() {
        return this.counter;
    }

    public String getErrorMsg() {
        return this.msg;
    }

    public String getFileName() {
        return this.inFileNamePath;
    }

    public int getTaskEnd() {
        return this.taskEnd;
    }

    public void setSortSpots(boolean b) {
        this.wantSort = b;
    }

    protected int[] arrangeKeys(int start, int end, int[] keys) {
        int[] temp = keys;
        int size = end - start + 1;
        int pIndex = start;
        int i = 0;
        while (i < size) {
            temp[pIndex] = this.oneGroup[0][i];
            ++pIndex;
            ++i;
        }
        return temp;
    }

    protected int determineTaskEnd() {
        Vector fileContent = new Vector();
        int numFiles = this.inFileNames.size();
        int tempEnd = 0;
        int i = 0;
        while (i < numFiles) {
            try {
                FileReading fileReader = new FileReading((String)this.inFileNames.elementAt(i));
                if (fileReader.done) {
                    fileContent = fileReader.getFileContentInLines();
                } else {
                    this.setErrorMessage(fileReader.getProcessMessage());
                    tempEnd = 1;
                    i = numFiles;
                }
            }
            catch (IOException e) {
                this.setErrorMessage(e.getMessage());
                tempEnd = 1;
                i = numFiles;
            }
            tempEnd += fileContent.size();
            ++i;
        }
        return tempEnd;
    }

    protected int partitionIt(int left, int right, int pivot, int sel) {
        int leftNum = left - 1;
        int rightNum = right;
        while (true) {
            if (sel == 1) {
                while (this.sortKeys[1][++leftNum] < pivot) {
                }
                while (rightNum > 0 && this.sortKeys[1][--rightNum] > pivot) {
                }
            } else {
                while (this.oneGroup[2][++leftNum] < pivot) {
                }
                while (rightNum > 0 && this.oneGroup[2][--rightNum] > pivot) {
                }
            }
            if (leftNum >= rightNum) break;
            this.swap(leftNum, rightNum, sel);
        }
        this.swap(leftNum, right, sel);
        return leftNum;
    }

    protected void quickSort(int left, int right, int sel) {
        if (right - left <= 0) {
            return;
        }
        int pivot = sel == 1 ? this.sortKeys[1][right] : this.oneGroup[2][right];
        int partition = this.partitionIt(left, right, pivot, sel);
        this.quickSort(left, partition - 1, sel);
        this.quickSort(partition + 1, right, sel);
    }

    protected String[] separateLine(String str) {
        String tempStr = new String("");
        StringSplitter spliter = new StringSplitter(str, "\t");
        int num = spliter.countTokens();
        int length = 0;
        String[] name = new String[num];
        if (num > 0) {
            while (spliter.hasMoreTokens()) {
                tempStr = spliter.nextToken();
                tempStr = MyIni.removeAllEndSpaces(tempStr);
                tempStr = MyIni.removeAllHeadSpaces(tempStr);
                name[length++] = tempStr;
            }
        }
        return name;
    }

    protected void setErrorMessage(String eMsg) {
        fetalError = true;
        System.out.println(eMsg);
        ExpressConverter.logFileContent.add("\n***********\n" + eMsg);
        this.msg = this.msg + "*********\n";
        this.msg = this.msg + eMsg + "\n";
    }

    protected int[] sortRowCol(int bNum, int bSize) {
        int tail = 0;
        int max = this.outFile.length - 1;
        int min = this.sortKeys[1][0];
        this.quickSort(min, max, 1);
        int numGroup = this.outFile.length / (bNum * bSize);
        int gSize = bNum * bSize;
        this.oneGroup = new int[3][gSize];
        max = gSize;
        int[] ready = new int[this.outFile.length];
        int i = 0;
        while (i < numGroup) {
            int head = i * gSize;
            int j = 0;
            while (j < gSize) {
                this.oneGroup[0][j] = this.sortKeys[0][i * gSize + j];
                this.oneGroup[1][j] = this.sortKeys[1][i * gSize + j];
                this.oneGroup[2][j] = this.sortKeys[2][i * gSize + j];
                tail = i * gSize + j;
                ++j;
            }
            min = 0;
            max = gSize - 1;
            this.quickSort(min, max, 2);
            ready = this.arrangeKeys(head, tail, ready);
            ++i;
        }
        return ready;
    }

    protected int[] sortUnbalancedRowCol() {
        int tail = 0;
        int max = this.outFile.length - 1;
        int min = this.sortKeys[1][0];
        this.quickSort(min, max, 1);
        int[] ready = new int[this.outFile.length];
        int[] colSize = new int[]{0, min};
        do {
            colSize = this.getColNumber(colSize[0]);
            int gSize = colSize[1];
            this.oneGroup = new int[3][gSize];
            int head = colSize[0] - colSize[1];
            int i = 0;
            while (i < gSize) {
                this.oneGroup[0][i] = this.sortKeys[0][head + i];
                this.oneGroup[1][i] = this.sortKeys[1][head + i];
                this.oneGroup[2][i] = this.sortKeys[2][head + i];
                ++i;
            }
            tail = head + i - 1;
            min = 0;
            max = gSize - 1;
            if (head < 0) continue;
            this.quickSort(min, max, 2);
            ready = this.arrangeKeys(head, tail, ready);
        } while (colSize[0] > 0);
        return ready;
    }

    protected void swap(int dex1, int dex2, int sel) {
        int[] temp = new int[3];
        int i = 0;
        while (i < temp.length) {
            if (sel == 1) {
                temp[i] = this.sortKeys[i][dex1];
                this.sortKeys[i][dex1] = this.sortKeys[i][dex2];
                this.sortKeys[i][dex2] = temp[i];
            } else {
                temp[i] = this.oneGroup[i][dex1];
                this.oneGroup[i][dex1] = this.oneGroup[i][dex2];
                this.oneGroup[i][dex2] = temp[i];
            }
            ++i;
        }
    }

    private int[] getColNumber(int offset) {
        boolean go = true;
        int[] temp = new int[2];
        int ctr = 0;
        int addr = offset;
        if (addr >= this.sortKeys[1].length) {
            temp[0] = -1;
            return temp;
        }
        int val = this.sortKeys[1][addr];
        while (go) {
            if (addr >= this.sortKeys[1].length) {
                go = false;
                ++addr;
                continue;
            }
            if (val == this.sortKeys[1][addr++]) {
                ++ctr;
                continue;
            }
            go = false;
        }
        temp[0] = addr - 1;
        temp[1] = ctr;
        return temp;
    }
}

