/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.converter.AgilentMev;
import org.tigr.microarray.converter.AgilentPanel;
import org.tigr.microarray.converter.ArrayVersionMev;
import org.tigr.microarray.converter.ArrayVersionPanel;
import org.tigr.microarray.converter.Converter;
import org.tigr.microarray.converter.ConverterLogView;
import org.tigr.microarray.converter.ConverterOption;
import org.tigr.microarray.converter.CustomerMev;
import org.tigr.microarray.converter.CustomerPanel;
import org.tigr.microarray.converter.GenePixPanel;
import org.tigr.microarray.converter.GenepixMev;
import org.tigr.microarray.converter.ImaGeneMev;
import org.tigr.microarray.converter.ImaGenePanel;
import org.tigr.microarray.converter.ImaGeneTav;
import org.tigr.microarray.converter.MevPanel;
import org.tigr.microarray.converter.MevTav;
import org.tigr.microarray.converter.ScanArrayMev;
import org.tigr.microarray.converter.ScanArrayPanel;
import org.tigr.microarray.converter.ScanArrayTav;
import org.tigr.microarray.converter.TavConverter;
import org.tigr.microarray.converter.TavMev;
import org.tigr.microarray.converter.TavPanel;
import org.tigr.util.ConfirmUsers;
import org.tigr.util.FileReading;
import org.tigr.util.InitialWindow;
import org.tigr.util.MadamFileFilter;
import org.tigr.util.MyTimer;
import org.tigr.util.Proface;
import org.tigr.util.ProfaceProjector;
import org.tigr.util.ProgramRunner;
import org.tigr.util.io.IOUtil;
import org.tigr.util.io.MyIni;

public class ExpressConverter
extends JFrame
implements InitialWindow {
    private ArrayVersionPanel arrayVersionPL;
    private AgilentPanel aligentPL;
    private CustomerPanel gCustomerPL;
    private Icon gAnnOneIcon;
    private Icon gAnnManyIcon;
    private JButton gAnnBtn;
    private JCheckBox gAnnOneCkbox;
    private JCheckBox gAnnManyCkbox;
    private JMenuItem aboutMI;
    private JMenuItem changeDirMI;
    private JMenuItem changeNameMI;
    private JMenuItem deleteMI;
    private JMenuItem exitMI;
    private JMenuItem gOpenMI;
    private JMenuItem gSaveMI;
    private JMenuItem helpMI;
    private JMenuItem gLoadMI;
    private JMenuItem prefMI;
    private JMenuItem resetMI;
    private JMenuItem gRunMI;
    private JMenuItem stopMI;
    private JMenuItem viewLogMI;
    private Icon browserIcon;
    private Icon deleteIcon;
    private Icon editIcon;
    private Icon gSaveIcon;
    private Icon gOpenIcon;
    private Icon runIcon;
    private Icon stopIcon;
    private Icon clearIcon;
    private Icon viewLogIcon;
    private Icon helpIcon;
    private Icon changeDirIcon;
    private JComboBox outputCB;
    private JPanel basePanel;
    private JPanel toolBarPanel;
    private JPanel viewPanel;
    private JPanel gAnnTypePanel;
    private JButton fileBrowserBtn;
    private JButton changeDirBtn;
    private JButton gOpenBtn;
    private JButton gSaveBtn;
    private JButton deleteBtn;
    private JButton clearBtn;
    private JButton convertBtn;
    private JButton helpBtn;
    private JButton editBtn;
    private JButton viewLogBtn;
    private JButton stopBtn;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu viewMenu;
    private JMenu helpMenu;
    private JMenu annMenu;
    private JCheckBox metalViewCkbox;
    private JCheckBox winViewMI;
    private JCheckBox motifViewMI;
    private JToolBar fileToolBar;
    private JToolBar editToolBar;
    private JToolBar helpToolBar;
    private JToolBar outSelBar;
    private JProgressBar bar;
    private JLabel progLabel;
    private JLabel infoLB;
    private JLabel outputLB;
    private JTabbedPane inputTP;
    private ConverterLogView logViewWin;
    private BevelBorder flat;
    private ButtonGroup btnGroup;
    private ButtonGroup gAnnGroup;
    public static Image iconPic;
    public static String gSysPath;
    private static Proface proPic;
    private static Proface creditWin;
    public static boolean logWinOn;
    public static boolean helpWinOn;
    public static Vector logFileContent;
    public static ProfaceProjector projector;
    public static final int ONE_FILE = 1;
    public static final int ALL_FILES = 2;
    public static final String CUS_HEADER_FILE = "Customer Header File";
    public static final String INIFILE = "docs/convt.ini";
    public static final String MEV_VER = "V4.0";
    public static final String TITLE = "ExpressConveter V.1.7";
    public static String[] ECH;
    public static final int MAC = 1;
    public static int scrWidth;
    public static int scrHeight;
    public static int gOs;
    private final String CUST_FILE = "custFile";
    private final String CUST_LINE = "cfSize";
    private final String MANUAL_NAME = "docs/convthelp.chm";
    private final String ONE_ONE_INFO = "Each mev file has its own ann file.";
    private final String MANY_ONE_INFO = "Many mev files share one ann file.";
    private final String SCREEN_X = "scrWidth";
    private final String SCREEN_Y = "scrHeight";
    private final String SCREEN_FEEL = "scrFeel";
    private final String SCREEN_PREF = "scrPref";
    private final String VERSION = "ver";
    private final String LOC_X = "locX";
    private final String LOC_Y = "locY";
    private final String ONE_ONE = "1";
    private final String MANY_ONE = "2";
    private AgilentMev aligentMevConvt;
    private ArrayVersionMev arrayVersionMevConvt;
    private boolean gDirtyData;
    private CustomerMev gCustMevConvt;
    private TavConverter genepixTavConvt;
    private GenepixMev genepixMevConvt;
    private ImaGeneTav imaGeneTavConvt;
    private ImaGeneMev imaGeneMevConvt;
    private ScanArrayTav scanArrayTavConvt;
    private ScanArrayMev scanArrayMevConvt;
    private TavMev tavMevConvt;
    private MevTav mevTavConvt;
    private Timer cvTimer;
    private int gSelConverter;
    private int gSizeX;
    private int gSizeY;
    private int gLocX;
    private int gLocY;
    private int gAnnType;
    private int gFileLine;
    private int gScrFeel;
    private int progEnd;
    private int progCounter;
    private int outputType;
    private long startTime;
    private long curTime;
    private ProgramRunner runner;
    private GenePixPanel genePixPL;
    private ImaGenePanel imaGenePL;
    private ScanArrayPanel scanArrayPL;
    private TavPanel tavPL;
    private MevPanel mevPL;
    private Vector selectedChAFiles;
    private Vector selectedChBFiles;
    private String[] gfType = new String[]{"gpr", "txt"};
    private String[] gCustType;
    private String[] txtType = new String[]{"txt"};
    private String[] tavType = new String[]{"tav"};
    private String[] mevType = new String[]{"mev"};
    private String info;
    private String title;
    private String iniFileName;
    private String gUserTypes;
    private String gVer;
    private Vector initFile;
    private final String[] FILE_TYPE = new String[]{"tav", "mev"};
    private final int QUIT = -1;
    private final int NO_FILE = 0;
    private final int TAV_OUT = 0;
    private final int MEV_OUT = 1;
    private final int GENEPIX = 0;
    private final int IMAGENE = 1;
    private final int SCANARRAY = 2;
    private final int ARRAYVERSION = 3;
    private final int ALIGENT = 4;
    private final int TAV = 5;
    private final int MEV = 6;
    private final int CUSTOMER = 7;

    public ExpressConverter() {
        this((String)null);
    }

    public ExpressConverter(String barTitle) {
        this.title = barTitle != null ? barTitle : TITLE;
        logWinOn = false;
        helpWinOn = false;
        this.gDirtyData = false;
        this.info = new String("");
        this.iniFileName = INIFILE;
        gOs = this.getOperationSystem(System.getProperty("os.name"));
        logFileContent = new Vector(10, 3);
        this.selectedChAFiles = new Vector(10, 3);
        this.selectedChBFiles = new Vector(10, 3);
        this.flat = new BevelBorder(2);
        this.outputType = 1;
        this.gAnnType = 1;
        this.runner = new ProgramRunner();
        projector.setInfoText("    Loading configuration information ... ");
        this.loadConfigInfo(this.iniFileName);
        projector.setInfoText("    Building GenePix converter ... ");
        this.genePixPL = new GenePixPanel(this);
        projector.setInfoText("    Building ImaGene converter ... ");
        this.imaGenePL = new ImaGenePanel(this);
        projector.setInfoText("    Building ScanArray converter ... ");
        this.scanArrayPL = new ScanArrayPanel(this);
        projector.setInfoText("    Building ArrayVerson Converter ... ");
        this.arrayVersionPL = new ArrayVersionPanel(this);
        projector.setInfoText("    Building Agilent converter ... ");
        this.aligentPL = new AgilentPanel(this);
        projector.setInfoText("    Building TAV converter ... ");
        this.tavPL = new TavPanel(this);
        projector.setInfoText("    Building MAV converter ... ");
        this.mevPL = new MevPanel(this);
        projector.setInfoText("   Building Customized  converter ... ");
        this.gCustomerPL = new CustomerPanel(this);
        if (this.gSizeX == 0 || this.gSizeY == 0) {
            this.gSizeX = (int)((double)scrWidth * 0.85);
            this.gSizeY = (int)((double)scrHeight * 0.85);
        }
        this.createGUI();
        this.adjustToolBar();
        this.setPreferenceState();
        this.validate();
        logFileContent.add("ExpressConverter started without errors.\n");
    }

    private void buttonFace(JButton btn) {
        btn.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent me) {
                ExpressConverter.this.buttonUp(me);
            }
        });
        btn.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent me) {
                ExpressConverter.this.buttonDown(me);
            }
        });
    }

    private void adjustToolBar() {
        this.fileBrowserBtn.setBorder(this.flat);
        this.gOpenBtn.setBorder(this.flat);
        this.gSaveBtn.setBorder(this.flat);
        this.convertBtn.setBorder(this.flat);
        this.stopBtn.setBorder(this.flat);
        this.changeDirBtn.setBorder(this.flat);
        this.editBtn.setBorder(this.flat);
        this.deleteBtn.setBorder(this.flat);
        this.clearBtn.setBorder(this.flat);
        this.viewLogBtn.setBorder(this.flat);
        this.helpBtn.setBorder(this.flat);
        this.gAnnBtn.setBorder(this.flat);
    }

    private void buttonDown(MouseEvent e) {
        JButton btn = (JButton)e.getSource();
        if (btn.isEnabled()) {
            btn.setBorder(new BevelBorder(2));
        }
    }

    private void buttonUp(MouseEvent e) {
        JButton btn = (JButton)e.getSource();
        if (btn.isEnabled()) {
            btn.setBorder(new BevelBorder(0));
        }
    }

    private void changeDirectory() {
        String tempPath;
        JFileChooser fileChooser = new JFileChooser(gSysPath);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle("ExpressConveter V.1.7 -- selecting a directory");
        int result = fileChooser.showOpenDialog(this);
        if (result == 1 || result < 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        gSysPath = tempPath = file.getPath();
        if (this.gSelConverter == 0) {
            this.genePixPL.editDirectory(tempPath);
        } else if (this.gSelConverter == 1) {
            this.imaGenePL.editDirectory(tempPath);
        } else if (this.gSelConverter == 2) {
            this.scanArrayPL.editDirectory(tempPath);
        } else if (this.gSelConverter == 3) {
            this.arrayVersionPL.editDirectory(tempPath);
        } else if (this.gSelConverter == 4) {
            this.aligentPL.editDirectory(tempPath);
        } else if (this.gSelConverter == 5) {
            this.tavPL.editDirectory(tempPath);
        } else if (this.gSelConverter == 6) {
            this.mevPL.editDirectory(tempPath);
        } else if (this.gSelConverter == 7) {
            this.gCustomerPL.editDirectory(tempPath);
        }
    }

    private void changeInitFile() {
        this.initFile = MyIni.setValueToFile(this.initFile, "scrWidth", "" + this.gSizeX);
        this.initFile = MyIni.setValueToFile(this.initFile, "scrHeight", "" + this.gSizeY);
        this.initFile = MyIni.setValueToFile(this.initFile, "scrFeel", "" + this.gScrFeel);
        this.initFile = MyIni.setValueToFile(this.initFile, "scrPref", "" + this.gSelConverter);
        this.initFile = MyIni.setValueToFile(this.initFile, "locX", "" + this.gLocX);
        this.initFile = MyIni.setValueToFile(this.initFile, "locY", "" + this.gLocY);
        this.initFile = MyIni.setValueToFile(this.initFile, "custFile", this.gUserTypes);
        this.initFile = MyIni.setValueToFile(this.initFile, "cfSize", "" + this.gFileLine);
    }

    private void convertFiles() {
        int test;
        String temp = new String("");
        Vector outputFileNames = new Vector();
        if (this.gSelConverter == 0) {
            outputFileNames = this.genePixPL.getOutputFileNames();
            this.selectedChAFiles = this.genePixPL.getSelectedFiles();
        } else if (this.gSelConverter == 1) {
            outputFileNames = this.imaGenePL.getOutputFileNames();
            this.selectedChAFiles = this.imaGenePL.getSelectedChAFiles();
            this.selectedChBFiles = this.imaGenePL.getSelectedChBFiles();
        } else if (this.gSelConverter == 2) {
            outputFileNames = this.scanArrayPL.getOutputFileNames();
            this.selectedChAFiles = this.scanArrayPL.getSelectedFiles();
        } else if (this.gSelConverter == 3) {
            outputFileNames = this.arrayVersionPL.getOutputFileNames();
            this.selectedChAFiles = this.arrayVersionPL.getSelectedFiles();
        } else if (this.gSelConverter == 4) {
            outputFileNames = this.aligentPL.getOutputFileNames();
            this.selectedChAFiles = this.aligentPL.getSelectedFiles();
        } else if (this.gSelConverter == 5) {
            outputFileNames = this.tavPL.getOutputFileNames();
            this.selectedChAFiles = this.tavPL.getSelectedFiles();
        } else if (this.gSelConverter == 6) {
            outputFileNames = this.mevPL.getOutputFileNames();
            this.selectedChAFiles = this.mevPL.getSelectedFiles();
        } else if (this.gSelConverter == 7) {
            if (this.gCustomerPL.isValidEquation()) {
                outputFileNames = this.gCustomerPL.getOutputFileNames();
                this.selectedChAFiles = this.gCustomerPL.getSelectedFiles();
            } else {
                return;
            }
        }
        int numOfFiles = outputFileNames.size();
        Vector<String> validOutputFiles = new Vector<String>(numOfFiles, numOfFiles >> 2);
        Vector<String> deletedFileAddr = new Vector<String>(numOfFiles, numOfFiles >> 2);
        boolean wantTest = true;
        int i = 0;
        while (i < numOfFiles) {
            temp = (String)outputFileNames.elementAt(i);
            test = this.validFile(temp, wantTest, 0);
            if (test == 1) {
                wantTest = true;
                validOutputFiles.add(temp);
            } else if (test == 2) {
                wantTest = false;
                validOutputFiles.add(temp);
            } else if (test == 0) {
                wantTest = true;
                deletedFileAddr.add("" + i);
            } else {
                return;
            }
            ++i;
        }
        numOfFiles = deletedFileAddr.size();
        i = 0;
        while (i < numOfFiles) {
            test = Integer.parseInt((String)deletedFileAddr.elementAt(i));
            this.selectedChAFiles.removeElementAt(test);
            if (this.gSelConverter == 1) {
                this.selectedChBFiles.removeElementAt(test);
            }
            outputFileNames.removeElementAt(test);
            ++i;
        }
        if (this.gSelConverter == 0) {
            this.genePixPL.changeFileList(this.selectedChAFiles, outputFileNames);
        } else if (this.gSelConverter == 1) {
            this.imaGenePL.changeFileList(this.selectedChAFiles, this.selectedChBFiles, outputFileNames);
        } else if (this.gSelConverter == 2) {
            this.scanArrayPL.changeFileList(this.selectedChAFiles, outputFileNames);
        } else if (this.gSelConverter == 3) {
            this.arrayVersionPL.changeFileList(this.selectedChAFiles, outputFileNames);
        } else if (this.gSelConverter == 4) {
            this.aligentPL.changeFileList(this.selectedChAFiles, outputFileNames);
        } else if (this.gSelConverter == 5) {
            this.tavPL.changeFileList(this.selectedChAFiles, outputFileNames);
        } else if (this.gSelConverter == 6) {
            this.mevPL.changeFileList(this.selectedChAFiles, outputFileNames);
        } else if (this.gSelConverter == 7) {
            this.gCustomerPL.changeFileList(this.selectedChAFiles, outputFileNames);
        }
        this.clearBtn.setEnabled(false);
        this.resetMI.setEnabled(false);
        this.changeDirBtn.setEnabled(false);
        this.changeDirMI.setEnabled(false);
        this.progEnd = 0;
        this.progCounter = 0;
        this.bar.setValue(this.progCounter);
        this.infoLB.setText("");
        this.progLabel.setText("");
        if (this.selectedChAFiles.size() > 0) {
            if (this.outputType == 0 && this.gSelConverter == 0) {
                this.genepixTavConvt = new TavConverter(this.selectedChAFiles, validOutputFiles);
                this.genepixTavConvt.setSortSpots(this.genePixPL.wantSort());
                this.genepixTavConvt.setKeepAllInformation(this.genePixPL.keepAllInformation());
                this.cvTimer = new Timer(100, new ConvertListener(this.genepixTavConvt));
                this.genepixTavConvt.start();
            } else if (this.outputType == 0 && this.gSelConverter == 1) {
                this.imaGeneTavConvt = new ImaGeneTav(this, this.selectedChAFiles, this.selectedChBFiles, validOutputFiles);
                this.imaGeneTavConvt.setSortSpots(this.imaGenePL.wantSort());
                this.imaGeneTavConvt.attachGeneId(this.imaGenePL.needGeneID());
                this.cvTimer = new Timer(100, new ConvertListener(this.imaGeneTavConvt));
                this.imaGeneTavConvt.start();
            } else if (this.outputType == 1 && this.gSelConverter == 0) {
                this.genepixMevConvt = new GenepixMev(this.selectedChAFiles, validOutputFiles, TITLE, this.gAnnType);
                this.genepixMevConvt.setSortSpots(this.genePixPL.wantSort());
                this.genepixMevConvt.setIntensityType(this.genePixPL.getIntensityType());
                this.genepixMevConvt.backgroundCorrected(this.genePixPL.isBackgroundCorrected());
                this.cvTimer = new Timer(100, new ConvertListener(this.genepixMevConvt));
                this.genepixMevConvt.start();
            } else if (this.outputType == 1 && this.gSelConverter == 1) {
                this.imaGeneMevConvt = new ImaGeneMev(this, this.selectedChAFiles, this.selectedChBFiles, validOutputFiles, TITLE, this.gAnnType);
                this.imaGeneMevConvt.setSortSpots(this.imaGenePL.wantSort());
                this.imaGeneMevConvt.setIntensityType(this.imaGenePL.getIntensityType());
                this.imaGeneMevConvt.backgroundCorrected(this.imaGenePL.isBackgroundCorrected());
                this.cvTimer = new Timer(100, new ConvertListener(this.imaGeneMevConvt));
                this.imaGeneMevConvt.start();
            } else if (this.outputType == 0 && this.gSelConverter == 2) {
                this.scanArrayTavConvt = new ScanArrayTav(this, this.selectedChAFiles, validOutputFiles, this.scanArrayPL.getQuantiationWay());
                this.scanArrayTavConvt.setSortSpots(this.scanArrayPL.wantSort());
                this.scanArrayTavConvt.setKeepAllInformation(this.scanArrayPL.keepAllInformation());
                this.scanArrayTavConvt.setSwapChannel(this.scanArrayPL.swapOriginalChannel());
                this.cvTimer = new Timer(100, new ConvertListener(this.scanArrayTavConvt));
                this.scanArrayTavConvt.start();
            } else if (this.outputType == 1 && this.gSelConverter == 2) {
                this.scanArrayMevConvt = new ScanArrayMev(this, this.selectedChAFiles, validOutputFiles, this.scanArrayPL.getQuantiationWay(), TITLE, this.gAnnType);
                this.scanArrayMevConvt.setSortSpots(this.scanArrayPL.wantSort());
                this.scanArrayMevConvt.setIntensityType(this.scanArrayPL.getIntensityType());
                this.scanArrayMevConvt.backgroundCorrected(this.scanArrayPL.isBackgroundCorrected());
                this.scanArrayMevConvt.needSwapChannels(this.scanArrayPL.swapOriginalChannel());
                this.cvTimer = new Timer(100, new ConvertListener(this.scanArrayMevConvt));
                this.scanArrayMevConvt.start();
            } else if (this.outputType == 1 && this.gSelConverter == 3) {
                this.arrayVersionMevConvt = new ArrayVersionMev(this.selectedChAFiles, validOutputFiles, TITLE);
                this.arrayVersionMevConvt.setSortSpots(this.arrayVersionPL.wantSort());
                this.arrayVersionMevConvt.setIntensityType(this.arrayVersionPL.getIntensityType());
                this.arrayVersionMevConvt.backgroundCorrected(this.arrayVersionPL.isBackgroundCorrected());
                this.cvTimer = new Timer(100, new ConvertListener(this.arrayVersionMevConvt));
                this.arrayVersionMevConvt.start();
            } else if (this.outputType == 1 && this.gSelConverter == 4) {
                this.aligentMevConvt = new AgilentMev(this, this.selectedChAFiles, validOutputFiles, TITLE, this.gAnnType);
                this.aligentMevConvt.setSortSpots(this.aligentPL.wantSort());
                this.aligentMevConvt.setIntensityType(this.aligentPL.getIntensityType());
                this.aligentMevConvt.backgroundCorrected(this.aligentPL.isBackgroundCorrected());
                this.cvTimer = new Timer(100, new ConvertListener(this.aligentMevConvt));
                this.aligentMevConvt.start();
            } else if (this.outputType == 1 && this.gSelConverter == 5) {
                this.tavMevConvt = new TavMev(this.selectedChAFiles, validOutputFiles, TITLE, this.gAnnType);
                this.tavMevConvt.setSortSpots(this.tavPL.wantSort());
                this.cvTimer = new Timer(100, new ConvertListener(this.tavMevConvt));
                this.tavMevConvt.start();
            } else if (this.outputType == 0 && this.gSelConverter == 6) {
                this.mevTavConvt = new MevTav(this.selectedChAFiles, validOutputFiles, TITLE);
                this.mevTavConvt.setSortSpots(this.mevPL.wantSort());
                this.mevTavConvt.setKeepAllInformation(this.mevPL.keepAllInformation());
                this.cvTimer = new Timer(100, new ConvertListener(this.mevTavConvt));
                this.mevTavConvt.start();
            } else if (this.outputType == 1 && this.gSelConverter == 7) {
                this.gCustMevConvt = new CustomerMev(this, this.selectedChAFiles, validOutputFiles, TITLE, this.gAnnType);
                this.gCustMevConvt.setSortSpots(this.gCustomerPL.wantSort());
                this.gCustMevConvt.setIntensityType(this.gCustomerPL.getIntensityType());
                this.gCustMevConvt.setCustomerEquation(this.gCustomerPL.getConvertEquations());
                this.gCustMevConvt.setMevHeaders(this.gCustomerPL.getMevHeaders());
                this.gCustMevConvt.setInputHeader(this.gCustomerPL.getInputHeaders());
                this.gCustMevConvt.setInputHeaderOffset(this.gCustomerPL.getInputHeaderOffset());
                this.gCustMevConvt.setSelectedColumnsForAnn(this.gCustomerPL.getSelecteColumnForAnn());
                this.cvTimer = new Timer(100, new ConvertListener(this.gCustMevConvt));
                this.gCustMevConvt.start();
            }
            this.startTime = System.currentTimeMillis();
            this.cvTimer.start();
            this.convertBtn.setEnabled(false);
            this.gRunMI.setEnabled(false);
            this.stopBtn.setEnabled(true);
            this.stopMI.setEnabled(true);
        }
    }

    private void editFileName() {
        if (this.gSelConverter == 0) {
            this.genePixPL.editFileName();
        } else if (this.gSelConverter == 1) {
            this.imaGenePL.editFileName();
        } else if (this.gSelConverter == 2) {
            this.scanArrayPL.editFileName();
        } else if (this.gSelConverter == 3) {
            this.arrayVersionPL.editFileName();
        } else if (this.gSelConverter == 4) {
            this.aligentPL.editFileName();
        } else if (this.gSelConverter == 5) {
            this.tavPL.editFileName();
        } else if (this.gSelConverter == 6) {
            this.mevPL.editFileName();
        } else if (this.gSelConverter == 7) {
            this.gCustomerPL.editFileName();
        }
    }

    private File getFile(String[] ext, String fileType, String path) {
        JFileChooser fileChooser = new JFileChooser(path);
        if (ext != null) {
            MadamFileFilter wanted = new MadamFileFilter(ext, fileType);
            fileChooser.setFileFilter(wanted);
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle("ExpressConveter V.1.7 -- selecting files");
        int result = fileChooser.showOpenDialog(this);
        if (result == 1 || result < 0) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        if (!file.isFile()) {
            this.alertUsers("The file (" + file.getName() + ") does not exist.");
            return null;
        }
        gSysPath = file.getPath();
        return file;
    }

    private String[] getFileName(String[] ext, String fileType, String path) {
        JFileChooser fileChooser = new JFileChooser(path);
        if (ext != null) {
            MadamFileFilter wanted = new MadamFileFilter(ext, fileType);
            fileChooser.setFileFilter(wanted);
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setDialogTitle("ExpressConveter V.1.7 -- selecting files");
        int result = fileChooser.showOpenDialog(this);
        if (result == 1 || result < 0) {
            return null;
        }
        File[] files = fileChooser.getSelectedFiles();
        int numFile = files.length;
        String[] temp = new String[numFile];
        String[] tempName = new String[numFile];
        int i = 0;
        while (i < numFile) {
            temp[i] = new String(files[i].getPath());
            tempName[i] = new String(files[i].getName());
            if (!files[i].isFile()) {
                this.alertUsers("The file (" + tempName[i] + ") does not exsit.");
                return null;
            }
            ++i;
        }
        gSysPath = IOUtil.extractPath(temp[numFile - 1]);
        if (ext != null && !this.isValidFileName(tempName, ext)) {
            return null;
        }
        return temp;
    }

    private int getOperationSystem(String sysOs) {
        if (sysOs.startsWith("W") || sysOs.startsWith("w")) {
            return 0;
        }
        return 1;
    }

    public void createGUI() {
        int btnWidth = 60;
        int btnHeight = 23;
        this.setIconImage(iconPic);
        this.setTitle(this.title);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                ExpressConverter.this.quit();
            }
        });
        this.initialMenuBar();
        this.initialToolBar();
        this.basePanel = new JPanel(new GridBagLayout());
        this.inputTP = new JTabbedPane();
        this.inputTP.setSize(this.gSizeX - 10, (int)((double)this.gSizeY * 0.66));
        this.inputTP.setPreferredSize(this.inputTP.getSize());
        this.inputTP.add("  GenePix  ", this.genePixPL);
        this.inputTP.add("  ImaGene  ", this.imaGenePL);
        this.inputTP.add("  ScanArray  ", this.scanArrayPL);
        this.inputTP.add("  ArrayVision  ", this.arrayVersionPL);
        this.inputTP.add("  Agilent  ", this.aligentPL);
        this.inputTP.add("  TAV  ", this.tavPL);
        this.inputTP.add("  MEV  ", this.mevPL);
        this.inputTP.add("  Customized  ", this.gCustomerPL);
        this.inputTP.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                ExpressConverter.this.outputCB.setEnabled(true);
                if (ExpressConverter.this.inputTP.getSelectedComponent() == ExpressConverter.this.genePixPL) {
                    ExpressConverter.this.gSelConverter = 0;
                    ExpressConverter.this.activateButton(ExpressConverter.this.genePixPL.isOutputReady(), ExpressConverter.this.genePixPL.isOutputReady());
                    ExpressConverter.this.outputCB.setSelectedIndex(ExpressConverter.this.genePixPL.getOutputTypeFromFile());
                } else if (ExpressConverter.this.inputTP.getSelectedComponent() == ExpressConverter.this.imaGenePL) {
                    ExpressConverter.this.gSelConverter = 1;
                    ExpressConverter.this.activateButton(ExpressConverter.this.imaGenePL.isOutputReady(), ExpressConverter.this.imaGenePL.isDataDirty());
                    ExpressConverter.this.outputCB.setSelectedIndex(ExpressConverter.this.imaGenePL.getOutputTypeFromFile());
                } else if (ExpressConverter.this.inputTP.getSelectedComponent() == ExpressConverter.this.scanArrayPL) {
                    ExpressConverter.this.gSelConverter = 2;
                    ExpressConverter.this.activateButton(ExpressConverter.this.scanArrayPL.isOutputReady(), ExpressConverter.this.scanArrayPL.isOutputReady());
                    ExpressConverter.this.outputCB.setSelectedIndex(ExpressConverter.this.scanArrayPL.getOutputTypeFromFile());
                } else if (ExpressConverter.this.inputTP.getSelectedComponent() == ExpressConverter.this.arrayVersionPL) {
                    ExpressConverter.this.gSelConverter = 3;
                    ExpressConverter.this.activateButton(ExpressConverter.this.arrayVersionPL.isOutputReady(), ExpressConverter.this.arrayVersionPL.isOutputReady());
                    ExpressConverter.this.outputCB.setSelectedIndex(1);
                } else if (ExpressConverter.this.inputTP.getSelectedComponent() == ExpressConverter.this.aligentPL) {
                    ExpressConverter.this.gSelConverter = 4;
                    ExpressConverter.this.activateButton(ExpressConverter.this.aligentPL.isOutputReady(), ExpressConverter.this.aligentPL.isOutputReady());
                    ExpressConverter.this.outputCB.setSelectedIndex(1);
                } else if (ExpressConverter.this.inputTP.getSelectedComponent() == ExpressConverter.this.tavPL) {
                    ExpressConverter.this.gSelConverter = 5;
                    ExpressConverter.this.activateButton(ExpressConverter.this.tavPL.getOutputReady(), ExpressConverter.this.tavPL.getOutputReady());
                    ExpressConverter.this.outputCB.setSelectedIndex(1);
                } else if (ExpressConverter.this.inputTP.getSelectedComponent() == ExpressConverter.this.mevPL) {
                    ExpressConverter.this.gSelConverter = 6;
                    ExpressConverter.this.activateButton(ExpressConverter.this.mevPL.getOutputReady(), ExpressConverter.this.mevPL.getOutputReady());
                    ExpressConverter.this.outputCB.setSelectedIndex(0);
                } else if (ExpressConverter.this.inputTP.getSelectedComponent() == ExpressConverter.this.gCustomerPL) {
                    ExpressConverter.this.gSelConverter = 7;
                    ExpressConverter.this.activateButton(ExpressConverter.this.gCustomerPL.getOutputReady(), ExpressConverter.this.gCustomerPL.getOutputReady());
                    ExpressConverter.this.outputCB.setSelectedIndex(0);
                }
                ExpressConverter.this.setPreferenceState();
                ExpressConverter.this.gDirtyData = true;
            }
        });
        this.progLabel = new JLabel("");
        this.progLabel.setPreferredSize(new Dimension(btnWidth, btnHeight));
        this.infoLB = new JLabel("");
        this.infoLB.setPreferredSize(new Dimension(btnWidth, btnHeight));
        this.bar = new JProgressBar();
        this.bar.setBorder(InitialWindow.low);
        this.bar.setStringPainted(true);
        this.toolBarPanel = new JPanel();
        this.toolBarPanel.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarPanel.setSize(this.gSizeX - 10, 30);
        this.toolBarPanel.setPreferredSize(this.toolBarPanel.getSize());
        int baseHigh = this.gSizeY - this.toolBarPanel.getSize().height - 60;
        this.basePanel.setPreferredSize(new Dimension(this.gSizeX - 10, baseHigh));
        this.toolBarPanel.add(this.fileToolBar);
        this.toolBarPanel.add(this.editToolBar);
        this.toolBarPanel.add(this.helpToolBar);
        this.toolBarPanel.add(this.outSelBar);
        this.getContentPane().add((Component)this.toolBarPanel, "North");
        this.getContentPane().add((Component)this.basePanel, "Center");
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent ce) {
                ExpressConverter.this.gSizeX = ExpressConverter.this.getWidth();
                ExpressConverter.this.gSizeY = ExpressConverter.this.getHeight();
                if (ExpressConverter.this.gSizeY > scrHeight || ExpressConverter.this.gSizeY > 1000) {
                    ExpressConverter.this.gSizeY = scrHeight - 30;
                }
                ExpressConverter.this.gDirtyData = true;
            }

            public void componentMoved(ComponentEvent ce) {
                ExpressConverter.this.gLocX = (int)ExpressConverter.this.getLocation().getX();
                ExpressConverter.this.gLocY = (int)ExpressConverter.this.getLocation().getY();
            }

            public void componentShown(ComponentEvent ce) {
            }

            public void componentHidden(ComponentEvent ce) {
            }
        });
        InitialWindow.gba.add(this.basePanel, this.inputTP, 0, 0, 1, 1, 1, 1, 1, 10, 3, 5, 3, 5);
        InitialWindow.gba.add(this.basePanel, this.infoLB, 0, 1, 1, 1, 1, 0, 2, 10, 8, 5, 2, 5);
        InitialWindow.gba.add(this.basePanel, this.progLabel, 0, 2, 1, 1, 1, 0, 2, 10, 2, 5, 2, 5);
        InitialWindow.gba.add(this.basePanel, this.bar, 0, 3, 1, 1, 1, 0, 2, 10, 1, 5, 5, 5);
        this.resize(this.gSizeX, this.gSizeY);
        if (this.gLocX < 0 && this.gLocY < 0) {
            this.gLocX = scrWidth - this.gSizeX >> 1;
            this.gLocY = scrHeight - 25 - this.gSizeY >> 1;
            if (this.gLocY < 0) {
                this.gLocY = 0;
            }
        }
        this.setLocation(this.gLocX, this.gLocY);
        this.setWindowFeel(this.gScrFeel);
        this.pack();
    }

    public void actionPerformed(ActionEvent ae) {
        this.adjustToolBar();
        if (ae.getSource() == this.stopBtn || ae.getSource() == this.stopMI) {
            this.terminate();
        } else if (ae.getSource() == this.convertBtn || ae.getSource() == this.gRunMI) {
            this.convertFiles();
        } else if (ae.getSource() == this.clearBtn || ae.getSource() == this.resetMI) {
            this.reset();
        } else if (ae.getSource() == this.helpBtn || ae.getSource() == this.helpMI) {
            this.showHelp();
        } else if (ae.getSource() == this.fileBrowserBtn || ae.getSource() == this.gLoadMI) {
            this.loadInputFiles();
        } else if (ae.getSource() == this.deleteBtn || ae.getSource() == this.deleteMI) {
            this.removeFile();
        } else if (ae.getSource() == this.editBtn || ae.getSource() == this.changeNameMI) {
            this.editFileName();
        } else if (ae.getSource() == this.exitMI) {
            this.quit();
        } else if (ae.getSource() == this.viewLogBtn || ae.getSource() == this.viewLogMI) {
            this.showLogContent();
        } else if (ae.getSource() == this.gAnnBtn || ae.getSource() == this.gAnnOneCkbox || ae.getSource() == this.gAnnManyCkbox) {
            this.setAnnFileType();
        } else if (ae.getSource() == this.gSaveBtn || ae.getSource() == this.gSaveMI) {
            this.saveCustomerHeader();
        } else if (ae.getSource() == this.gOpenBtn || ae.getSource() == this.gOpenMI) {
            this.openCustomerHeader();
        } else if (ae.getSource() == this.aboutMI) {
            if (!projector.isFaceOn()) {
                ExpressConverter.showAbout(false);
            } else {
                projector.terminate();
                ExpressConverter.showAbout(false);
            }
        } else if (ae.getSource() == this.changeDirMI || ae.getSource() == this.changeDirBtn) {
            this.changeDirectory();
        } else if (ae.getSource() == this.winViewMI) {
            this.gScrFeel = 1;
            this.setWindowFeel(this.gScrFeel);
            this.adjustToolBar();
        } else if (ae.getSource() == this.prefMI) {
            this.setOption();
        } else if (ae.getSource() == this.metalViewCkbox) {
            this.gScrFeel = 0;
            this.setWindowFeel(this.gScrFeel);
            this.adjustToolBar();
        } else if (ae.getSource() == this.motifViewMI) {
            this.gScrFeel = 2;
            this.setWindowFeel(this.gScrFeel);
            this.adjustToolBar();
        }
    }

    public void activateButton(boolean go, boolean clear) {
        this.convertBtn.setEnabled(go);
        this.gRunMI.setEnabled(go);
        this.clearBtn.setEnabled(clear);
        this.resetMI.setEnabled(clear);
        this.changeDirBtn.setEnabled(clear);
        this.changeDirMI.setEnabled(clear);
        this.changeNameMI.setEnabled(clear);
        this.editBtn.setEnabled(clear);
        this.stopBtn.setEnabled(false);
        this.stopMI.setEnabled(false);
        if (this.gSelConverter == 7) {
            this.gSaveBtn.setEnabled(clear);
            this.gSaveMI.setEnabled(clear);
            this.gOpenBtn.setEnabled(this.gCustomerPL.getOutputReady());
            this.gOpenMI.setEnabled(this.gCustomerPL.getOutputReady());
        } else {
            this.gSaveBtn.setEnabled(false);
            this.gSaveMI.setEnabled(false);
            this.gOpenBtn.setEnabled(false);
            this.gOpenMI.setEnabled(false);
        }
    }

    private void initialMenuBar() {
        this.browserIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/brwsdir.gif")));
        this.deleteIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/delete.gif")));
        this.editIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/edit.gif")));
        this.runIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/runconvt.gif")));
        this.stopIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/stop.gif")));
        this.clearIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/erase.gif")));
        this.viewLogIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/vlog.gif")));
        this.helpIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/help.gif")));
        this.changeDirIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/chdir.gif")));
        this.gAnnOneIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/oneone.gif")));
        this.gAnnManyIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/onemany.gif")));
        this.gOpenIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/openfile.gif")));
        this.gSaveIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/save.gif")));
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        this.menuBar.add(this.fileMenu);
        this.gLoadMI = new JMenuItem(" Select input files ...", this.browserIcon);
        this.gLoadMI.addActionListener(this);
        this.gOpenMI = new JMenuItem(" Open header file ...", this.gOpenIcon);
        this.gOpenMI.addActionListener(this);
        this.gOpenMI.setEnabled(false);
        this.gSaveMI = new JMenuItem(" Save header file ...", this.gSaveIcon);
        this.gSaveMI.addActionListener(this);
        this.gSaveMI.setEnabled(false);
        this.gRunMI = new JMenuItem(" Start converting", this.runIcon);
        this.gRunMI.setEnabled(false);
        this.gRunMI.addActionListener(this);
        this.stopMI = new JMenuItem(" Stop converting", this.stopIcon);
        this.stopMI.addActionListener(this);
        this.stopMI.setEnabled(false);
        this.prefMI = new JMenuItem("         Preference ...");
        this.prefMI.addActionListener(this);
        this.exitMI = new JMenuItem("         Exit");
        this.exitMI.addActionListener(this);
        this.fileMenu.add(this.gLoadMI);
        this.fileMenu.add(this.gOpenMI);
        this.fileMenu.add(this.gSaveMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.gRunMI);
        this.fileMenu.add(this.stopMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.prefMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMI);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic('E');
        this.menuBar.add(this.editMenu);
        this.changeDirMI = new JMenuItem(" Change directory", this.changeDirIcon);
        this.changeDirMI.setEnabled(false);
        this.changeDirMI.addActionListener(this);
        this.changeNameMI = new JMenuItem(" Change file name", this.editIcon);
        this.changeNameMI.setEnabled(false);
        this.changeNameMI.addActionListener(this);
        this.deleteMI = new JMenuItem(" Delete a file", this.deleteIcon);
        this.deleteMI.addActionListener(this);
        this.resetMI = new JMenuItem(" Reset", this.clearIcon);
        this.resetMI.setEnabled(false);
        this.resetMI.addActionListener(this);
        this.editMenu.add(this.changeDirMI);
        this.editMenu.add(this.changeNameMI);
        this.editMenu.add(this.deleteMI);
        this.editMenu.add(this.resetMI);
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic('V');
        this.menuBar.add(this.viewMenu);
        this.btnGroup = new ButtonGroup();
        this.viewLogMI = new JMenuItem(" Log", this.viewLogIcon);
        this.viewLogMI.addActionListener(this);
        this.metalViewCkbox = new JCheckBox("Metal L&F");
        this.metalViewCkbox.addActionListener(this);
        this.winViewMI = new JCheckBox("Window L&F");
        this.winViewMI.addActionListener(this);
        this.motifViewMI = new JCheckBox("Motif L&F");
        this.motifViewMI.addActionListener(this);
        this.btnGroup.add(this.winViewMI);
        this.btnGroup.add(this.metalViewCkbox);
        this.btnGroup.add(this.motifViewMI);
        if (this.gScrFeel == 0) {
            this.metalViewCkbox.setSelected(true);
        } else if (this.gScrFeel == 1) {
            this.winViewMI.setSelected(true);
        } else {
            this.motifViewMI.setSelected(true);
        }
        this.viewPanel = new JPanel(new GridBagLayout());
        InitialWindow.gba.add(this.viewPanel, this.metalViewCkbox, 0, 0, 1, 1, 0, 0, 0, 17, 0, 4, 0, 0);
        if (gOs != 1) {
            InitialWindow.gba.add(this.viewPanel, this.winViewMI, 0, 1, 1, 1, 0, 0, 0, 17, 0, 4, 0, 0);
        }
        InitialWindow.gba.add(this.viewPanel, this.motifViewMI, 0, 2, 1, 1, 0, 0, 0, 17, 0, 4, 0, 0);
        this.viewMenu.add(this.viewLogMI);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.viewPanel);
        this.annMenu = new JMenu("Ann File");
        this.annMenu.setMnemonic('A');
        this.menuBar.add(this.annMenu);
        this.gAnnGroup = new ButtonGroup();
        this.gAnnOneCkbox = new JCheckBox("One to One");
        this.gAnnOneCkbox.setToolTipText("Each mev file has its own ann file.");
        this.gAnnOneCkbox.addActionListener(this);
        this.gAnnManyCkbox = new JCheckBox("Many to One");
        this.gAnnManyCkbox.setToolTipText("Many mev files share one ann file.");
        this.gAnnManyCkbox.addActionListener(this);
        this.gAnnGroup.add(this.gAnnOneCkbox);
        this.gAnnGroup.add(this.gAnnManyCkbox);
        this.gAnnOneCkbox.setSelected(true);
        this.gAnnTypePanel = new JPanel(new GridBagLayout());
        InitialWindow.gba.add(this.gAnnTypePanel, this.gAnnOneCkbox, 0, 0, 1, 1, 0, 0, 0, 17, 0, 4, 0, 0);
        InitialWindow.gba.add(this.gAnnTypePanel, this.gAnnManyCkbox, 0, 1, 1, 1, 0, 0, 0, 17, 0, 4, 0, 0);
        this.annMenu.add(this.gAnnTypePanel);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic('H');
        this.menuBar.add(this.helpMenu);
        this.aboutMI = new JMenuItem("         about");
        this.aboutMI.addActionListener(this);
        this.helpMI = new JMenuItem(" Content and topics", this.helpIcon);
        this.helpMI.addActionListener(this);
        this.helpMenu.add(this.aboutMI);
        if (gOs != 1) {
            this.helpMenu.add(this.helpMI);
        }
    }

    private void initialToolBar() {
        Dimension iconSize = new Dimension(27, 27);
        this.fileToolBar = new JToolBar();
        this.fileToolBar.setBorderPainted(false);
        this.fileToolBar.setName("File ...");
        this.fileBrowserBtn = new JButton(this.browserIcon);
        this.fileBrowserBtn.setToolTipText("Browser system to find input files.");
        this.fileBrowserBtn.setPreferredSize(iconSize);
        this.fileBrowserBtn.addActionListener(this);
        this.buttonFace(this.fileBrowserBtn);
        this.gOpenBtn = new JButton(this.gOpenIcon);
        this.gOpenBtn.setToolTipText("Open a header file.");
        this.gOpenBtn.setPreferredSize(iconSize);
        this.gOpenBtn.addActionListener(this);
        this.buttonFace(this.gOpenBtn);
        this.gOpenBtn.setEnabled(false);
        this.gSaveBtn = new JButton(this.gSaveIcon);
        this.gSaveBtn.setToolTipText("Save a header file.");
        this.gSaveBtn.setPreferredSize(iconSize);
        this.gSaveBtn.addActionListener(this);
        this.buttonFace(this.gSaveBtn);
        this.gSaveBtn.setEnabled(false);
        this.convertBtn = new JButton(this.runIcon);
        this.convertBtn.setToolTipText("Start converting the selected files");
        this.convertBtn.setPreferredSize(iconSize);
        this.convertBtn.addActionListener(this);
        this.buttonFace(this.convertBtn);
        this.convertBtn.setEnabled(false);
        this.stopBtn = new JButton(this.stopIcon);
        this.stopBtn.addActionListener(this);
        this.stopBtn.setEnabled(false);
        this.stopBtn.setPreferredSize(iconSize);
        this.buttonFace(this.stopBtn);
        this.fileToolBar.add(this.fileBrowserBtn);
        this.fileToolBar.add(this.gOpenBtn);
        this.fileToolBar.add(this.gSaveBtn);
        this.fileToolBar.add(this.convertBtn);
        this.fileToolBar.add(this.stopBtn);
        this.editToolBar = new JToolBar();
        this.editToolBar.setBorderPainted(false);
        this.editToolBar.setName("Edit ...");
        this.changeDirBtn = new JButton(this.changeDirIcon);
        this.changeDirBtn.setToolTipText("Change output directory.");
        this.changeDirBtn.setPreferredSize(iconSize);
        this.changeDirBtn.addActionListener(this);
        this.changeDirBtn.setEnabled(false);
        this.buttonFace(this.changeDirBtn);
        this.editBtn = new JButton(this.editIcon);
        this.editBtn.setToolTipText("Modify the output file name.");
        this.editBtn.setPreferredSize(iconSize);
        this.editBtn.addActionListener(this);
        this.buttonFace(this.editBtn);
        this.deleteBtn = new JButton(this.deleteIcon);
        this.deleteBtn.setToolTipText("Remove the files from the selected list.");
        this.deleteBtn.addActionListener(this);
        this.deleteBtn.setPreferredSize(iconSize);
        this.buttonFace(this.deleteBtn);
        this.clearBtn = new JButton(this.clearIcon);
        this.clearBtn.setToolTipText("Clear interface and set Converter to its original status.");
        this.clearBtn.setEnabled(false);
        this.clearBtn.setPreferredSize(iconSize);
        this.clearBtn.addActionListener(this);
        this.buttonFace(this.clearBtn);
        this.gAnnBtn = new JButton(this.gAnnOneIcon);
        this.gAnnBtn.setToolTipText("Each mev file has its own ann file.");
        this.gAnnBtn.setPreferredSize(iconSize);
        this.gAnnBtn.addActionListener(this);
        this.gAnnBtn.setName("1");
        this.buttonFace(this.gAnnBtn);
        this.editToolBar.add(this.changeDirBtn);
        this.editToolBar.add(this.editBtn);
        this.editToolBar.add(this.deleteBtn);
        this.editToolBar.add(this.clearBtn);
        this.editToolBar.add(this.gAnnBtn);
        this.outSelBar = new JToolBar();
        this.outSelBar.setBorderPainted(false);
        this.outSelBar.setName("Output Type");
        this.outputLB = new JLabel("Output: ");
        this.outputLB.setPreferredSize(new Dimension(45, 27));
        this.outputCB = new JComboBox<String>(this.FILE_TYPE);
        this.outputCB.setBorder(InitialWindow.low);
        this.outputCB.setPreferredSize(new Dimension(60, 27));
        this.outputCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    ExpressConverter.this.outputType = ExpressConverter.this.outputCB.getSelectedIndex();
                    if (ExpressConverter.this.gSelConverter == 0) {
                        ExpressConverter.this.genePixPL.adjustGUI(ExpressConverter.this.outputType);
                    } else if (ExpressConverter.this.gSelConverter == 1) {
                        ExpressConverter.this.imaGenePL.adjustGUI(ExpressConverter.this.outputType);
                    } else if (ExpressConverter.this.gSelConverter == 2) {
                        ExpressConverter.this.scanArrayPL.adjustGUI(ExpressConverter.this.outputType);
                    } else if (ExpressConverter.this.gSelConverter == 5) {
                        ExpressConverter.this.tavPL.adjustGUI(ExpressConverter.this.outputType);
                    } else if (ExpressConverter.this.gSelConverter == 6) {
                        ExpressConverter.this.mevPL.adjustGUI(ExpressConverter.this.outputType);
                    }
                }
            }
        });
        this.outSelBar.add(this.outputLB);
        this.outSelBar.add(this.outputCB);
        this.helpToolBar = new JToolBar();
        this.helpToolBar.setBorderPainted(false);
        this.helpToolBar.setName("Help ...");
        this.viewLogBtn = new JButton(this.viewLogIcon);
        this.viewLogBtn.setToolTipText("View Log");
        this.viewLogBtn.setPreferredSize(iconSize);
        this.viewLogBtn.addActionListener(this);
        this.buttonFace(this.viewLogBtn);
        this.helpBtn = new JButton(this.helpIcon);
        this.helpBtn.setToolTipText("Open Manual.");
        this.helpBtn.setPreferredSize(iconSize);
        this.helpBtn.addActionListener(this);
        this.buttonFace(this.helpBtn);
        if (gOs != 1) {
            this.helpToolBar.add(this.helpBtn);
        }
        this.helpToolBar.add(this.viewLogBtn);
    }

    private boolean isValidFileName(String[] names, String[] ftypes) {
        String temp = new String("");
        boolean correct = true;
        if (names != null) {
            int num = names.length;
            int i = 0;
            while (i < num) {
                temp = IOUtil.getFileNameExtension(names[i]);
                boolean oneRight = false;
                int j = 0;
                while (j < ftypes.length) {
                    if (temp.equalsIgnoreCase(ftypes[j])) {
                        oneRight = true;
                        j = ftypes.length;
                    }
                    ++j;
                }
                if (!oneRight) {
                    correct = false;
                    String fExt = new String("");
                    int k = 0;
                    while (k < ftypes.length) {
                        fExt = fExt + ftypes[k] + "/";
                        ++k;
                    }
                    fExt = fExt.substring(0, fExt.length() - 1);
                    this.alertUsers("Only " + fExt + " file is acceptable for this field.");
                    i = num;
                }
                ++i;
            }
            if (!correct) {
                return correct;
            }
        } else {
            return false;
        }
        return correct;
    }

    private void loadConfigInfo(String fName) {
        try {
            FileReading fr = new FileReading(fName);
            if (fr.done) {
                this.initFile = fr.getFileContentInLines();
            } else {
                this.terminateProgram(fr.getProcessMessage());
            }
        }
        catch (IOException e) {
            this.terminateProgram(e.getMessage());
        }
        this.gSizeX = Integer.parseInt(MyIni.getSingleValueFromIni(this.initFile, "scrWidth"));
        this.gSizeY = Integer.parseInt(MyIni.getSingleValueFromIni(this.initFile, "scrHeight"));
        this.gScrFeel = Integer.parseInt(MyIni.getSingleValueFromIni(this.initFile, "scrFeel"));
        this.gSelConverter = Integer.parseInt(MyIni.getSingleValueFromIni(this.initFile, "scrPref"));
        this.gLocX = Integer.parseInt(MyIni.getSingleValueFromIni(this.initFile, "locX"));
        this.gLocY = Integer.parseInt(MyIni.getSingleValueFromIni(this.initFile, "locY"));
        this.gUserTypes = MyIni.getSingleValueFromIni(this.initFile, "custFile");
        this.gFileLine = Integer.parseInt(MyIni.getSingleValueFromIni(this.initFile, "cfSize"));
        this.gVer = MyIni.getSingleValueFromIni(this.initFile, "ver");
        this.gUserTypes = MyIni.removeEndSpace(this.gUserTypes);
        this.gCustType = this.setCustomizedFileType(this.gUserTypes);
        if (this.gSizeX > scrWidth) {
            this.gSizeX = scrWidth;
        }
    }

    private void loadInputFiles() {
        String[] fNames = null;
        if (this.gSelConverter == 0) {
            fNames = this.getFileName(this.gfType, "GenePix File", gSysPath);
        } else if (this.gSelConverter == 1) {
            fNames = this.getFileName(this.txtType, "ImaGene File", gSysPath);
        } else if (this.gSelConverter == 2) {
            fNames = this.getFileName(this.txtType, "ScanArray File", gSysPath);
        } else if (this.gSelConverter == 3) {
            fNames = this.getFileName(this.txtType, "ArrayVersion File", gSysPath);
        } else if (this.gSelConverter == 4) {
            fNames = this.getFileName(this.txtType, "Agilent File", gSysPath);
        } else if (this.gSelConverter == 5) {
            fNames = this.getFileName(this.tavType, "TAV File", gSysPath);
        } else if (this.gSelConverter == 6) {
            fNames = this.getFileName(this.mevType, "MEV File", gSysPath);
        } else if (this.gSelConverter == 7) {
            fNames = this.getFileName(this.gCustType, "Your Input File", gSysPath);
        }
        if (fNames != null) {
            if (this.gSelConverter == 0) {
                this.genePixPL.setSelectedFiles(fNames);
            } else if (this.gSelConverter == 1) {
                this.imaGenePL.setSelectedFiles(fNames);
            } else if (this.gSelConverter == 2) {
                this.scanArrayPL.setSelectedFiles(fNames);
            } else if (this.gSelConverter == 3) {
                this.arrayVersionPL.setSelectedFiles(fNames);
            } else if (this.gSelConverter == 4) {
                this.aligentPL.setSelectedFiles(fNames);
            } else if (this.gSelConverter == 5) {
                this.tavPL.setSelectedFiles(fNames);
            } else if (this.gSelConverter == 6) {
                this.mevPL.setSelectedFiles(fNames);
            } else if (this.gSelConverter == 7) {
                this.gCustomerPL.setSelectedFiles(fNames);
            }
        }
    }

    private void saveCustomerHeader() {
        gSysPath = this.gCustomerPL.saveHeader(gSysPath);
    }

    private void quit() {
        if (helpWinOn) {
            this.runner.terminate();
        }
        if (this.gDirtyData) {
            this.changeInitFile();
            IOUtil.writeToFileLineByLine((Object)this, this.iniFileName, this.initFile);
        }
        System.exit(0);
    }

    public void alertUsers(String msg) {
        this.getToolkit().beep();
        JOptionPane.showMessageDialog(this, msg, "You make a mistake ... ", 0);
    }

    public Vector getCustomizedFileTypes() {
        Vector<String> vec = new Vector<String>(this.gCustType.length);
        int i = 0;
        while (i < this.gCustType.length) {
            vec.add(this.gCustType[i]);
            ++i;
        }
        return vec;
    }

    public int getLocationX() {
        return this.gLocX;
    }

    public int getLocationY() {
        return this.gLocY;
    }

    public int getPreviewLine() {
        return this.gFileLine;
    }

    public String getVersion() {
        return this.gVer;
    }

    public static void main(String[] arg) {
        gSysPath = System.getProperty("user.dir") + System.getProperty("file.separator");
        iconPic = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/convticon.gif"));
        scrWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        scrHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        ExpressConverter.showAbout(true);
        projector.setTextColor(Color.green);
        projector.setInfoText("    Start runing ExpressConverter, ver.1.7 ... ");
        ExpressConverter exc = new ExpressConverter(TITLE);
        exc.show();
        projector.setInfoText("    Program loading is successful ... ");
        projector.terminate();
    }

    static void showAbout(boolean load) {
        Image image = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/convertface.gif"));
        proPic = new Proface(image, 2, Color.black);
        proPic.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pe) {
                if (pe.getPropertyName().equals("credit")) {
                    ExpressConverter.presentThanks();
                }
            }
        });
        projector = new ProfaceProjector(proPic, load);
        projector.start();
        if (!load) {
            projector.setTextColor(Color.green);
            projector.setButtonTextColor(Color.green);
            projector.setButtonText(" Acknowledgments  ");
            projector.setInfoText("   Jerry Li and John Quackenbush. ");
        }
    }

    static void presentThanks() {
        JTextArea ta = new JTextArea();
        StringBuffer thank = new StringBuffer(100);
        thank.append("We thank following people for their great contributions:\n\n");
        thank.append("Vasily Sharov at TIGR for his valuable comments about intensity conversion\n");
        thank.append("     algorithms.\n");
        thank.append("Dr. Joseph White at TIGR for his spot mapping algorithms.\n");
        thank.append("Dr. Wes Warren at Washington University, St. Louis, for providing information\n");
        thank.append("     about ScanArray file format.\n");
        thank.append("Dr. Dave Berger at the University of Pretoria, South Africa, for providing\n");
        thank.append("     information about ArrayVision file format.\n");
        thank.append("Vu Chu at University of Washington for his protype to convert Agilent file.\n");
        ta.setSize(proPic.getImageWidth(), proPic.getImageHeight());
        creditWin = new Proface(ta, thank.toString(), Color.black);
        creditWin.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pe) {
                if (pe.getPropertyName().equals("close")) {
                    projector.terminate();
                }
            }
        });
        projector.setFace(creditWin);
        projector.setButtonTextColor(Color.green);
        projector.setTextColor(Color.yellow);
    }

    public void terminate() {
        if (this.genepixTavConvt != null && this.genepixTavConvt.isAlive()) {
            this.genepixTavConvt.stop();
        }
        if (this.genepixMevConvt != null && this.genepixMevConvt.isAlive()) {
            this.genepixMevConvt.stop();
        }
        if (this.imaGeneTavConvt != null && this.imaGeneTavConvt.isAlive()) {
            this.imaGeneTavConvt.stop();
        }
        if (this.imaGeneMevConvt != null && this.imaGeneMevConvt.isAlive()) {
            this.imaGeneMevConvt.stop();
        }
        if (this.scanArrayTavConvt != null && this.scanArrayTavConvt.isAlive()) {
            this.scanArrayTavConvt.stop();
        }
        if (this.arrayVersionMevConvt != null && this.arrayVersionMevConvt.isAlive()) {
            this.arrayVersionMevConvt.stop();
        }
        if (this.aligentMevConvt != null && this.aligentMevConvt.isAlive()) {
            this.aligentMevConvt.stop();
        }
        if (this.tavMevConvt != null && this.tavMevConvt.isAlive()) {
            this.tavMevConvt.stop();
        }
        if (this.mevTavConvt != null && this.mevTavConvt.isAlive()) {
            this.mevTavConvt.stop();
        }
        if (this.gCustMevConvt != null && this.gCustMevConvt.isAlive()) {
            this.gCustMevConvt.stop();
        }
        this.info = "";
        this.progCounter = this.progEnd;
        this.cvTimer.stop();
        this.progLabel.setText("Converting is stopped.");
        this.stopBtn.setEnabled(false);
        this.stopMI.setEnabled(false);
        this.clearBtn.setEnabled(true);
        this.resetMI.setEnabled(true);
        this.convertBtn.setEnabled(true);
        this.fileBrowserBtn.setEnabled(true);
        this.deleteBtn.setEnabled(true);
        this.changeDirBtn.setEnabled(true);
        this.changeDirMI.setEnabled(true);
        this.changeNameMI.setEnabled(true);
        this.editBtn.setEnabled(true);
    }

    public int validFile(String fName, boolean needTest, int btnShow) {
        String name = new String(fName);
        String folder = new String("");
        int confirm = 1;
        JFrame jf = new JFrame();
        File targFile = null;
        folder = IOUtil.extractPath(name);
        folder = IOUtil.makeDir(folder);
        if (needTest) {
            targFile = new File(name);
            if (targFile.exists()) {
                jf.getToolkit().beep();
                ConfirmUsers cu = new ConfirmUsers(jf, this.title, "The file \"" + name + "\" already exists, do you want to replace " + "the existing file?", btnShow, true);
                confirm = cu.getConfirmed();
            }
        } else {
            confirm = 2;
        }
        return confirm;
    }

    private void reset() {
        if (this.gSelConverter == 0) {
            this.genePixPL.reset();
        } else if (this.gSelConverter == 1) {
            this.imaGenePL.reset();
        } else if (this.gSelConverter == 2) {
            this.scanArrayPL.reset();
        } else if (this.gSelConverter == 3) {
            this.arrayVersionPL.reset();
        } else if (this.gSelConverter == 4) {
            this.aligentPL.reset();
        } else if (this.gSelConverter == 5) {
            this.tavPL.reset();
        } else if (this.gSelConverter == 6) {
            this.mevPL.reset();
        } else if (this.gSelConverter == 7) {
            this.gCustomerPL.reset();
        }
        this.progLabel.setText(this.info);
        this.infoLB.setText("");
        this.fileBrowserBtn.setEnabled(true);
        this.deleteBtn.setEnabled(true);
        this.bar.setValue(0);
    }

    private void removeFile() {
        if (this.gSelConverter == 0) {
            this.genePixPL.removeFileFromList();
        } else if (this.gSelConverter == 1) {
            this.imaGenePL.removeFileFromList();
        } else if (this.gSelConverter == 2) {
            this.scanArrayPL.removeFileFromList();
        } else if (this.gSelConverter == 3) {
            this.arrayVersionPL.removeFileFromList();
        } else if (this.gSelConverter == 4) {
            this.aligentPL.removeFileFromList();
        } else if (this.gSelConverter == 5) {
            this.tavPL.removeFileFromList();
        } else if (this.gSelConverter == 6) {
            this.mevPL.removeFileFromList();
        } else if (this.gSelConverter == 7) {
            this.gCustomerPL.removeFileFromList();
        }
    }

    private void openCustomerHeader() {
        File hdFile = null;
        hdFile = this.getFile(ECH, CUS_HEADER_FILE, gSysPath);
        if (hdFile != null) {
            this.gCustomerPL.loadHeader(hdFile);
        }
    }

    private void setAnnFileType() {
        if (this.gAnnBtn.getName().equals("1")) {
            this.gAnnType = 2;
            this.gAnnBtn.setIcon(this.gAnnManyIcon);
            this.gAnnBtn.setName("2");
            this.gAnnBtn.setToolTipText("Many mev files share one ann file.");
            this.gAnnManyCkbox.setSelected(true);
        } else {
            this.gAnnType = 1;
            this.gAnnBtn.setIcon(this.gAnnOneIcon);
            this.gAnnBtn.setName("1");
            this.gAnnBtn.setToolTipText("Each mev file has its own ann file.");
            this.gAnnOneCkbox.setSelected(true);
        }
    }

    private String[] setCustomizedFileType(String type) {
        int i = 0;
        StringTokenizer token = new StringTokenizer(type, " ");
        String[] temp = new String[token.countTokens()];
        while (token.hasMoreTokens()) {
            temp[i++] = token.nextToken();
        }
        return temp;
    }

    private void setOption() {
        ConverterOption ctOption = new ConverterOption(this, true);
        ctOption.show();
        if (ctOption.dataEntered && ctOption.dirtyData) {
            this.gUserTypes = ctOption.getCustomizedFileNameExtensions();
            this.gCustType = this.setCustomizedFileType(this.gUserTypes);
            this.gFileLine = ctOption.getPreviewFileSize();
            this.gDirtyData = true;
        }
    }

    private void setPreferenceState() {
        this.inputTP.setSelectedIndex(this.gSelConverter);
        this.outputCB.setSelectedIndex(0);
        this.outputCB.setSelectedIndex(1);
        if (this.gSelConverter == 6) {
            this.outputType = 0;
            this.mevPL.adjustGUI(this.outputType);
            this.outputCB.setSelectedIndex(this.outputType);
            this.outputCB.setEnabled(false);
        } else if (this.gSelConverter == 5 || this.gSelConverter == 3 || this.gSelConverter == 4 || this.gSelConverter == 7) {
            this.outputCB.setEnabled(false);
        } else {
            this.outputCB.setEnabled(true);
        }
        if (this.gSelConverter == 1 || this.gSelConverter == 6 || this.gSelConverter == 3) {
            this.gAnnBtn.setEnabled(false);
            this.gAnnOneCkbox.setEnabled(false);
            this.gAnnManyCkbox.setEnabled(false);
        } else {
            this.gAnnBtn.setEnabled(true);
            this.gAnnOneCkbox.setEnabled(true);
            this.gAnnManyCkbox.setEnabled(true);
        }
    }

    private void setWindowFeel(int sel) {
        try {
            if (sel == 1) {
                UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
            } else if (sel == 0) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(new MotifLookAndFeel());
            }
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {}
    }

    private void showHelp() {
        String helpFile = new String("docs/convthelp.chm");
        String appl = new String("hh ");
        if (!this.runner.isRunning()) {
            helpWinOn = false;
        }
        if (!helpWinOn) {
            this.runner = new ProgramRunner(appl, helpFile);
            this.runner.start();
            helpWinOn = true;
        }
    }

    private void showLogContent() {
        if (!logWinOn) {
            this.logViewWin = new ConverterLogView(this, logFileContent, this.title);
            this.logViewWin.show();
            logWinOn = true;
        } else {
            this.logViewWin.setState(0);
            this.logViewWin.show();
        }
    }

    private void showProgressMassege(boolean done, boolean error, boolean smMistake) {
        if (done && !error && !smMistake) {
            this.progLabel.setText("Converting is successful.");
        } else if (error) {
            this.progLabel.setText("Converting is interrupted due to errors, which are showed in the Log Window.");
        } else if (smMistake) {
            this.progLabel.setText("Converting is completed with some errors, which are showed in the Log Window.");
        } else {
            this.progLabel.setText("");
        }
    }

    private void stopConverting() {
        this.progLabel.setText(this.info);
        this.bar.setValue(this.progCounter);
        this.progCounter = 0;
        this.progEnd = 1000;
        Toolkit.getDefaultToolkit().beep();
        this.bar.setMaximum(this.progEnd);
        this.bar.setValue(this.progCounter);
        this.cvTimer.stop();
        this.info = "";
        this.infoLB.setText(this.info);
        if (this.outputType == 0 && this.gSelConverter == 0) {
            this.showProgressMassege(TavConverter.ready, TavConverter.fetalError, TavConverter.minorError);
        } else if (this.outputType == 1 && this.gSelConverter == 0) {
            this.showProgressMassege(GenepixMev.ready, GenepixMev.fetalError, GenepixMev.minorError);
        } else if (this.outputType == 0 && this.gSelConverter == 1) {
            this.showProgressMassege(ImaGeneTav.ready, ImaGeneTav.fetalError, ImaGeneTav.minorError);
        } else if (this.outputType == 1 && this.gSelConverter == 1) {
            this.showProgressMassege(ImaGeneMev.ready, ImaGeneMev.fetalError, ImaGeneMev.minorError);
        } else if (this.outputType == 0 && this.gSelConverter == 2) {
            this.showProgressMassege(ScanArrayTav.ready, ScanArrayTav.fetalError, ScanArrayTav.minorError);
        } else if (this.outputType == 1 && this.gSelConverter == 2) {
            this.showProgressMassege(ScanArrayMev.ready, ScanArrayMev.fetalError, ScanArrayMev.minorError);
        } else if (this.outputType == 1 && this.gSelConverter == 5) {
            this.showProgressMassege(TavMev.ready, TavMev.fetalError, TavMev.minorError);
        } else if (this.outputType == 0 && this.gSelConverter == 6) {
            this.showProgressMassege(MevTav.ready, MevTav.fetalError, MevTav.minorError);
        } else if (this.outputType == 1 && this.gSelConverter == 3) {
            this.showProgressMassege(ArrayVersionMev.ready, ArrayVersionMev.fetalError, ArrayVersionMev.minorError);
        } else if (this.outputType == 1 && this.gSelConverter == 4) {
            this.showProgressMassege(AgilentMev.ready, AgilentMev.fetalError, AgilentMev.minorError);
        } else if (this.outputType == 1 && this.gSelConverter == 7) {
            this.showProgressMassege(CustomerMev.ready, CustomerMev.fetalError, CustomerMev.minorError);
        }
        this.activateButton(true, true);
    }

    private void terminateProgram(String msg) {
        JFrame frame = new JFrame();
        frame.getToolkit().beep();
        JOptionPane.showMessageDialog(null, msg, "Error in ... ", 0);
        System.exit(1);
    }

    static {
        ECH = new String[]{"ech"};
    }

    class ConvertListener
    implements ActionListener {
        Converter convt;

        public ConvertListener(Converter c) {
            this.convt = c;
        }

        public void actionPerformed(ActionEvent evt) {
            if (Converter.fetalError) {
                logFileContent.add(this.convt.getErrorMsg());
                ExpressConverter.this.stopConverting();
                return;
            }
            ExpressConverter.this.curTime = System.currentTimeMillis();
            ExpressConverter.this.progEnd = this.convt.getTaskEnd();
            ExpressConverter.this.bar.setMaximum(this.convt.getTaskEnd());
            ExpressConverter.this.progCounter = this.convt.getCurrent();
            if (ExpressConverter.this.progCounter == 0) {
                ExpressConverter.this.progLabel.setText("Wait, preparing for converting ...     Elapsed time: " + MyTimer.changeToStandardTime((ExpressConverter.this.curTime - ExpressConverter.this.startTime) / 1000L));
                return;
            }
            ExpressConverter.this.infoLB.setText("Converting " + this.convt.getFileName() + " ...");
            ExpressConverter.this.info = "completed " + (ExpressConverter.this.progCounter >> 1) + " out of " + (ExpressConverter.this.progEnd >> 1) + " spots " + "for " + ExpressConverter.this.selectedChAFiles.size() + " files.   Elapsed time: " + MyTimer.changeToStandardTime((ExpressConverter.this.curTime - ExpressConverter.this.startTime) / 1000L);
            if (ExpressConverter.this.progCounter < ExpressConverter.this.progEnd) {
                ExpressConverter.this.progLabel.setText(ExpressConverter.this.info);
                ExpressConverter.this.bar.setValue(ExpressConverter.this.progCounter);
            } else if (ExpressConverter.this.progEnd != 0) {
                logFileContent.add(this.convt.getErrorMsg());
                ExpressConverter.this.stopConverting();
                return;
            }
        }
    }
}

