/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.microarray.MevAttributes;
import org.tigr.microarray.converter.Converter;
import org.tigr.microarray.converter.MevConverter;
import org.tigr.util.FileReading;
import org.tigr.util.MyTimer;
import org.tigr.util.io.IOUtil;

public class GenepixMev
extends MevConverter
implements MevAttributes {
    private String bgChA;
    private String bgChB;
    private String bgChAn;
    private String bgChBn;
    private String chA;
    private String chAn;
    private String chB;
    private String chBn;
    private String chAs;
    private String chAsn;
    private String chBs;
    private String chBsn;
    private String title;
    private Vector mevFileNames;
    private int fPixAddr;
    private int gAnnType;
    private final int FIRST_NUM = 1;
    private final String FLAG = "\"Flags\"";
    private final String BLOCK = "\"Block\"";
    private final String COLUMN = "\"Column\"";
    private final String RW = "\"Row\"";
    private final String F_PIX = "\"F Pixels\"";
    private final String FLAG_N = "Flags";
    private final String BLOCK_N = "Block";
    private final String COLUMN_N = "Column";
    private final String ROW_N = "Row";
    private final String F_PIX_N = "F Pixels";
    private final String WAVE_KEY_1 = "ImageName";
    private final String WAVE_KEY_2 = "Wavelengths";
    final String ID = "ID";
    final String ID_N = "\"ID\"";
    final String NAME = "Name";
    final String NAME_N = "\"Name\"";

    public GenepixMev(String gfName, String mfName) {
        this.inFileNames = new Vector(1);
        this.mevFileNames = new Vector(1);
        this.inFileNames.add(gfName);
        this.mevFileNames.add(mfName);
        this.title = new String("Genepix vs Mev");
    }

    public GenepixMev(Vector gfNames, Vector mfNames, String barTitle, int annNum) {
        this.inFileNames = gfNames;
        this.mevFileNames = mfNames;
        this.title = barTitle;
        this.gAnnType = annNum;
    }

    public void run() {
        String aLine = new String("");
        String densA = new String("");
        String densB = new String("");
        String flagA = new String("");
        String flagB = new String("");
        String bgA = new String("");
        String bgB = new String("");
        String medA = new String("");
        String medB = new String("");
        String extraInfo = new String("");
        String[] annoFile = null;
        String[] waves = new String[2];
        StringBuffer mevLine = new StringBuffer(200);
        int max = 0;
        int maxRow = 0;
        int maxCol = 0;
        BufferedWriter mevWriter = null;
        BufferedWriter annoWriter = null;
        FileOutputStream mevFileOut = null;
        Vector genepixFile = null;
        this.taskEnd = this.determineTaskEnd();
        if (this.taskEnd == 1) {
            return;
        }
        this.taskEnd <<= 1;
        this.counter = 0;
        int numOfFiles = this.inFileNames.size();
        int i = 0;
        while (i < numOfFiles) {
            String mevFileName;
            boolean noError;
            block42: {
                noError = true;
                this.inFileNamePath = (String)this.inFileNames.elementAt(i);
                mevFileName = (String)this.mevFileNames.elementAt(i);
                try {
                    FileReading fileReader = new FileReading(this.inFileNamePath);
                    if (fileReader.done) {
                        genepixFile = fileReader.getFileContentInLines();
                        break block42;
                    }
                    this.taskEnd = 1;
                    this.counter = 1;
                    this.setErrorMessage(fileReader.getProcessMessage());
                    return;
                }
                catch (IOException e) {
                    this.taskEnd = 1;
                    this.counter = 1;
                    this.setErrorMessage(e.getMessage());
                    return;
                }
            }
            int fSize = genepixFile.size();
            int hLines = 0;
            boolean going = true;
            while (going) {
                aLine = (String)genepixFile.elementAt(hLines);
                if (aLine.charAt(0) == '\"' || this.isChar(aLine.charAt(0))) {
                    if (this.isWaveLengthDefination(aLine)) {
                        waves = this.getWaveLengths(aLine);
                    }
                    going = true;
                    ++hLines;
                    continue;
                }
                if (hLines == 1) {
                    going = true;
                    ++hLines;
                    continue;
                }
                going = false;
            }
            this.defineKeys(waves);
            aLine = (String)genepixFile.elementAt(hLines - 1);
            String[] colNames = this.separateLine(aLine);
            int blockIndex = this.findRightCol(colNames, "\"Block\"", "Block");
            int colIndex = this.findRightCol(colNames, "\"Column\"", "Column");
            int rowIndex = this.findRightCol(colNames, "\"Row\"", "Row");
            aLine = (String)genepixFile.elementAt(fSize - 1);
            String[] colValues = this.separateLine(aLine);
            if (colValues.length > 2) {
                max = Integer.parseInt(colValues[blockIndex]);
                maxCol = Integer.parseInt(colValues[colIndex]);
                maxRow = Integer.parseInt(colValues[rowIndex]);
            } else {
                JOptionPane.showMessageDialog(null, "You might add extra space at the end of file.\n(" + this.inFileNamePath + "). \nPlease remove it and try again. Converting will continue " + "\nfor remaining files", this.title + " -- Gpr-Mev", 0);
                noError = false;
                this.counter += numOfFiles;
            }
            if (noError) {
                int maxMetaCol = max <= 12 ? 2 : 4;
                noError = true;
                if (max * maxCol * maxRow + hLines != genepixFile.size()) {
                    JOptionPane.showMessageDialog(null, "You might have dropped some of your spots in the file \n(" + this.inFileNamePath + ".\nThe converter requires an original GenePix file." + "\nConverting will continue for the remaining files", this.title + " -- Gpr-Mev", 0);
                    noError = false;
                    this.counter += numOfFiles;
                }
                if (noError) {
                    int flagIndex = this.findRightCol(colNames, "\"Flags\"", "Flags");
                    this.fPixAddr = this.findRightCol(colNames, "\"F Pixels\"", "F Pixels");
                    int f635m = this.findRightCol(colNames, this.chA, this.chAn);
                    int f635s = this.findRightCol(colNames, this.chAs, this.chAsn);
                    int b635m = this.findRightCol(colNames, this.bgChA, this.bgChAn);
                    int f532m = this.findRightCol(colNames, this.chB, this.chBn);
                    int f532s = this.findRightCol(colNames, this.chBs, this.chBsn);
                    int b532m = this.findRightCol(colNames, this.bgChB, this.bgChBn);
                    int idIndex = this.findRightCol(colNames, "ID", "\"ID\"");
                    int nameIndex = this.findRightCol(colNames, "Name", "\"Name\"");
                    try {
                        String annoFileNamePath = IOUtil.dropExtension(mevFileName);
                        annoFileNamePath = annoFileNamePath + ".ann";
                        mevFileOut = new FileOutputStream(mevFileName);
                        mevWriter = new BufferedWriter(new OutputStreamWriter(mevFileOut));
                        this.sortKeys = new int[3][fSize - hLines];
                        this.outFile = new String[fSize - hLines];
                        String gprFileName = IOUtil.extractFileNameFromPath(this.inFileNamePath);
                        String[] mevFileHeader = this.generateHeader(gprFileName, fSize - hLines, true);
                        int j = 0;
                        while (j < mevFileHeader.length) {
                            mevWriter.write(mevFileHeader[j]);
                            mevWriter.newLine();
                            mevWriter.flush();
                            ++j;
                        }
                        if (this.gAnnType == 1) {
                            annoFile = new String[fSize - hLines];
                            annoWriter = this.createAnnoWriter(annoFileNamePath, gprFileName, fSize - hLines);
                        } else if (i < 1) {
                            annoFile = new String[fSize - hLines];
                            annoWriter = this.createAnnoWriter(annoFileNamePath, gprFileName, fSize - hLines);
                        }
                        this.counter += hLines;
                        int ident = 1;
                        j = hLines;
                        int k = 0;
                        while (j < fSize) {
                            aLine = (String)genepixFile.elementAt(j);
                            colValues = this.separateLine(aLine);
                            int block = Integer.parseInt(colValues[blockIndex]);
                            int col = Integer.parseInt(colValues[colIndex]);
                            int row = Integer.parseInt(colValues[rowIndex]);
                            int spAreaA = this.calculateSpotDimeter(colValues, f532s);
                            int spAreaB = this.calculateSpotDimeter(colValues, f635s);
                            flagA = this.setFlag(colValues, f532s, flagIndex);
                            flagB = this.setFlag(colValues, f635s, flagIndex);
                            int metaRow = (block - 1) / maxMetaCol + 1;
                            int metaCol = (block - 1) % maxMetaCol + 1;
                            int slideRow = (metaRow - 1) * maxRow + row;
                            int slideCol = (metaCol - 1) * maxCol + col;
                            bgA = this.calculateBackground(colValues, b532m);
                            bgB = this.calculateBackground(colValues, b635m);
                            mevLine.append(ident).append("\t");
                            if (this.gBkgCorrect) {
                                densA = this.calculateIntegrateDensity(colValues, f532m, f532s, b532m, true);
                                densB = this.calculateIntegrateDensity(colValues, f635m, f635s, b635m, true);
                                medA = this.calculateMedianIntensity(colValues, f532m, b532m, true);
                                medB = this.calculateMedianIntensity(colValues, f635m, b635m, true);
                            } else {
                                densA = this.calculateIntegrateDensity(colValues, f532m, f532s, b532m, false);
                                densB = this.calculateIntegrateDensity(colValues, f635m, f635s, b635m, false);
                                medA = this.calculateMedianIntensity(colValues, f532m, b532m, false);
                                medB = this.calculateMedianIntensity(colValues, f635m, b635m, false);
                            }
                            if (this.gUseMedian) {
                                mevLine.append(medA).append("\t").append(medB);
                                aLine = densA + "\t" + densB;
                            } else {
                                mevLine.append(densA).append("\t").append(densB);
                                aLine = medA + "\t" + medB;
                            }
                            mevLine.append("\t").append(slideRow).append("\t").append(slideCol);
                            mevLine.append("\t").append(metaRow).append("\t").append(metaCol);
                            mevLine.append("\t").append(row).append("\t").append(col).append("\t");
                            mevLine.append(bgA).append("\t").append(bgB).append("\t").append(flagA);
                            mevLine.append("\t").append(flagB).append("\t").append(spAreaA).append("\t");
                            mevLine.append(spAreaB).append("\t").append(aLine);
                            this.outFile[k] = new String(mevLine.toString());
                            mevLine.delete(0, mevLine.length());
                            if (this.gAnnType == 1) {
                                extraInfo = ident + "\t" + slideRow + "\t" + slideCol + "\t" + colValues[nameIndex] + "\t" + colValues[idIndex];
                                annoFile[k] = new String(extraInfo);
                            } else if (i < 1) {
                                extraInfo = ident + "\t" + slideRow + "\t" + slideCol + "\t" + colValues[nameIndex] + "\t" + colValues[idIndex];
                                annoFile[k] = new String(extraInfo);
                            }
                            this.sortKeys[0][k] = k;
                            this.sortKeys[1][k] = slideRow;
                            this.sortKeys[2][k] = slideCol;
                            ++ident;
                            ++this.counter;
                            ++j;
                            ++k;
                        }
                        if (this.wantSort) {
                            this.sorted = this.sortRowCol(maxMetaCol, maxCol);
                            j = 0;
                            while (j < this.outFile.length) {
                                mevWriter.write(this.outFile[this.sorted[j]]);
                                mevWriter.newLine();
                                mevWriter.flush();
                                if (this.gAnnType == 1) {
                                    annoWriter.write(annoFile[this.sorted[j]]);
                                    annoWriter.newLine();
                                    annoWriter.flush();
                                } else if (i < 1) {
                                    annoWriter.write(annoFile[this.sorted[j]]);
                                    annoWriter.newLine();
                                    annoWriter.flush();
                                }
                                ++this.counter;
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < this.outFile.length) {
                                mevWriter.write(this.outFile[j]);
                                mevWriter.newLine();
                                mevWriter.flush();
                                if (this.gAnnType == 1) {
                                    annoWriter.write(annoFile[j]);
                                    annoWriter.newLine();
                                    annoWriter.flush();
                                } else if (i < 1) {
                                    annoWriter.write(annoFile[j]);
                                    annoWriter.newLine();
                                    annoWriter.flush();
                                }
                                ++this.counter;
                                ++j;
                            }
                        }
                        mevFileOut.close();
                        if (this.gAnnType == 1) {
                            annoWriter.close();
                        } else if (i < 1) {
                            annoWriter.close();
                        }
                    }
                    catch (IOException ie) {
                        Converter.fetalError = true;
                        Converter.ready = false;
                        System.out.println("Error in writing file: " + ie.getMessage());
                        this.msg = this.msg + "**********\n";
                        this.msg = this.msg + "Error in writing file: " + ie.getMessage() + "\n";
                        return;
                    }
                    catch (Exception e) {
                        Converter.fetalError = true;
                        Converter.ready = false;
                        this.msg = this.msg + "**********\n";
                        this.msg = this.msg + "Error: " + e.getMessage() + ". Please report the developer.\n";
                        return;
                    }
                }
            }
            ++i;
        }
        Converter.ready = true;
        this.counter = this.taskEnd;
    }

    private int calculateSpotDimeter(String[] tuple, int sat) {
        float fPix = Float.parseFloat(tuple[this.fPixAddr]);
        float fSat = Float.parseFloat(tuple[sat]);
        int temp = (int)(fPix * (1.0f - (fSat /= 100.0f)));
        return temp;
    }

    private String calculateBackground(String[] tuple, int backg) {
        String bg = new String("");
        try {
            float fPix = Float.parseFloat(tuple[this.fPixAddr]);
            float bMedian = Float.parseFloat(tuple[backg]);
            int temp = (int)(bMedian * fPix);
            bg = bg + temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            bg = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value for either F Pixcel or B Median;\n";
            this.msg = this.msg + "and the background was set to null.\n";
        }
        return bg;
    }

    private String calculateIntegrateDensity(String[] tuple, int med, int sat, int backg, boolean bgSub) {
        String den = new String("");
        try {
            float fMedian = Float.parseFloat(tuple[med]);
            float bMedian = Float.parseFloat(tuple[backg]);
            float fPix = Float.parseFloat(tuple[this.fPixAddr]);
            float fSat = Float.parseFloat(tuple[sat]);
            int temp = bgSub ? (int)(fPix * (fMedian - bMedian) * (1.0f - fSat)) : (int)(fPix * fMedian * (1.0f - (fSat /= 100.0f)));
            den = den + temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            den = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate intensity; and the intensity was set to null.\n";
        }
        return den;
    }

    private String calculateMedianIntensity(String[] tuple, int med, int backg, boolean bgSub) {
        String den = new String("");
        try {
            float fMedian = Float.parseFloat(tuple[med]);
            float bMedian = Float.parseFloat(tuple[backg]);
            float temp = bgSub ? fMedian - bMedian : fMedian;
            den = den + (int)temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            den = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate intensity; and the intensity was set to null.\n";
        }
        return den;
    }

    private String[] generateHeader(String fName, int numRow, boolean mev) {
        String[] tempHeader = mev ? new String[8] : new String[7];
        String bkgVal = this.gBkgCorrect ? "ON" : "OFF";
        tempHeader[0] = new String("# version: V1.0");
        tempHeader[1] = new String("# format_version:V4.0");
        tempHeader[2] = new String("# date: " + MyTimer.getCurrentDateAndTime('.'));
        tempHeader[3] = new String("# created by: " + this.title);
        tempHeader[4] = new String("# row_count:" + numRow);
        tempHeader[5] = new String("# converted from GenePix file: " + fName);
        if (mev) {
            tempHeader[6] = new String("# background_correction:" + bkgVal);
            tempHeader[7] = this.gUseMedian ? "UID\tMedA\tMedB\tR\tC\tMR\tMC\tSR\tSC\tBkgA\tBkgB\tFlagA\tFlagB\tSAA\tSAB\tIA\tIB" : "UID\tIA\tIB\tR\tC\tMR\tMC\tSR\tSC\tBkgA\tBkgB\tFlagA\tFlagB\tSAA\tSAB\tMedA\tMedB";
        } else {
            tempHeader[6] = "UID\tR\tC\tName\tID";
        }
        return tempHeader;
    }

    private String[] getWaveLengths(String str) {
        String[] tempWave = new String[2];
        String wavStr = new String(str.substring(str.indexOf(61) + 1, str.lastIndexOf(34)));
        StringTokenizer token = new StringTokenizer(wavStr);
        int num = 0;
        while (token.hasMoreTokens()) {
            String wv = token.nextToken();
            if (!this.isNumber(wv)) continue;
            tempWave[num] = new String(wv);
            ++num;
        }
        return tempWave;
    }

    private BufferedWriter createAnnoWriter(String fName, String inName, int numSpots) {
        BufferedWriter out;
        try {
            FileOutputStream fOut = new FileOutputStream(fName);
            out = new BufferedWriter(new OutputStreamWriter(fOut));
            String[] annoFileHeader = this.generateHeader(inName, numSpots, false);
            int i = 0;
            while (i < annoFileHeader.length) {
                out.write(annoFileHeader[i]);
                out.newLine();
                out.flush();
                ++i;
            }
        }
        catch (IOException ie) {
            Converter.fetalError = true;
            Converter.ready = false;
            System.out.println("Error in creating ann file: " + ie.getMessage());
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "Error in creating ann file: " + ie.getMessage() + "\n";
            return null;
        }
        return out;
    }

    private void defineKeys(String[] wvs) {
        this.chA = new String("\"F" + wvs[0] + " Median\"");
        this.chB = new String("\"F" + wvs[1] + " Median\"");
        this.chAs = new String("\"F" + wvs[0] + " % Sat.\"");
        this.chBs = new String("\"F" + wvs[1] + " % Sat.\"");
        this.bgChA = new String("\"B" + wvs[0] + " Median\"");
        this.bgChB = new String("\"B" + wvs[1] + " Median\"");
        this.chAn = new String("F" + wvs[0] + " Median");
        this.chBn = new String("F" + wvs[1] + " Median");
        this.chAsn = new String("F" + wvs[0] + " % Sat.");
        this.chBsn = new String("F" + wvs[1] + " % Sat.");
        this.bgChAn = new String("B" + wvs[0] + " Median");
        this.bgChBn = new String("B" + wvs[1] + " Median");
    }

    private int findRightCol(String[] str, String key, String noQuato) {
        int addr = 0;
        int size = str.length;
        String temp = new String("");
        int i = 0;
        while (i < str.length) {
            if (str[i].equalsIgnoreCase(key) || str[i].equalsIgnoreCase(noQuato)) {
                addr = i;
                i = str.length;
            }
            ++i;
        }
        return addr;
    }

    private boolean isChar(char x) {
        boolean b = true;
        switch (x) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                b = false;
                break;
            }
            default: {
                b = true;
            }
        }
        return b;
    }

    private boolean isNumber(String x) {
        boolean b = true;
        int length = x.length();
        int i = 0;
        while (i < length) {
            if (this.isChar(x.charAt(i))) {
                b = false;
                i = length;
            }
            ++i;
        }
        return b;
    }

    private boolean isWaveLengthDefination(String str) {
        String temp = str;
        if (temp.charAt(0) == '\"' && temp.indexOf(61) > 0) {
            return (temp = temp.substring(1, temp.indexOf(61))).equalsIgnoreCase("ImageName") || temp.equalsIgnoreCase("Wavelengths");
        }
        return false;
    }

    private String setFlag(String[] tuple, int sat, int indx) {
        float fSat;
        float fPix;
        float test;
        String f = new String("");
        int flagInt = Integer.parseInt(tuple[indx]);
        f = flagInt < 0 ? "X" : ((test = (fPix = Float.parseFloat(tuple[this.fPixAddr])) * (1.0f - (fSat = Float.parseFloat(tuple[sat])))) < 10.0f ? "A" : (test >= 10.0f || test < 50.0f ? "B" : "C"));
        return f;
    }
}

