/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.converter.ConvertPanel;
import org.tigr.microarray.converter.ExpressConverter;
import org.tigr.util.LongTextChanger;
import org.tigr.util.io.IOUtil;

public class ImaGenePanel
extends ConvertPanel
implements ItemListener,
MouseListener,
ActionListener {
    private Icon upIcon;
    private Icon downIcon;
    private Icon leftIcon;
    private Icon rightIcon;
    private JPanel genePanel;
    private JPanel ch1FilePL;
    private JPanel ch2FilePL;
    private JPanel tavPanel;
    private JPanel pairButtonPL;
    private JList ch1FileList;
    private JList ch2FileList;
    private JList outputFileList;
    private JButton upBtn;
    private JButton downBtn;
    private JButton leftBtn;
    private JButton rightBtn;
    private JCheckBox keepAllCB;
    private JCheckBox ch1CB;
    private JCheckBox ch2CB;
    private JLabel fileNumLB;
    private JLabel igFileLB;
    private JLabel outputFileLB;
    private JLabel ch1FileLB;
    private JLabel ch2FileLB;
    private JScrollPane inputFilesSP;
    private JScrollPane tFilesSP;
    private JScrollPane ch1FileSP;
    private JScrollPane ch2FileSP;
    private JSplitPane fileSplitPane;
    private JSplitPane inputSplitPane;
    private ButtonGroup btnGroup;
    private String[] gfType = new String[]{"txt"};
    private long curTime;
    private boolean dirtyData = false;
    private boolean keepAll = false;
    private boolean ch1Selected = true;
    private Vector selectedCh1Files = new Vector(10, 3);
    private Vector selectedCh2Files = new Vector(10, 3);
    private final String NUM_FILE = "  Number of Files:  ";

    public ImaGenePanel() {
        this((ExpressConverter)null);
    }

    public ImaGenePanel(ExpressConverter ec) {
        super(ec);
        this.createGUI();
        this.adjustInputSelection(this.ch1Selected);
    }

    private void adjustInputSelection(boolean ch1) {
        this.rightBtn.setEnabled(ch1);
        this.leftBtn.setEnabled(!ch1);
    }

    public void editDirectory(String path) {
        int selected = -1;
        String tempPath = path;
        selected = this.outputFileList.getSelectedIndex();
        int num = this.outputFileNames.size();
        int i = 0;
        while (i < num) {
            String tempName = (String)this.outputFileNames.elementAt(i);
            tempName = IOUtil.extractFileNameFromPath(tempName);
            tempName = tempPath + "\\" + tempName;
            this.outputFileNames.setElementAt(tempName, i);
            ++i;
        }
        this.outputFileList.setListData(this.outputFileNames);
        if (selected >= 0) {
            this.outputFileList.setSelectedIndex(selected);
        } else {
            this.outputFileList.setSelectedIndex(0);
        }
    }

    public void editFileName() {
        int selected = -1;
        selected = this.outputFileList.getSelectedIndex();
        if (selected >= 0) {
            String tempName = (String)this.outputFileList.getModel().getElementAt(selected);
            LongTextChanger changer = new LongTextChanger(null, true, tempName);
            changer.show();
            if (changer.isTextChanged()) {
                tempName = changer.getText();
                StringTokenizer token = new StringTokenizer(tempName, ":");
                if (token.countTokens() <= 1) {
                    tempName = "c:\\" + tempName;
                }
                tempName = (tempName = IOUtil.dropExtension(tempName)).lastIndexOf(46) == tempName.length() - 1 ? tempName + this.FILE_TYPE[this.outputType] : tempName + "." + this.FILE_TYPE[this.outputType];
                this.outputFileNames.setElementAt(tempName, selected);
                this.outputFileList.setListData(this.outputFileNames);
                this.outputFileList.setSelectedIndex(selected);
            }
        }
    }

    public void adjustGUI(int index) {
        String tmpName = new String("");
        this.outputType = index;
        if (this.outputType == 0) {
            this.outputFileLB.setText("TAV Files:");
            this.keepAllCB.setEnabled(true);
            this.activeIntensityWay(false);
        } else {
            this.outputFileLB.setText("MEV Files:");
            this.keepAllCB.setEnabled(false);
            this.activeIntensityWay(true);
        }
        int numFiles = this.outputFileNames.size();
        int i = 0;
        while (i < numFiles) {
            tmpName = (String)this.outputFileNames.elementAt(i);
            tmpName = IOUtil.dropExtension(tmpName);
            tmpName = tmpName + "." + this.FILE_TYPE[this.outputType];
            this.outputFileNames.setElementAt(tmpName, i);
            ++i;
        }
        this.validate();
    }

    public void changeFileList(Vector in1Files, Vector in2Files, Vector outFiles) {
        this.selectedCh1Files = in1Files;
        this.selectedCh2Files = in2Files;
        this.ch1FileList.setListData(this.selectedCh1Files);
        this.ch2FileList.setListData(this.selectedCh2Files);
        this.outputFileList.setListData(this.outputFileNames);
        this.fileNumLB.setText("  Number of Files:  " + this.selectedCh1Files.size());
    }

    protected void createGUI() {
        Dimension btnSize = new Dimension(20, 20);
        BevelBorder high = new BevelBorder(0);
        BevelBorder low = new BevelBorder(1);
        int sizeX = (int)((double)ExpressConverter.scrWidth * 0.85);
        int sizeY = (int)((double)ExpressConverter.scrHeight * 0.85);
        this.setLayout(new GridBagLayout());
        this.upIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/uparow.gif")));
        this.downIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/downarow.gif")));
        this.leftIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/leftarow.gif")));
        this.rightIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("images/rightarow.gif")));
        this.genePanel = new JPanel(new GridBagLayout());
        this.ch1FilePL = new JPanel(new GridBagLayout());
        this.ch2FilePL = new JPanel(new GridBagLayout());
        this.pairButtonPL = new JPanel(new GridBagLayout());
        this.igFileLB = new JLabel("ImaGene Files:");
        this.outputFileLB = new JLabel("MEV Files:");
        this.ch1FileLB = new JLabel("Channel A:");
        this.ch2FileLB = new JLabel("Channel B:");
        this.ch1CB = new JCheckBox();
        this.ch1CB.setBackground(Color.green);
        this.ch1CB.setBorder(low);
        this.ch1CB.setBorderPainted(false);
        this.ch1CB.setSelected(true);
        this.ch1CB.addItemListener(this);
        this.ch2CB = new JCheckBox();
        this.ch2CB.setBackground(Color.red);
        this.ch2CB.setBorder(low);
        this.ch2CB.setBorderPainted(false);
        this.ch2CB.addItemListener(this);
        this.btnGroup = new ButtonGroup();
        this.btnGroup.add(this.ch1CB);
        this.btnGroup.add(this.ch2CB);
        this.ch1FileList = new JList();
        this.ch1FileList.setBorder(low);
        this.ch1FileList.addMouseListener(this);
        this.handleList(this.ch1FileList);
        this.ch1FileSP = new JScrollPane(this.ch1FileList);
        this.ch1FileSP.setVerticalScrollBarPolicy(21);
        this.ch2FileList = new JList();
        this.ch2FileList.setBorder(low);
        this.ch2FileList.addMouseListener(this);
        this.handleList(this.ch2FileList);
        this.ch2FileSP = new JScrollPane(this.ch2FileList);
        this.ch2FileSP.setVerticalScrollBarPolicy(21);
        this.inputSplitPane = new JSplitPane(1, true, this.ch1FilePL, this.ch2FilePL);
        this.inputSplitPane.setSize(sizeX - 20, sizeY - 100 >> 1);
        this.inputSplitPane.setDividerSize(4);
        this.inputSplitPane.setDividerLocation(0.5);
        this.inputFilesSP = new JScrollPane(this.inputSplitPane);
        this.upBtn = new JButton(this.upIcon);
        this.upBtn.setToolTipText("Move up the selected file by one line.");
        this.upBtn.setBorder(high);
        this.upBtn.setPreferredSize(btnSize);
        this.upBtn.setMaximumSize(btnSize);
        this.upBtn.setMinimumSize(btnSize);
        this.upBtn.addActionListener(this);
        this.downBtn = new JButton(this.downIcon);
        this.downBtn.setToolTipText("Move down the selected file by one line.");
        this.downBtn.setBorder(high);
        this.downBtn.setPreferredSize(btnSize);
        this.downBtn.setMaximumSize(btnSize);
        this.downBtn.setMinimumSize(btnSize);
        this.downBtn.addActionListener(this);
        this.leftBtn = new JButton(this.leftIcon);
        this.leftBtn.setToolTipText("Move the selected file to the left list.");
        this.leftBtn.setBorder(high);
        this.leftBtn.setPreferredSize(btnSize);
        this.leftBtn.setMaximumSize(btnSize);
        this.leftBtn.setMinimumSize(btnSize);
        this.leftBtn.addActionListener(this);
        this.rightBtn = new JButton(this.rightIcon);
        this.rightBtn.setToolTipText("Move the selected file to the right list.");
        this.rightBtn.setBorder(high);
        this.rightBtn.setPreferredSize(btnSize);
        this.rightBtn.setMaximumSize(btnSize);
        this.rightBtn.setMinimumSize(btnSize);
        this.rightBtn.addActionListener(this);
        this.keepAllCB = new JCheckBox("Keep Gene ID for Manually Checking.");
        this.keepAllCB.setToolTipText("Attach the gene id at the end of each spot.");
        this.keepAllCB.setSelected(this.keepAll);
        this.keepAllCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ce) {
                if (ImaGenePanel.this.keepAllCB.isSelected()) {
                    ImaGenePanel.this.keepAll = true;
                } else {
                    ImaGenePanel.this.keepAll = false;
                }
            }
        });
        this.tavPanel = new JPanel();
        this.tavPanel.setLayout(new GridBagLayout());
        this.tavPanel.setPreferredSize(new Dimension(sizeX - 10, sizeY - 120 >> 1));
        this.outputFileList = new JList();
        this.outputFileList.setBorder(low);
        this.outputFileList.setSelectionMode(0);
        this.handleList(this.outputFileList);
        this.fileNumLB = new JLabel("  Number of Files:  ");
        this.fileNumLB.setBorder(low);
        this.tFilesSP = new JScrollPane(this.outputFileList);
        this.fileSplitPane = new JSplitPane(0, true, this.genePanel, this.tavPanel);
        this.fileSplitPane.setDividerSize(4);
        this.fileSplitPane.setSize(sizeX - 10, sizeY >> 1);
        this.fileSplitPane.setPreferredSize(new Dimension(sizeX - 10, sizeY - 130 >> 1));
        this.fileSplitPane.setDividerLocation(0.5);
        this.gba.add(this, this.fileSplitPane, 0, 0, 2, 1, 1, 1, 1, 10, 5, 5, 10, 5);
        this.gba.add(this, this.sortCB, 0, 1, 1, 1, 1, 0, 2, 10, 10, 15, 3, 5);
        this.gba.add(this, this.keepAllCB, 0, 2, 1, 1, 1, 0, 2, 10, 3, 15, 3, 5);
        this.gba.add(this, this.gIntenPanel, 1, 1, 1, 2, 1, 0, 2, 17, 10, 0, 3, 5);
        this.gba.add(this.ch1FilePL, this.igFileLB, 0, 0, 1, 1, 1, 0, 2, 10, 5, 10, 5, 2);
        this.gba.add(this.ch1FilePL, this.ch1FileLB, 1, 0, 1, 1, 0, 0, 0, 13, 5, 10, 5, 2);
        this.gba.add(this.ch1FilePL, this.ch1CB, 2, 0, 1, 1, 0, 0, 0, 13, 5, 1, 5, 5);
        this.gba.add(this.ch1FilePL, this.ch1FileSP, 0, 1, 3, 1, 1, 1, 1, 10, 5, 2, 5, 0);
        this.gba.add(this.ch2FilePL, new JLabel(" "), 0, 0, 1, 1, 1, 0, 2, 10, 5, 10, 5, 2);
        this.gba.add(this.ch2FilePL, this.ch2FileLB, 1, 0, 1, 1, 0, 0, 0, 13, 5, 10, 5, 2);
        this.gba.add(this.ch2FilePL, this.ch2CB, 2, 0, 1, 1, 0, 0, 0, 13, 5, 1, 5, 5);
        this.gba.add(this.ch2FilePL, this.ch2FileSP, 0, 1, 3, 1, 1, 1, 1, 10, 5, 0, 5, 2);
        this.gba.add(this.genePanel, this.inputFilesSP, 0, 0, 1, 1, 1, 1, 1, 10, 1, 2, 1, 2);
        this.gba.add(this.genePanel, this.pairButtonPL, 0, 1, 1, 1, 1, 0, 2, 10, 3, 2, 5, 2);
        this.gba.add(this.pairButtonPL, this.upBtn, 0, 0, 1, 1, 0, 0, 0, 10, 1, 10, 1, 5);
        this.gba.add(this.pairButtonPL, this.downBtn, 1, 0, 1, 1, 0, 0, 0, 10, 1, 5, 1, 5);
        this.gba.add(this.pairButtonPL, this.leftBtn, 2, 0, 1, 1, 0, 0, 0, 10, 1, 5, 1, 5);
        this.gba.add(this.pairButtonPL, this.rightBtn, 3, 0, 1, 1, 0, 0, 0, 10, 1, 5, 1, 10);
        this.gba.add(this.tavPanel, this.outputFileLB, 0, 0, 1, 1, 1, 0, 2, 17, 5, 10, 2, 2);
        this.gba.add(this.tavPanel, this.tFilesSP, 0, 1, 1, 1, 1, 1, 1, 10, 1, 2, 5, 2);
        this.gba.add(this.tavPanel, this.fileNumLB, 0, 2, 1, 1, 1, 0, 2, 10, 1, 2, 5, 2);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.upBtn) {
            this.moveWithinList(true);
        } else if (ae.getSource() == this.downBtn) {
            this.moveWithinList(false);
        } else if (ae.getSource() == this.leftBtn || ae.getSource() == this.rightBtn) {
            this.moveBetweenLists();
        }
    }

    private void handleList(JList l) {
        JList list = l;
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                ImaGenePanel.this.setOuputSituation();
            }
        });
    }

    private void setOuputSituation() {
        int numCh1 = this.ch1FileList.getModel().getSize();
        int numCh2 = this.ch2FileList.getModel().getSize();
        int numOut = this.outputFileList.getModel().getSize();
        this.dirtyData = numOut > 0 || numCh1 > 0 || numCh2 > 0;
        this.outputReady = numOut > 0 && numCh1 == numCh2;
        this.parent.activateButton(this.outputReady, this.dirtyData);
    }

    private void moveBetweenLists() {
        String tempName = new String("");
        String tempOut = new String("");
        int indx = 0;
        if (this.ch1Selected && this.selectedCh1Files.size() > 0) {
            indx = this.ch1FileList.getSelectedIndex();
            if (indx >= 0) {
                tempName = (String)this.selectedCh1Files.remove(indx);
                tempOut = (String)this.outputFileNames.remove(indx);
                if (!this.selectedCh2Files.contains(tempName)) {
                    if (indx < this.selectedCh2Files.size()) {
                        this.selectedCh2Files.insertElementAt(tempName, indx);
                    } else {
                        this.selectedCh2Files.add(tempName);
                    }
                    this.ch2FileList.setListData(this.selectedCh2Files);
                }
                this.ch1FileList.setListData(this.selectedCh1Files);
                this.ch1FileList.setSelectedIndex(indx);
                this.outputFileList.setListData(this.outputFileNames);
                this.ch2FileList.setSelectedIndex(this.ch1FileList.getSelectedIndex());
            }
        } else if (!this.ch1Selected && this.selectedCh2Files.size() > 0 && (indx = this.ch2FileList.getSelectedIndex()) >= 0) {
            tempName = (String)this.selectedCh2Files.remove(indx);
            if (!this.selectedCh1Files.contains(tempName)) {
                if (indx < this.selectedCh1Files.size()) {
                    this.selectedCh1Files.insertElementAt(tempName, indx);
                    this.outputFileNames.insertElementAt(IOUtil.dropExtension(tempName) + "." + this.FILE_TYPE[this.outputType], indx);
                } else {
                    this.selectedCh1Files.add(tempName);
                    this.outputFileNames.add(IOUtil.dropExtension(tempName) + "." + this.FILE_TYPE[this.outputType]);
                }
                this.ch1FileList.setListData(this.selectedCh1Files);
            }
            this.ch2FileList.setListData(this.selectedCh2Files);
            this.ch2FileList.setSelectedIndex(indx);
            this.outputFileList.setListData(this.outputFileNames);
            this.ch1FileList.setSelectedIndex(this.ch2FileList.getSelectedIndex());
        }
        if (this.outputFileNames.size() > 0) {
            this.outputFileList.setSelectedIndex(0);
            this.fileNumLB.setText("  Number of Files:  " + this.selectedCh1Files.size());
        } else {
            this.fileNumLB.setText("  Number of Files:  ");
        }
    }

    private void moveWithinList(boolean up) {
        String tempName = new String("");
        String tempOut = new String("");
        int indx = 0;
        if (this.ch1Selected && this.selectedCh1Files.size() > 0) {
            indx = this.ch1FileList.getSelectedIndex();
            if (up) {
                if (indx > 0) {
                    tempName = (String)this.selectedCh1Files.remove(indx);
                    tempOut = (String)this.outputFileNames.remove(indx);
                    this.selectedCh1Files.insertElementAt(tempName, indx - 1);
                    this.outputFileNames.insertElementAt(tempOut, indx - 1);
                    this.ch1FileList.setListData(this.selectedCh1Files);
                    this.ch1FileList.setSelectedIndex(indx - 1);
                    this.outputFileList.setListData(this.outputFileNames);
                }
            } else if (indx < this.selectedCh1Files.size() - 1) {
                tempName = (String)this.selectedCh1Files.remove(indx);
                tempOut = (String)this.outputFileNames.remove(indx);
                this.selectedCh1Files.insertElementAt(tempName, indx + 1);
                this.outputFileNames.insertElementAt(tempOut, indx + 1);
                this.ch1FileList.setListData(this.selectedCh1Files);
                this.ch1FileList.setSelectedIndex(indx + 1);
                this.outputFileList.setListData(this.outputFileNames);
            }
            this.ch2FileList.setSelectedIndex(this.ch1FileList.getSelectedIndex());
        } else if (this.selectedCh2Files.size() > 0) {
            indx = this.ch2FileList.getSelectedIndex();
            if (up) {
                if (indx > 0) {
                    tempName = (String)this.selectedCh2Files.remove(indx);
                    this.selectedCh2Files.insertElementAt(tempName, indx - 1);
                    this.ch2FileList.setListData(this.selectedCh2Files);
                    this.ch2FileList.setSelectedIndex(indx - 1);
                }
            } else if (indx < this.selectedCh2Files.size() - 1) {
                tempName = (String)this.selectedCh2Files.remove(indx);
                this.selectedCh2Files.insertElementAt(tempName, indx + 1);
                this.ch2FileList.setListData(this.selectedCh2Files);
                this.ch2FileList.setSelectedIndex(indx + 1);
            }
            this.ch1FileList.setSelectedIndex(this.ch2FileList.getSelectedIndex());
        }
        if (this.outputFileNames.size() > 0) {
            this.outputFileList.setSelectedIndex(0);
        }
    }

    public void removeFileFromList() {
        int[] addrs;
        if (this.selectedCh1Files.size() > 0 && (addrs = this.ch1FileList.getSelectedIndices()).length > 0) {
            int i = 0;
            while (i < addrs.length) {
                this.selectedCh1Files.remove(addrs[i]);
                this.outputFileNames.remove(addrs[i]);
                if (addrs[i] < this.selectedCh2Files.size()) {
                    this.selectedCh2Files.remove(addrs[i]);
                }
                ++i;
            }
            this.ch1FileList.setListData(this.selectedCh1Files);
            this.ch2FileList.setListData(this.selectedCh2Files);
            this.outputFileList.setListData(this.outputFileNames);
            if (this.outputFileNames.size() > 0) {
                this.outputFileList.setSelectedIndex(0);
                this.fileNumLB.setText("  Number of Files:  " + this.selectedCh1Files.size());
            } else {
                this.fileNumLB.setText("  Number of Files:  ");
            }
        }
    }

    public void reset() {
        this.selectedCh1Files.removeAllElements();
        this.selectedCh2Files.removeAllElements();
        this.outputFileNames.removeAllElements();
        this.fileNumLB.setText("  Number of Files:  ");
        this.ch1FileList.setListData(this.selectedCh1Files);
        this.ch2FileList.setListData(this.selectedCh2Files);
        this.outputFileList.setListData(this.outputFileNames);
        this.wantSort = true;
        this.keepAll = false;
        this.ch1Selected = true;
        this.outputReady = false;
        this.dirtyData = false;
        this.sortCB.setSelected(this.wantSort);
        this.keepAllCB.setSelected(this.keepAll);
        this.ch1CB.setSelected(this.ch1Selected);
        this.parent.activateButton(this.outputReady, this.dirtyData);
    }

    public Vector getOutputFileNames() {
        return this.outputFileNames;
    }

    public Vector getSelectedChAFiles() {
        return this.selectedCh1Files;
    }

    public Vector getSelectedChBFiles() {
        return this.selectedCh2Files;
    }

    public boolean isOutputReady() {
        return this.outputReady;
    }

    public boolean isDataDirty() {
        return this.dirtyData;
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.ch1CB && ie.getStateChange() == 1) {
            this.ch1Selected = true;
        } else if (ie.getSource() == this.ch2CB && ie.getStateChange() == 1) {
            this.ch1Selected = false;
        }
        this.adjustInputSelection(this.ch1Selected);
    }

    public void mouseClicked(MouseEvent me) {
        if (me.getSource() == this.ch1FileList) {
            this.ch2FileList.setSelectedIndex(this.ch1FileList.getSelectedIndex());
        } else {
            this.ch1FileList.setSelectedIndex(this.ch2FileList.getSelectedIndex());
        }
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void setSelectedFiles(String[] newFiles) {
        String temp = new String("");
        int num = newFiles.length;
        if (this.ch1Selected) {
            int i = 0;
            while (i < num) {
                if (!this.selectedCh1Files.contains(newFiles[i])) {
                    this.selectedCh1Files.add(newFiles[i]);
                    this.outputFileNames.add(IOUtil.dropExtension(newFiles[i]) + "." + this.FILE_TYPE[this.outputType]);
                }
                ++i;
            }
            this.ch1FileList.setListData(this.selectedCh1Files);
            this.outputFileList.setListData(this.outputFileNames);
            this.outputFileList.setSelectedIndex(0);
            this.fileNumLB.setText("  Number of Files:  " + this.selectedCh1Files.size());
        } else {
            int i = 0;
            while (i < num) {
                if (!this.selectedCh2Files.contains(newFiles[i])) {
                    this.selectedCh2Files.add(newFiles[i]);
                }
                ++i;
            }
            this.ch2FileList.setListData(this.selectedCh2Files);
        }
    }

    public boolean needGeneID() {
        return this.keepAll;
    }

    private int validFile(String fName, boolean needTest) {
        String name = new String(fName);
        String folder = new String("");
        int confirm = 1;
        JFrame jf = new JFrame();
        File targFile = null;
        folder = IOUtil.extractPath(name);
        folder = IOUtil.makeDir(folder);
        if (needTest) {
            targFile = new File(name);
            if (targFile.exists()) {
                jf.getToolkit().beep();
            }
        } else {
            confirm = 2;
        }
        return confirm;
    }
}

