/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.microarray.converter.Converter;
import org.tigr.util.FileReading;

public class TavConverter
extends Converter {
    private String bgChA;
    private String bgChB;
    private String bgChAn;
    private String bgChBn;
    private String bgChAmean;
    private String bgChAnMean;
    private String bgChBnMean;
    private String bgChBmean;
    private String chA;
    private String chAn;
    private String chB;
    private String chBn;
    private String chAMean;
    private String chAnMean;
    private String chBMean;
    private String chBnMean;
    private String chAMedian;
    private String chBMedian;
    private String chAnMedian;
    private String chBnMedian;
    private String chAs;
    private String chAsn;
    private String chBs;
    private String chBsn;
    private String gpFileName;
    private int fPixAddr;
    private boolean keepAll;
    private boolean useMean;
    private boolean tavIntensity;
    private final int FIRST_NUM = 1;
    private final String FLAG = "\"Flags\"";
    private final String BLOCK = "\"Block\"";
    private final String COLUMN = "\"Column\"";
    private final String RW = "\"Row\"";
    private final String F_PIX = "\"F Pixels\"";
    private final String FLAG_N = "Flags";
    private final String BLOCK_N = "Block";
    private final String COLUMN_N = "Column";
    private final String ROW_N = "Row";
    private final String F_PIX_N = "F Pixels";
    private final String WAVE_KEY_1 = "ImageName";
    private final String WAVE_KEY_2 = "Wavelengths";

    public TavConverter(String gfName, String tfName) {
        this.inFileNames = new Vector(1);
        this.outFileNames = new Vector(1);
        this.inFileNames.add(gfName);
        this.outFileNames.add(tfName);
        this.msg = new String("");
        Converter.ready = false;
        this.wantSort = true;
        this.keepAll = true;
        Converter.fetalError = false;
        Converter.minorError = false;
        this.useMean = true;
        this.tavIntensity = true;
    }

    public TavConverter(Vector gfNames, Vector tfNames) {
        this.inFileNames = gfNames;
        this.outFileNames = tfNames;
        this.msg = new String("");
        Converter.ready = false;
        this.wantSort = true;
        this.keepAll = true;
        Converter.fetalError = false;
        Converter.minorError = false;
        this.useMean = true;
        this.tavIntensity = true;
    }

    public int getTaskEnd() {
        return this.taskEnd;
    }

    public int getCurrent() {
        return this.counter;
    }

    public String getErrorMsg() {
        return this.msg;
    }

    public String getFileName() {
        return this.gpFileName;
    }

    public void useMeanForIntensity(boolean b) {
        this.useMean = b;
    }

    public void run() {
        String aLine = new String("");
        String densA = new String("");
        String densB = new String("");
        String tavLine = new String("");
        String flagA = new String("");
        String flagB = new String("");
        String bgA = new String("");
        String bgB = new String("");
        String extraInfo = new String("");
        String[] waves = new String[2];
        int max = 0;
        int maxRow = 0;
        int maxCol = 0;
        BufferedWriter bufWriter = null;
        FileOutputStream fileOut = null;
        this.taskEnd = this.determineTaskEnd();
        if (this.taskEnd == 1) {
            return;
        }
        this.taskEnd <<= 1;
        this.counter = 0;
        int numOfFiles = this.inFileNames.size();
        int i = 0;
        while (i < numOfFiles) {
            Vector genepixFile;
            String tavFileName;
            boolean noError;
            block26: {
                noError = true;
                this.gpFileName = (String)this.inFileNames.elementAt(i);
                tavFileName = (String)this.outFileNames.elementAt(i);
                try {
                    FileReading fileReader = new FileReading(this.gpFileName);
                    if (fileReader.done) {
                        genepixFile = fileReader.getFileContentInLines();
                        break block26;
                    }
                    this.setErrorMessage(fileReader.getProcessMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
                catch (IOException e) {
                    this.setErrorMessage(e.getMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
            }
            int fSize = genepixFile.size();
            int hLines = 0;
            boolean going = true;
            while (going) {
                aLine = (String)genepixFile.elementAt(hLines);
                if (aLine.charAt(0) == '\"' || this.isChar(aLine.charAt(0))) {
                    if (this.isWaveLengthDefination(aLine)) {
                        waves = this.getWaveLengths(aLine);
                    }
                    going = true;
                    ++hLines;
                    continue;
                }
                if (hLines == 1) {
                    going = true;
                    ++hLines;
                    continue;
                }
                going = false;
            }
            this.defineKeys(waves);
            aLine = (String)genepixFile.elementAt(hLines - 1);
            String[] colNames = this.separateLine(aLine);
            int blockIndex = this.findRightCol(colNames, "\"Block\"", "Block");
            int colIndex = this.findRightCol(colNames, "\"Column\"", "Column");
            int rowIndex = this.findRightCol(colNames, "\"Row\"", "Row");
            aLine = (String)genepixFile.elementAt(fSize - 1);
            String[] colValues = this.separateLine(aLine);
            if (colValues.length > 2) {
                max = Integer.parseInt(colValues[blockIndex]);
                maxCol = Integer.parseInt(colValues[colIndex]);
                maxRow = Integer.parseInt(colValues[rowIndex]);
            } else {
                JOptionPane.showMessageDialog(null, "You might add extra space at the end of file.\n(" + this.gpFileName + "). \nPlease remove it and try again. Converting will continue " + "\nfor remaining files", "GenePix-Tav Converter", 0);
                noError = false;
                this.counter += numOfFiles;
            }
            if (noError) {
                int maxMetaCol = max <= 12 ? 2 : 4;
                noError = true;
                if (max * maxCol * maxRow + hLines != genepixFile.size()) {
                    JOptionPane.showMessageDialog(null, "You might have dropped some of your spots in the file \n(" + this.gpFileName + ".\nThe converter requires an original GenePix file." + "\nConverting will continue for the remaining files", "GenePix-Tav Converter", 0);
                    noError = false;
                    this.counter += numOfFiles;
                }
                if (noError) {
                    int flagIndex = this.findRightCol(colNames, "\"Flags\"", "Flags");
                    this.fPixAddr = this.findRightCol(colNames, "\"F Pixels\"", "F Pixels");
                    int f635m = this.findRightCol(colNames, this.chA, this.chAn);
                    int f635s = this.findRightCol(colNames, this.chAs, this.chAsn);
                    int fCh1Mean = this.findRightCol(colNames, this.chAMean, this.chAnMean);
                    int fCh1Median = this.findRightCol(colNames, this.chAMedian, this.chAnMedian);
                    int b635m = this.findRightCol(colNames, this.bgChA, this.bgChAn);
                    int bgCh1Mean = this.findRightCol(colNames, this.bgChAmean, this.bgChAnMean);
                    int f532m = this.findRightCol(colNames, this.chB, this.chBn);
                    int f532s = this.findRightCol(colNames, this.chBs, this.chBsn);
                    int fCh2Mean = this.findRightCol(colNames, this.chBMean, this.chBnMean);
                    int fCh2Median = this.findRightCol(colNames, this.chBMedian, this.chBnMedian);
                    int b532m = this.findRightCol(colNames, this.bgChB, this.bgChBn);
                    int bgCh2Mean = this.findRightCol(colNames, this.bgChBmean, this.bgChBnMean);
                    try {
                        fileOut = new FileOutputStream(tavFileName);
                        bufWriter = new BufferedWriter(new OutputStreamWriter(fileOut));
                        this.sortKeys = new int[3][fSize - hLines];
                        this.outFile = new String[fSize - hLines];
                        this.counter += hLines;
                        int j = hLines;
                        int k = 0;
                        while (j < fSize) {
                            aLine = (String)genepixFile.elementAt(j);
                            colValues = this.separateLine(aLine);
                            int block = Integer.parseInt(colValues[blockIndex]);
                            int col = Integer.parseInt(colValues[colIndex]);
                            int row = Integer.parseInt(colValues[rowIndex]);
                            int spAreaA = this.calculateSpotDimeter(colValues, f532s);
                            int spAreaB = this.calculateSpotDimeter(colValues, f635s);
                            if (this.tavIntensity) {
                                bgA = this.calculateBackground(colValues, b532m);
                                bgB = this.calculateBackground(colValues, b635m);
                                densA = this.calculateDensity(colValues, f532m, f532s, b532m);
                                densB = this.calculateDensity(colValues, f635m, f635s, b635m);
                            } else if (this.useMean) {
                                bgA = colValues[bgCh2Mean];
                                bgB = colValues[bgCh1Mean];
                                densA = colValues[fCh2Mean];
                                densB = colValues[fCh1Mean];
                            } else {
                                bgA = colValues[b532m];
                                bgB = colValues[b635m];
                                densA = colValues[fCh2Median];
                                densB = colValues[fCh1Median];
                            }
                            flagA = this.setFlag(colValues, f532s, flagIndex);
                            flagB = this.setFlag(colValues, f635s, flagIndex);
                            int metaRow = (block - 1) / maxMetaCol + 1;
                            int metaCol = (block - 1) % maxMetaCol + 1;
                            int slideRow = (metaRow - 1) * maxRow + row;
                            int slideCol = (metaCol - 1) * maxCol + col;
                            tavLine = slideRow + "\t" + slideCol + "\t" + metaRow + "\t" + metaCol + "\t" + row + "\t" + col + "\t" + densA + "\t" + densB + "\t" + spAreaA + "\t" + spAreaB + "\tnull\tnull\tnull\t" + bgA + "\t" + bgB + "\t" + flagA + "\t" + flagB;
                            if (this.keepAll) {
                                extraInfo = this.setAnnotaionInfo(colValues, flagIndex);
                                tavLine = tavLine + extraInfo.toString();
                            }
                            this.outFile[k] = new String(tavLine);
                            this.sortKeys[0][k] = k;
                            this.sortKeys[1][k] = slideRow;
                            this.sortKeys[2][k] = slideCol;
                            ++this.counter;
                            ++j;
                            ++k;
                        }
                        if (this.wantSort) {
                            this.sorted = this.sortRowCol(maxMetaCol, maxCol);
                            j = 0;
                            while (j < this.outFile.length) {
                                bufWriter.write(this.outFile[this.sorted[j]]);
                                bufWriter.newLine();
                                bufWriter.flush();
                                ++this.counter;
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < this.outFile.length) {
                                bufWriter.write(this.outFile[j]);
                                bufWriter.newLine();
                                bufWriter.flush();
                                ++this.counter;
                                ++j;
                            }
                        }
                        fileOut.close();
                    }
                    catch (IOException ie) {
                        Converter.fetalError = true;
                        System.out.println("Error in writing file: " + ie.getMessage());
                        this.msg = this.msg + "**********\n";
                        this.msg = this.msg + "Error in writing file: " + ie.getMessage() + "\n";
                    }
                }
            }
            ++i;
        }
        Converter.ready = true;
        this.counter = this.taskEnd;
    }

    public void setSortSpots(boolean b) {
        this.wantSort = b;
    }

    public void setKeepAllInformation(boolean b) {
        this.keepAll = b;
    }

    private String calculateBackground(String[] tuple, int backg) {
        String bg = new String("");
        try {
            float fPix = Float.parseFloat(tuple[this.fPixAddr]);
            float bMedian = Float.parseFloat(tuple[backg]);
            int temp = (int)(bMedian * fPix);
            bg = bg + temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            bg = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value for either F Pixcel or B Median;\n";
            this.msg = this.msg + "and the intensity was set to null.\n";
        }
        return bg;
    }

    private int calculateSpotDimeter(String[] tuple, int sat) {
        float fPix = Float.parseFloat(tuple[this.fPixAddr]);
        float fSat = Float.parseFloat(tuple[sat]);
        int temp = (int)(fPix * (1.0f - (fSat /= 100.0f)));
        return temp;
    }

    private String calculateDensity(String[] tuple, int med, int sat, int backg) {
        String den = new String("");
        try {
            float fMedian = Float.parseFloat(tuple[med]);
            float bMedian = Float.parseFloat(tuple[backg]);
            float fPix = Float.parseFloat(tuple[this.fPixAddr]);
            float fSat = Float.parseFloat(tuple[sat]);
            int temp = (int)(fPix * (fMedian - bMedian) * (1.0f - (fSat /= 100.0f)));
            den = den + temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            den = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate intensity; and the intensity was set to null.\n";
        }
        return den;
    }

    private String[] getWaveLengths(String str) {
        String[] tempWave = new String[2];
        String wavStr = new String(str.substring(str.indexOf(61) + 1, str.lastIndexOf(34)));
        StringTokenizer token = new StringTokenizer(wavStr);
        int num = 0;
        while (token.hasMoreTokens()) {
            String wv = token.nextToken();
            if (!this.isNumber(wv)) continue;
            tempWave[num] = new String(wv);
            ++num;
        }
        return tempWave;
    }

    private void defineKeys(String[] wvs) {
        this.chA = new String("\"F" + wvs[0] + " Median\"");
        this.chB = new String("\"F" + wvs[1] + " Median\"");
        this.chAMean = new String("\"F" + wvs[0] + " Mean - B" + wvs[0] + "\"");
        this.chBMean = new String("\"F" + wvs[1] + " Mean - B" + wvs[1] + "\"");
        this.chAMedian = new String("\"F" + wvs[0] + " Median - B" + wvs[0] + "\"");
        this.chBMedian = new String("\"F" + wvs[1] + " Median - B" + wvs[1] + "\"");
        this.chAs = new String("\"F" + wvs[0] + " % Sat.\"");
        this.chBs = new String("\"F" + wvs[1] + " % Sat.\"");
        this.bgChA = new String("\"B" + wvs[0] + " Median\"");
        this.bgChB = new String("\"B" + wvs[1] + " Median\"");
        this.bgChAmean = new String("\"B" + wvs[0] + " Mean\"");
        this.bgChBmean = new String("\"B" + wvs[1] + " Mean\"");
        this.chAn = new String("F" + wvs[0] + " Median");
        this.chBn = new String("F" + wvs[1] + " Median");
        this.chAnMean = new String("F" + wvs[0] + " Mean - B" + wvs[0]);
        this.chBnMean = new String("F" + wvs[1] + " Mean - B" + wvs[1]);
        this.chAnMedian = new String("F" + wvs[0] + " Median - B" + wvs[0]);
        this.chBnMedian = new String("F" + wvs[1] + " Median - B" + wvs[1]);
        this.chAsn = new String("F" + wvs[0] + " % Sat.");
        this.chBsn = new String("F" + wvs[1] + " % Sat.");
        this.bgChAn = new String("B" + wvs[0] + " Median");
        this.bgChBn = new String("B" + wvs[1] + " Median");
        this.bgChAnMean = new String("B" + wvs[0] + " Mean");
        this.bgChBnMean = new String("B" + wvs[1] + " Mean");
    }

    private int findRightCol(String[] str, String key, String noQuato) {
        int addr = 0;
        int size = str.length;
        String temp = new String("");
        int i = 0;
        while (i < str.length) {
            if (str[i].equalsIgnoreCase(key) || str[i].equalsIgnoreCase(noQuato)) {
                addr = i;
                i = str.length;
            }
            ++i;
        }
        return addr;
    }

    private boolean isChar(char x) {
        boolean b = true;
        switch (x) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                b = false;
                break;
            }
            default: {
                b = true;
            }
        }
        return b;
    }

    private boolean isNumber(String x) {
        boolean b = true;
        int length = x.length();
        int i = 0;
        while (i < length) {
            if (this.isChar(x.charAt(i))) {
                b = false;
                i = length;
            }
            ++i;
        }
        return b;
    }

    private boolean isWaveLengthDefination(String str) {
        String temp = str;
        if (temp.charAt(0) == '\"' && temp.indexOf(61) > 0) {
            return (temp = temp.substring(1, temp.indexOf(61))).equalsIgnoreCase("ImageName") || temp.equalsIgnoreCase("Wavelengths");
        }
        return false;
    }

    private String setAnnotaionInfo(String[] val, int fAddr) {
        StringBuffer temp = new StringBuffer();
        int i = 3;
        while (i < val.length) {
            if (i != fAddr) {
                temp.append("\t" + val[i]);
            }
            ++i;
        }
        return temp.toString();
    }

    private String setFlag(String[] tuple, int sat, int indx) {
        float fSat;
        float fPix;
        float test;
        String f = new String("");
        int flagInt = Integer.parseInt(tuple[indx]);
        f = flagInt < 0 ? "X" : ((test = (fPix = Float.parseFloat(tuple[this.fPixAddr])) * (1.0f - (fSat = Float.parseFloat(tuple[sat])))) < 10.0f ? "A" : (test >= 10.0f || test < 50.0f ? "B" : "C"));
        return f;
    }
}

