/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.microarray.MevAttributes;
import org.tigr.microarray.converter.Converter;
import org.tigr.util.FileReading;
import org.tigr.util.MyTimer;
import org.tigr.util.io.IOUtil;

public class TavMev
extends Converter
implements MevAttributes {
    private String title;
    int gAnnType;

    public TavMev(Vector inNames, Vector mfNames, String barTitle, int annNum) {
        this.inFileNames = inNames;
        this.outFileNames = mfNames;
        this.title = barTitle;
        this.gAnnType = annNum;
    }

    public void run() {
        String aLine = new String("");
        String extraInfo = new String("");
        String[] annoFile = null;
        BufferedWriter mevWriter = null;
        BufferedWriter annoWriter = null;
        FileOutputStream mevFileOut = null;
        this.taskEnd = this.determineTaskEnd();
        if (this.taskEnd == 1) {
            return;
        }
        this.taskEnd <<= 1;
        this.counter = 0;
        int numOfFiles = this.inFileNames.size();
        int i = 0;
        while (i < numOfFiles) {
            Vector tavFile;
            String mevFileName;
            boolean noError;
            block33: {
                noError = true;
                this.inFileNamePath = (String)this.inFileNames.elementAt(i);
                mevFileName = (String)this.outFileNames.elementAt(i);
                try {
                    FileReading fileReader = new FileReading(this.inFileNamePath);
                    if (fileReader.done) {
                        tavFile = fileReader.getFileContentInLines();
                        break block33;
                    }
                    this.setErrorMessage(fileReader.getProcessMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
                catch (IOException e) {
                    this.setErrorMessage(e.getMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
            }
            int fSize = tavFile.size();
            aLine = (String)tavFile.elementAt(fSize - 1);
            String[] colValues = this.separateLine(aLine);
            if (colValues.length < 2) {
                JOptionPane.showMessageDialog(null, "You might add extra space at the end of file.\n(" + this.inFileNamePath + "). \nPlease remove it and try again. Converting will continue " + "\nfor remaining files", this.title + " -- Tav-Mev", 0);
                noError = false;
                this.counter += numOfFiles;
            }
            if (noError && !this.isOriginal(tavFile, colValues)) {
                JOptionPane.showMessageDialog(null, "You might have dropped some of your spots in the file \n(" + this.inFileNamePath + ".\nThe converter requires an file with all spots." + "\nConverting will continue for the remaining files", this.title + " -- Tav-Mev", 0);
                noError = false;
                this.counter += numOfFiles;
            }
            if (noError && !this.isTavFile(colValues)) {
                JOptionPane.showMessageDialog(null, "You might have added more columns into the file \n(" + this.inFileNamePath + ".\nThe converter requires an file with correct columns." + "\nConverting will continue for the remaining files", this.title + " -- Tav-Mev", 0);
                noError = false;
                this.counter += numOfFiles;
            }
            if (noError) {
                try {
                    String annoFileNamePath = IOUtil.dropExtension(mevFileName);
                    annoFileNamePath = annoFileNamePath + ".ann";
                    mevFileOut = new FileOutputStream(mevFileName);
                    mevWriter = new BufferedWriter(new OutputStreamWriter(mevFileOut));
                    this.sortKeys = new int[3][fSize];
                    this.outFile = new String[fSize];
                    String tavFileName = IOUtil.extractFileNameFromPath(this.inFileNamePath);
                    String[] mevFileHeader = this.generateHeader(tavFileName, fSize, colValues.length, 0);
                    int j = 0;
                    while (j < mevFileHeader.length) {
                        mevWriter.write(mevFileHeader[j]);
                        mevWriter.newLine();
                        mevWriter.flush();
                        ++j;
                    }
                    if (this.gAnnType == 1) {
                        annoFile = new String[fSize];
                        annoWriter = this.createAnnoWriter(annoFileNamePath, tavFileName, fSize, colValues);
                    } else if (i < 1) {
                        annoFile = new String[fSize];
                        annoWriter = this.createAnnoWriter(annoFileNamePath, tavFileName, fSize, colValues);
                    }
                    int unid = 1;
                    int maxMetaCol = Integer.parseInt(colValues[3]);
                    int maxCol = Integer.parseInt(colValues[5]);
                    j = 0;
                    int k = 0;
                    while (j < fSize) {
                        aLine = (String)tavFile.elementAt(j);
                        colValues = this.separateLine(aLine);
                        int slideRow = Integer.parseInt(colValues[0]);
                        int slideCol = Integer.parseInt(colValues[1]);
                        String mevLine = this.setMevLine(unid, colValues);
                        this.outFile[k] = new String(mevLine);
                        if (this.gAnnType == 1) {
                            extraInfo = this.setAnnoLine(unid, colValues);
                            annoFile[k] = new String(extraInfo);
                        } else if (i < 1) {
                            extraInfo = this.setAnnoLine(unid, colValues);
                            annoFile[k] = new String(extraInfo);
                        }
                        this.sortKeys[0][k] = k;
                        this.sortKeys[1][k] = slideRow;
                        this.sortKeys[2][k] = slideCol;
                        ++this.counter;
                        ++unid;
                        ++j;
                        ++k;
                    }
                    if (this.wantSort) {
                        this.sorted = this.sortRowCol(maxMetaCol, maxCol);
                        j = 0;
                        while (j < this.outFile.length) {
                            mevWriter.write(this.outFile[this.sorted[j]]);
                            mevWriter.newLine();
                            mevWriter.flush();
                            if (this.gAnnType == 1) {
                                annoWriter.write(annoFile[this.sorted[j]]);
                                annoWriter.newLine();
                                annoWriter.flush();
                            } else if (i < 1) {
                                annoWriter.write(annoFile[this.sorted[j]]);
                                annoWriter.newLine();
                                annoWriter.flush();
                            }
                            ++this.counter;
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < this.outFile.length) {
                            mevWriter.write(this.outFile[j]);
                            mevWriter.newLine();
                            mevWriter.flush();
                            if (this.gAnnType == 1) {
                                annoWriter.write(annoFile[j]);
                                annoWriter.newLine();
                                annoWriter.flush();
                            } else if (i < 1) {
                                annoWriter.write(annoFile[j]);
                                annoWriter.newLine();
                                annoWriter.flush();
                            }
                            ++this.counter;
                            ++j;
                        }
                    }
                    mevFileOut.close();
                    if (this.gAnnType == 1) {
                        annoWriter.close();
                    } else if (i < 1) {
                        annoWriter.close();
                    }
                }
                catch (IOException ie) {
                    Converter.fetalError = true;
                    Converter.ready = false;
                    System.out.println("Error in writing file: " + ie.getMessage());
                    this.msg = this.msg + "**********\n";
                    this.msg = this.msg + "Error in writing file: " + ie.getMessage() + "\n";
                    return;
                }
                catch (Exception e) {
                    Converter.fetalError = true;
                    Converter.ready = false;
                    this.msg = this.msg + "**********\n";
                    this.msg = this.msg + "Error: " + e.getMessage() + ". Please report the developer.\n";
                    return;
                }
            }
            ++i;
        }
        Converter.ready = true;
        this.counter = this.taskEnd;
    }

    private BufferedWriter createAnnoWriter(String fName, String inName, int numSpots, String[] cValues) {
        BufferedWriter out;
        try {
            FileOutputStream fOut = new FileOutputStream(fName);
            out = new BufferedWriter(new OutputStreamWriter(fOut));
            String[] annoFileHeader = this.generateHeader(inName, numSpots, cValues.length, 1);
            int i = 0;
            while (i < annoFileHeader.length) {
                out.write(annoFileHeader[i]);
                out.newLine();
                out.flush();
                ++i;
            }
        }
        catch (IOException ie) {
            Converter.fetalError = true;
            Converter.ready = false;
            System.out.println("Error in creating ann file: " + ie.getMessage());
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "Error in creating ann file: " + ie.getMessage() + "\n";
            return null;
        }
        return out;
    }

    private String[] generateHeader(String fName, int numRow, int numCol, int type) {
        String[] tempHeader = new String[6];
        int i = 0;
        while (i < tempHeader.length) {
            tempHeader[i] = new String("");
            ++i;
        }
        tempHeader[0] = new String("# version: V1.0");
        tempHeader[1] = new String("# date: " + MyTimer.getCurrentDate('.'));
        tempHeader[2] = new String("# created by: " + this.title);
        tempHeader[3] = new String("# row_count:" + numRow);
        tempHeader[4] = "# Converted from tav file: " + fName;
        if (type == 0) {
            switch (numCol) {
                case 8: {
                    tempHeader[5] = "UID\tIA\tIB\tR\tC\tMR\tMC\tSR\tSC";
                    break;
                }
                case 14: 
                case 17: {
                    tempHeader[5] = "UID\tIA\tIB\tR\tC\tMR\tMC\tSR\tSC\tBkgA\tBkgB\tFlagA\tFlagB\tSAA\tSAB";
                    break;
                }
                case 24: {
                    tempHeader[5] = "UID\tIA\tIB\tR\tC\tMR\tMC\tSR\tSC\tBkgA\tBkgB\tSA\tFlagA\tFlagB";
                    break;
                }
                default: {
                    this.msg = "**********\nConverter needs to know the definitions of each column.\nPlease contact the author to solve this problem.";
                    JOptionPane.showMessageDialog(null, this.msg, this.title + " -- Tav-Mev", 0);
                    Converter.fetalError = true;
                    break;
                }
            }
        } else {
            switch (numCol) {
                case 8: 
                case 14: 
                case 17: {
                    tempHeader[5] = "UID\tR\tC";
                    break;
                }
                case 24: {
                    tempHeader[5] = "UID\tR\tC\tPlateNum\tWellNum\tCloneN\tAMP\tGBNum\tTCNum\tRolGus\tCluster\tGeneN\tComN";
                }
            }
        }
        return tempHeader;
    }

    private boolean isOriginal(Vector inFile, String[] lastLine) {
        boolean noChange = true;
        int numSpot = inFile.size();
        int mr = 0;
        int mc = 0;
        int sr = 0;
        int sc = 0;
        try {
            mr = Integer.parseInt(lastLine[2]);
            mc = Integer.parseInt(lastLine[3]);
            sr = Integer.parseInt(lastLine[4]);
            sc = Integer.parseInt(lastLine[5]);
        }
        catch (NumberFormatException nfex) {
            noChange = false;
            return noChange;
        }
        if (mr * mc * sr * sc != numSpot) {
            noChange = false;
        }
        return noChange;
    }

    private boolean isTavFile(String[] oneLine) {
        boolean itIs;
        switch (oneLine.length) {
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 24: {
                itIs = true;
                break;
            }
            default: {
                itIs = false;
            }
        }
        return itIs;
    }

    private String setAnnoLine(int uid, String[] val) {
        String temp = new String("");
        switch (val.length) {
            case 14: 
            case 17: {
                temp = uid + "\t" + val[0] + "\t" + val[1];
                break;
            }
            case 24: {
                temp = val[23] + "\t" + val[0] + "\t" + val[1];
                int i = 13;
                while (i < val.length - 1) {
                    temp = temp + "\t" + val[i];
                    ++i;
                }
                break;
            }
        }
        return temp;
    }

    private String setMevLine(int uid, String[] val) {
        String temp = new String("");
        temp = val.length == 24 ? val[23] + "\t" + val[6] + "\t" + val[7] + "\t" : uid + "\t" + val[6] + "\t" + val[7] + "\t";
        int i = 0;
        while (i < 6) {
            temp = temp + val[i] + "\t";
            ++i;
        }
        switch (val.length) {
            case 14: {
                temp = temp + val[10] + "\t" + val[11] + "\t" + val[12] + "\t" + val[13] + "\t" + val[8] + "\t" + val[9];
                break;
            }
            case 17: {
                temp = temp + val[13] + "\t" + val[14] + "\t" + val[15] + "\t" + val[16] + "\t" + val[8] + "\t" + val[9];
                break;
            }
            case 24: {
                temp = temp + val[10] + "\t" + val[11] + "\t" + val[12] + "\t" + val[8] + "\t" + val[9];
            }
        }
        return temp;
    }
}

