/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;

public class FileReading {
    public static boolean success;
    public static final int OUT_AS_ARRAY = 1;
    public static final int OUT_AS_VECTOR = 2;
    public static final int OUT_AS_STRING_BUFFER = 3;
    public boolean done;
    private boolean useURL;
    private FileInputStream fileInput;
    private InputStream input;
    private String msg;
    private String fileName;
    private String[] fileContentArray;
    private StringBuffer fileContentSB;
    private URL fileURL;
    private BufferedReader buf;
    private Vector fileContent;
    private int outForm;
    int gNumLines;

    public FileReading(String fName) throws IOException {
        this(fName, 2);
    }

    public FileReading(URL fName) {
        success = false;
        this.fileURL = fName;
        this.useURL = true;
        this.msg = new String("");
        this.gNumLines = -1;
        try {
            if (this.openFile()) {
                this.fileContent = this.readFile();
                this.closeFile();
                success = true;
            }
        }
        catch (IOException e) {}
    }

    public FileReading(String fName, int outputFormat) throws IOException {
        this(fName, outputFormat, -1);
    }

    public FileReading(String fName, int outputFormat, int fSize) throws IOException {
        success = false;
        this.useURL = false;
        this.outForm = outputFormat;
        this.fileName = new String(fName);
        this.msg = new String("");
        this.gNumLines = fSize;
        if (this.openFile()) {
            switch (this.outForm) {
                case 1: {
                    this.fileContentArray = this.readFileToArray();
                    break;
                }
                case 2: {
                    this.fileContent = this.readFile();
                    break;
                }
                case 3: {
                    this.fileContentSB = this.readFileToStringBuffer();
                    break;
                }
                default: {
                    this.fileContent = this.readFile();
                }
            }
            this.closeFile();
            success = true;
        }
    }

    public String getProcessMessage() {
        return this.msg;
    }

    public Vector getFileContentInLines() {
        return this.fileContent;
    }

    public String[] getFileContentAsArray() {
        return this.fileContentArray;
    }

    public StringBuffer getFileContentAsStringBuffer() {
        return this.fileContentSB;
    }

    public int getFileSizeInLines() {
        return this.fileContent.size();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getOneLine(int x) {
        return (String)this.fileContent.elementAt(x);
    }

    public void closeFile() {
        try {
            this.buf.close();
        }
        catch (IOException e) {
            this.done = false;
            this.msg = "Failed to close the file(" + this.fileName + "): " + e;
        }
    }

    private boolean openFile() throws IOException {
        try {
            if (this.useURL) {
                this.input = this.fileURL.openStream();
                this.buf = new BufferedReader(new InputStreamReader(this.input));
            } else {
                this.fileInput = new FileInputStream(this.fileName);
                this.buf = new BufferedReader(new InputStreamReader(this.fileInput));
            }
        }
        catch (IOException e) {
            this.done = false;
            this.msg = this.useURL ? "Failed to open " + this.fileURL.toString() + ": " + e.getMessage() : "Failed to open " + this.fileName + ": " + e.getMessage();
            throw e;
        }
        this.done = true;
        return this.done;
    }

    private Vector readFile() {
        String aLine = new String("");
        Vector<String> temp = new Vector<String>(50, 10);
        try {
            if (this.gNumLines < 0) {
                while ((aLine = this.buf.readLine()) != null) {
                    temp.add(aLine);
                }
            } else {
                int i = 0;
                while (i < this.gNumLines) {
                    aLine = this.buf.readLine();
                    temp.add(aLine);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.done = false;
            this.msg = "Failed to read " + this.fileName + ": " + e.getMessage();
        }
        return temp;
    }

    private StringBuffer readFileToStringBuffer() {
        String aLine = new String("");
        StringBuffer temp = new StringBuffer(255);
        while (true) {
            try {
                aLine = this.buf.readLine();
                if (aLine == null) break;
                temp.append(aLine).append("\n");
            }
            catch (IOException e) {
                this.done = false;
                this.msg = "Failed to read " + this.fileName + ": " + e;
            }
        }
        return temp;
    }

    private String[] readFileToArray() throws IOException {
        String aLine = new String("");
        int num = 0;
        try {
            if (this.gNumLines < 0) {
                while ((aLine = this.buf.readLine()) != null) {
                    ++num;
                }
                this.closeFile();
            } else {
                num = this.gNumLines;
            }
        }
        catch (IOException e) {
            this.done = false;
            this.msg = "Failed to read " + this.fileName + ": " + e.getMessage();
            throw e;
        }
        String[] temp = new String[num];
        try {
            if (this.openFile()) {
                int i = 0;
                while (i < num) {
                    temp[i] = aLine = this.buf.readLine();
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.done = false;
            this.msg = "Failed to read " + this.fileName + ": " + e.getMessage();
            throw e;
        }
        return temp;
    }
}

