/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JWindow;
import org.tigr.util.Proface;

public class ProfaceProjector
extends Thread {
    boolean faceOn;
    private Dimension screenSize;
    private JWindow jw;
    private Proface face;
    private boolean active;
    private int x;
    private int y;
    private int picX;
    private int picY;

    public ProfaceProjector() {
        this.faceOn = false;
        this.jw = new JWindow();
    }

    public ProfaceProjector(Proface face, boolean noEvent) {
        this.face = face;
        this.active = noEvent;
        this.jw = new JWindow();
        this.picX = face.getImageWidth();
        this.picY = face.getImageHeight();
    }

    public boolean isFaceOn() {
        return this.faceOn;
    }

    public void run() {
        this.jw.getContentPane().add(this.face);
        if (!this.active) {
            this.jw.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent me) {
                }

                public void mouseReleased(MouseEvent me) {
                }

                public void mouseExited(MouseEvent me) {
                }

                public void mouseEntered(MouseEvent me) {
                }

                public void mouseClicked(MouseEvent me) {
                    ProfaceProjector.this.terminate();
                }
            });
        }
        this.jw.resize(this.picX, this.picY);
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.x = (this.screenSize.width - this.picX) / 2;
        this.y = (this.screenSize.height - this.picY) / 2;
        this.jw.setLocation(this.x, this.y);
        this.jw.show();
        this.jw.pack();
        this.faceOn = true;
    }

    public void setFace(Proface pFace) {
        this.jw.remove(this.face);
        this.face = pFace;
        this.jw.getContentPane().add(this.face);
        this.jw.validate();
        this.jw.show();
    }

    public void setInfoImage(Image img) {
        this.face.setInfoImage(img);
    }

    public void setInfoText(String text) {
        if (this.face != null) {
            this.face.setInfoText(text);
        }
    }

    public void setButtonText(String text) {
        this.face.setButtonText(text);
    }

    public void setTextColor(Color color) {
        this.face.setTextColor(color);
    }

    public void setButtonTextColor(Color color) {
        this.face.setButtonTextColor(color);
    }

    public void showFace() {
        if (this.faceOn) {
            this.jw.show();
        }
    }

    public void terminate() {
        this.jw.disable();
        this.faceOn = false;
        this.jw.dispose();
    }
}

