/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.formula;

import org.tigr.util.formula.MathTree;
import org.tigr.util.formula.Variant;
import org.tigr.util.formula.node.EvaluateException;
import org.tigr.util.formula.node.MathNode;

public class ExpressionParser
implements Variant {
    private MathTree gTree;
    private String gExpr;

    public ExpressionParser(String formula) {
        this.gExpr = formula;
    }

    public String evaluate() {
        String result;
        block2: {
            result = null;
            if (this.gTree == null) break block2;
            try {
                result = "" + this.gTree.evaluate();
            }
            catch (EvaluateException eex) {}
        }
        return result;
    }

    public String evaluate(String[] operants, boolean iRes) {
        String result;
        block3: {
            result = null;
            if (this.gTree == null) break block3;
            try {
                float res = this.gTree.evaluate(operants);
                if (iRes) {
                    result = "" + (int)res;
                    break block3;
                }
                result = "" + res;
            }
            catch (EvaluateException eex) {}
        }
        return result;
    }

    public boolean execute() {
        boolean moreFormula = true;
        String rEnd = new String("");
        this.gTree = new MathTree();
        this.buildMathTree(this.gExpr, 1);
        MathNode curNode = this.gTree.getNodeAt(1);
        while (curNode.getChildren() != null) {
            MathNode[] nodes = curNode.getChildren();
            rEnd = nodes[1].getContent();
            if (!this.isNumber(rEnd)) {
                int id = nodes[1].getIndex();
                this.buildMathTree(rEnd, id);
            }
            curNode = nodes[0];
        }
        while (moreFormula) {
            String[] moreExpr = this.gTree.findExpression();
            if (moreExpr != null) {
                this.buildMathTree(moreExpr[0], Integer.parseInt(moreExpr[1]));
                continue;
            }
            moreFormula = false;
        }
        return true;
    }

    private void buildMathTree(String operation, int ndAddr) {
        String[] bitems = new String[3];
        bitems[0] = operation;
        while ((bitems = this.buildTwoItems(bitems[0]))[0] != null && bitems[1] != null) {
            String leftVal = bitems[0];
            String rightVal = bitems[2];
            if (this.isOperator(bitems[1].charAt(0), false)) {
                this.gTree.extendTree(bitems, ndAddr);
            }
            if (leftVal != null && rightVal != null && (!leftVal.equals("") && !this.isNumber(leftVal) || !rightVal.equals("") && !this.isNumber(rightVal))) continue;
            break;
        }
    }

    private String[] buildTwoItems(String formula) {
        String[] temp = new String[3];
        int end = formula.length();
        int i = end - 1;
        while (i >= 0) {
            int lpIndx;
            char ch = formula.charAt(i);
            if (ch == Variant.OPERATORS[0] || ch == Variant.OPERATORS[1]) {
                temp[0] = formula.substring(0, i);
                temp[1] = "" + ch;
                temp[2] = formula.substring(i + 1, end);
                i = -1;
            } else if (ch == Variant.OPERATORS[2]) {
                lpIndx = this.hasParenthesis(formula.substring(0, i), false);
                if (lpIndx > 0) {
                    temp[0] = formula.substring(0, lpIndx);
                    temp[1] = "" + formula.charAt(lpIndx);
                    temp[2] = formula.substring(lpIndx + 1, end);
                } else {
                    temp[0] = formula.substring(0, i);
                    temp[1] = "" + ch;
                    temp[2] = formula.substring(i + 1, end);
                }
                i = -1;
            } else if (ch == Variant.OPERATORS[3]) {
                lpIndx = this.hasParenthesis(formula.substring(0, i), true);
                if (lpIndx > 0) {
                    temp[0] = formula.substring(0, lpIndx);
                    temp[1] = "" + formula.charAt(lpIndx);
                    temp[2] = formula.substring(lpIndx + 1, end);
                } else {
                    temp[0] = formula.substring(0, i);
                    temp[1] = "" + ch;
                    temp[2] = formula.substring(i + 1, end);
                }
                i = -1;
            } else if (ch == Variant.OPERATORS[5]) {
                lpIndx = this.findLeftParenthesis(formula.substring(0, i + 1));
                if (lpIndx > 0) {
                    int preOp = this.isPlusOrMinus(formula.substring(0, lpIndx), false);
                    if (preOp > 0) {
                        temp[0] = formula.substring(0, lpIndx - 1);
                        temp[1] = "" + formula.charAt(lpIndx - 1);
                        temp[2] = formula.substring(lpIndx + 1, end - 1);
                    } else {
                        preOp = this.findPreOperator(formula.substring(0, lpIndx));
                        if (preOp > 0) {
                            temp[0] = formula.substring(0, preOp);
                            temp[1] = "" + formula.charAt(preOp);
                            temp[2] = formula.substring(preOp + 1, end);
                        } else {
                            temp[0] = formula.substring(0, lpIndx - 1);
                            temp[1] = "" + formula.charAt(lpIndx - 1);
                            temp[2] = formula.substring(lpIndx + 1, end - 1);
                        }
                    }
                } else {
                    temp[2] = formula.substring(0, lpIndx);
                    temp[1] = "" + ch;
                    temp[0] = formula.substring(lpIndx + 1, end - 1);
                }
                i = -1;
            }
            --i;
        }
        return temp;
    }

    private int findLeftParenthesis(String formula) {
        int length;
        int lpNum = 0;
        int rpNum = 0;
        int indx = length = formula.length();
        int i = length - 1;
        while (i >= 0) {
            char ch = formula.charAt(i);
            if (ch == Variant.OPERATORS[5]) {
                ++rpNum;
            } else if (ch == Variant.OPERATORS[4]) {
                ++lpNum;
                indx = i;
            }
            if (rpNum == lpNum && indx < length) {
                return indx;
            }
            --i;
        }
        return indx;
    }

    private int findPreOperator(String formula) {
        int indx = 0;
        int count = 0;
        int length = formula.length();
        int i = length - 1;
        while (i >= 0) {
            char ch = formula.charAt(i);
            if (this.isOperator(ch, false)) {
                ++count;
            }
            if (ch == Variant.OPERATORS[5]) {
                return this.findLeftParenthesis(formula.substring(0, i + 1)) - 1;
            }
            if (count == 2) {
                indx = i;
                i = -1;
            }
            --i;
        }
        return indx;
    }

    private int getLastPlusOrMinus(String formula) {
        int addr = -1;
        int end = formula.length();
        int i = end - 1;
        while (i >= 0) {
            char ch = formula.charAt(i);
            if (ch == Variant.OPERATORS[0] || ch == Variant.OPERATORS[1]) {
                return i;
            }
            if (ch == Variant.OPERATORS[5]) {
                return i + 1;
            }
            --i;
        }
        return addr;
    }

    private int hasParenthesis(String formula, boolean plusMul) {
        int addr = -1;
        int end = formula.length();
        int i = end - 1;
        while (i >= 0) {
            char ch = formula.charAt(i);
            if (this.isOperator(ch, true)) {
                if (ch == Variant.OPERATORS[5]) {
                    addr = this.findLeftParenthesis(formula.substring(0, i + 1));
                    --addr;
                } else {
                    addr = plusMul ? this.isPlusOrMinus(formula.substring(0, end - 1), plusMul) : this.getLastPlusOrMinus(formula.substring(0, end - 1));
                }
                return addr;
            }
            --i;
        }
        return addr;
    }

    private boolean isNumber(String st) {
        try {
            float temp = Float.parseFloat(st);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private int isPlusOrMinus(String formula, boolean plusMul) {
        int addr = -1;
        int end = formula.length();
        int i = end - 1;
        while (i >= 0) {
            char ch = formula.charAt(i);
            if (plusMul) {
                if (ch == Variant.OPERATORS[0] || ch == Variant.OPERATORS[1] || ch == Variant.OPERATORS[2]) {
                    addr = i;
                    i = -1;
                } else if (ch == Variant.OPERATORS[3] || ch == Variant.OPERATORS[5]) {
                    i = -1;
                }
            } else if (ch == Variant.OPERATORS[0] || ch == Variant.OPERATORS[1]) {
                addr = i;
                i = -1;
            } else if (ch == Variant.OPERATORS[2] || ch == Variant.OPERATORS[3] || ch == Variant.OPERATORS[5]) {
                i = -1;
            }
            --i;
        }
        return addr;
    }

    private boolean isOperator(char ch, boolean all) {
        boolean yes = false;
        int numOps = all ? 6 : 4;
        int i = 0;
        while (i < numOps) {
            if (ch == Variant.OPERATORS[i]) {
                yes = true;
                i = numOps;
            }
            ++i;
        }
        return yes;
    }
}

