/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.util.MyStringTokenizer;

public class IOUtil {
    public static boolean caseSen = true;
    public static String FILE_URL_PREFIX = "file://localhost/";
    public static String CUR_DRIVER = ".";

    public static String changeUrlToFilePathName(String url) {
        String path = url;
        String s = url;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '/' || s.charAt(i) == '\\') {
                path = s.substring(i + 1);
                i = s.length();
            }
            ++i;
        }
        return path;
    }

    public static String dropExtension(String fPath) {
        String f = fPath;
        if (f != null) {
            int i = f.lastIndexOf(46);
            if (i > 0 && i < f.length() - 1) {
                String ext = f.substring(i + 1);
                if (ext.length() != 3) {
                    return f;
                }
                return f.substring(0, i);
            }
            return f;
        }
        return null;
    }

    public static void deleteFiles(String[] fNames) {
        int i = 0;
        while (i < fNames.length) {
            File file = new File(fNames[i]);
            if (file.exists()) {
                file.delete();
            }
            ++i;
        }
    }

    public static String extractPath(String abPath) {
        String name;
        String s = name = abPath;
        int addr = 0;
        addr = IOUtil.fileSeparatorAt(s, true);
        if (addr > 0 && addr < s.length()) {
            name = s.substring(0, addr + 1);
        }
        return name;
    }

    public static String extractFileNameFromPath(String path) {
        String name = path;
        String s = path;
        int i = IOUtil.fileSeparatorAt(path, true);
        if (i > 0 && i < s.length() - 1) {
            name = s.substring(i + 1);
        }
        return name;
    }

    public static String extractFileNameFromURL(String url) {
        String name = url;
        String s = url;
        int i = s.lastIndexOf(47);
        if (i > 0 && i < s.length() - 1) {
            name = s.substring(i + 1);
        }
        return name;
    }

    public static int fileSeparatorAt(String str, boolean last) {
        int indx = 0;
        if (last) {
            int i = str.length() - 1;
            while (i > 0) {
                char ch = str.charAt(i);
                if (ch == '/' || ch == '\\') {
                    indx = i;
                    i = 0;
                }
                --i;
            }
        } else {
            int i = 0;
            while (i < str.length() - 1) {
                char ch = str.charAt(i);
                if (ch == '/' || ch == '\\') {
                    indx = i;
                    i = str.length();
                }
                ++i;
            }
        }
        return indx;
    }

    public static String[] getDirectoryNames(File[] allNames) {
        Vector<String> dir = new Vector<String>(10, 3);
        int i = 0;
        while (i < allNames.length) {
            if (allNames[i].isDirectory()) {
                dir.add(allNames[i].getName());
            }
            ++i;
        }
        String[] dirNames = new String[dir.size()];
        int i2 = 0;
        while (i2 < dir.size()) {
            dirNames[i2] = (String)dir.elementAt(i2);
            ++i2;
        }
        return dirNames;
    }

    public static String getFileNameExtension(String fileName) {
        String res = new String("");
        String s = fileName;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length()) {
            res = s.substring(i + 1, s.length());
        }
        return res;
    }

    public static char getRoot(String abPath) {
        char r = abPath != null && abPath.length() > 1 ? abPath.toLowerCase().charAt(0) : (char)'c';
        return r;
    }

    public static String extractPathFromURL(String url) {
        String name = url;
        String s = name;
        int i = s.lastIndexOf(47);
        if (i > 0 && i < s.length()) {
            name = s.substring(0, i);
        }
        return name;
    }

    public static String ignoreSpaceInPath(String path) {
        String tempDir = new String(path);
        StringTokenizer wholePath = new StringTokenizer(path, " ");
        if (wholePath.countTokens() > 1) {
            tempDir = "\"" + path + "\"";
        }
        return tempDir;
    }

    public static String makeDir(String pDir) {
        String dir = null;
        File tmpFile = new File(pDir);
        if (!tmpFile.isDirectory()) {
            tmpFile.mkdir();
            dir = tmpFile.getPath();
        } else {
            dir = pDir;
        }
        return dir;
    }

    public static String maskFileSeparator(String path) {
        int i;
        boolean masked = false;
        String dir = path;
        String temp = new String("");
        do {
            if ((i = IOUtil.fileSeparatorAt(dir, false)) <= 0 || i >= dir.length() - 1) continue;
            char ch = dir.charAt(i);
            temp = ch == '\\' ? temp + dir.substring(0, i + 1) + "\\" : temp + dir.substring(0, i + 1);
            dir = dir.substring(i + 1);
            masked = true;
        } while (i > 0);
        temp = temp + dir;
        if (!masked) {
            temp = path;
        }
        return temp;
    }

    public static String pathToUri(String path) {
        if (path == null) {
            return path;
        }
        StringBuffer sb = new StringBuffer(path);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == File.separatorChar) {
                sb.setCharAt(i, '/');
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeSpaceFromPath(String filePath) {
        String tempDir = new String("");
        char[] separator = new char[]{'\\', '/'};
        boolean spaceFound = false;
        MyStringTokenizer wholePath = new MyStringTokenizer(filePath, separator);
        int numDir = wholePath.countTokens();
        int i = 0;
        while (i < numDir) {
            String tempFolder = wholePath.nextToken();
            StringTokenizer onePath = new StringTokenizer(tempFolder, " ");
            int num = onePath.countTokens();
            if (num > 1) {
                spaceFound = true;
                String brokenName = onePath.nextToken();
                if (brokenName.length() > 6) {
                    brokenName = brokenName.substring(0, 6);
                    tempFolder = brokenName + "~1";
                }
                tempDir = tempDir + tempFolder + "/";
            } else {
                tempDir = tempDir + tempFolder + "/";
            }
            ++i;
        }
        if (!spaceFound) {
            tempDir = filePath;
        }
        if (tempDir.charAt(tempDir.length() - 1) == separator[0] || tempDir.charAt(tempDir.length() - 1) == separator[1]) {
            tempDir = tempDir.substring(0, tempDir.length() - 1);
        }
        return tempDir;
    }

    public static String toURL(String str) throws Exception {
        try {
            str = IOUtil.pathToUri(str);
            if (!caseSen) {
                str = str.toLowerCase();
            }
            new URL(str);
        }
        catch (Exception ex) {
            str = IOUtil.pathToUri(new File(str).getCanonicalPath());
            if (!caseSen) {
                str = str.toLowerCase();
            }
            str = FILE_URL_PREFIX + str;
        }
        return str;
    }

    public static File validFile(JComponent parent, File pFile, String[] fileType, boolean needCheck) {
        String name = new String("");
        JFrame jf = new JFrame();
        File targFile = null;
        File file = pFile;
        name = file.getPath();
        name = IOUtil.dropExtension(name);
        name = name + "." + fileType[0];
        if (needCheck && (targFile = new File(name)).exists()) {
            jf.getToolkit().beep();
            int confirm = JOptionPane.showConfirmDialog(parent, "The file \"" + name + "\" already exists, \ndo you want to replace " + "the existing file?", parent.getName(), 0, 2);
            if (confirm == 0) {
                return targFile;
            }
            targFile = null;
        }
        return targFile;
    }

    public static boolean writeToFileLineByLine(Object owner, String name, Vector beWritten) {
        BufferedWriter bufWriter = null;
        FileOutputStream fileOut = null;
        int length = beWritten.size();
        try {
            fileOut = new FileOutputStream(name);
            bufWriter = new BufferedWriter(new OutputStreamWriter(fileOut));
            int i = 0;
            while (i < length) {
                bufWriter.write((String)beWritten.elementAt(i));
                bufWriter.newLine();
                ++i;
            }
            bufWriter.flush();
            fileOut.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog((JFrame)owner, "Failed to write due to: " + e.getMessage(), "Error in writing ...", 0);
            return false;
        }
        return true;
    }

    public static boolean writeToFileLineByLine(Object owner, String name, String[] beWritten) {
        BufferedWriter bufWriter = null;
        FileOutputStream fileOut = null;
        int length = beWritten.length;
        try {
            fileOut = new FileOutputStream(name);
            bufWriter = new BufferedWriter(new OutputStreamWriter(fileOut));
            int i = 0;
            while (i < length) {
                bufWriter.write(beWritten[i]);
                bufWriter.newLine();
                ++i;
            }
            bufWriter.flush();
            fileOut.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog((JFrame)owner, "Failed to write due to: " + e.getMessage(), "Error in writing ...", 0);
            return false;
        }
        return true;
    }
}

