/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.client;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.impl.BluejayEventCoordinator;
import ca.ucalgary.bluejay.client.impl.BluejayIOController;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.DataManager;
import ca.ucalgary.bluejay.gui.util.BluejayCheckTree;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.gui.util.SwingWorkerVariant;
import com.simonstl.sax.xlink.Link;
import com.simonstl.sax.xlink.LinkSet;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class ParseTask {
    public final boolean CATCH_PARSING_ERRORS = true;
    public final boolean IGNORE_PARSING_ERRORS = false;
    private static BluejayDObjectList dlist;
    private static BluejayCheckTree tree;
    private static BluejayIOController io;
    private static BluejayEventCoordinator bec;
    private static String[] mimetypes;
    private static URL nowAtURL;
    private static URL actualURLName;
    private static JButton refresh;
    private static int maxNumOnLoadReads;
    private static int maxNumLinkbaseJumps;
    private static boolean usingXLinkFilter;
    private boolean synchronous = false;

    public ParseTask() {
    }

    public ParseTask(BluejayDObjectList bluejayDObjectList, BluejayIOController bluejayIOController, boolean bl) {
        this.setDList(bluejayDObjectList);
        this.setIO(bluejayIOController);
        this.setSynchronous(bl);
    }

    public void setSynchronous(boolean bl) {
        this.synchronous = bl;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public synchronized void go(URL uRL) {
        this.go(uRL, null);
    }

    public synchronized void go(final URL uRL, final String string) {
        if (refresh != null) {
            refresh.setEnabled(false);
        }
        if (tree != null) {
            tree.setEnabled(false);
        }
        SwingWorkerVariant swingWorkerVariant = new SwingWorkerVariant(){

            public void doThings() {
                this.doNonUILogic();
            }

            protected void doNonUILogic() {
                if (string == null) {
                    this.doReplacementParsing();
                } else {
                    this.doEmbeddedParsing();
                }
            }

            private void doReplacementParsing() {
                int[] nArray = new int[20000];
                try {
                    LinkSet linkSet = null;
                    dlist.setScale(-5.898);
                    nowAtURL = uRL;
                    if (dlist.getBluejayParser().getLinkSet() != null) {
                        dlist.getBluejayParser().getLinkSet().removeAllLinks();
                    }
                    dlist.getDataManager().removeAllHyperlinks();
                    dlist.getDataManager().clearXPointerDOMMap();
                    for (int i = 0; i < maxNumOnLoadReads; ++i) {
                        this.parse(nowAtURL, actualURLName, true);
                        this.processLinkbaseLinks(actualURLName);
                        LinkSet linkSet2 = null;
                        if (dlist.getBluejayParser().getLinkSet() != null) {
                            linkSet = dlist.getBluejayParser().getLinkSet().getByFromURLFile(actualURLName);
                            linkSet2 = linkSet.getByActuate("onLoad");
                        }
                        if (linkSet2 == null || linkSet2.size() <= 0) break;
                        nowAtURL = linkSet2.firstLink().getToNode().getURL();
                        actualURLName = nowAtURL;
                        System.out.println("###SHALL PARSE " + linkSet2.firstLink());
                    }
                    if (Debug.SHOW_XLINKS) {
                        System.out.println("\nXLinks():\n\n" + dlist.getBluejayParser().getLinkSet());
                        System.out.println("\nOutgoing XLinks():\n\n" + linkSet);
                    }
                    dlist.getAbstractLinearGraphics().setLinkSet(linkSet);
                    dlist.getDataManager().buildXPointerDOMMap();
                    dlist.reconPaint();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    nArray = null;
                    System.gc();
                    JOptionPane.showMessageDialog(null, "Bluejay has run out of memory (parsing a large document) due to applet restrictions.  Please refer to the \"Out of Memory\" instructions on the applet's Web page.", "Bluejay is Out of Memory", 0);
                }
            }

            private void doEmbeddedParsing() {
                int[] nArray = new int[20000];
                try {
                    Object var2_2 = null;
                    DataManager dataManager = dlist.getDataManager();
                    URL uRL2 = uRL;
                    if (dlist.isMemorySavingMode()) {
                        dataManager.clearSVGTreesIfPossible();
                        dataManager.clearRenderingTrees();
                        dlist.getBluejayParser().reparse();
                    }
                    DTDElementInstance dTDElementInstance = null;
                    dataManager.buildXPointerDOMMap();
                    if (string != null) {
                        dTDElementInstance = dlist.getDTDElementInstance(string);
                    }
                    dataManager.clearXPointerDOMMap();
                    this.parse(uRL2, uRL2, true, dTDElementInstance);
                    dlist.repaint(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    nArray = null;
                    System.gc();
                    JOptionPane.showMessageDialog(null, "Bluejay has run out of memory (parsing a large document) due to applet restrictions.  Please refer to the \"Out of Memory\" instructions on the applet's Web page.", "Bluejay is Out of Memory", 0);
                }
            }

            private void processLinkbaseLinks(URL uRL3) {
                LinkSet linkSet = this.extractLinkbaseOnLoadLinks(dlist.getBluejayParser().getLinkSet(), uRL3);
                if (linkSet == null || linkSet.size() == 0) {
                    return;
                }
                LinkSet linkSet2 = dlist.getBluejayParser().getLinkSet();
                LinkSet linkSet3 = new LinkSet();
                dlist.getBluejayParser().setLinkSet(linkSet3);
                dlist.getBluejayParser().setCollectingLinksOnly(true);
                for (int i = 0; i < maxNumLinkbaseJumps; ++i) {
                    int n;
                    int n2 = n = linkSet == null ? 0 : linkSet.size();
                    if (0 == n) break;
                    for (int j = 0; j < n; ++j) {
                        Link link = linkSet.firstLink();
                        URL uRL2 = link.getToNode().getURL();
                        linkSet.removeLink(link);
                        System.out.println("we get here using the ..linkbaseURL parse line");
                        this.parse(uRL2, uRL2, false);
                        linkSet.addLinkSet(this.extractLinkbaseOnLoadLinks(linkSet3, uRL2));
                        linkSet2.addLinkSet(linkSet3);
                        linkSet3.removeAllLinks();
                    }
                }
                dlist.getBluejayParser().setCollectingLinksOnly(false);
                dlist.getBluejayParser().setLinkSet(linkSet2);
            }

            private LinkSet extractLinkbaseOnLoadLinks(LinkSet linkSet, URL uRL2) {
                if (linkSet == null || linkSet.getByFromURLFile(uRL2) == null) {
                    return null;
                }
                LinkSet linkSet2 = linkSet.getByFromURLFile(uRL2).getLinkbaseLinksByActuate("onLoad");
                linkSet.removeLinkSet(linkSet2);
                return linkSet2;
            }

            private void parse(URL uRL3, URL uRL2, boolean bl) {
                this.parse(uRL3, uRL2, bl, null);
            }

            private void parse(URL uRL3, URL uRL2, boolean bl, DTDElementInstance dTDElementInstance) {
                boolean bl2 = dTDElementInstance == null;
                dlist.getBluejayParser().setParsingTools(io, mimetypes, bec, usingXLinkFilter);
                dlist.getBluejayParser().setContextDTDElementInstance(dTDElementInstance);
                dlist.getBluejayParser().parse(uRL3, uRL2, bl, true, bl2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished() {
                try {
                    this.doUIUpdateLogic();
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    System.out.println("SwingWorker error" + runtimeException);
                }
                finally {
                    if (this.getAComponent() != null) {
                        this.getAComponent().requestFocus();
                    }
                }
            }

            protected void doUIUpdateLogic() {
                if (tree != null) {
                    tree.expandAll();
                    tree.setEnabled(true);
                }
                if (refresh != null) {
                    refresh.setEnabled(true);
                }
            }
        };
        if (this.synchronous) {
            swingWorkerVariant.doThings();
            swingWorkerVariant.finished();
        } else {
            swingWorkerVariant.start();
        }
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    public void setTree(BluejayCheckTree bluejayCheckTree) {
        tree = bluejayCheckTree;
    }

    public void setUsingXLinkFilter(boolean bl) {
        usingXLinkFilter = bl;
    }

    public void setActualURLName(URL uRL) {
        actualURLName = uRL;
    }

    public void setRefresh(JButton jButton) {
        refresh = jButton;
    }

    public void setMimeTypes(String[] stringArray) {
        mimetypes = stringArray;
    }

    public void setBec(BluejayEventCoordinator bluejayEventCoordinator) {
        bec = bluejayEventCoordinator;
    }

    public void setIO(BluejayIOController bluejayIOController) {
        io = bluejayIOController;
    }

    static {
        maxNumOnLoadReads = 5;
        maxNumLinkbaseJumps = 3;
    }
}

