/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.client.impl;

import ca.ucalgary.bluejay.client.DTDMarkupSpecifier;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BluejayEntityResolver
implements EntityResolver {
    private DTDMarkupSpecifier[] languages;
    private Hashtable resourceUrlCache = new Hashtable();
    private URL lastResolvedEntityURL;
    private static Logger logger = Logger.getLogger(BluejayEntityResolver.class);

    public BluejayEntityResolver() {
    }

    public BluejayEntityResolver(DTDMarkupSpecifier[] dTDMarkupSpecifierArray) {
        this();
        this.setDTDMarkupSpecifiers(dTDMarkupSpecifierArray);
    }

    public void setDTDMarkupSpecifiers(DTDMarkupSpecifier[] dTDMarkupSpecifierArray) {
        this.languages = dTDMarkupSpecifierArray;
    }

    private InputSource storeResourceToCache(String string, URL uRL, InputSource inputSource) {
        logger.debug("Trying to save cache record for XML entity " + string);
        if ("file".equals(uRL.getProtocol()) || "jar".equals(uRL.getProtocol()) || this.resourceUrlCache.containsValue(uRL)) {
            this.resourceUrlCache.put(string, uRL);
            return inputSource;
        }
        InputSource inputSource2 = null;
        URL uRL2 = null;
        try {
            File file = File.createTempFile("bluejay", ".resource");
            logger.debug("Trying to save XML entity " + string + " to " + file.toURL());
            Reader reader = inputSource.getCharacterStream();
            if (reader == null) {
                logger.warn("Error getting Reader from " + inputSource.getSystemId() + ", cannot cache the resource");
                return null;
            }
            FileWriter fileWriter = new FileWriter(file);
            char[] cArray = new char[50000];
            int n = reader.read(cArray);
            while (n != -1) {
                fileWriter.write(cArray, 0, n);
                n = reader.read(cArray);
            }
            fileWriter.close();
            uRL2 = file.toURL();
        }
        catch (IOException iOException) {
            logger.warn("Warning: Strange internal error: could not save XML entity " + string + " to local cache (" + uRL2 + "): " + iOException);
        }
        this.resourceUrlCache.put(string, uRL2);
        inputSource2 = this.getResourceFromCache(string);
        if (inputSource2 == null) {
            this.resourceUrlCache.remove(string);
            logger.warn("Warning: Strange internal error: cannot load cache file (" + uRL2 + ") we just saved for XML entity " + string);
        }
        return inputSource2;
    }

    private SourceURL getSourceFromResource(String string) {
        URL uRL = this.getClass().getClassLoader().getResource(string);
        if (uRL == null) {
            logger.warn("Warning: Could not find the specified XML entity " + string);
            return null;
        }
        SourceURL sourceURL = new SourceURL();
        sourceURL.url = uRL;
        InputSource inputSource = this.urlToInputSource(uRL);
        if (inputSource == null) {
            logger.warn("Warning: Found URL (" + uRL + ") for the specified XML entity " + string + " but could not retrieve it");
            return null;
        }
        sourceURL.source = inputSource;
        return sourceURL;
    }

    private InputSource urlToInputSource(URL uRL) {
        logger.debug("Trying to retrieve URL " + uRL);
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            logger.warn("Warning: Could not open input stream for the specified XML entity URL " + uRL + ", exception was " + iOException);
            return null;
        }
        if (inputStream == null) {
            logger.warn("Warning: Could not open input stream for the specified XML entity URL " + uRL);
            return null;
        }
        logger.debug("Opened URL input stream");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        logger.debug("About to create SAX InputSource for " + uRL);
        InputSource inputSource = new InputSource(inputStreamReader);
        logger.debug("Sucessfully created SAX InputSource for " + uRL);
        return inputSource;
    }

    private InputSource getResourceFromCache(String string) {
        if (string == null) {
            return null;
        }
        if (!this.resourceUrlCache.containsKey(string)) {
            return null;
        }
        URL uRL = (URL)this.resourceUrlCache.get(string);
        if (uRL == null) {
            logger.warn("Warning: Strange internal error: cached value for XML entity " + string + " was null");
            return null;
        }
        InputSource inputSource = this.urlToInputSource(uRL);
        if (inputSource == null) {
            logger.warn("Warning: Strange internal error: the cache URL (" + uRL + ") for XML entity " + string + " no longer seems to be valid, deleting the cache record");
            this.resourceUrlCache.remove(string);
        }
        return inputSource;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        SourceURL sourceURL;
        int n;
        InputSource inputSource = null;
        inputSource = this.getResourceFromCache(string);
        if (inputSource != null) {
            logger.debug("Retrieved XML entity " + string + " from cache");
            return inputSource;
        }
        String string3 = this.getSystemIdShortName(string2);
        inputSource = this.getResourceFromCache(string3);
        if (inputSource != null) {
            logger.debug("Retrieved XML entity " + string2 + " from cache");
            return inputSource;
        }
        URL uRL = null;
        if (string != null) {
            for (n = 0; n < this.languages.length; ++n) {
                if (!string.equals(this.languages[n].getPublicId())) continue;
                sourceURL = this.getSourceFromResource(this.languages[n].getMarkupResource());
                if (sourceURL == null) {
                    logger.warn("Warning: weird internal error, can't retrieve Bluejay resource " + this.languages[n].getMarkupResource());
                    continue;
                }
                inputSource = sourceURL.source;
                uRL = sourceURL.url;
                break;
            }
        }
        if (inputSource == null && string3 != null) {
            for (n = 0; n < this.languages.length; ++n) {
                if (!string3.equals(this.getSystemIdShortName(this.languages[n].getMarkupResource()))) continue;
                sourceURL = this.getSourceFromResource(this.languages[n].getMarkupResource());
                if (sourceURL == null) {
                    logger.warn("Warning: weird internal error, can't retrieve Bluejay resource " + this.languages[n].getMarkupResource());
                    continue;
                }
                inputSource = sourceURL.source;
                uRL = sourceURL.url;
                break;
            }
        }
        if (inputSource != null) {
            logger.debug("Resolved XML entity internally in Bluejay: PUBLIC: " + string + " / SYSTEM ID:" + string2 + " to " + uRL);
        }
        if (inputSource == null) {
            logger.debug("Trying to resolve XML entity " + string2 + " externally " + "(it's not in Bluejay's XML repetoire)");
            URL uRL2 = null;
            try {
                uRL2 = new URL(string2);
                if (uRL2 != null) {
                    uRL = uRL2;
                    inputSource = this.urlToInputSource(uRL2);
                }
                if (inputSource == null && (uRL2.getProtocol().equals("file:") || uRL2.getHost() == null || uRL2.getHost().equals(""))) {
                    uRL = new URL(this.lastResolvedEntityURL, string3);
                    logger.debug("Try last ditch attempt to find entity at " + uRL);
                    inputSource = this.urlToInputSource(uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.warn("Warning: Bluejay cannot resolve the XML entity, and system ID " + string2 + " could not be parsed into a URL: " + malformedURLException);
            }
            if (inputSource == null) {
                logger.warn("Warning: Bluejay cannot resolve the XML entity, and system ID " + string2 + " could not be retrieved successfully.  Try disabling " + "XML entity caching for this document.");
            }
        }
        if (inputSource != null) {
            this.lastResolvedEntityURL = uRL;
            if (string != null) {
                inputSource = this.storeResourceToCache(string, uRL, inputSource);
            }
            if (string3 != null) {
                inputSource = this.storeResourceToCache(string3, uRL, inputSource);
            }
        }
        return inputSource;
    }

    private String getSystemIdShortName(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return string;
        }
        if (n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    class SourceURL {
        public URL url = null;
        public InputSource source = null;

        SourceURL() {
        }
    }
}

