/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.client.lineartarget;

import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.client.impl.BluejayDTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.MaskPainter;
import ca.ucalgary.bluejay.gui.painter.BasicPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.util.Conversion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.log4j.Logger;

public class TextLinearTarget
implements LinearTarget {
    private double pixelsPerPosScale;
    private int min_pos;
    private int max_pos;
    private double width;
    private double height;
    public static boolean vert;
    private boolean isBreakable;
    private int maxPositionsPerBreakLine;
    private int above_pixels;
    private int below_pixels;
    private AbstractLinearGraphics alg;
    private int shift = 0;
    private Rectangle boundingRect;
    private int mode = 0;
    private static final double HALF_PI_ANGLE = 1.5707963267948966;
    private static final double RAD_PER_DEGREE = Math.PI / 180;
    private boolean ignoreMode = false;
    private final double LINE_SPACE_FACTOR = 0.8;
    private static final int SCREEN_MARGIN = 90;
    private static final double CHAR_MARGIN = 2.0;
    private String[] sequences;
    private String contigSeq;
    private static Logger logger;
    public static final boolean VERTICAL_TEXT_TARGET = true;
    public static final boolean HORIZONTAL_TEXT_TARGET = false;
    public static final boolean BREAKABLE_TEXT_TARGET = true;
    public static final boolean UNBREAKABLE_TEXT_TARGET = false;
    private Vector visibleRangeSegments = new Vector();
    private MaskPainter maskPainter;
    private boolean shouldSplit;

    public TextLinearTarget(AbstractLinearGraphics abstractLinearGraphics, int n, int n2, int n3, int n4, double d, boolean bl, boolean bl2, String[] stringArray, int n5) {
        this.alg = abstractLinearGraphics;
        this.min_pos = n;
        this.max_pos = n2;
        this.above_pixels = n3;
        this.below_pixels = n4;
        vert = bl;
        this.isBreakable = bl2;
        this.setScale(d);
        this.shouldSplit = false;
        this.sequences = new String[n5];
        for (int i = 0; i < n5; ++i) {
            this.sequences[i] = stringArray[i].toUpperCase();
        }
    }

    public void setMaskPainter(MaskPainter maskPainter) {
        this.maskPainter = maskPainter;
    }

    public MaskPainter getMaskPainter() {
        return this.maskPainter;
    }

    public int getMinPosition() {
        return this.min_pos;
    }

    public int getMaxPosition() {
        return this.max_pos;
    }

    public int getWidth() {
        return (int)(0.5 + this.width);
    }

    public int getHeight() {
        return (int)(0.5 + this.height);
    }

    private Point2D.Double getPositionPoint(int n) throws IllegalArgumentException {
        if (n > this.max_pos || n < this.min_pos) {
            throw new IllegalArgumentException("In TextLinearTarget, request for location of position " + n + " which is outside legal position range of [" + this.min_pos + "," + this.max_pos + "]");
        }
        if (vert) {
            return new Point2D.Double(this.below_pixels, this.pixelsPerPosScale * (double)(n - this.min_pos + 1));
        }
        if (this.isBreakable) {
            int n2 = (n - this.min_pos) / this.maxPositionsPerBreakLine;
            int n3 = 1 + (n - this.min_pos) % this.maxPositionsPerBreakLine;
            return new Point2D.Double((double)n3 * this.pixelsPerPosScale, (double)(n2 * (this.above_pixels + this.below_pixels)) * 0.8 + (double)this.above_pixels);
        }
        return new Point2D.Double(this.pixelsPerPosScale * (double)(n - this.min_pos + 1), this.above_pixels);
    }

    private double getPositionAngle(int n) throws IllegalArgumentException {
        if (n > this.max_pos || n < this.min_pos) {
            throw new IllegalArgumentException("In TextLinearTarget, request for angle of position " + n + " which is outside legal position range of [" + this.min_pos + "," + this.max_pos + "]");
        }
        return vert ? 90.0 : 0.0;
    }

    public int getAbovePixels() {
        return this.above_pixels;
    }

    public int getBelowPixels() {
        return this.below_pixels;
    }

    public void setAbovePixels(int n) {
        this.above_pixels = n;
        this.recalculateWidthHeight();
    }

    public void setBelowPixels(int n) {
        this.below_pixels = n;
        this.recalculateWidthHeight();
    }

    public double getScale() {
        return this.pixelsPerPosScale;
    }

    public void setScale(double d) {
        this.pixelsPerPosScale = d;
        this.recalculateWidthHeight();
    }

    public void drawString(Graphics graphics, String string, int n, double d, double d2, int n2) {
        this.drawAngledString(graphics, string, n, d, d2, n2, 0.0);
    }

    public void drawAngledString(Graphics graphics, String string, int n, double d, double d2, int n2, double d3) {
        String string2;
        if ((this.mode & 2) == 2 && !this.ignoreMode) {
            n = (n + this.shift + this.max_pos - 1) % this.max_pos + 1;
        }
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n = this.max_pos - n + 1;
        }
        double d4 = d * (double)(d >= 0.0 ? this.above_pixels : this.below_pixels);
        double d5 = d2 * (double)(d2 >= 0.0 ? this.above_pixels : this.below_pixels);
        double d6 = d4 - d5;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.stringWidth(string);
        int n5 = fontMetrics.charWidth('A');
        if (d6 >= (double)n4) {
            string2 = string;
        } else {
            int n6 = (int)(0.5 + (double)string.length() * d6 / (double)n4) - 3;
            if (n6 < 0) {
                n6 = 0;
            }
            string2 = string.substring(0, n6) + "...";
            n4 = fontMetrics.stringWidth(string2);
        }
        Point2D.Double double_ = this.getPositionPoint(n);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (vert) {
            double d7 = d * (double)(d >= 0.0 ? this.above_pixels : this.below_pixels);
            double d8 = d7 - (double)(d2 >= 0.0 ? this.above_pixels : this.below_pixels) * d2;
            if (d3 == 180.0) {
                if (d2 >= 0.0) {
                    this.drawVerticalString(graphics2D, string2, double_.x + d8 - d7 - (double)n5, double_.y);
                } else {
                    this.drawVerticalString(graphics2D, string2, double_.x + d8 - d7, double_.y);
                }
            } else {
                graphics2D.drawString(string2, (float)(double_.x - d7 + 4.0), (float)(double_.y + this.pixelsPerPosScale / 2.0));
            }
        } else {
            if (d3 == 270.0) {
                double d9 = d * (double)(d >= 0.0 ? this.above_pixels : this.below_pixels);
                double d10 = d9 - (double)(d2 >= 0.0 ? this.above_pixels : this.below_pixels) * d2;
                if (d2 >= 0.0) {
                    graphics2D.drawString(string2, (float)double_.x, (float)(double_.y + d10 - d9 - (double)n5 - 2.0));
                } else {
                    graphics2D.drawString(string2, (float)double_.x, (float)(double_.y + d10 - d9 + (double)n5 + 2.0));
                }
                return;
            }
            double d11 = d3 * (Math.PI / 180);
            double d12 = double_.x;
            double d13 = double_.x;
            switch (n2) {
                case 30: {
                    d12 += d5;
                    d13 += d5;
                    break;
                }
                case 40: {
                    d12 += d4 - (double)n4;
                    d13 += d4;
                    break;
                }
                case 0: {
                    d12 += (d5 + d4 - (double)n4) / 2.0;
                    d13 += (d5 + d4) / 2.0;
                }
            }
            if (graphics2D instanceof SVGGraphics2D) {
                graphics2D.drawString(" ", 0, 0);
            }
            graphics2D.rotate(-1.5707963267948966, double_.x, double_.y);
            if (d11 != 0.0) {
                graphics2D.rotate(-d11, d13, double_.y);
            }
            graphics2D.drawString(string2, (float)d12, (float)(0.5 + double_.y));
            if (d11 != 0.0) {
                graphics2D.rotate(d11, d13, double_.y);
            }
            graphics2D.rotate(1.5707963267948966, double_.x, double_.y);
        }
    }

    public void drawString(Graphics graphics, String string, int n, double d, int n2) {
        this.drawAngledString(graphics, string, n, d, n2, 0.0);
    }

    public void drawAngledString(Graphics graphics, String string, int n, double d, int n2, double d2) {
        if ((this.mode & 2) == 2 && !this.ignoreMode) {
            n = (n + this.shift + this.max_pos - 1) % this.max_pos + 1;
        }
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n = this.max_pos - n + 1;
        }
        this.ignoreMode = true;
        switch (n2) {
            case 30: {
                this.drawAngledString(graphics, string, n, 777.77, d, n2, d2);
                break;
            }
            case 40: {
                this.drawAngledString(graphics, string, n, d, -777.77, n2, d2);
                break;
            }
            case 0: {
                this.drawAngledString(graphics, string, n, 777.77, -777.77, n2, d2);
            }
        }
        this.ignoreMode = false;
    }

    public void drawWaypointIcon(Graphics graphics, String string, Image image, int n, int n2, int n3, int n4, double d) {
        Serializable serializable;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point point = this.getPointLocally(n4, d);
        int n5 = (int)point.getX();
        int n6 = (int)point.getY();
        int n7 = n2 + 4;
        int n8 = n + 5;
        int n9 = n2 + 2;
        Rectangle rectangle = new Rectangle(n5, n6, n7, n9);
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.white);
        graphics2D.fill(rectangle);
        graphics2D.setColor(color);
        graphics2D.draw(rectangle);
        if (image != null) {
            serializable = new AffineTransform();
            serializable.setToTranslation(n5 + 2, n6 + 1);
            graphics2D.drawImage(image, (AffineTransform)serializable, this.maskPainter.getDList());
        }
        rectangle = new Rectangle(n5 + n7, n6, n8, n9);
        graphics2D.setColor(Color.yellow);
        graphics2D.fill(rectangle);
        graphics2D.setColor(color);
        graphics2D.draw(rectangle);
        serializable = graphics2D.getFont();
        graphics2D.setFont(new Font("SansSerif", 0, 12));
        graphics2D.drawString(string, n5 + n7 + 3, n6 + n9 - 5);
        graphics2D.setFont((Font)serializable);
    }

    public void drawVerticalString(Graphics graphics, String string, int n, double d, int n2) {
        vert = true;
        if ((this.mode & 2) == 2 && !this.ignoreMode) {
            n = (n + this.shift + this.max_pos - 1) % this.max_pos + 1;
        }
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n = this.max_pos - n + 1;
        }
        this.ignoreMode = true;
        switch (n2) {
            case 30: {
                this.drawString(graphics, string, n, 777.77, d, n2);
                break;
            }
            case 40: {
                this.drawString(graphics, string, n, d, -777.77, n2);
                break;
            }
            case 0: {
                this.drawString(graphics, string, n, 777.77, -777.77, n2);
            }
        }
        this.ignoreMode = false;
        vert = false;
    }

    private Line2D.Double getPreShrunkLine(double d, double d2, double d3, double d4) {
        Line2D.Double double_ = null;
        double d5 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        if (d5 < 1.0E-4) {
            double_ = new Line2D.Double(d, d2, d3, d4);
        } else {
            double d6 = 0.5 * (d3 - d) / d5;
            double d7 = 0.5 * (d4 - d2) / d5;
            double d8 = d + d6;
            double d9 = d2 + d7;
            double d10 = d3 - d6;
            double d11 = d4 - d7;
            double_ = new Line2D.Double(d8, d9, d10, d11);
        }
        return double_;
    }

    public void drawLine(Graphics graphics, int n, int n2, double d, double d2) {
        if ((this.mode & 2) == 2 && !this.ignoreMode && (n2 = (n2 + this.shift + this.max_pos - 1) % this.max_pos + 1) < (n = (n + this.shift + this.max_pos - 1) % this.max_pos + 1)) {
            logger.debug("we have a border crosser");
            this.drawLine(graphics, (this.min_pos - this.shift + this.max_pos - 1) % this.max_pos + 1, (n2 - this.shift + this.max_pos - 1) % this.max_pos + 1, d, d2);
            n2 = this.max_pos;
        }
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            int n3 = n;
            n = this.max_pos - n2 + 1;
            n2 = this.max_pos - n3 + 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Double double_ = this.getPositionPoint(n);
        Point2D.Double double_2 = this.getPositionPoint(n2);
        double d3 = (double)(d >= 0.0 ? this.above_pixels : this.below_pixels) * d;
        double d4 = (double)(d2 >= 0.0 ? this.above_pixels : this.below_pixels) * d2;
        if (vert) {
            if (n == n2) {
                if (d >= 0.0 && d2 >= 0.0) {
                    graphics2D.draw(this.getPreShrunkLine(double_.x, double_.y, double_.x + d3, double_2.y));
                } else {
                    graphics2D.draw(this.getPreShrunkLine(double_.x - d3, double_.y, double_.x - d4, double_2.y));
                }
            } else {
                graphics2D.draw(this.getPreShrunkLine(double_.x - d3 - 2.0, double_.y, double_.x - d4 - 2.0, double_2.y));
            }
            return;
        }
        if (this.isBreakable) {
            double d5 = d3;
            int n4 = this.nextBreakLineStartPosition(n);
            while (n4 < n2) {
                Point2D.Double double_3 = this.getPositionPoint(n4 - 1);
                double d6 = d3 + ((double)n4 - (double)n) / (double)(n2 - n) * (d4 - d3);
                graphics2D.draw(this.getPreShrunkLine(double_.x, double_.y - d5, double_3.x + (double)((int)this.pixelsPerPosScale), double_3.y - d6));
                double_ = this.getPositionPoint(n4);
                d5 = d6;
                n4 = this.nextBreakLineStartPosition(n4);
            }
            d3 = d5;
            graphics2D.draw(this.getPreShrunkLine(double_.x, double_.y - d3, double_2.x, double_2.y - d4));
        } else {
            graphics2D.draw(this.getPreShrunkLine(double_.x, double_.y - d3, double_2.x, double_2.y - d4));
        }
    }

    public void drawLinkingLine(Graphics graphics, int n, int n2, double d, double d2, double d3, int n3, int n4, double d4, double d5, double d6) {
        int n5 = (n + n2) / 2;
        int n6 = (n3 + n4) / 2;
        if ((this.mode & 2) == 2 && !this.ignoreMode && (n6 = (n6 + this.shift + this.max_pos - 1) % this.max_pos + 1) < (n5 = (n5 + this.shift + this.max_pos - 1) % this.max_pos + 1)) {
            logger.debug("we have a border crosser");
            this.drawLine(graphics, (this.min_pos - this.shift + this.max_pos - 1) % this.max_pos + 1, (n6 - this.shift + this.max_pos - 1) % this.max_pos + 1, d, d4);
            n6 = this.max_pos;
        }
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            int n7 = n5;
            n5 = this.max_pos - n6 + 1;
            n6 = this.max_pos - n7 + 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Double double_ = this.getPositionPoint(n5);
        Point2D.Double double_2 = this.getPositionPoint(n6);
        double d7 = (double)(d >= 0.0 ? this.above_pixels : this.below_pixels) * d;
        double d8 = (double)(d4 >= 0.0 ? this.above_pixels : this.below_pixels) * d4;
        graphics2D.draw(this.getPreShrunkLine(double_.x, double_.y - d7, double_2.x, double_2.y - d8));
    }

    private void drawVerticalString(Graphics graphics, String string, int n, int n2) {
        int n3 = graphics.getFontMetrics(graphics.getFont()).getAscent();
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            graphics.drawString(string.substring(i, i + 1), n, n2 + i * n3);
        }
    }

    private void drawVerticalString(Graphics2D graphics2D, String string, double d, double d2) {
        int n = string.length();
        float f = (float)d;
        float f2 = (float)(d2 + this.pixelsPerPosScale);
        for (int i = 0; i < n; ++i) {
            graphics2D.drawString(string.substring(i, i + 1), f, f2);
            f2 = (float)((double)f2 + this.pixelsPerPosScale);
        }
    }

    private Color calculateColorForForeground(Color color) {
        if (color.getRed() + color.getGreen() + color.getBlue() > 384) {
            return Color.black;
        }
        return Color.white;
    }

    public void drawRect(Graphics graphics, int n, int n2, double d, double d2) {
        if ((this.mode & 2) == 2 && !this.ignoreMode && (n2 = (n2 + this.shift + this.max_pos - 1) % this.max_pos + 1) < (n = (n + this.shift + this.max_pos - 1) % this.max_pos + 1)) {
            logger.debug("we have a border crosser");
            this.drawRect(graphics, (this.min_pos - this.shift + this.max_pos - 1) % this.max_pos + 1, (n2 - this.shift + this.max_pos - 1) % this.max_pos + 1, d, d2);
            n2 = this.max_pos;
        }
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            int n3 = n;
            n = this.max_pos - n2 + 1;
            n2 = this.max_pos - n3 + 1;
        }
        this.ignoreMode = true;
        this.drawLine(graphics, n, n, d, d2);
        this.drawLine(graphics, n2, n2, d, d2);
        this.drawLine(graphics, n, n2, d, d);
        this.drawLine(graphics, n, n2, d2, d2);
        this.ignoreMode = false;
    }

    private Point2D.Double adjustAlignmentNonBreakable(Graphics2D graphics2D, Point2D.Double double_, double d, double d2) {
        double d3 = d * (double)(d >= 0.0 ? this.above_pixels : this.below_pixels);
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y + d2);
        double_2.x += d3;
        return double_2;
    }

    private void paintRectangleAndSequence(Graphics2D graphics2D, String string, Point2D.Double double_, Point2D.Double double_2, double d, double d2, double d3, double d4, boolean bl) {
        BluejayDTDElementInstance bluejayDTDElementInstance = (BluejayDTDElementInstance)this.alg.getDTDElementInstance();
        Color color = graphics2D.getColor();
        if (bl) {
            if (bluejayDTDElementInstance.getTagName().equals("contig")) {
                graphics2D.fill(new Rectangle2D.Double(double_.x, double_.y - d3, double_2.x - double_.x + this.pixelsPerPosScale, d4));
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, (float)double_.x, (float)(double_.y - d3 - 2.0));
                graphics2D.drawString(Conversion.convertToNegative(string), (float)double_.x, (float)(double_.y - d3 + 3.0 * d4 + 2.0));
            } else if (bluejayDTDElementInstance.getTagName().equals("repeat_region")) {
                graphics2D.fill(new Rectangle2D.Double(double_.x, double_.y - d3, double_2.x - double_.x + this.pixelsPerPosScale, d4));
            } else if (bluejayDTDElementInstance.getIsComplement()) {
                graphics2D.fill(new Rectangle2D.Double(double_.x, double_.y - d3, double_2.x - double_.x + this.pixelsPerPosScale, d4 + 4.0));
                graphics2D.setColor(this.calculateColorForForeground(graphics2D.getColor()));
                graphics2D.drawString(Conversion.convertToNegative(string), (float)double_.x, (float)(double_.y - d3 + d4 + 2.0));
            } else {
                graphics2D.fill(new Rectangle2D.Double(double_.x, double_.y - d3 - 4.0, double_2.x - double_.x + this.pixelsPerPosScale, d4 + 4.0));
                graphics2D.setColor(this.calculateColorForForeground(graphics2D.getColor()));
                graphics2D.drawString(string, (float)double_.x, (float)(double_.y - d3 + d4 - 2.0));
            }
        } else {
            int n = graphics2D.getFontMetrics(graphics2D.getFont()).charWidth('A');
            double d5 = d3;
            double d6 = d4;
            if (d2 > 0.0) {
                graphics2D.fill(new Rectangle2D.Double(double_.x - (double)n - 4.0, double_.y, (double)n + 4.0, double_2.y - double_.y + this.pixelsPerPosScale));
                graphics2D.setColor(this.calculateColorForForeground(graphics2D.getColor()));
                this.drawVerticalString(graphics2D, string, double_.x - (double)n - 2.0, double_.y);
            } else if (d2 == 0.0) {
                graphics2D.fill(new Rectangle2D.Double(double_.x, double_.y, d6, double_2.y - double_.y + this.pixelsPerPosScale));
                graphics2D.setColor(Color.black);
                this.drawVerticalString(graphics2D, string, double_.x - (double)n - 2.0, double_.y);
                this.drawVerticalString(graphics2D, Conversion.convertToNegative(string), double_.x + d6 + 2.0, double_.y);
            } else {
                if (d < 0.0) {
                    graphics2D.fill(new Rectangle2D.Double(double_.x - d5, double_.y, n, double_2.y - double_.y + this.pixelsPerPosScale));
                    return;
                }
                graphics2D.fill(new Rectangle2D.Double(double_.x + d6 / 2.0, double_.y, (double)n + 4.0, double_2.y - double_.y + this.pixelsPerPosScale));
                graphics2D.setColor(this.calculateColorForForeground(graphics2D.getColor()));
                this.drawVerticalString(graphics2D, Conversion.convertToNegative(string), double_.x + d6 / 2.0 + 2.0, double_.y);
            }
        }
        graphics2D.setColor(color);
    }

    public void fillRect(Graphics graphics, int n, int n2, double d, double d2) {
        String string;
        int n3;
        int n4;
        int n5 = this.alg.getDTDElementInstance().getSlaveNum();
        if ((this.mode & 2) == 2 && !this.ignoreMode) {
            n4 = n;
            n3 = n2;
            if ((n2 = (n2 + this.shift + this.max_pos - 1) % this.max_pos + 1) < (n = (n + this.shift + this.max_pos - 1) % this.max_pos + 1)) {
                logger.debug("we have a border crosser: " + this.min_pos + " : " + this.max_pos + "\n start was originally : " + n4 + "\nstop was originally : " + n3 + "\nstart is now" + n + "\n stop is now" + n2);
                this.fillRect(graphics, (this.min_pos - this.shift + this.max_pos - 1) % this.max_pos + 1, (n2 - this.shift + this.max_pos - 1) % this.max_pos + 1, d, d2);
                n2 = this.max_pos;
            }
        }
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n4 = n2 - n;
            n3 = n;
            n = this.max_pos - n2 + 1;
            n2 = this.max_pos - n3 + 1;
        }
        if (this.alg.getDTDElementInstance().getTagName().equals("contig")) {
            string = this.contigSeq;
            if (n > string.length()) {
                return;
            }
            if (n2 > string.length()) {
                n2 = string.length();
            }
        } else {
            string = this.sequences[n5];
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(new Font("Monospaced", 0, 12));
        Point2D.Double double_ = this.getPositionPoint(n);
        Point2D.Double double_2 = this.getPositionPoint(n2);
        double d3 = d * (double)(d >= 0.0 ? this.above_pixels : this.below_pixels);
        double d4 = d3 - (double)(d2 >= 0.0 ? this.above_pixels : this.below_pixels) * d2;
        if (this.isBreakable) {
            String string2;
            int n6 = 0;
            int n7 = this.nextBreakLineStartPosition(n);
            while (n7 <= n2) {
                int n8 = n7 - this.maxPositionsPerBreakLine;
                int n9 = n7 - 1;
                if (n >= n8) {
                    n8 = n;
                }
                this.paintRectangleAndSequence(graphics2D, string.substring(n8 - 1, n9), double_, this.getPositionPoint(n7 - 1), d, d2, d3, d4, true);
                n6 = n7;
                double_ = this.getPositionPoint(n7);
                n7 = this.nextBreakLineStartPosition(n7);
            }
            if (n > n6) {
                string2 = string.substring(n - 1, n2);
            } else if (n2 < n6 + this.maxPositionsPerBreakLine) {
                double_ = this.getPositionPoint(n6);
                string2 = string.substring(n6 - 1, n2);
            } else {
                System.err.println("TextLinearTarget.fillRect(): Breakable: neither first linenor last line is being painted");
                return;
            }
            this.paintRectangleAndSequence(graphics2D, string2, double_, double_2, d, d2, d3, d4, true);
        } else if (vert) {
            this.paintRectangleAndSequence(graphics2D, string.substring(n - 1, n2), double_, double_2, d, d2, d3, d4, false);
        } else {
            this.paintRectangleAndSequence(graphics2D, string.substring(n - 1, n2), double_, double_2, d, d2, d3, d4, true);
        }
    }

    public Point getPointLocally(int n, double d) {
        if ((this.mode & 2) == 2 && !this.ignoreMode) {
            n = (n + this.shift + this.max_pos - 1) % this.max_pos + 1;
        }
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n = this.max_pos - n + 1;
        }
        double d2 = d * (double)(d >= 0.0 ? this.above_pixels : this.below_pixels);
        Point2D.Double double_ = this.getPositionPoint(n);
        if (vert) {
            double_.x += d2;
        } else {
            double_.y -= d2;
        }
        return new Point((int)(0.5 + double_.x), (int)(0.5 + double_.y));
    }

    public int getPositionLocally(Point point) {
        int n = -777777;
        if (vert) {
            n = (int)(0.5 + (double)point.y / this.pixelsPerPosScale) + this.min_pos - 1;
        } else {
            int n2 = (int)((double)point.x / this.pixelsPerPosScale);
            int n3 = this.isBreakable && point.y > 0 ? point.y / (int)(0.8 * (double)(this.above_pixels + this.below_pixels)) : 0;
            n = n3 * this.maxPositionsPerBreakLine + n2 + this.min_pos - 1;
        }
        int n4 = n < this.min_pos ? this.min_pos : (n = n > this.max_pos ? this.max_pos : n);
        if (!this.ignoreMode) {
            if ((this.mode & 1) == 1) {
                n = this.max_pos - n + 1;
            }
            if ((this.mode & 2) == 2) {
                n = (n - this.shift + this.max_pos - 1) % this.max_pos + 1;
            }
        }
        return n;
    }

    public double getHeightRatioLocally(Point point) {
        double d = 0.0;
        if (vert) {
            d = point.x < this.below_pixels ? 1.0 - (double)(point.x / this.below_pixels) : (double)((point.x - this.below_pixels) / this.above_pixels);
        } else if (point.y < 0) {
            d = 1.0 + (double)(-point.y / this.above_pixels);
        } else {
            int n;
            int n2;
            int n3;
            int n4 = point.y / (this.above_pixels + this.below_pixels) + 1;
            if (this.isBreakable && n4 >= (n3 = (this.max_pos - this.min_pos + 1) / this.maxPositionsPerBreakLine + 1) && (n4 = n3) > 1 && (n2 = (int)(0.5 + (double)point.x / this.pixelsPerPosScale)) > (n = (this.max_pos - this.min_pos + 1) % this.maxPositionsPerBreakLine)) {
                --n4;
            }
            n3 = point.y - (n4 > 1 ? (n4 - 1) * (this.above_pixels + this.below_pixels) : 0);
            double d2 = d = n3 < this.above_pixels ? 1.0 - (double)(n3 / this.above_pixels) : (double)((n3 - this.above_pixels) / this.below_pixels);
        }
        if ((this.mode & 1) != 1 || !this.ignoreMode) {
            // empty if block
        }
        return d;
    }

    public boolean isWithinTargetAreaLocally(Point point) {
        return point.x >= 0 && (double)point.x <= this.width && point.y >= 0 && (double)point.y <= this.height;
    }

    public void drawPolygon(Graphics graphics, Polygon polygon, Rectangle rectangle, int n, int n2, double d, double d2) {
    }

    public void fillPolygon(Graphics graphics, Polygon polygon, Rectangle rectangle, int n, int n2, double d, double d2) {
    }

    public void drawArc(Graphics graphics, int n, int n2, double d, double d2, int n3, int n4) {
    }

    public void fillArc(Graphics graphics, int n, int n2, double d, double d2, int n3, int n4) {
    }

    public void drawImage(Graphics graphics, Image image, int n, int n2, double d, double d2) {
    }

    private int nextBreakLineStartPosition(int n) {
        if (vert || !this.isBreakable) {
            return this.max_pos;
        }
        int n2 = (n - this.min_pos) / this.maxPositionsPerBreakLine;
        int n3 = this.min_pos - 1 + (1 + n2) * this.maxPositionsPerBreakLine;
        return n3 + 1;
    }

    private void recalculateWidthHeight() {
        if (vert) {
            this.height = this.pixelsPerPosScale * (double)(this.max_pos - this.min_pos + 1);
            this.width = this.above_pixels + this.below_pixels;
            this.maxPositionsPerBreakLine = (int)(this.height / this.pixelsPerPosScale);
        } else if (this.isBreakable) {
            int n = this.alg.getBreakablePageWidth() - this.alg.getLeftMargin() - this.alg.getRightMargin();
            if (n <= 0) {
                n = this.alg.getStandardPageWidth();
            }
            this.width = this.pixelsPerPosScale * (double)(this.max_pos - this.min_pos + 1);
            this.height = (this.width / (double)n + 1.0) * (double)(this.above_pixels + this.below_pixels);
            if (this.width / (double)n != 0.0) {
                this.width = n;
            }
            this.maxPositionsPerBreakLine = (int)(this.width / this.pixelsPerPosScale);
        } else {
            this.width = this.pixelsPerPosScale * (double)(this.max_pos - this.min_pos + 1);
            this.height = this.above_pixels + this.below_pixels;
            this.maxPositionsPerBreakLine = (int)(this.width / this.pixelsPerPosScale);
        }
    }

    public Object drawObject(Object object) {
        return null;
    }

    public Rectangle getBoundingRect() {
        return this.boundingRect;
    }

    public void setBoundingRect(Rectangle rectangle) {
        this.boundingRect = rectangle;
    }

    public double calculateIdealScale(int n, Dimension dimension, LaneManager laneManager, int n2) {
        return (double)n / (dimension.getWidth() - (double)(2 * n2));
    }

    public double calculateIdealScale(Dimension dimension) {
        double d;
        int n = (int)(1.0E-5 + dimension.getHeight() / (double)(this.above_pixels + this.below_pixels));
        if (vert || !this.isBreakable || n <= 0) {
            n = 1;
        }
        double d2 = d = vert ? dimension.getHeight() : dimension.getWidth();
        if (d > 180.0) {
            d -= 90.0;
        }
        return (double)(this.max_pos - this.min_pos + 1) / ((double)n * d);
    }

    public void addMode(int n) {
        this.mode |= n;
    }

    public int getModeFlags() {
        return this.mode;
    }

    public void removeMode(int n) {
        this.mode &= (n ^= 0xFFFFFFFF);
    }

    public void setShift(int n) {
        this.shift = n;
    }

    public List getVisiblePositionRange() {
        if (this.visibleRangeSegments.isEmpty()) {
            this.clearVisiblePositionRange();
        }
        return this.visibleRangeSegments;
    }

    public void clearVisiblePositionRange() {
        this.visibleRangeSegments.removeAllElements();
        int[] nArray = new int[]{this.min_pos, this.max_pos};
        this.visibleRangeSegments.add(nArray);
    }

    public void calculateVisiblePositionRange(Rectangle rectangle) {
        Point point = new Point(rectangle.x, rectangle.y);
        Point point2 = new Point(rectangle.x + rectangle.width, rectangle.y);
        Point point3 = new Point(rectangle.x, rectangle.y + rectangle.height);
        Point point4 = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Point point5 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        this.calculateRangeCutOffBySemiplane(point, point2, point5);
        this.calculateRangeCutOffBySemiplane(point2, point4, point5);
        this.calculateRangeCutOffBySemiplane(point4, point3, point5);
        this.calculateRangeCutOffBySemiplane(point3, point, point5);
        for (int[] nArray : this.visibleRangeSegments) {
        }
    }

    private void makeRangeSegmentInvisible(int n, int n2) {
        logger.debug("\n\n\n### StraightLT.makeRangeSegmentInvisible(start=" + n + ", end=" + n2 + ")");
        if (this.visibleRangeSegments.isEmpty()) {
            this.clearVisiblePositionRange();
        }
        if (n >= n2 || n2 < ((int[])this.visibleRangeSegments.firstElement())[0] || n > ((int[])this.visibleRangeSegments.lastElement())[1]) {
            return;
        }
        for (int i = 0; i < this.visibleRangeSegments.size(); ++i) {
            int[] nArray = (int[])this.visibleRangeSegments.elementAt(i);
            if (n2 < nArray[0] || n > nArray[1]) continue;
            if (n <= nArray[0] && n2 < nArray[1]) {
                nArray[0] = n2 + 1;
                continue;
            }
            if (n > nArray[0] && n2 >= nArray[1]) {
                nArray[1] = n - 1;
                continue;
            }
            if (n <= nArray[0] && n2 >= nArray[1]) {
                this.visibleRangeSegments.removeElement(nArray);
                --i;
                continue;
            }
            if (n <= nArray[0] || n2 >= nArray[1]) continue;
            int n3 = nArray[1];
            nArray[1] = n - 1;
            int[] nArray2 = new int[]{n2 + 1, n3};
            this.visibleRangeSegments.insertElementAt(nArray2, i + 1);
        }
    }

    private void calculateRangeCutOffBySemiplane(Point point, Point point2, Point point3) {
        boolean bl;
        boolean bl2;
        logger.debug("\n\n\n### StraightLT.calculateRangeCutOffBySemiplane(a=" + point + ", b=" + point2 + ", c=" + point3 + ")");
        if (vert) {
            return;
        }
        if (this.isBreakable) {
            return;
        }
        boolean bl3 = bl2 = point.x == point2.x;
        if (!bl2) {
            return;
        }
        boolean bl4 = (this.mode & 1) == 1 && !this.ignoreMode;
        boolean bl5 = (this.mode & 2) == 1 && !this.ignoreMode;
        int n = bl5 ? this.shift : 0;
        int n2 = this.min_pos + n;
        int n3 = (this.max_pos + n - 1) % this.max_pos + 1;
        int n4 = this.getPositionLocally(point);
        if (n4 <= n2 || n4 >= n3) {
            return;
        }
        boolean bl6 = bl5 && n4 >= this.min_pos && n4 < n2;
        boolean bl7 = point.x < point3.x;
        boolean bl8 = bl = bl4 == bl7;
        if (bl) {
            if (bl5 && !bl6) {
                this.makeRangeSegmentInvisible(n4, this.max_pos);
                this.makeRangeSegmentInvisible(this.min_pos, n3);
            } else {
                this.makeRangeSegmentInvisible(n4, n3);
            }
        } else if (bl5 && bl6) {
            this.makeRangeSegmentInvisible(n2, this.max_pos);
            this.makeRangeSegmentInvisible(this.min_pos, n4);
        } else {
            this.makeRangeSegmentInvisible(n2, n4);
        }
    }

    public int getShape() {
        return 111;
    }

    public void fillArrowShape(Graphics graphics, int n, int n2, double d, double d2) {
        Polygon polygon = this.createNormalArrow(graphics, n, n2, d, d2);
        if (polygon != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.fill(polygon);
        }
    }

    public void drawArrowShape(Graphics graphics, int n, int n2, double d, double d2) {
        Polygon polygon = null;
        Polygon polygon2 = null;
        if (n > n2) {
            this.setSplitArrow(true);
            polygon2 = this.createBrokenRect(graphics, n, this.getMaxPosition(), d, d2);
            polygon = this.createBrokenArrow(graphics, this.getMinPosition(), n2, d, d2);
            if (polygon != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.draw(polygon2);
                graphics2D.draw(polygon);
            }
        } else {
            this.setSplitArrow(false);
            polygon = this.createNormalArrow(graphics, n, n2, d, d2);
            if (polygon != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.draw(polygon);
            }
        }
    }

    public Polygon createBrokenArrow(Graphics graphics, int n, int n2, double d, double d2) {
        Point2D.Double double_;
        int n3;
        int n4;
        if ((this.mode & 2) == 2 && !this.ignoreMode) {
            n4 = n;
            n3 = n2;
            if ((n2 = (n2 + this.shift + this.max_pos - 1) % this.max_pos + 1) < (n = (n + this.shift + this.max_pos - 1) % this.max_pos + 1)) {
                logger.debug("we have a border crosser: " + this.min_pos + " : " + this.max_pos + "\n start was originally : " + n4 + "\nstop was originally : " + n3 + "\nstart is now" + n + "\n stop is now" + n2);
                this.fillRect(graphics, (this.min_pos - this.shift + this.max_pos - 1) % this.max_pos + 1, (n2 - this.shift + this.max_pos - 1) % this.max_pos + 1, d, d2);
                n2 = this.max_pos;
            }
        }
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n4 = n2 - n;
            n3 = n;
            n = this.max_pos - n2 + 1;
            n2 = this.max_pos - n3 + 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        n3 = 8;
        int n5 = new Double((double)n3 / this.pixelsPerPosScale).intValue();
        int n6 = n2 - n;
        int n7 = new Double(10.0 / this.pixelsPerPosScale).intValue();
        int n8 = n6 >= n7 ? (BasicPainter.APPEARFRAME > 0 ? n2 - n7 : n + n7) : (BasicPainter.APPEARFRAME > 0 ? n : n2);
        int n9 = n7 >= n5 ? n + n5 : n + n7 / 2;
        Point2D.Double double_2 = this.getPositionPoint(n);
        Point2D.Double double_3 = this.getPositionPoint(n2);
        Point2D.Double double_4 = this.getPositionPoint(n8);
        Point2D.Double double_5 = this.getPositionPoint(n9);
        double d3 = d * (double)(d >= 0.0 ? this.above_pixels : this.below_pixels);
        double d4 = d3 - (double)(d2 >= 0.0 ? this.above_pixels : this.below_pixels) * d2;
        if (vert) {
            graphics2D.fill(new Rectangle2D.Double(double_2.x + d3 - d4, double_2.y, d4, double_3.y - double_2.y));
            return null;
        }
        if (this.isBreakable) {
            int n10 = this.nextBreakLineStartPosition(n);
            while (n10 < n2) {
                double_ = this.getPositionPoint(n10 - 1);
                graphics2D.fill(new Rectangle2D.Double(double_2.x, double_2.y - d3, double_.x - double_2.x + this.pixelsPerPosScale, d4));
                double_2 = this.getPositionPoint(n10);
                n10 = this.nextBreakLineStartPosition(n10);
            }
        }
        Point2D.Double double_6 = null;
        double_ = null;
        Point2D.Double double_7 = null;
        Point2D.Double double_8 = null;
        Point2D.Double double_9 = null;
        Point2D.Double double_10 = null;
        Point2D.Double double_11 = null;
        Point2D.Double double_12 = null;
        Point2D.Double double_13 = null;
        Point2D.Double double_14 = null;
        if (BasicPainter.APPEARFRAME > 0) {
            double_6 = new Point2D.Double(double_2.x, double_2.y - d3);
            double_ = new Point2D.Double(double_2.x, double_2.y - d3 + d4);
            double_7 = new Point2D.Double(double_4.x, double_2.y - d3 + d4);
            double_8 = new Point2D.Double(double_4.x, double_2.y - d3 + d4 * 5.0 / 4.0);
            double_9 = new Point2D.Double(double_3.x, double_2.y - d3 + d4 * 1.0 / 2.0);
            double_10 = new Point2D.Double(double_4.x, double_2.y - d3 - d4 * 1.0 / 4.0);
            double_11 = new Point2D.Double(double_4.x, double_2.y - d3);
            double_12 = new Point2D.Double(double_5.x, double_2.y - d3 + d4 * 1.0 / 4.0);
            double_13 = new Point2D.Double(double_2.x, double_2.y - d3 + d4 * 1.0 / 2.0);
            double_14 = new Point2D.Double(double_5.x, double_2.y - d3 + d4 * 3.0 / 4.0);
        } else {
            double_6 = new Point2D.Double(double_3.x, double_3.y - d3 + d4);
            double_ = new Point2D.Double(double_3.x, double_3.y - d3);
            double_7 = new Point2D.Double(double_4.x, double_2.y - d3);
            double_8 = new Point2D.Double(double_4.x, double_2.y - d3 - d4 * 1.0 / 4.0);
            double_9 = new Point2D.Double(double_2.x, double_2.y - d3 + d4 * 1.0 / 2.0);
            double_10 = new Point2D.Double(double_4.x, double_2.y - d3 + d4 * 5.0 / 4.0);
            double_11 = new Point2D.Double(double_4.x, double_2.y - d3 + d4);
            double_12 = new Point2D.Double(double_5.x, double_2.y - d3 + d4 * 3.0 / 4.0);
            double_13 = new Point2D.Double(double_3.x, double_2.y - d3 + d4 * 1.0 / 2.0);
            double_14 = new Point2D.Double(double_5.x, double_2.y - d3 + d4 * 1.0 / 4.0);
        }
        int[] nArray = new int[10];
        int[] nArray2 = new int[10];
        nArray[0] = new Double(double_6.x).intValue();
        nArray[1] = new Double(double_12.x).intValue();
        nArray[2] = new Double(double_13.x).intValue();
        nArray[3] = new Double(double_14.x).intValue();
        nArray[4] = new Double(double_.x).intValue();
        nArray[5] = new Double(double_7.x).intValue();
        nArray[6] = new Double(double_8.x).intValue();
        nArray[7] = new Double(double_9.x).intValue();
        nArray[8] = new Double(double_10.x).intValue();
        nArray[9] = new Double(double_11.x).intValue();
        nArray2[0] = new Double(double_6.y).intValue();
        nArray2[1] = new Double(double_12.y).intValue();
        nArray2[2] = new Double(double_13.y).intValue();
        nArray2[3] = new Double(double_14.y).intValue();
        nArray2[4] = new Double(double_.y).intValue();
        nArray2[5] = new Double(double_7.y).intValue();
        nArray2[6] = new Double(double_8.y).intValue();
        nArray2[7] = new Double(double_9.y).intValue();
        nArray2[8] = new Double(double_10.y).intValue();
        nArray2[9] = new Double(double_11.y).intValue();
        Polygon polygon = new Polygon(nArray, nArray2, 10);
        return polygon;
    }

    public Polygon createBrokenRect(Graphics graphics, int n, int n2, double d, double d2) {
        Point2D.Double double_;
        int n3;
        int n4;
        if ((this.mode & 2) == 2 && !this.ignoreMode) {
            n4 = n;
            n3 = n2;
            if ((n2 = (n2 + this.shift + this.max_pos - 1) % this.max_pos + 1) < (n = (n + this.shift + this.max_pos - 1) % this.max_pos + 1)) {
                logger.debug("we have a border crosser: " + this.min_pos + " : " + this.max_pos + "\n start was originally : " + n4 + "\nstop was originally : " + n3 + "\nstart is now" + n + "\n stop is now" + n2);
                this.fillRect(graphics, (this.min_pos - this.shift + this.max_pos - 1) % this.max_pos + 1, (n2 - this.shift + this.max_pos - 1) % this.max_pos + 1, d, d2);
                n2 = this.max_pos;
            }
        }
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n4 = n2 - n;
            n3 = n;
            n = this.max_pos - n2 + 1;
            n2 = this.max_pos - n3 + 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = n2 - n;
        n3 = 8;
        int n6 = new Double((double)n3 / this.pixelsPerPosScale).intValue();
        int n7 = n5 >= n6 ? (BasicPainter.APPEARFRAME > 0 ? n2 - n6 : n + n6) : (BasicPainter.APPEARFRAME > 0 ? n : n2);
        Point2D.Double double_2 = this.getPositionPoint(n);
        Point2D.Double double_3 = this.getPositionPoint(n2);
        Point2D.Double double_4 = this.getPositionPoint(n7);
        double d3 = d * (double)(d >= 0.0 ? this.above_pixels : this.below_pixels);
        double d4 = d3 - (double)(d2 >= 0.0 ? this.above_pixels : this.below_pixels) * d2;
        if (vert) {
            graphics2D.fill(new Rectangle2D.Double(double_2.x + d3 - d4, double_2.y, d4, double_3.y - double_2.y));
            return null;
        }
        if (this.isBreakable) {
            int n8 = this.nextBreakLineStartPosition(n);
            while (n8 < n2) {
                logger.debug(n8);
                double_ = this.getPositionPoint(n8 - 1);
                graphics2D.fill(new Rectangle2D.Double(double_2.x, double_2.y - d3, double_.x - double_2.x + this.pixelsPerPosScale, d4));
                double_2 = this.getPositionPoint(n8);
                n8 = this.nextBreakLineStartPosition(n8);
            }
        }
        Point2D.Double double_5 = null;
        double_ = null;
        Point2D.Double double_6 = null;
        Point2D.Double double_7 = null;
        Point2D.Double double_8 = null;
        Point2D.Double double_9 = null;
        Point2D.Double double_10 = null;
        if (BasicPainter.APPEARFRAME > 0) {
            double_5 = new Point2D.Double(double_2.x, double_2.y - d3);
            double_ = new Point2D.Double(double_2.x, double_2.y - d3 + d4);
            double_6 = new Point2D.Double(double_3.x, double_2.y - d3 + d4);
            double_7 = new Point2D.Double(double_4.x, double_2.y - d3 + d4 * 3.0 / 4.0);
            double_8 = new Point2D.Double(double_3.x, double_2.y - d3 + d4 * 1.0 / 2.0);
            double_9 = new Point2D.Double(double_4.x, double_2.y - d3 + d4 * 1.0 / 4.0);
            double_10 = new Point2D.Double(double_3.x, double_2.y - d3);
        } else {
            double_5 = new Point2D.Double(double_3.x, double_3.y - d3 + d4);
            double_ = new Point2D.Double(double_3.x, double_3.y - d3);
            double_6 = new Point2D.Double(double_2.x, double_2.y - d3);
            double_7 = new Point2D.Double(double_4.x, double_2.y - d3 + d4 * 1.0 / 4.0);
            double_8 = new Point2D.Double(double_2.x, double_2.y - d3 + d4 * 1.0 / 2.0);
            double_9 = new Point2D.Double(double_4.x, double_2.y - d3 + d4 * 3.0 / 4.0);
            double_10 = new Point2D.Double(double_2.x, double_2.y - d3 + d4);
        }
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        nArray[0] = new Double(double_5.x).intValue();
        nArray[1] = new Double(double_.x).intValue();
        nArray[2] = new Double(double_6.x).intValue();
        nArray[3] = new Double(double_7.x).intValue();
        nArray[4] = new Double(double_8.x).intValue();
        nArray[5] = new Double(double_9.x).intValue();
        nArray[6] = new Double(double_10.x).intValue();
        nArray2[0] = new Double(double_5.y).intValue();
        nArray2[1] = new Double(double_.y).intValue();
        nArray2[2] = new Double(double_6.y).intValue();
        nArray2[3] = new Double(double_7.y).intValue();
        nArray2[4] = new Double(double_8.y).intValue();
        nArray2[5] = new Double(double_9.y).intValue();
        nArray2[6] = new Double(double_10.y).intValue();
        Polygon polygon = new Polygon(nArray, nArray2, 7);
        return polygon;
    }

    public Polygon createNormalArrow(Graphics graphics, int n, int n2, double d, double d2) {
        Point2D.Double double_;
        int n3;
        int n4;
        if ((this.mode & 2) == 2 && !this.ignoreMode) {
            n4 = n;
            n3 = n2;
            if ((n2 = (n2 + this.shift + this.max_pos - 1) % this.max_pos + 1) < (n = (n + this.shift + this.max_pos - 1) % this.max_pos + 1)) {
                logger.debug("we have a border crosser: " + this.min_pos + " : " + this.max_pos + "\n start was originally : " + n4 + "\nstop was originally : " + n3 + "\nstart is now" + n + "\n stop is now" + n2);
                this.fillRect(graphics, (this.min_pos - this.shift + this.max_pos - 1) % this.max_pos + 1, (n2 - this.shift + this.max_pos - 1) % this.max_pos + 1, d, d2);
                n2 = this.max_pos;
            }
        }
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n4 = n2 - n;
            n3 = n;
            n = this.max_pos - n2 + 1;
            n2 = this.max_pos - n3 + 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = n2 - n;
        n3 = new Double(10.0 / this.pixelsPerPosScale).intValue();
        int n6 = n5 >= n3 ? (BasicPainter.APPEARFRAME > 0 ? n2 - n3 : n + n3) : (BasicPainter.APPEARFRAME > 0 ? n : n2);
        Point2D.Double double_2 = this.getPositionPoint(n);
        Point2D.Double double_3 = this.getPositionPoint(n2);
        Point2D.Double double_4 = this.getPositionPoint(n6);
        double d3 = d * (double)(d >= 0.0 ? this.above_pixels : this.below_pixels);
        double d4 = d3 - (double)(d2 >= 0.0 ? this.above_pixels : this.below_pixels) * d2;
        if (vert) {
            graphics2D.fill(new Rectangle2D.Double(double_2.x + d3 - d4, double_2.y, d4, double_3.y - double_2.y));
            return null;
        }
        if (this.isBreakable) {
            int n7 = this.nextBreakLineStartPosition(n);
            while (n7 < n2) {
                logger.debug(n7);
                double_ = this.getPositionPoint(n7 - 1);
                graphics2D.fill(new Rectangle2D.Double(double_2.x, double_2.y - d3, double_.x - double_2.x + this.pixelsPerPosScale, d4));
                double_2 = this.getPositionPoint(n7);
                n7 = this.nextBreakLineStartPosition(n7);
            }
        }
        Point2D.Double double_5 = null;
        double_ = null;
        Point2D.Double double_6 = null;
        Point2D.Double double_7 = null;
        Point2D.Double double_8 = null;
        Point2D.Double double_9 = null;
        Point2D.Double double_10 = null;
        if (BasicPainter.APPEARFRAME > 0) {
            double_5 = new Point2D.Double(double_2.x, double_2.y - d3);
            double_ = new Point2D.Double(double_2.x, double_2.y - d3 + d4);
            double_6 = new Point2D.Double(double_4.x, double_2.y - d3 + d4);
            double_7 = new Point2D.Double(double_4.x, double_2.y - d3 + d4 * 5.0 / 4.0);
            double_8 = new Point2D.Double(double_3.x, double_2.y - d3 + d4 * 1.0 / 2.0);
            double_9 = new Point2D.Double(double_4.x, double_2.y - d3 - d4 * 1.0 / 4.0);
            double_10 = new Point2D.Double(double_4.x, double_2.y - d3);
        } else {
            double_5 = new Point2D.Double(double_3.x, double_3.y - d3 + d4);
            double_ = new Point2D.Double(double_3.x, double_3.y - d3);
            double_6 = new Point2D.Double(double_4.x, double_2.y - d3);
            double_7 = new Point2D.Double(double_4.x, double_2.y - d3 - d4 * 1.0 / 4.0);
            double_8 = new Point2D.Double(double_2.x, double_2.y - d3 + d4 * 1.0 / 2.0);
            double_9 = new Point2D.Double(double_4.x, double_2.y - d3 + d4 * 5.0 / 4.0);
            double_10 = new Point2D.Double(double_4.x, double_2.y - d3 + d4);
        }
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        nArray[0] = new Double(double_5.x).intValue();
        nArray[1] = new Double(double_.x).intValue();
        nArray[2] = new Double(double_6.x).intValue();
        nArray[3] = new Double(double_7.x).intValue();
        nArray[4] = new Double(double_8.x).intValue();
        nArray[5] = new Double(double_9.x).intValue();
        nArray[6] = new Double(double_10.x).intValue();
        nArray2[0] = new Double(double_5.y).intValue();
        nArray2[1] = new Double(double_.y).intValue();
        nArray2[2] = new Double(double_6.y).intValue();
        nArray2[3] = new Double(double_7.y).intValue();
        nArray2[4] = new Double(double_8.y).intValue();
        nArray2[5] = new Double(double_9.y).intValue();
        nArray2[6] = new Double(double_10.y).intValue();
        Polygon polygon = new Polygon(nArray, nArray2, 7);
        return polygon;
    }

    public void setSplitArrow(boolean bl) {
        this.shouldSplit = bl;
    }

    public boolean isSplitArrow() {
        return this.shouldSplit;
    }

    public void setMaxPosition(int n) {
        this.max_pos = n;
    }

    public void setMinPosition(int n) {
        this.min_pos = n;
    }

    public String getSequence(int n) {
        return this.sequences[n];
    }

    public void setContigSeq(int n) {
        this.contigSeq = this.sequences[n];
    }

    static {
        logger = Logger.getLogger(TextLinearTarget.class);
    }
}

