/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.DTDMarkupSpecifier;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.client.URLLoader;
import ca.ucalgary.bluejay.client.impl.BluejayEventCoordinator;
import ca.ucalgary.bluejay.client.impl.BluejayParser;
import ca.ucalgary.bluejay.client.impl.BluejayURLLoader;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayAbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.CanvasMouseListener;
import ca.ucalgary.bluejay.gui.DataManager;
import ca.ucalgary.bluejay.gui.DataNavigator;
import ca.ucalgary.bluejay.gui.DisplayOptions;
import ca.ucalgary.bluejay.gui.ExpressionSliderWidget;
import ca.ucalgary.bluejay.gui.GeometryListWidget;
import ca.ucalgary.bluejay.gui.ImageCreator;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.LegendManager;
import ca.ucalgary.bluejay.gui.MaskPainter;
import ca.ucalgary.bluejay.gui.NavigateWidget;
import ca.ucalgary.bluejay.gui.NavigationManager;
import ca.ucalgary.bluejay.gui.OrientationTab;
import ca.ucalgary.bluejay.gui.RotateWidget;
import ca.ucalgary.bluejay.gui.Scale;
import ca.ucalgary.bluejay.gui.Searcher;
import ca.ucalgary.bluejay.gui.Selector;
import ca.ucalgary.bluejay.gui.ThumbnailManager;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.WaypointsTab;
import ca.ucalgary.bluejay.gui.Zoom;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.comparison.ComparisonTab;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.comparison.GenomeLabelPainter;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.menu.MicroArrayMenuManager;
import ca.ucalgary.bluejay.gui.menu.ViewMenuManager;
import ca.ucalgary.bluejay.gui.microarray.AnalysisMonitor;
import ca.ucalgary.bluejay.gui.microarray.DistanceSliderWidget;
import ca.ucalgary.bluejay.gui.microarray.MicroarrayFunctions;
import ca.ucalgary.bluejay.gui.microarray.player.ExperimentSelectorWidget;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.gui.util.Rounding;
import ca.ucalgary.bluejay.gui.util.SVGEventMasker;
import ca.ucalgary.bluejay.session.HistoryTable;
import ca.ucalgary.bluejay.session.StateCollection;
import ca.ucalgary.bluejay.util.SplashWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.text.DefaultStyledDocument;
import org.apache.batik.apps.svgbrowser.ThumbnailPanel;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.log4j.Logger;
import org.apache.xml.utils.PrefixResolver;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluejayDObjectList
extends JSVGCanvas
implements PropertyChangeListener,
PrefixResolver {
    private AbstractLinearGraphics alg;
    private Vector angles;
    private Vector reverses;
    private Vector focusPositions;
    private Vector shifts;
    private Vector shift_maxs;
    private int old_width;
    private boolean changed_layout;
    private DisplayOptions dos;
    private Dimension canvasSize;
    private boolean noWorker;
    private ImageCreator imageWorker;
    private JProgressBar progress;
    private BluejayEventCoordinator bec;
    private boolean clear;
    private JComponent shapeTab;
    private JComponent orientationTab;
    private JComponent waypointsTab;
    private RotateWidget rotate;
    private OrientationTab orient;
    private WaypointsTab waypts;
    private GeometryListWidget geometry;
    private ComparisonTab comparisonTab;
    private Zoom zoomerang;
    private Zoom batikZoom;
    private LegendManager legendManager;
    private ThumbnailManager thumbnailManager;
    private NavigationManager navigationManager;
    private JToolBar thumbnailBar;
    private Searcher searcher;
    private Selector selector;
    private JScrollPane textScrollPane;
    private final int TAB = 5;
    private Vector backbones = null;
    private Vector circularBackbones = null;
    private Vector circularSequences = null;
    private Hashtable circularBackboneTargets = null;
    private static JTextPane textView;
    private JComboBox sizes;
    private Font savePreference;
    private DTDMarkupSpecifier[] languages;
    private boolean memorySavingMode = false;
    private boolean wholeLegendPrinted = true;
    private boolean isMicro = false;
    private boolean drawingChromosomes = false;
    private boolean drawingCentromeres = false;
    private Point2D svgCanvasTranslation;
    private Document xmlDocument;
    private Document prev_xmlDocument;
    private DataManager dataManager;
    private DataNavigator dataNavigator;
    private Scale scaleComponent;
    private int lastEventIDActedOn = -76;
    private int selfLaunchedPropagationId = -67;
    public static final double ALMOST_ZERO = 1.0E-6;
    private BluejayParser dataParser;
    private SVGEventMasker svgEventMasker;
    private ViewMenuManager viewMenu;
    private ComparisonMenuManager compMgr;
    private MicroArrayMenuManager arrayMenu;
    private MicroarrayFunctions microArrayFunctions;
    private MultipleArrayViewer arrayViewer;
    private static StateCollection collection;
    private Frame topFrame;
    private VisibilityManager vizMgr = null;
    private int savedLOD;
    private double savedScale;
    private static BluejayURLLoader urlLoader;
    private static Logger logger;
    private ComparisonPool comparisonPool;
    private GenomeLabelPainter genomeLabelPainter;
    private String[] chrNames;
    private Color[] chrColors;
    private String[] parNames;
    private Hashtable<String, Color> parColors;
    private String organism;

    public BluejayDObjectList(DisplayOptions displayOptions, URLLoader uRLLoader, DTDMarkupSpecifier[] dTDMarkupSpecifierArray) {
        this(displayOptions, uRLLoader);
        this.setDTDMarkupSpecifiers(dTDMarkupSpecifierArray);
    }

    public BluejayDObjectList(DisplayOptions displayOptions, URLLoader uRLLoader) {
        this.dos = displayOptions;
        this.languages = null;
        Font font = new Font("Monospaced", 0, 14);
        textView = new JTextPane(new DefaultStyledDocument());
        textView.setEditable(false);
        SplashWindow.setStatus("Initializing Canvas...graphics library");
        this.alg = new BluejayAbstractLinearGraphics(this.dos);
        SplashWindow.setStatus("Initializing Canvas...zooming");
        this.zoomerang = new Zoom(Zoom.RESCALE_CHOICES);
        this.zoomerang.setEnabled(false);
        this.zoomerang.setEnabledAll(false);
        this.batikZoom = new Zoom(Zoom.RESCALE_CHOICES);
        this.batikZoom.setEnabled(false);
        this.batikZoom.setEnabledAll(false);
        this.batikZoom.setZoomFactor(100.0);
        this.xmlDocument = null;
        SplashWindow.setStatus("Initializing Canvas...data manager");
        this.dataManager = new DataManager(this);
        SplashWindow.setStatus("Initializing Canvas...navigation");
        this.svgEventMasker = new SVGEventMasker(false);
        this.dataNavigator = new DataNavigator(this, this.svgEventMasker);
        SplashWindow.setStatus("Initializing Canvas...parser");
        this.dataParser = new BluejayParser(this, this.languages);
        this.addJGVTComponentListener(new CanvasMouseListener(this, uRLLoader, this.svgEventMasker));
        SplashWindow.setStatus("Initializing Canvas...microarray tools");
        this.svgCanvasTranslation = new Point2D.Double(0.0, 0.0);
        this.microArrayFunctions = new MicroarrayFunctions(this, this.alg, this.dataManager);
        this.shapeTab = null;
        this.orientationTab = null;
        this.waypointsTab = null;
        this.orient = new OrientationTab();
        this.rotate = this.orient.getRotateWidget();
        this.geometry = new GeometryListWidget();
        this.comparisonTab = new ComparisonTab();
        this.waypts = new WaypointsTab(this.getFrame(), this);
        this.angles = new Vector();
        this.reverses = new Vector();
        this.focusPositions = new Vector();
        this.shifts = new Vector();
        this.shift_maxs = new Vector();
        this.thumbnailManager = new ThumbnailManager(this);
        this.legendManager = new LegendManager(this, this.alg, this.dataManager);
        this.navigationManager = new NavigationManager(this);
        SplashWindow.setStatus("Initializing Canvas...imaging");
        this.imageWorker = new ImageCreator(this);
        this.noWorker = true;
        this.canvasSize = new Dimension(2, 2);
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.bec = new BluejayEventCoordinator();
        this.clear = true;
        SplashWindow.setStatus("Initializing Canvas...for comparison environment");
        this.comparisonPool = new ComparisonPool();
        this.genomeLabelPainter = new GenomeLabelPainter(this);
    }

    public VisibilityManager getVisibilityManager() {
        return this.vizMgr;
    }

    public void setVisibilityManager(VisibilityManager visibilityManager, PropertyChangeListener propertyChangeListener) {
        this.vizMgr = visibilityManager;
        this.alg.setVisibilityManager(this.vizMgr);
        this.navigationManager.setVisibilityManager(this.vizMgr);
        this.dataNavigator.setVisibilityManager(this.vizMgr);
        this.batikZoom.setVisibilityManager(this.vizMgr);
        this.zoomerang.setVisibilityManager(this.vizMgr);
        this.waypts.setVisibilityManager(this.vizMgr);
        this.vizMgr.addPropertyChangeListener("scale in bases per pixel", this.scaleComponent);
        this.vizMgr.addPropertyChangeListener("scale in bases per pixel", this);
        this.vizMgr.addPropertyChangeListener("target drawn range", this);
        this.vizMgr.addPropertyChangeListener("scale in bases per pixel", propertyChangeListener);
        this.vizMgr.addPropertyChangeListener("target focus", propertyChangeListener);
        this.vizMgr.addPropertyChangeListener("target visible range", propertyChangeListener);
        this.vizMgr.addPropertyChangeListener("target drawn range", propertyChangeListener);
    }

    public void setFrame(Frame frame) {
        this.alg.setFrame(frame);
        this.topFrame = frame;
    }

    public Frame getFrame() {
        return this.topFrame;
    }

    public void setDisplayOptions(DisplayOptions displayOptions) {
        this.dos = displayOptions;
    }

    public void setDTDMarkupSpecifiers(DTDMarkupSpecifier[] dTDMarkupSpecifierArray) {
        this.languages = dTDMarkupSpecifierArray;
        this.dataParser.setDTDMarkupSpecifiers(dTDMarkupSpecifierArray);
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public DataNavigator getDataNavigator() {
        return this.dataNavigator;
    }

    public DTDElementInstance getDTDElementInstance(String string) {
        DTDElementInstance dTDElementInstance = null;
        if (this.dataManager.getXPtrToDeiMap() != null && string != null && this.dataManager.getXPtrToDeiMap().containsKey(string)) {
            dTDElementInstance = (DTDElementInstance)this.dataManager.getXPtrToDeiMap().get(string);
        }
        return dTDElementInstance;
    }

    @Override
    public String getBaseIdentifier() {
        return null;
    }

    @Override
    public String getNamespaceForPrefix(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        if ("xlink".equals(string)) {
            return "http://www.w3.org/1999/xlink";
        }
        for (int i = 0; i < this.languages.length; ++i) {
            if (!this.languages[i].getElementPrefix().equals(string)) continue;
            return this.languages[i].getNamespaceURI();
        }
        return null;
    }

    @Override
    public String getNamespaceForPrefix(String string, Node node) {
        return this.getNamespaceForPrefix(string);
    }

    @Override
    public boolean handlesNullPrefixes() {
        return false;
    }

    @Override
    public void setDocument(Document document) {
        this.prev_xmlDocument = document;
        this.xmlDocument = document;
    }

    public Document getDocument() {
        return this.xmlDocument;
    }

    private void addFontSize() {
        this.savePreference = this.dos.getFont();
        Vector<String> vector = new Vector<String>();
        int n = this.dos.getFont().getSize();
        int n2 = 0;
        int n3 = 8;
        do {
            vector.addElement("" + n3);
            if (n3 == n) {
                n2 = vector.size() - 1;
            }
            if (n3 <= 30) {
                n3 += 2;
                continue;
            }
            if (n3 <= 70) {
                n3 += 4;
                continue;
            }
            n3 += 8;
        } while (n3 < 50);
        this.sizes = new JComboBox(vector);
        this.sizes.setSelectedIndex(n2);
        this.sizes.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = (String)BluejayDObjectList.this.sizes.getSelectedItem();
                    Integer n = new Integer(string);
                    float f = n.floatValue();
                    BluejayDObjectList.this.dos.setFont(BluejayDObjectList.this.dos.getFont().deriveFont(f));
                    BluejayDObjectList.this.repaint(true);
                }
            }
        });
        this.sizes.setPreferredSize(new Dimension(100, 30));
        this.sizes.setMinimumSize(new Dimension(100, 30));
        this.sizes.setMaximumSize(new Dimension(100, 30));
    }

    private void removeFontSize() {
        if (this.sizes == null || this.sizes.getListeners(ItemListener.class) == null) {
            return;
        }
        EventListener[] eventListenerArray = this.sizes.getListeners(ItemListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            this.sizes.removeItemListener((ItemListener)eventListenerArray[i]);
        }
        this.dos.setFont(this.savePreference);
    }

    public JTextPane getTextView() {
        return textView;
    }

    public JComboBox getFontSizeZoom() {
        return this.sizes;
    }

    public void adjustShapeIfAfterTextMode() {
        if (this.alg.isInTextMode()) {
            Vector vector = this.alg.getTargetAppearances();
            for (int i = 0; i < vector.size(); ++i) {
                TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(i);
                targetAppearance.setCurrentCollection(this.getCurrentCollection());
                targetAppearance.resetDefaultShape();
            }
        }
    }

    public void singleFrameMode(boolean bl) {
        this.adjustShapeIfAfterTextMode();
        if (urlLoader.getHistoryTable() != null && urlLoader.getHistoryTable().get(urlLoader.getCurrentURL()) != null) {
            collection = this.getCurrentCollection();
        }
        collection.setView("Single Frame");
        textView.setText("");
        System.gc();
        this.removeFontSize();
        if (this.alg.isInTextMode()) {
            this.alg.setSingleFrameMode();
            this.alg.setLOD(this.savedLOD);
            this.vizMgr.setScale(this.savedScale);
        } else if ((this.alg.isBarChartMode() || this.alg.isPieChartMode()) && this.vizMgr.getScale() < 1.0) {
            this.alg.setSingleFrameMode();
            this.vizMgr.setScale(-5.898);
        } else {
            this.alg.setSingleFrameMode();
        }
        this.getViewMenu().getRbArrowShape().setSelected(true);
        this.getViewMenu().getRbBoxShape().setEnabled(false);
        this.alg.setArrowShape();
        if (bl) {
            this.dataNavigator.repaintScrollBars();
            this.scaleComponent.setScale(this.vizMgr.getScale());
            if (this.zoomerang.getCurrentZoom() == 0.0) {
                this.reconPaint();
            } else {
                this.repaint(true);
            }
        }
        this.zoomerang.setEnabledAll(true);
        this.batikZoom.setEnabledAll(true);
        this.enableInteractors();
        this.enableViewMenus();
    }

    public void twoFrameMode(boolean bl) {
        this.adjustShapeIfAfterTextMode();
        if (urlLoader.getHistoryTable() != null && urlLoader.getHistoryTable().get(urlLoader.getCurrentURL()) != null) {
            collection = this.getCurrentCollection();
        }
        if (collection.getFrameView() == "Single Frame") {
            this.alg.setRectShape();
            this.getViewMenu().getRbBoxShape().setEnabled(true);
            this.getViewMenu().getRbBoxShape().setSelected(true);
        }
        collection.setView("Two Frame");
        textView.setText("");
        System.gc();
        this.removeFontSize();
        if (this.alg.isInTextMode()) {
            this.alg.setTwoFrameMode();
            this.alg.setLOD(this.savedLOD);
            this.vizMgr.setScale(this.savedScale);
        } else if (this.alg.isInChartMode() && this.vizMgr.getScale() < 1.0) {
            this.alg.setTwoFrameMode();
            this.vizMgr.setScale(-5.898);
        } else {
            this.alg.setTwoFrameMode();
        }
        if (bl) {
            this.dataNavigator.repaintScrollBars();
            this.scaleComponent.setScale(this.vizMgr.getScale());
            if (this.zoomerang.getCurrentZoom() == 0.0) {
                this.reconPaint();
            } else {
                this.repaint(true);
            }
        }
        this.zoomerang.setEnabledAll(true);
        this.batikZoom.setEnabledAll(true);
        this.enableInteractors();
        this.enableViewMenus();
    }

    public void sixFrameMode(boolean bl) {
        this.adjustShapeIfAfterTextMode();
        if (urlLoader.getHistoryTable() != null && urlLoader.getHistoryTable().get(urlLoader.getCurrentURL()) != null) {
            collection = this.getCurrentCollection();
        }
        if (collection.getFrameView() == "Single Frame") {
            this.alg.setRectShape();
            this.getViewMenu().getRbBoxShape().setEnabled(true);
            this.getViewMenu().getRbBoxShape().setSelected(true);
        }
        collection.setView("Six Frame");
        textView.setText("");
        System.gc();
        this.removeFontSize();
        if (this.alg.isInTextMode()) {
            this.alg.setSixFrameMode();
            this.alg.setLOD(this.savedLOD);
            this.vizMgr.setScale(this.savedScale);
        } else if (this.alg.isInChartMode() && this.vizMgr.getScale() < 1.0) {
            this.alg.setSixFrameMode();
            this.vizMgr.setScale(-5.898);
        } else {
            this.alg.setSixFrameMode();
        }
        if (bl) {
            this.dataNavigator.repaintScrollBars();
            this.scaleComponent.setScale(this.vizMgr.getScale());
            if (this.zoomerang.getCurrentZoom() == 0.0) {
                this.reconPaint();
            } else {
                this.repaint(true);
            }
        }
        this.zoomerang.setEnabledAll(true);
        this.batikZoom.setEnabledAll(true);
        this.enableInteractors();
        this.enableViewMenus();
    }

    public void textHMode(boolean bl, boolean bl2) {
        if (urlLoader.getHistoryTable() != null && urlLoader.getHistoryTable().get(urlLoader.getCurrentURL()) != null) {
            collection = this.getCurrentCollection();
        }
        if (collection.getFrameView() == "Single Frame") {
            this.alg.setRectShape();
            this.getViewMenu().getRbBoxShape().setEnabled(true);
            this.getViewMenu().getRbBoxShape().setSelected(true);
        }
        collection.setView("Horizontal Sequential Text");
        textView.setText("");
        System.gc();
        this.removeFontSize();
        if (this.alg.isSingleFrameMode() || this.alg.isTwoFrameMode() || this.alg.isSixFrameMode()) {
            this.savedScale = this.vizMgr.getScale();
            this.savedLOD = this.alg.getLOD();
        }
        this.alg.setTextHMode();
        this.alg.setBreakable(bl2);
        this.alg.setLOD(80);
        Vector vector = this.alg.getTargetAppearances();
        for (int i = 0; i < vector.size(); ++i) {
            TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(i);
            targetAppearance.setCurrentCollection(this.getCurrentCollection());
            targetAppearance.setShape(119);
        }
        this.dataNavigator.repaintScrollBars();
        double d = ((BluejayAbstractLinearGraphics)this.alg).getCharWidth();
        this.vizMgr.setScale(1.0 / d);
        this.scaleComponent.setScale(this.vizMgr.getScale());
        if (this.zoomerang.getCurrentZoom() == 0.0) {
            this.reconPaint();
        } else {
            this.repaint(true);
        }
        this.zoomerang.setEnabledAll(false);
        this.batikZoom.setEnabledAll(false);
        this.enableInteractors();
        this.enableViewMenus();
    }

    public void textVMode(boolean bl) {
        if (urlLoader.getHistoryTable() != null && urlLoader.getHistoryTable().get(urlLoader.getCurrentURL()) != null) {
            collection = this.getCurrentCollection();
        }
        if (collection.getFrameView() == "Single Frame") {
            this.alg.setRectShape();
            this.getViewMenu().getRbBoxShape().setEnabled(true);
            this.getViewMenu().getRbBoxShape().setSelected(true);
        }
        collection.setView("Vertical Text");
        textView.setText("");
        System.gc();
        this.removeFontSize();
        if (this.alg.isSingleFrameMode() || this.alg.isTwoFrameMode() || this.alg.isSixFrameMode()) {
            this.savedScale = this.vizMgr.getScale();
            this.savedLOD = this.alg.getLOD();
        }
        this.alg.setTextVMode();
        this.alg.setLOD(80);
        Vector vector = this.alg.getTargetAppearances();
        for (int i = 0; i < vector.size(); ++i) {
            TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(i);
            targetAppearance.setCurrentCollection(this.getCurrentCollection());
            targetAppearance.setShape(120);
        }
        this.dataNavigator.repaintScrollBars();
        double d = ((BluejayAbstractLinearGraphics)this.alg).getCharHeight();
        this.vizMgr.setScale(1.0 / d);
        this.zoomerang.setEnabledAll(false);
        this.batikZoom.setEnabledAll(false);
        this.enableInteractors();
        this.enableViewMenus();
    }

    public void textMode(JScrollPane jScrollPane, boolean bl) {
        logger.error("This method is deprecated and should not be used.");
    }

    public void arrowShapeMode(boolean bl) {
        this.adjustShapeIfAfterTextMode();
        textView.setText("");
        System.gc();
        this.removeFontSize();
        this.alg.setArrowShape();
        if (bl) {
            this.dataNavigator.repaintScrollBars();
            this.zoomerang.setEnabledAll(true);
            this.batikZoom.setEnabledAll(true);
            this.scaleComponent.setScale(this.vizMgr.getScale());
            if (this.zoomerang.getCurrentZoom() == 0.0) {
                this.reconPaint();
            } else {
                this.repaint(true);
            }
        }
    }

    public void rectShapeMode(boolean bl) {
        this.adjustShapeIfAfterTextMode();
        textView.setText("");
        System.gc();
        this.removeFontSize();
        this.alg.setRectShape();
        if (bl) {
            this.dataNavigator.repaintScrollBars();
            this.zoomerang.setEnabledAll(true);
            this.batikZoom.setEnabledAll(true);
            this.scaleComponent.setScale(this.vizMgr.getScale());
            if (this.zoomerang.getCurrentZoom() == 0.0) {
                this.reconPaint();
            } else {
                this.repaint(true);
            }
        }
    }

    public void BarChartMode(boolean bl) {
        this.adjustShapeIfAfterTextMode();
        if (urlLoader.getHistoryTable() != null && urlLoader.getHistoryTable().get(urlLoader.getCurrentURL()) != null) {
            collection = this.getCurrentCollection();
        }
        collection.setView("Bar Chart");
        textView.setText("");
        System.gc();
        this.removeFontSize();
        this.alg.setBarChartMode();
        if (bl) {
            this.repaint(true);
        }
        this.zoomerang.setEnabledAll(false);
        this.batikZoom.setEnabledAll(false);
        this.enableInteractors();
        this.enableViewMenus();
    }

    public void PieChartMode(boolean bl) {
        this.adjustShapeIfAfterTextMode();
        if (urlLoader.getHistoryTable() != null && urlLoader.getHistoryTable().get(urlLoader.getCurrentURL()) != null) {
            collection = urlLoader.getHistoryTable().get(urlLoader.getCurrentURL());
        }
        collection.setView("Pie Chart");
        textView.setText("");
        System.gc();
        this.removeFontSize();
        this.alg.setPieChartMode();
        if (bl) {
            this.repaint(true);
        }
        this.zoomerang.setEnabledAll(false);
        this.batikZoom.setEnabledAll(false);
        this.enableInteractors();
        this.enableViewMenus();
    }

    public int getIndexOfCircularTarget(int n) {
        int n2 = -1;
        int n3 = -1;
        Vector vector = this.alg.getTargetAppearances();
        int n4 = vector.size();
        for (int i = 0; i < n4; ++i) {
            if (((TargetAppearance)vector.elementAt(i)).getShape() == 112) {
                ++n2;
            }
            if (n2 != n) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    public RotateWidget getRotateWidget() {
        return this.rotate;
    }

    public OrientationTab getOrientationWidget() {
        return this.orient;
    }

    public ComparisonTab getComparisonTab() {
        return this.comparisonTab;
    }

    public WaypointsTab getWaypointsWidget() {
        return this.waypts;
    }

    public ExpressionSliderWidget getExpressionWidget() {
        return this.microArrayFunctions.getExpressionWidget();
    }

    public ExperimentSelectorWidget getExperimentSelector() {
        return this.microArrayFunctions.getExperimentSelector();
    }

    public DistanceSliderWidget getDistanceWidget() {
        return this.microArrayFunctions.getDistanceWidget();
    }

    public GeometryListWidget getGeometryWidget() {
        return this.geometry;
    }

    public Vector getCircularBackbones() {
        return this.circularBackbones;
    }

    public Hashtable getCircularTargets() {
        return this.circularBackboneTargets;
    }

    Vector createCircularBackboneList() {
        Vector vector = this.alg.getTargetAppearances();
        int n = vector.size();
        this.circularBackbones = new Vector();
        this.circularBackboneTargets = new Hashtable();
        this.angles = new Vector();
        if (n > 1) {
            this.circularBackbones.addElement("All Backbones");
            this.angles.addElement(new Double(0.0));
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            if (((TargetAppearance)vector.elementAt(i)).getShape() != 112) continue;
            String string = new String("Backbone " + n2 + ": " + ((TargetAppearance)vector.elementAt(i)).getLocalName());
            TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(i);
            targetAppearance.setCurrentCollection(this.getCurrentCollection());
            Double d = new Double(Rounding.toString((1.0 - (double)targetAppearance.getTopPosition() / (double)targetAppearance.getMaxPosition()) * 360.0, 0));
            this.angles.addElement(d);
            this.circularBackbones.addElement(string);
            this.circularBackboneTargets.put(new Integer(i), targetAppearance);
        }
        return this.circularBackbones;
    }

    public Vector createRotationList() {
        ComparisonPool comparisonPool = this.getComparisonPool();
        Vector<Genome> vector = comparisonPool.getSeqsFromPool();
        int n = vector.size();
        this.circularSequences = new Vector();
        Vector vector2 = this.alg.getTargetAppearances();
        int n2 = vector2.size();
        this.angles = new Vector();
        if (n > 1) {
            this.circularSequences.addElement("All Sequences");
            this.angles.addElement(new Double(0.0));
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = i + 1;
            if (((TargetAppearance)vector2.elementAt(i)).getShape() != 112) continue;
            for (int j = 0; j < n; ++j) {
                String string = vector.elementAt(j).getGenomeName();
                String string2 = null;
                string2 = j == 0 ? new String("m: " + string) : new String("s" + j + ": " + string);
                TargetAppearance targetAppearance = (TargetAppearance)vector2.elementAt(i);
                targetAppearance.setCurrentCollection(this.getCurrentCollection());
                Double d = new Double(Rounding.toString((1.0 - (double)targetAppearance.getTopPosition() / (double)targetAppearance.getMaxPosition()) * 360.0, 0));
                this.angles.addElement(d);
                this.circularSequences.addElement(string2);
            }
        }
        return this.circularSequences;
    }

    public JComponent getShapeTab() {
        return this.shapeTab;
    }

    public JComponent getOrientationTab() {
        return this.orientationTab;
    }

    public JComponent getWaypointsTab() {
        return this.waypointsTab;
    }

    public void setShapeTab(JComponent jComponent) {
        this.shapeTab = jComponent;
    }

    public void setOrientationTab(JComponent jComponent) {
        this.orientationTab = jComponent;
    }

    public void setComparisonTab(JComponent jComponent) {
        this.comparisonTab = (ComparisonTab)jComponent;
    }

    public void setWaypointsTab(JComponent jComponent) {
        this.waypointsTab = jComponent;
    }

    Vector createAllBackboneList() {
        int n;
        Vector vector = this.alg.getTargetAppearances();
        int n2 = vector.size();
        logger.debug("DList.createAllBackboneList() -- number of targetelements = " + n2);
        this.geometry.removeAllGeometryPanels();
        this.backbones = new Vector();
        this.reverses = new Vector();
        this.focusPositions = new Vector();
        this.shifts = new Vector();
        this.shift_maxs = new Vector();
        if (n2 > 1) {
            this.backbones.addElement("All Backbones");
            this.geometry.addAllPanel("All BackBones");
            this.reverses.addElement(new Boolean(false));
            this.focusPositions.addElement(new Integer(1));
            this.shifts.addElement(new Integer(1));
            this.shift_maxs.addElement(new Integer(Integer.MAX_VALUE));
        } else {
            this.geometry.removeAllPanel();
        }
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(n);
            targetAppearance.setCurrentCollection(this.getCurrentCollection());
            String string = new String("Backbone " + (n + 1) + ": " + targetAppearance.getLocalName());
            this.backbones.addElement(string);
            boolean bl2 = targetAppearance.getShape() == 112;
            this.geometry.addGeometryPanel(string, bl2);
            if (targetAppearance.isReverseComplement()) {
                this.reverses.addElement(new Boolean(true));
            } else {
                this.reverses.addElement(new Boolean(false));
                bl = false;
            }
            int n3 = this.dataNavigator.getPositionInFocus(n);
            this.focusPositions.addElement(new Integer(n3));
            int n4 = -targetAppearance.getShift() + 1;
            this.shifts.addElement(new Integer(n4));
            this.shift_maxs.addElement(new Integer(targetAppearance.getMaxPosition()));
        }
        if (n2 > 1) {
            if (bl) {
                this.reverses.remove(0);
                this.reverses.insertElementAt(new Boolean(true), 0);
            }
            this.shift_maxs.trimToSize();
            n = Integer.MAX_VALUE;
            for (int i = 1; i < this.shift_maxs.size(); ++i) {
                if ((Integer)this.shift_maxs.elementAt(i) >= n) continue;
                n = (Integer)this.shift_maxs.elementAt(i);
            }
            this.shift_maxs.remove(0);
            this.shift_maxs.insertElementAt(new Integer(n), 0);
            this.orient.getReverseComplementWidget().setAllReversed(bl);
        }
        return this.backbones;
    }

    public ThumbnailPanel getThumbnailPanel() {
        return this.thumbnailManager.getThumbnailPanel();
    }

    public JToolBar getLegendBar() {
        return this.legendManager.getLegendBar();
    }

    public JToolBar getThumbnailBar() {
        return this.thumbnailManager.getThumbnailBar();
    }

    public JToolBar getNavigationBar() {
        return this.navigationManager.getNavigationBar();
    }

    public NavigateWidget getNavigationPanel() {
        return this.navigationManager.getNavigationPanel();
    }

    public void switchLegendBarLayout() {
        this.legendManager.switchLegendBarLayout();
    }

    public void switchThumbnailBarLayout() {
        this.thumbnailManager.switchThumbnailBarLayout();
    }

    public void switchNavigationBarLayout() {
        this.navigationManager.switchNavigationBarLayout();
    }

    public Legend getLegend() {
        return this.legendManager.getLegendPanel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.vizMgr && !ComparisonMenuManager.isReshuffle) {
            int n;
            int n2 = (Integer)propertyChangeEvent.getNewValue();
            int n3 = n = propertyChangeEvent.getPropagationId() == null ? -67 : (Integer)propertyChangeEvent.getPropagationId();
            if ("scale in bases per pixel".equals(propertyChangeEvent.getPropertyName())) {
                if (this.svgEventMasker.isZoomIgnoring()) {
                    return;
                }
                if (this.lastEventIDActedOn == n2 || n != -67 && this.selfLaunchedPropagationId == n) {
                    return;
                }
                this.lastEventIDActedOn = n2;
                double d = this.vizMgr.getScale();
                double d2 = (Double)propertyChangeEvent.getOldValue();
                if (d == -3.73) {
                    if (d2 == -5.898) {
                        return;
                    }
                    this.reconPaint();
                    return;
                }
                if (d2 != -5.898 && d != -5.898) {
                    int n4 = this.vizMgr.getFocusTarget();
                    if (this.vizMgr.isCompleteTargetVisible(n4) && d > d2) {
                        this.repaint(true);
                        return;
                    }
                    double d3 = d / d2;
                    int[] nArray = this.getRectRange(d3, this.vizMgr.getFocusTarget(), this.vizMgr.getFocusPosition());
                    this.selfLaunchedPropagationId = this.vizMgr.usePropagationId(true);
                    this.vizMgr.setPropagation(false);
                    this.vizMgr.setVisibleRange(n4, nArray[0], nArray[1]);
                    this.vizMgr.setPropagation(true);
                    this.vizMgr.usePropagationId(false);
                    this.repaint(true);
                }
            } else if ("target drawn range".equals(propertyChangeEvent.getPropertyName())) {
                if (this.svgEventMasker.isTranslationIgnoring()) {
                    return;
                }
                this.svgEventMasker.setTranslationIgnoring(true);
                if (this.lastEventIDActedOn != n2 && (n == -67 || this.selfLaunchedPropagationId != n)) {
                    this.lastEventIDActedOn = n2;
                    this.alg.removeAllTargets();
                    this.repaint(true);
                }
                this.svgEventMasker.setTranslationIgnoring(false);
            } else {
                logger.warn("Programmer error: BluejayDObjectList got vizMgr's propertyChange callback with an unrecognized property name (" + propertyChangeEvent.getPropertyName() + "), ignoring");
            }
        }
    }

    public Point2D getTranslation() {
        return this.svgCanvasTranslation;
    }

    public void setTranslation(double d, double d2) {
        if (d != (double)((int)this.svgCanvasTranslation.getX()) || d2 != (double)((int)this.svgCanvasTranslation.getX())) {
            this.svgCanvasTranslation = new Point2D.Double(d, d2);
        }
    }

    public boolean getInTab() {
        return this.thumbnailManager.isInTab();
    }

    public Zoom getZoom() {
        return this.zoomerang;
    }

    public Zoom getBatikZoom() {
        return this.batikZoom;
    }

    public double getScale() {
        return this.alg.getScale();
    }

    public void setClear(boolean bl) {
        this.clear = bl;
    }

    public SVGEventMasker getSvgEventMasker() {
        return this.svgEventMasker;
    }

    public void setScale(double d) {
        this.alg.setScale(d);
    }

    public void reconPaint() {
        logger.info("### DList.reconPaint() start");
        int n = this.alg.getLOD();
        this.alg.setScale(-5.898);
        this.alg.resetPageSize();
        this.dataNavigator.recalculateScrollBars(this.getSize());
        if (this.alg.isSingleFrameMode() || this.alg.isTwoFrameMode() || this.alg.isSixFrameMode()) {
            this.zoomerang.setEnabledAll(true);
            this.batikZoom.setEnabledAll(true);
        }
        this.repaint(true);
    }

    public void reRender() {
        GraphicsNode graphicsNode = this.getGraphicsNode();
        if (graphicsNode != null) {
            Stack<Node> stack = new Stack<Node>();
            Stack<Boolean> stack2 = new Stack<Boolean>();
            Element element = this.xmlDocument.getDocumentElement();
            if (element != null) {
                stack.push(element);
                stack2.push(Boolean.TRUE);
                while (!stack.empty()) {
                    Node node;
                    boolean bl;
                    Node node2 = (Node)stack.pop();
                    boolean bl2 = bl = ((Boolean)stack2.pop()).booleanValue();
                    if (node2 instanceof DTDElementInstance) {
                        node = (DTDElementInstance)node2;
                        bl2 = bl && node.getVisibility() != 114 && node.isModelVisible();
                        List list = node.getGVTNodeList();
                        if (list != null) {
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                ((GraphicsNode)iterator.next()).setVisible(bl2);
                            }
                        }
                    }
                    for (node = node2.getFirstChild(); node != null; node = node.getNextSibling()) {
                        stack.push(node);
                        stack2.push(bl2 ? Boolean.TRUE : Boolean.FALSE);
                    }
                }
            }
        }
        this.renderGVTTree();
    }

    public void repaintSynchronous() throws InterruptedException {
        this.clear = false;
        logger.info("Dlist.repaintSynchronous() -- WE ARE ATTEMPTING THE IMAGE CREATION**********************************");
        if (!this.noWorker) {
            logger.info("Dlist.repaintSynchronous() -- There is a Worker**********************************************");
            this.imageWorker.stop();
        }
        this.imageWorker = new ImageCreator(this);
        this.noWorker = false;
        this.imageWorker.goSynchronous();
        this.batikZoom.setZoomFactor(100.0);
    }

    public void repaint(boolean bl) {
        if (!bl) {
            return;
        }
        this.clear = false;
        if (!this.noWorker) {
            this.imageWorker.stop();
        }
        this.imageWorker = new ImageCreator(this);
        this.noWorker = false;
        this.imageWorker.go();
        this.batikZoom.setZoomFactor(100.0);
    }

    public AbstractLinearGraphics getAbstractLinearGraphics() {
        return this.alg;
    }

    void setChangedLayout(boolean bl) {
        this.changed_layout = bl;
    }

    void setNoWorker(boolean bl) {
        this.noWorker = bl;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (Debug.DEBUG) {
            this.imageWorker.check(graphics);
        }
        super.paintComponent(graphics);
        if (!this.changed_layout && !this.clear) {
            this.alg.paint(graphics);
        }
        if (!this.alg.isInChartMode()) {
            Dimension dimension = ((JViewport)this.getParent()).getExtentSize();
            Dimension dimension2 = this.scaleComponent.getPreferredSize();
            graphics.translate(dimension.width - dimension2.width, dimension.height - dimension2.height);
            this.scaleComponent.paint(graphics);
            if (ComparisonMenuManager.isComparison && this.getComparisonPool().getPoolSize() > 1) {
                graphics.translate(-(dimension.width - dimension2.width), -(dimension.height - dimension2.height));
                this.genomeLabelPainter.paint(graphics, dimension);
            } else if (this.drawingChromosomes) {
                graphics.translate(-(dimension.width - dimension2.width), -(dimension.height - dimension2.height));
                this.genomeLabelPainter.paintChrLegend(graphics, dimension, ((BluejayAbstractLinearGraphics)this.alg).getLLPainter());
            }
        }
    }

    public void setRoot(DTDElementInstance dTDElementInstance) {
        if (this.xmlDocument.getDocumentElement() != null) {
            this.xmlDocument.replaceChild(dTDElementInstance, this.xmlDocument.getDocumentElement());
        } else if (!this.xmlDocument.hasChildNodes()) {
            this.xmlDocument.appendChild(dTDElementInstance);
        } else {
            logger.error("### ERROR: xmlDocument  non-empty but top element is null");
            new Exception("### ERROR: xmlDocument  non-empty but top element is null").printStackTrace();
        }
        this.vizMgr.clearVisibleTargets();
        dTDElementInstance.getPainter().preProcess(this.alg, null, dTDElementInstance);
        this.getLegend().clearClicks();
        this.legendManager.buildLegend(this.xmlDocument);
        this.alg.setTitle("");
        this.dataParser.releaseParsers();
    }

    public void repaintLegendUsing(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4) {
        if (urlLoader.getHistoryTable() != null && urlLoader.getHistoryTable().get(urlLoader.getCurrentURL()) != null) {
            collection = this.getCurrentCollection();
        }
        this.legendManager.repaintLegendUsing(hashtable, hashtable2, hashtable3, hashtable4, collection);
    }

    public void repaintLegendUsing(Hashtable hashtable, Hashtable hashtable2) {
        if (urlLoader.getHistoryTable() != null && urlLoader.getHistoryTable().get(urlLoader.getCurrentURL()) != null) {
            collection = this.getCurrentCollection();
        }
        this.legendManager.repaintLegendUsing(hashtable, hashtable2, collection);
    }

    public synchronized void prepareStuff() {
        this.bec.notify(8, "Creating Image...");
        logger.info("### DList.doStuff() BEGIN Preparing Image... Painting canvas laid out again");
        this.legendManager.updateLegendPainting();
        this.changed_layout = true;
        this.dataNavigator.doSmartPositioning();
        if (this.isEmptyDOM()) {
            System.out.println("######### ok, the data need to be reparsed in BluejayDObjectList Class");
            this.dataParser.reparse();
        }
    }

    public synchronized int doStuff() {
        block15: {
            this.prepareStuff();
            BluejayDObjectList bluejayDObjectList = this;
            Dimension dimension = ((JViewport)bluejayDObjectList.getParent()).getExtentSize();
            this.alg.resetPageSize();
            this.alg.startPage(bluejayDObjectList, dimension);
            try {
                if (Debug.DEBUG) {
                    this.imageWorker.check(this.alg);
                }
                Element element = this.xmlDocument.getDocumentElement();
                if (this.alg.isBarChartMode()) {
                    this.legendManager.sortSynchronous();
                    this.alg.makeBarChart();
                } else if (this.alg.isPieChartMode()) {
                    this.legendManager.sortSynchronous();
                    this.alg.makePieChart();
                } else if (element != null) {
                    logger.info("DList.doStuff() -- Start painting at root node");
                    ((DTDElementInstance)element).resetPaintProgressStatus(this.progress);
                    ((DTDElementInstance)element).paint(this.alg);
                }
                if (Debug.DEBUG) {
                    this.imageWorker.check(this.alg);
                }
                this.canvasSize = this.alg.endPage();
                if (this.isMemorySavingMode()) {
                    this.dataManager.clearDOMTrees();
                }
                if (!this.alg.isInChartMode()) {
                    this.dataNavigator.recalculateScrollBars(dimension);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.error("DList.doStuff() Exception -- " + exception.getMessage());
                if (exception.getMessage() != "imageSizeExceeded message") break block15;
                logger.error("### DList.doStuff() return ImageCreator.IMAGE_SIZE_EXCEEDED -- dealing with expand canvas issue.");
                return -10;
            }
        }
        if (this.wholeLegendPrinted && !this.isMicro && this.comparisonPool.isPoolEmpty()) {
            this.getLegendManager().getLegendPanel().clear();
            this.getLegendManager().buildLegendItemsPublic();
            if (this.alg.isSingleFrameMode() || this.alg.isTwoFrameMode() || this.alg.isSixFrameMode()) {
                this.viewMenu.getFullLegend().setEnabled(true);
            }
        } else {
            if (!this.comparisonPool.isPoolEmpty() || this.isMicro) {
                this.viewMenu.getFullLegend().setEnabled(false);
                this.viewMenu.getPartialLegend().setSelected(true);
            }
            this.legendManager.setIgnoreLegendRedrawWhileRepainting(false);
            this.legendManager.updateLegendPainting();
        }
        logger.debug("### DList.doStuff() DONE, return ZERO, LOD=" + this.alg.getLOD());
        new Thread(){

            public void run() {
                System.runFinalization();
                System.gc();
            }
        }.start();
        return 0;
    }

    public void setIsMicro(boolean bl) {
        this.isMicro = bl;
    }

    public void reverseComplement() {
        logger.debug("DList.reverseComplement()");
        DefaultComboBoxModel defaultComboBoxModel = this.orient.getReverseComplementWidget().getModel();
        Vector vector = this.alg.getTargetAppearances();
        if (vector.size() == 1) {
            TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(0);
            targetAppearance.setCurrentCollection(this.getCurrentCollection());
            targetAppearance.setReverseComplement(!targetAppearance.isReverseComplement());
            logger.debug("DList.reverseComplement() -- we got into single case reverse");
        } else {
            int n = this.backbones.indexOf(defaultComboBoxModel.getSelectedItem()) - 1;
            if (n == -1) {
                logger.debug("DList.reverseComplement() -- special case here for reverse" + this.orient.getReverseComplementWidget().getAllReversed());
                for (int i = 0; i < vector.size(); ++i) {
                    TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(i);
                    targetAppearance.setCurrentCollection(this.getCurrentCollection());
                    targetAppearance.setReverseComplement(!this.orient.getReverseComplementWidget().getAllReversed());
                }
                this.orient.getReverseComplementWidget().setAllReversed(!this.orient.getReverseComplementWidget().getAllReversed());
            } else {
                TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(n);
                targetAppearance.setCurrentCollection(this.getCurrentCollection());
                targetAppearance.setReverseComplement(!targetAppearance.isReverseComplement());
            }
        }
        this.repaint(true);
    }

    public int setGeometry(int n, int n2, int n3) {
        int n4 = 2;
        TargetAppearance targetAppearance = (TargetAppearance)this.alg.getTargetAppearances().elementAt(n2);
        targetAppearance.setCurrentCollection(this.getCurrentCollection());
        targetAppearance.setShape(n);
        if (n == 112) {
            targetAppearance.setTopPosition(n3);
            n4 = 3;
        }
        this.repaint(true);
        return n4;
    }

    public void setRotation(int n, int n2) {
        TargetAppearance targetAppearance = (TargetAppearance)this.alg.getTargetAppearances().elementAt(n2);
        targetAppearance.setCurrentCollection(this.getCurrentCollection());
        targetAppearance.setTopPosition(n);
        this.repaint(true);
    }

    public void shift(int n) {
        this.orient.getShiftWidget().setSliderValue(n);
        this.shift();
    }

    public void shift() {
        DefaultComboBoxModel defaultComboBoxModel = this.orient.getShiftWidget().getModel();
        Vector vector = this.alg.getTargetAppearances();
        if (vector.size() == 1) {
            TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(0);
            targetAppearance.setCurrentCollection(this.getCurrentCollection());
            int n = this.orient.getShiftWidget().getCurrentShift();
            logger.debug("shift position is: " + n);
            if (n != -1) {
                targetAppearance.setShift(-(n - 1));
            } else {
                logger.warn("shift doesn't have an appropriate value");
            }
        } else {
            int n = this.backbones.indexOf(defaultComboBoxModel.getSelectedItem()) - 1;
            if (n == -1) {
                for (int i = 0; i < vector.size(); ++i) {
                    TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(i);
                    targetAppearance.setCurrentCollection(this.getCurrentCollection());
                    int n2 = this.orient.getShiftWidget().getCurrentShift();
                    logger.debug("shift position is: " + n2);
                    if (n2 != -1) {
                        targetAppearance.setShift(-(n2 - 1));
                        continue;
                    }
                    logger.warn("shift doesn't have an appropriate value");
                }
            } else {
                TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(n);
                targetAppearance.setCurrentCollection(this.getCurrentCollection());
                int n3 = this.orient.getShiftWidget().getCurrentShift();
                if (n3 != -1) {
                    targetAppearance.setShift(-(n3 - 1));
                } else {
                    logger.warn("shift doesn't have an appropriate value");
                }
            }
        }
        this.repaint(true);
    }

    public void rotateAll(double d) {
        Vector vector = this.alg.getTargetAppearances();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (((TargetAppearance)vector.elementAt(i)).getShape() != 112) continue;
            this.actualRotate(i, d);
        }
        this.repaint(true);
    }

    private void actualCumulativeRotate(int n, double d) {
        TargetAppearance targetAppearance = (TargetAppearance)this.alg.getTargetAppearances().elementAt(n);
        targetAppearance.setCurrentCollection(this.getCurrentCollection());
        int n2 = (int)((double)targetAppearance.getMaxPosition() * (d / 360.0));
        logger.debug("DList.actualCumulativeRotate() -- x: " + n2 + " out of: " + targetAppearance.getMaxPosition() + " position" + (double)n2 / (double)targetAppearance.getMaxPosition() + "rotation" + d / 360.0);
        targetAppearance.setTopPosition((targetAppearance.getMaxPosition() + targetAppearance.getTopPosition() - n2) % targetAppearance.getMaxPosition());
    }

    private void actualRotate(int n, double d) {
        TargetAppearance targetAppearance = (TargetAppearance)this.alg.getTargetAppearances().elementAt(n);
        targetAppearance.setCurrentCollection(this.getCurrentCollection());
        System.out.println("*****AD:: DList.actualRotate() max position is: " + targetAppearance.getMaxPosition());
        System.out.println("*****AD:: DList.actualRotate() top position is: " + targetAppearance.getTopPosition());
        int n2 = (int)((double)targetAppearance.getMaxPosition() * (d / 360.0));
        logger.debug("DList.actualRotate() -- x: " + n2 + " out of: " + targetAppearance.getMaxPosition() + " position" + (double)n2 / (double)targetAppearance.getMaxPosition() + "rotation" + d / 360.0);
        if ((targetAppearance.getMaxPosition() - n2) % targetAppearance.getMaxPosition() < 1 && (targetAppearance.getMaxPosition() - n2) % targetAppearance.getMaxPosition() > -1) {
            targetAppearance.setTopPosition(1);
        } else {
            targetAppearance.setTopPosition((targetAppearance.getMaxPosition() - n2) % targetAppearance.getMaxPosition());
        }
        System.out.println("*****AD:: DList.actualRotate() top position after rotation is: " + targetAppearance.getTopPosition());
    }

    public void rotate(int n, double d) {
        this.actualRotate(n, d);
        this.repaint(true);
    }

    public void updateWidgetModels() {
        Vector vector = this.createAllBackboneList();
        Vector vector2 = null;
        vector2 = ComparisonMenuManager.isComparison && this.getComparisonPool().getPoolSize() > 1 ? this.createRotationList() : this.createCircularBackboneList();
        if (vector.size() < 1) {
            this.navigationManager.setEnabledAll(false);
            this.geometry.setEnabledAll(false);
            this.orient.getReverseComplementWidget().setEnabledAll(false);
            this.orient.getShiftWidget().setEnabledAll(false);
        } else {
            this.navigationManager.setEnabledAll(true);
            this.geometry.setEnabledAll(true);
            this.orient.getReverseComplementWidget().setEnabledAll(true);
            this.orient.getShiftWidget().setEnabledAll(true);
        }
        if (vector2.size() < 1) {
            this.rotate.setEnabledAll(false);
        } else {
            this.rotate.setEnabledAll(true);
        }
        this.rotate.updateModel(new DefaultComboBoxModel(vector2), this.angles);
        this.orient.updateModel(new DefaultComboBoxModel(vector2), this.angles, new DefaultComboBoxModel(vector), this.reverses, new DefaultComboBoxModel(vector), this.shifts, this.shift_maxs);
        this.navigationManager.updateModel(new DefaultComboBoxModel(vector), this.focusPositions, this.shift_maxs);
    }

    public void setEventCoordinator(BluejayEventCoordinator bluejayEventCoordinator) {
        this.bec = bluejayEventCoordinator;
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public BluejayEventCoordinator getEventCoordinator() {
        return this.bec;
    }

    public void setProgressBar(JProgressBar jProgressBar) {
        this.progress = jProgressBar;
        MaskPainter.setJProgressBar(jProgressBar);
    }

    public JProgressBar getProgressBar() {
        return this.progress;
    }

    public Dimension getPreferredCanvasSize() {
        return this.canvasSize;
    }

    public void setSizeBar(Dimension dimension, Dimension dimension2) {
        if (this.alg.isBarChartMode() && (dimension.getWidth() != dimension2.getWidth() || dimension.getHeight() != dimension2.getHeight())) {
            this.dataNavigator.recalculateScrollBars(dimension);
            logger.debug("\nNew Dimension : " + dimension);
            ((JViewport)this.getParent()).setExtentSize(dimension);
            super.setSize(dimension);
            this.repaint(true);
        }
    }

    @Override
    public void setSize(Dimension dimension) {
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = ((JViewport)this.getParent()).getExtentSize();
        boolean bl = dimension3.getWidth() > dimension2.getWidth() || dimension3.getHeight() > dimension2.getHeight();
        this.dataNavigator.recalculateScrollBars(dimension3);
        logger.debug("### DList.setSize() asked d=" + dimension + ", switch to=" + dimension3);
        super.setSize(dimension3);
        if (bl && this.alg.hasPositionsOutsideVisibleRange()) {
            this.repaint(true);
        }
    }

    public BluejayParser getBluejayParser() {
        return this.dataParser;
    }

    public boolean isMemorySavingMode() {
        return this.memorySavingMode;
    }

    public void setMemorySavingMode(boolean bl) {
        this.memorySavingMode = bl;
    }

    public void releaseRenderingReferences(Object object) throws IllegalAccessException {
        boolean bl = object instanceof DataManager;
        if (!bl) {
            logger.error("IllegalAccessException: Access to methodBluejayDObjectList.releaseRenderingReferences() not allowed from instances of " + (object == null ? "null" : object.getClass().getName()));
            throw new IllegalAccessException("Method access not allowed");
        }
        this.releaseRenderingReferences();
    }

    public boolean isEmptyDOM() {
        return this.xmlDocument == null || this.xmlDocument.getDocumentElement() == null || this.xmlDocument.getDocumentElement().getFirstChild() == null;
    }

    public boolean isGVTTreeAccessible() {
        return this.gvtTreeBuilder == null && this.gvtRoot != null && this.svgDocument != null && this.svgDocument.getDocumentElement() != null;
    }

    public void disposeBridgeContext() {
        if (this.isGVTTreeAccessible() && this.bridgeContext != null) {
            this.bridgeContext.dispose();
        }
    }

    public void setArrayViewer(MultipleArrayViewer multipleArrayViewer) {
        this.arrayViewer = multipleArrayViewer;
        this.alg.setArrayViewer(this.arrayViewer);
        this.alg.setAnalysisMonitor(this.getAnalysisMonitor());
        this.microArrayFunctions.setArrayViewer(this.arrayViewer);
        this.arrayViewer.setMicroArrayFunctions(this.microArrayFunctions);
    }

    public void changeExpressionLanes() {
        AbstractGraphicsNode abstractGraphicsNode = null;
        ShapeNode shapeNode = null;
        AbstractGraphicsNode abstractGraphicsNode2 = null;
        ShapeNode shapeNode2 = null;
        Vector vector = this.alg.getTargetAppearances();
        String string = ((TargetAppearance)vector.elementAt(0)).getXPointer();
        Vector vector2 = (Vector)this.dataManager.getXPtrToGVTMap().get(string);
        if (vector2 != null) {
            int n = vector2.size();
            for (int i = 0; i < n; ++i) {
                GraphicsNode graphicsNode = (GraphicsNode)vector2.elementAt(i);
                if (!(graphicsNode instanceof ShapeNode)) continue;
                if (abstractGraphicsNode == null) {
                    shapeNode = this.checkIfShapesAreSame(graphicsNode, vector2);
                    if (shapeNode == null) continue;
                    abstractGraphicsNode = (ShapeNode)graphicsNode;
                    continue;
                }
                if (abstractGraphicsNode2 != null || (shapeNode2 = this.checkIfShapesAreSame(graphicsNode, vector2)) == null || shapeNode2.hashCode() == shapeNode.hashCode() || shapeNode2.hashCode() == abstractGraphicsNode.hashCode()) continue;
                abstractGraphicsNode2 = (ShapeNode)graphicsNode;
            }
        }
        try {
            if (abstractGraphicsNode.getBounds().getWidth() < abstractGraphicsNode2.getBounds().getWidth()) {
                AbstractGraphicsNode abstractGraphicsNode3 = abstractGraphicsNode;
                ShapeNode shapeNode3 = shapeNode;
                abstractGraphicsNode = abstractGraphicsNode2;
                shapeNode = shapeNode2;
                abstractGraphicsNode2 = abstractGraphicsNode3;
                shapeNode2 = shapeNode3;
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        this.renderGVTTree();
    }

    public ShapeNode checkIfShapesAreSame(GraphicsNode graphicsNode, Vector vector) {
        Shape shape = ((ShapeNode)graphicsNode).getShape();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Shape shape2;
                GraphicsNode graphicsNode2 = (GraphicsNode)vector.elementAt(i);
                if (!(graphicsNode2 instanceof ShapeNode) || graphicsNode.hashCode() == graphicsNode2.hashCode() || !(shape2 = ((ShapeNode)graphicsNode2).getShape()).getBounds().equals(shape.getBounds())) continue;
                return (ShapeNode)graphicsNode2;
            }
        }
        return null;
    }

    public boolean setVisibilityForNode(Object object, int n) {
        Vector vector;
        boolean bl = false;
        if (object != null && (vector = (Vector)this.dataManager.getXPtrToGVTMap().get(object)) != null) {
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                GraphicsNode graphicsNode = (GraphicsNode)vector.elementAt(i);
                if (!(graphicsNode instanceof ShapeNode) || !(((ShapeNode)graphicsNode).getShapePainter() instanceof CompositeShapePainter)) continue;
                CompositeShapePainter compositeShapePainter = (CompositeShapePainter)((ShapeNode)graphicsNode).getShapePainter();
                boolean bl2 = true;
                int n3 = 0;
                while (bl2) {
                    int n4;
                    if (n3 == compositeShapePainter.getShapePainterCount()) {
                        bl2 = false;
                    } else if (compositeShapePainter.getShapePainter(n3) instanceof FillShapePainter && (n4 = graphicsNode.getDataVisibility()) != n) {
                        if (this.getAnalysisMonitor().isMicroArrayElementPaintable((String)object) || n == 114) {
                            graphicsNode.setDataVisibility(n);
                            if (!bl) {
                                bl = true;
                            }
                        } else if (n4 != 113) {
                            graphicsNode.setDataVisibility(113);
                            if (!bl) {
                                bl = true;
                            }
                        }
                        bl2 = false;
                    }
                    ++n3;
                }
            }
        }
        return bl;
    }

    public void refreshDisplay() {
        this.renderGVTTree();
    }

    public void setViewMenu(ViewMenuManager viewMenuManager) {
        this.viewMenu = viewMenuManager;
    }

    public void setArrayMenu(MicroArrayMenuManager microArrayMenuManager) {
        this.microArrayFunctions.setArrayMenu(microArrayMenuManager);
    }

    public ViewMenuManager getViewMenu() {
        return this.viewMenu;
    }

    public void showAnalysisTab() {
        if (!this.viewMenu.getcbAnalysis().isSelected()) {
            this.viewMenu.getcbAnalysis().setSelected(true);
        }
    }

    public void showMicroarrayTab() {
        if (!this.viewMenu.getcbMicroArray().isSelected()) {
            this.viewMenu.getcbMicroArray().setSelected(true);
        }
    }

    public void enableMicroArrayMenu() {
        this.microArrayFunctions.enableMicroArrayMenu();
    }

    public void disableSaveRatioValues() {
        this.microArrayFunctions.disableSaveRatioValues();
    }

    public void enableSaveRatioValues() {
        this.microArrayFunctions.enableSaveRatioValues();
    }

    public MultipleArrayViewer getArrayViewer() {
        return this.arrayViewer;
    }

    public AnalysisMonitor getAnalysisMonitor() {
        return this.microArrayFunctions.getAnalysisMonitor();
    }

    public MicroarrayFunctions getMicroarrayFunctions() {
        return this.microArrayFunctions;
    }

    public void resetMicroArrayTreeMaps() {
        this.alg.resetMicroArrayTreeMaps();
    }

    public int[] getRectRange(double d, int n, int n2) {
        Object object;
        boolean bl;
        Dimension dimension = ((JViewport)this.getParent()).getExtentSize();
        dimension.width = (int)((double)dimension.width * d);
        dimension.height = (int)((double)dimension.height * d);
        if (dimension.width < 2) {
            dimension.width = 2;
        }
        if (dimension.height < 2) {
            dimension.height = 2;
        }
        double d2 = 0.0;
        Point point = this.alg.getPoint(n, n2, d2);
        Point point2 = this.alg.getPoint(n, this.alg.getTarget(n).getMinPosition(), d2);
        Point point3 = this.alg.getPoint(n, this.alg.getTarget(n).getMaxPosition(), d2);
        int n3 = point.x - dimension.width / 2;
        int n4 = point.x + dimension.width / 2;
        int n5 = 0;
        boolean bl2 = bl = this.alg.getTarget(n).getShape() != 112;
        if (bl && n3 < point2.x) {
            n5 = point2.x - n3;
            n3 += n5;
            n4 += n5;
        }
        if (bl && n4 > point3.x) {
            n5 = n4 - point3.x;
            n3 -= n5;
            n4 -= n5;
        }
        int n6 = point.y - dimension.height / 2;
        int n7 = point.y + dimension.height / 2;
        int n8 = this.dataNavigator.getTruePointPosition(n3, n6, n);
        int n9 = this.dataNavigator.getTruePointPosition(n3, n7, n);
        int n10 = this.dataNavigator.getTruePointPosition(n4, n6, n);
        int n11 = this.dataNavigator.getTruePointPosition(n4, n7, n);
        if (n8 > n10) {
            object = this.getCircularTargets();
            TargetAppearance targetAppearance = (TargetAppearance)((Hashtable)object).get(new Integer(this.vizMgr.getFocusTarget()));
            targetAppearance.setCurrentCollection(this.getCurrentCollection());
            if (targetAppearance == null || !((double)n8 > (double)targetAppearance.getMaxPosition() * 0.75) || !((double)n10 < (double)targetAppearance.getMaxPosition() * 0.25)) {
                int n12 = n8;
                n8 = n10;
                n10 = n12;
                n12 = n9;
                n9 = n11;
                n11 = n12;
            }
        }
        if (n9 < n8) {
            n8 = n9;
        }
        if (n11 > n10) {
            n10 = n11;
        }
        object = new int[2];
        object[0] = n8;
        object[1] = n10;
        return object;
    }

    public ComparisonPool getComparisonPool() {
        return this.comparisonPool;
    }

    public void setComparisonPool(ComparisonPool comparisonPool) {
        this.comparisonPool = comparisonPool;
    }

    public BluejayURLLoader getURLLoader() {
        return urlLoader;
    }

    public DisplayOptions getDisplayOptions() {
        return this.dos;
    }

    public void checkMicroarrayCluster() {
        this.microArrayFunctions.checkMicroarrayCluster();
    }

    public void restoreMicroArrayInfo() {
        this.microArrayFunctions.restoreMicroArrayInfo();
    }

    public void clearScaleComponent() {
        this.scaleComponent = new Scale();
    }

    public void setCircularSequences(Vector vector) {
        this.circularSequences = vector;
    }

    public Vector getCircularSequences() {
        return this.circularSequences;
    }

    public LegendManager getLegendManager() {
        return this.legendManager;
    }

    public void setWholeLegendPrinted(boolean bl) {
        this.wholeLegendPrinted = bl;
    }

    public void setCompMenuMan(ComparisonMenuManager comparisonMenuManager) {
        this.compMgr = comparisonMenuManager;
    }

    public ComparisonMenuManager getCompMenuMan() {
        return this.compMgr;
    }

    public boolean isNoWorker() {
        return this.noWorker;
    }

    public void enableInteractors() {
        if (this.alg.isSingleFrameMode() || this.alg.isTwoFrameMode() || this.alg.isSixFrameMode()) {
            this.setEnableImageZoomInteractor(true);
            this.setEnableZoomInteractor(true);
            this.setEnableRotateInteractor(true);
        } else if (this.alg.isInTextMode() || this.alg.isInChartMode()) {
            this.setEnableImageZoomInteractor(false);
            this.setEnableZoomInteractor(false);
            this.setEnableRotateInteractor(false);
        } else {
            System.err.println("=> BluejayDObjectList.enableInteractors(): View mode is strange; doing nothing");
        }
    }

    public void enableViewMenus() {
        if (this.alg.isSingleFrameMode() || this.alg.isTwoFrameMode() || this.alg.isSixFrameMode()) {
            this.viewMenu.enableViewMenus("Frame");
        } else if (this.alg.isInTextMode()) {
            this.viewMenu.enableViewMenus("Text");
        } else if (this.alg.isInChartMode()) {
            this.viewMenu.enableViewMenus("Chart");
        } else {
            System.err.println("=> BluejayDObjectList.enableViewMenus(): View mode is strange; doing nothing");
        }
    }

    public Object getCurrentURL() {
        return urlLoader.getCurrentURL();
    }

    public HistoryTable getHistoryTable() {
        return urlLoader.getHistoryTable();
    }

    public StateCollection getCurrentCollection() {
        return urlLoader.getCurrentCollection();
    }

    public void setChrColors(Color[] colorArray) {
        this.chrColors = colorArray;
    }

    public Color[] getChrColors() {
        return this.chrColors;
    }

    public void setChrNames(String[] stringArray) {
        this.chrNames = stringArray;
    }

    public String[] getChrNames() {
        return this.chrNames;
    }

    public void setParColors(Hashtable<String, Color> hashtable) {
        this.parColors = hashtable;
    }

    public void setParColor(String string, Color color) {
        this.parColors.put(string, color);
    }

    public Color getParColor(String string) {
        return this.parColors.get(string);
    }

    public void setParNames(String[] stringArray) {
        this.parNames = stringArray;
    }

    public String[] getParNames() {
        return this.parNames;
    }

    public String getOrganism() {
        return this.organism;
    }

    public void setOrganism(String string) {
        this.organism = string;
    }

    public void setDrawingChromosomes(boolean bl) {
        this.drawingChromosomes = bl;
    }

    public boolean isDrawingChromosomes() {
        return this.drawingChromosomes;
    }

    public void setDrawingCentromeres(boolean bl) {
        this.drawingCentromeres = bl;
    }

    public boolean isDrawingCentromeres() {
        return this.drawingCentromeres;
    }

    static {
        urlLoader = new BluejayURLLoader();
        logger = Logger.getLogger(BluejayDObjectList.class);
    }
}

