/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import com.simonstl.sax.xlink.LinkSet;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataManager {
    private BluejayDObjectList dlist;
    private TreeMap xPtrToDeiMap;
    private TreeMap xPtrToGVTMap;
    private static final int MAX_NUM_DEI_LINKS_TO_DISPLAY = 30;

    private DataManager() {
    }

    public DataManager(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
    }

    public TreeMap getXPtrToDeiMap() {
        return this.xPtrToDeiMap;
    }

    public TreeMap getXPtrToGVTMap() {
        return this.xPtrToGVTMap;
    }

    public void clearXPtrToGVTMap() {
        this.xPtrToGVTMap = null;
    }

    public void clearXPtrToDeiMap() {
        this.xPtrToDeiMap = null;
    }

    public Object getXPtrToGVTMapValue(String string) {
        return this.xPtrToGVTMap == null ? null : this.xPtrToGVTMap.get(string);
    }

    public void buildXPointerDOMMap() {
        int n;
        AbstractLinearGraphics abstractLinearGraphics = this.dlist.getAbstractLinearGraphics();
        LinkSet linkSet = abstractLinearGraphics.getLinkSet();
        boolean bl = linkSet != null && !linkSet.isEmpty();
        this.xPtrToDeiMap = new TreeMap();
        String string = null;
        if (bl && (n = (string = linkSet.firstLink().getFromNode().getURL().toString()).indexOf(35)) < 0) {
            string = string.substring(0, n);
        }
        Stack<Node> stack = new Stack<Node>();
        Element element = this.dlist.getDocument().getDocumentElement();
        if (element != null) {
            stack.push(element);
            while (!stack.empty()) {
                DTDElementInstance dTDElementInstance;
                String string2;
                Node node = (Node)stack.pop();
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    stack.push(node2);
                }
                if (!(node instanceof DTDElementInstance) || (string2 = (dTDElementInstance = (DTDElementInstance)node).getXPointer()) == null || "".equals(string2)) continue;
                this.xPtrToDeiMap.put(string2, dTDElementInstance);
                if (!bl) continue;
                String string3 = string + '#' + string2;
                List list = abstractLinearGraphics.getLinkSet().getByFromURLFileFragment(string3).toList();
                if (list == null || list.isEmpty()) continue;
                dTDElementInstance.setLinkList(list);
            }
        }
    }

    public void clearXPointerDOMMap() {
        this.xPtrToDeiMap = null;
    }

    public void buildGVTMap() {
        GraphicsNode graphicsNode = this.dlist.getGraphicsNode();
        if (graphicsNode != null) {
            Object object;
            this.xPtrToGVTMap = new TreeMap();
            Stack<Object> stack = new Stack<Object>();
            stack.push(graphicsNode);
            while (!stack.empty()) {
                String string;
                object = (GraphicsNode)stack.pop();
                if (object instanceof CompositeGraphicsNode) {
                    int n = ((CompositeGraphicsNode)object).getChildren().size();
                    for (int i = 0; i < n; ++i) {
                        stack.push(((CompositeGraphicsNode)object).get(i));
                    }
                }
                if ((string = object.getDataXPointer()) == null || "".equals(string)) continue;
                if (this.xPtrToGVTMap.containsKey(string)) {
                    ((Vector)this.xPtrToGVTMap.get(string)).add(object);
                    continue;
                }
                Vector<Object> vector = new Vector<Object>(1, 1);
                vector.add(object);
                this.xPtrToGVTMap.put(string, vector);
            }
            object = null;
            Document document = this.dlist.getDocument();
            if (document != null) {
                object = this.dlist.getDocument().getDocumentElement();
            }
            if (object != null) {
                this.buildDOMtoGVTMap();
            }
        }
    }

    private void buildDOMtoGVTMap() {
        Element element = this.dlist.getDocument().getDocumentElement();
        Stack<Node> stack = new Stack<Node>();
        stack.push(element);
        while (!stack.empty()) {
            Object object;
            Node node = (Node)stack.pop();
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                stack.push((Node)object);
            }
            if (!(node instanceof DTDElementInstance) || (object = ((DTDElementInstance)node).getXPointer()) == null || "".equals(object)) continue;
            ((DTDElementInstance)node).setGVTNodeList((Vector)this.xPtrToGVTMap.get(object));
        }
    }

    public void clearDOMtoGVTMap() {
        GraphicsNode graphicsNode = this.dlist.getGraphicsNode();
        if (graphicsNode != null) {
            Stack<Node> stack = new Stack<Node>();
            if (this.dlist.getDocument() == null) {
                return;
            }
            Element element = this.dlist.getDocument().getDocumentElement();
            if (element != null) {
                stack.push(element);
                while (!stack.empty()) {
                    Node node = (Node)stack.pop();
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        stack.push(node2);
                    }
                    if (!(node instanceof DTDElementInstance)) continue;
                    ((DTDElementInstance)node).clearGVTNodeList();
                }
            }
        }
    }

    public void removeAllHyperlinks() {
        this.dlist.getAbstractLinearGraphics().removeAllHyperlinks();
    }

    public List getHyperlinks(String string) {
        return this.getHyperlinks(string, this.dlist.getAbstractLinearGraphics().getLinkSet());
    }

    public List getHyperlinks(String string, Genome genome) {
        return this.getHyperlinks(string, genome.getOutXLinks());
    }

    public List getHyperlinks(String string, LinkSet linkSet) {
        if (linkSet == null || linkSet.isEmpty()) {
            return null;
        }
        if (this.dlist.getAbstractLinearGraphics().getxPtrToGBMap().containsKey(string)) {
            string = string.substring(0, string.lastIndexOf(47));
        }
        String string2 = linkSet.firstLink().getFromNode().getURL().toString();
        string2 = string2.substring(0, string2.indexOf(35));
        int n = string.lastIndexOf(47) + 1;
        int n2 = new Integer(string.substring(n));
        String string3 = string.substring(0, n) + (1 + n2);
        String string4 = string2 + "#" + string;
        LinkSet linkSet2 = linkSet.getByFromURLFileFragment(string4);
        LinkSet linkSet3 = linkSet.getByFromURLFileFragment_StartsWith(string4 + "/");
        int n3 = linkSet3.size();
        if (n3 <= 0 || n3 > 30) {
            return linkSet2.toList();
        }
        linkSet3.addLinkSet(linkSet2);
        return linkSet3.toList();
    }

    public void clearDOMTrees() {
        Element element;
        this.clearXPointerDOMMap();
        this.clearDOMtoGVTMap();
        Document document = this.dlist.getDocument();
        if (document != null && (element = document.getDocumentElement()) != null) {
            Stack<Node> stack = new Stack<Node>();
            boolean bl = false;
            stack.push(element);
            while (!stack.empty()) {
                Node node = (Node)stack.pop();
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    stack.push(node2);
                }
                Node node3 = node.getParentNode();
                if (node3 == null) continue;
                node3.removeChild(node);
            }
        }
    }

    public void clearSVGTreesIfPossible() {
        if (this.dlist.isGVTTreeAccessible()) {
            this.dlist.disposeBridgeContext();
            Element element = this.dlist.getSVGDocument().getDocumentElement();
            Stack<Node> stack = new Stack<Node>();
            boolean bl = false;
            if (element != null) {
                stack.push(element);
                while (!stack.empty()) {
                    Node node = (Node)stack.pop();
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        stack.push(node2);
                    }
                    Node node3 = node.getParentNode();
                    if (node3 == null || node3 instanceof Document) continue;
                    node3.removeChild(node);
                }
            }
        }
    }

    public void clearRenderingTrees() {
        this.dlist.getTextView().setText("");
        this.clearDOMtoGVTMap();
        this.clearGVTTree();
        this.clearXPtrToGVTMap();
        if (this.dlist.getThumbnailPanel() != null) {
            this.dlist.getThumbnailPanel().releaseThumbnailRenderingReferences();
        }
        try {
            this.dlist.releaseRenderingReferences(this);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Caught unexpected exception");
            illegalAccessException.printStackTrace();
        }
    }

    private void clearGVTTree() {
        GraphicsNode graphicsNode = this.dlist.getGraphicsNode();
        if (graphicsNode != null) {
            CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
            for (int i = compositeGraphicsNode.size() - 1; i >= 0; --i) {
                CompositeGraphicsNode compositeGraphicsNode2 = (CompositeGraphicsNode)compositeGraphicsNode.get(i);
                for (int j = compositeGraphicsNode2.size() - 1; j >= 0; --j) {
                    compositeGraphicsNode2.remove(j);
                }
                compositeGraphicsNode.remove(i);
            }
        }
    }

    public void clearAllBeforeParsing(boolean bl) {
        this.dlist.resetMicroArrayTreeMaps();
        this.clearDOMTrees();
        this.clearSVGTreesIfPossible();
        this.clearRenderingTrees();
        this.dlist.getAbstractLinearGraphics().setPreserveTargetAppearances(!bl);
        if (bl) {
            this.dlist.getDataNavigator().clearPositionSettings();
            this.dlist.getLegend().clear();
        }
    }
}

