/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.DisplayOptions;
import ca.ucalgary.bluejay.gui.PreviewPanel;
import ca.ucalgary.bluejay.session.StateCollection;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class FontColourSelect
extends JDialog
implements ActionListener,
ItemListener {
    private DisplayOptions dos;
    private PreviewPanel preview;
    private JPanel fontPanel;
    private String fontchoice;
    private int stylechoice;
    private int fontsize;
    private JComboBox styles;
    private JComboBox sizes;
    private JComboBox fontList;
    private boolean OKSelected = false;
    private BluejayDObjectList dlist;
    private StateCollection collection;
    private static Logger logger = Logger.getLogger(FontColourSelect.class);
    public static final int INCH = Toolkit.getDefaultToolkit().getScreenResolution();

    public FontColourSelect(Frame frame, String string, DisplayOptions displayOptions) {
        super(frame, string, true);
        Container container = this.getContentPane();
        this.collection = new StateCollection();
        this.dos = displayOptions;
        Font font = this.dos.getFont();
        font = font.deriveFont(0);
        this.fontchoice = font.getFontName();
        this.stylechoice = this.dos.getFont().getStyle();
        this.fontsize = this.dos.getFont().getSize();
        logger.debug("fontchoice is: " + this.fontchoice);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = 0;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
            String string2 = stringArray[i].concat(".plain");
            if (string2.equals(this.fontchoice)) {
                n = vector.size() - 1;
                logger.debug(this.fontchoice + "compare is" + string2 + " envFont at: " + i + " is: " + stringArray[i]);
            }
            if (!stringArray[i].equals(this.fontchoice)) continue;
            n = vector.size() - 1;
        }
        this.fontList = new JComboBox(vector);
        this.fontList.setSelectedIndex(n);
        this.fontList.addItemListener(this);
        Vector<String> vector2 = new Vector<String>();
        n = 0;
        int n2 = 8;
        do {
            vector2.addElement("" + n2);
            if (n2 == this.fontsize) {
                n = vector2.size() - 1;
            }
            if (n2 <= 30) {
                n2 += 2;
                continue;
            }
            if (n2 <= 70) {
                n2 += 4;
                continue;
            }
            n2 += 8;
        } while (n2 < 100);
        this.sizes = new JComboBox(vector2);
        this.sizes.setSelectedIndex(n);
        this.sizes.addItemListener(this);
        this.styles = new JComboBox<Object>(new Object[]{"PLAIN", "BOLD", "ITALIC", "BOLD & ITALIC"});
        this.styles.addItemListener(this);
        this.styles.setSelectedIndex(this.stylechoice);
        JLabel jLabel = new JLabel(" Font:");
        JLabel jLabel2 = new JLabel(" Size:");
        JLabel jLabel3 = new JLabel("Style:");
        jLabel.setLabelFor(this.fontList);
        jLabel2.setLabelFor(this.sizes);
        jLabel3.setLabelFor(this.styles);
        this.fontPanel = new JPanel(new GridLayout(3, 2));
        this.fontPanel.setBorder(new TitledBorder("Choose Font"));
        this.fontPanel.setPreferredSize(new Dimension(150, 100));
        this.fontPanel.setMaximumSize(new Dimension(150, 100));
        this.fontPanel.setMinimumSize(new Dimension(100, 100));
        this.fontPanel.add(jLabel);
        this.fontPanel.add(this.fontList);
        this.fontPanel.add(jLabel2);
        this.fontPanel.add(this.sizes);
        this.fontPanel.add(jLabel3);
        this.fontPanel.add(this.styles);
        container.add((Component)this.fontPanel, "North");
        JColorChooser jColorChooser = new JColorChooser(this.dos.getBackgroundColor());
        jColorChooser.setBorder(BorderFactory.createTitledBorder("Choose Background Color"));
        this.preview = new PreviewPanel(jColorChooser, this.dos.getBackgroundColor(), this.dos.getForegroundColor(), this.dos.getFont());
        jColorChooser.setPreviewPanel(this.preview);
        container.add((Component)jColorChooser, "Center");
        JButton jButton = new JButton("Cancel");
        jButton.setActionCommand("Cancel");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("OK");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(jButton);
        container.add((Component)jPanel, "South");
        this.pack();
        this.setVisible(true);
    }

    public boolean OKSelected() {
        return this.OKSelected;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            this.collection = this.dlist.getCurrentCollection();
            this.collection.setDrawingPrefs(this.preview.getTextFont(), this.preview.getTextForeground(), this.preview.getTextBackground());
            this.dos.setBackgroundColor(this.preview.getTextBackground());
            this.dos.setForegroundColor(this.preview.getTextForeground());
            this.dos.setFont(this.preview.getTextFont());
            this.setVisible(false);
            this.OKSelected = true;
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.styles) {
            this.stylechoice = this.styles.getSelectedIndex();
        } else if (object == this.fontList) {
            this.fontchoice = (String)this.fontList.getSelectedItem();
        } else {
            String string = (String)this.sizes.getSelectedItem();
            Integer n = new Integer(string);
            this.fontsize = n;
        }
        if (this.isVisible()) {
            this.preview.changeFont(this.fontchoice, this.stylechoice, this.fontsize);
        }
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
    }
}

