/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.XCheckBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;
import org.apache.xpath.XPath;

public class LegendItem
extends JPanel
implements ItemSelectable,
ItemListener,
Comparable {
    private static final String view_locked_icon_file = "images/view_locked.png";
    private static final String view_unlocked_icon_file = "images/view_unlocked.png";
    private static final String view_lock_tooltip = "When locked, always show (even if parent type is turned off)";
    private static ImageIcon view_locked_icon = null;
    private static ImageIcon view_unlocked_icon = null;
    private Color colour;
    private int count;
    private int visible_count;
    private int visible_state_count;
    private Image glyph = null;
    private JLabel label = null;
    private XPath xpath = null;
    private String description;
    private String category;
    private XCheckBox check;
    private JToggleButton view_lock;
    private Vector listeners;
    private boolean listening;
    private Vector deiXPointers;
    public static String GENERIC = "GENERIC";
    private static Logger logger = Logger.getLogger(LegendItem.class);

    public LegendItem(ImageIcon imageIcon, String string, String string2, int n, XPath xPath, int n2, boolean bl, Vector vector, Color color) {
        this.setLayout(new FlowLayout(3, 0, 0));
        this.setBackground(Color.white);
        this.label = new JLabel(string2 + " (" + n + ")", imageIcon, 2);
        this.check = new XCheckBox("", n2);
        this.check.setBackground(Color.white);
        this.check.setMargin(new Insets(1, 1, 1, 1));
        this.glyph = imageIcon == null ? null : imageIcon.getImage();
        this.colour = color;
        this.loadViewLockIcons();
        this.view_lock = new JToggleButton(view_unlocked_icon, bl);
        this.view_lock.setSelectedIcon(view_locked_icon);
        this.view_lock.setPreferredSize(new Dimension(view_locked_icon.getIconWidth(), view_locked_icon.getIconHeight()));
        this.view_lock.setBorderPainted(false);
        this.view_lock.setToolTipText(view_lock_tooltip);
        this.view_lock.setMargin(new Insets(1, 1, 1, 1));
        this.label.setToolTipText(string2 + " (" + n + ")");
        this.description = string2;
        this.category = string;
        this.visible_count = 0;
        this.visible_state_count = n;
        this.count = n;
        this.xpath = xPath;
        this.deiXPointers = vector;
        this.listeners = new Vector(1);
        this.listening = false;
        Font font = this.label.getFont();
        this.label.setMinimumSize(new Dimension(15, 15));
        this.label.setFont(font.deriveFont(10.0f));
        this.add(this.check);
        this.add(this.view_lock);
        this.add(this.label);
    }

    private synchronized void loadViewLockIcons() {
        if (view_locked_icon != null && view_unlocked_icon != null) {
            return;
        }
        if (view_locked_icon == null && (view_locked_icon = new ImageIcon(this.getClass().getClassLoader().getResource(view_locked_icon_file))) == null) {
            logger.warn("Could not load icon file images/view_locked.png");
        }
        if (view_unlocked_icon == null && (view_unlocked_icon = new ImageIcon(this.getClass().getClassLoader().getResource(view_unlocked_icon_file))) == null) {
            logger.warn("Could not load icon file images/view_locked.png");
        }
    }

    public void updateVisualState(int n) {
        this.check.updateVisualState(n);
    }

    public void setVisibleCount(int n) {
        this.visible_count = n;
    }

    public int getVisibleStateCount() {
        return this.visible_state_count;
    }

    public void setVisibilityOnLocked(boolean bl) {
        this.view_lock.setSelected(bl);
    }

    public boolean getVisibilityOnLocked() {
        return this.view_lock.isSelected();
    }

    public void setSelectionState(int n) {
        this.check.setSelectionState(n);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemEvent itemEvent2 = null;
        if (itemEvent.getSource() == this.check) {
            this.check.updateVisualState(101);
            itemEvent2 = new ItemEvent(this, itemEvent.getID(), this.check, itemEvent.getStateChange());
        } else if (itemEvent.getSource() == this.view_lock) {
            itemEvent2 = new ItemEvent(this, itemEvent.getID(), this.view_lock, itemEvent.getStateChange());
        } else if (itemEvent.getSource() instanceof Legend) {
            if (itemEvent.getID() == 100) {
                this.check.updateVisualState(100);
                itemEvent2 = new ItemEvent(this, itemEvent.getID(), this.check, itemEvent.getStateChange());
            } else {
                this.check.updateVisualState(itemEvent.getID());
                itemEvent2 = new ItemEvent(this, itemEvent.getID(), this.check, itemEvent.getStateChange());
            }
        } else {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ItemListener)this.listeners.elementAt(i)).itemStateChanged(itemEvent2);
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (this.listeners.size() == 0) {
            this.check.addItemListener(this);
        }
        this.listeners.add(itemListener);
    }

    public Object[] getSelectedObjects() {
        if (this.check.isSelected()) {
            Object[] objectArray = new Object[]{this.check};
            return objectArray;
        }
        return new Object[0];
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.listeners.removeElement(itemListener);
        if (this.listeners.size() == 0) {
            this.check.removeItemListener(this);
        }
    }

    public int getItemSelectionState() {
        return this.check.getSelectionState();
    }

    public boolean isVisibilityEvent(ItemEvent itemEvent) {
        return itemEvent.getItem() == this.check;
    }

    public String getDescription() {
        return this.description;
    }

    public XPath getXPath() {
        return this.xpath;
    }

    public String getCategory() {
        return this.category;
    }

    public Color getColor() {
        return this.colour;
    }

    public int getTotalCount() {
        return this.count;
    }

    void setTotalCount(int n) {
        this.count = n;
    }

    public Vector getXPointers() {
        return this.deiXPointers;
    }

    void setXPointers(Vector vector) {
        this.deiXPointers = vector;
    }

    public Boolean getVisibleState() {
        if (this.check.getSelectionState() == 112) {
            return new Boolean(true);
        }
        if (this.check.getSelectionState() == 114) {
            return new Boolean(false);
        }
        if (this.check.getSelectionState() == 113) {
            return null;
        }
        return null;
    }

    public int getVisibility() {
        return this.check.getSelectionState();
    }

    public int compareTo(Object object) {
        if (object instanceof LegendItem && this instanceof LegendItem) {
            if (this.getTotalCount() == ((LegendItem)object).getTotalCount()) {
                return 0;
            }
            if (this.getTotalCount() > ((LegendItem)object).getTotalCount()) {
                return 1;
            }
            return -1;
        }
        logger.error("ClassCastException: not a Legend Item comparable\n");
        throw new ClassCastException("\nIt is not a Legend Item comparable\n");
    }
}

