/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.gui.VisibilityManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class Scale
extends JPanel
implements PropertyChangeListener {
    public static final int DEFAULT_MAXIMUM_FRACTION_DIGITS = 1;
    public static final int DEFAULT_SCALE_LENGTH = 128;
    public static final int DEFAULT_SCALE_DIVISIONS = 8;
    private static final int NOT_INITIALIZED = -6;
    private final int component_padding = 5;
    private boolean property_initialized = false;
    private NumberFormat nf = NumberFormat.getInstance();
    private String property_name = null;
    private double scale = -5.898;
    private int scale_divisions = 8;
    private int scale_length = 128;
    private FontMetrics fm;
    private Insets insets;
    private int scale_total_units;
    private int real_scale_length;
    private int text_height;
    private int text_width;
    private static Logger logger = Logger.getLogger(Scale.class);

    public Scale() {
        this.nf.setMaximumFractionDigits(1);
        this.fm = null;
        this.insets = this.getInsets();
        this.adjustPreferredSize();
    }

    public void setDivisions(int n) throws IllegalArgumentException {
        if (n / 2 > this.scale_length) {
            logger.error("IllegalArgumentException: Number passed to Scale.setDivisions (" + n + ") was greater than the limit, " + "half the scale length in pixels (" + this.scale_length + ")");
            throw new IllegalArgumentException();
        }
        int n2 = 1;
        boolean bl = false;
        int n3 = 0;
        while (n3 <= 6) {
            if (n == n2) {
                bl = true;
            }
            ++n3;
            n2 *= 2;
        }
        if (!bl) {
            logger.error("Number passed to Scale.setDivisions was not a power of two, found " + n);
            throw new IllegalArgumentException();
        }
        this.scale_divisions = n;
    }

    public int getDivisions() {
        return this.scale_divisions;
    }

    public void setLength(int n) throws IllegalArgumentException {
        if (this.scale_divisions * 2 > n) {
            logger.error("IllegalArgumentException: Number passed to Scale.setLength (" + n + ") was less than the limit, " + "twice the number of divisions (" + this.scale_divisions + ")");
            throw new IllegalArgumentException();
        }
        int n2 = 1;
        boolean bl = false;
        int n3 = 0;
        while (n3 <= 10) {
            if (n == n2) {
                bl = true;
            }
            ++n3;
            n2 *= 2;
        }
        if (!bl) {
            logger.error("IllegalArgumentException Number passed to Scale.setLength was not a power of two, found " + n);
            throw new IllegalArgumentException();
        }
        this.scale_length = n;
        this.adjustPreferredSize();
    }

    public int getLength() {
        return this.scale_length;
    }

    public NumberFormat getNumberFormat() {
        return this.nf;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        if (this.nf == null) {
            logger.debug("Scale.setNumberFormat was passed null, ignoring");
            return;
        }
        this.nf = numberFormat;
        this.adjustPreferredSize();
    }

    public void setScale(double d) throws IllegalArgumentException {
        if (d <= 0.0 && d != -5.898) {
            logger.error("IllegalArgumentException Value passed to setScale must be  positive or the sentinal value -5.898 (VisibilityManager.SCALE_UNAVAILABLE), found: " + d);
            throw new IllegalArgumentException();
        }
        this.scale = d;
        this.adjustPreferredSize();
    }

    public void setProperty(String string) throws IllegalArgumentException {
        this.property_name = string;
        this.property_initialized = true;
        logger.debug("Scale.setProperty() now set to listen for " + string);
    }

    public double getScale() {
        return this.scale;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("scale in bases per pixel")) {
            logger.debug("Scale.propertyChange() propertyName=scale in bases per pixel -- should change scale widget");
            Object object = propertyChangeEvent.getOldValue();
            double d = 0.0;
            if (propertyChangeEvent.getSource() instanceof VisibilityManager) {
                d = ((VisibilityManager)propertyChangeEvent.getSource()).getScale();
            } else if (propertyChangeEvent.getNewValue() instanceof Double) {
                d = (Double)propertyChangeEvent.getNewValue();
            } else {
                logger.debug("Scale.propertyChange() received unusable non-double value " + object + " -- will NOT change scale widget");
            }
            if (d != this.scale && (d > 0.0 || d == -5.898)) {
                try {
                    this.setScale(d);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.error("IllegalArgumentException Scale.propertyChange(), could not set scale to " + d + ": " + illegalArgumentException);
                    return;
                }
                logger.debug("Scale.propertyChange() changed value to " + this.scale);
                this.repaint();
            }
        } else {
            logger.debug("Scale.propertyChange() received non-target change to propertyName=" + propertyChangeEvent.getPropertyName() + " -- should NOT change scale widget");
        }
    }

    protected void adjustPreferredSize() {
        double d;
        if (this.nf == null) {
            return;
        }
        logger.debug("Adjusting Scale widget size (Scale.adjustPreferredSize())");
        this.scale_total_units = (int)((double)this.scale_length * this.scale / 4.0);
        for (d = 0.1; d < (double)this.scale_total_units; d *= 10.0) {
        }
        int n = this.scale_total_units;
        this.scale_total_units = (int)(d /= 10.0);
        while ((double)this.scale_total_units + d < (double)n) {
            this.scale_total_units = (int)((double)this.scale_total_units + d);
        }
        this.scale_total_units *= 4;
        this.real_scale_length = (int)((double)this.scale_total_units / this.scale);
        this.fm = this.getFontMetrics(this.getFont());
        this.text_height = this.fm.getHeight();
        this.text_width = this.fm.stringWidth(this.getLabel());
        int n2 = this.fm.stringWidth(this.nf.format(this.scale_total_units));
        this.insets = this.getInsets();
        int n3 = this.text_width;
        if (this.scale != -5.898 && this.real_scale_length + n2 + 5 > n3) {
            n3 = this.real_scale_length + n2 + 5;
        }
        int n4 = this.text_height + this.insets.top + this.insets.bottom + (this.scale == -5.898 ? 0 : this.text_height + 5);
        this.setPreferredSize(new Dimension(n3 += this.insets.left + this.insets.right + 10, n4));
    }

    protected String getLabel() {
        String string = null;
        if (this.scale == -5.898) {
            string = new String("Scale: N/A");
        } else if (this.scale < 1.0 && this.scale > 0.0) {
            double d = 1.0 / this.scale;
            string = new String("Scale: " + this.nf.format(d) + " pixels/unit");
        } else {
            string = new String("Scale: " + this.nf.format(this.scale) + " units/pixel");
        }
        return string;
    }

    protected int getScaleTotalUnits() {
        return (int)((double)this.scale_length * this.scale);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.adjustPreferredSize();
    }

    public void paint(Graphics graphics) {
        if (!this.getInsets().equals(this.insets)) {
            this.adjustPreferredSize();
            this.repaint();
            return;
        }
        String string = this.getLabel();
        Dimension dimension = this.getPreferredSize();
        Insets insets = this.getInsets();
        Font font = graphics.getFont();
        graphics.setFont(this.getFont());
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        int n = insets.top + this.text_height - this.fm.getDescent();
        graphics.drawString(string, (dimension.width - this.text_width + insets.left - insets.right) / 2, n);
        if (this.scale == -5.898) {
            return;
        }
        int n2 = this.text_height + 5 + (this.text_height + insets.top) / 2;
        int n3 = insets.left + 5;
        graphics.drawLine(n3, n2, n3 + this.real_scale_length, n2);
        int n4 = 7;
        graphics.drawLine(n3, n2 - n4, n3, n2 + n4);
        graphics.drawLine(n3 + this.real_scale_length, n2 - n4, n3 + this.real_scale_length, n2 + n4);
        for (int i = this.scale_divisions; i > 1; i /= 2) {
            --n4;
            int n5 = 2 * this.scale_divisions / i;
            double d = 1.0f * (float)this.real_scale_length / (float)n5;
            for (int j = 1; j < n5; ++j) {
                int n6 = (int)((double)j * d + 0.5);
                graphics.drawLine(n3 + n6, n2 - n4, n3 + n6, n2 + n4);
            }
        }
        graphics.drawString(this.nf.format(this.scale_total_units), n3 + this.real_scale_length + 5, n + this.text_height + 5);
        graphics.setFont(font);
    }
}

