/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoxLayout;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.apache.batik.apps.svgbrowser.ThumbnailPanel;
import org.apache.log4j.Logger;

public class ThumbnailManager
extends ComponentAdapter {
    private ThumbnailPanel thumbnailPanel;
    private JToolBar thumbnailBar;
    private BluejayDObjectList dlist;
    private boolean inTab = true;
    private static Logger logger = Logger.getLogger(ThumbnailManager.class);

    public boolean isInTab() {
        return this.inTab;
    }

    public void setInTab(boolean bl) {
        this.inTab = bl;
    }

    public JToolBar getThumbnailBar() {
        return this.thumbnailBar;
    }

    public void setThumbnailBar(JToolBar jToolBar) {
        this.thumbnailBar = jToolBar;
    }

    public ThumbnailPanel getThumbnailPanel() {
        return this.thumbnailPanel;
    }

    public void setThumbnailPanel(ThumbnailPanel thumbnailPanel) {
        this.thumbnailPanel = thumbnailPanel;
    }

    public ThumbnailManager(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
        if (Debug.thumbnail) {
            this.setThumbnailBar();
        }
    }

    private void setThumbnailBar() {
        this.thumbnailPanel = new ThumbnailPanel(this.dlist);
        this.thumbnailBar = new JToolBar("Thumbnail");
        this.thumbnailBar.setLayout(new BoxLayout(this.thumbnailBar, 1));
        ((BasicToolBarUI)this.thumbnailBar.getUI()).setDockingColor(Color.darkGray);
        if (this.inTab) {
            this.thumbnailBar.setPreferredSize(new Dimension(200, 200));
        } else {
            this.thumbnailBar.setPreferredSize(new Dimension(200, 400));
        }
        this.thumbnailBar.setMinimumSize(new Dimension(200, 200));
        this.thumbnailBar.setMaximumSize(new Dimension(800, 800));
        this.thumbnailPanel.setPreferredSize(new Dimension(200, 168));
        this.dlist.getBatikZoom().setPreferredSize(new Dimension(160, 30));
        this.thumbnailBar.add(this.thumbnailPanel);
        this.thumbnailBar.add(this.dlist.getBatikZoom());
        this.thumbnailBar.setMargin(new Insets(0, 0, 0, 0));
        this.thumbnailBar.addComponentListener(this);
    }

    public void switchThumbnailBarLayout() {
        Dimension dimension = this.thumbnailBar.getPreferredSize();
        if (dimension.equals(new Dimension(200, 200))) {
            this.thumbnailBar.setPreferredSize(new Dimension(300, 300));
            if (Debug.DEBUG) {
                System.out.println("ThumbnailManager.switchThumbnailBarLayout() -- in tab ya ya");
            }
        } else {
            this.thumbnailBar.setPreferredSize(new Dimension(200, 200));
            if (Debug.DEBUG) {
                System.out.println("ThumbnailManager.switchThumbnailBarLayout() -- outside we are we area are");
            }
        }
        this.thumbnailBar.repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.thumbnailBar.getPreferredSize();
        Dimension dimension2 = this.thumbnailBar.getMinimumSize();
        Dimension dimension3 = this.thumbnailBar.getMaximumSize();
        int n = this.dlist.getBatikZoom().getSize().height + 2;
        this.thumbnailPanel.setPreferredSize(new Dimension(dimension.width, dimension.height - n));
        this.thumbnailPanel.setMinimumSize(new Dimension(dimension2.width, dimension2.height - n));
        this.thumbnailPanel.setMaximumSize(new Dimension(dimension3.width, dimension3.height - n));
        this.thumbnailPanel.revalidate();
        this.thumbnailBar.repaint();
        logger.debug("### ThumbnailManager.thumbnailBar.componentResized() thumbnailPanel.getSize()=" + this.thumbnailPanel.getSize());
    }
}

