/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.impl.BluejayEventCoordinator;
import ca.ucalgary.bluejay.client.impl.BluejayURLLoader;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.menu.BookmarksMenuManager;
import ca.ucalgary.bluejay.gui.util.AnimatorApplicationTimer;
import ca.ucalgary.bluejay.gui.util.CodeBase;
import ca.ucalgary.bluejay.gui.util.History;
import ca.ucalgary.bluejay.gui.util.JSVGPrintUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ToolbarWidgets
implements ActionListener,
ItemListener {
    public static final String NO_ACTION_COMMAND = "";
    private static JButton undo;
    private static JButton redo;
    private static JButton back;
    private static JButton forward;
    private static JButton refresh;
    private static JButton stop;
    private static BluejayDObjectList dlist;
    private BluejayURLLoader urlLoader;
    private static AnimatorApplicationTimer animator;
    private static boolean isAnApplet;
    private static CodeBase implCodeBase;
    private static BluejayEventCoordinator bec;
    private static BookmarksMenuManager bookmarksMenu;
    private static JToolBar editToolbar;
    private static JButton open;
    private static JButton bookmarksButton;
    public static final boolean ADD_TO_HISTORY = true;
    public static final boolean DO_NOT_ADD_TO_HISTORY = false;
    JComboBox tf = new JComboBox();
    private static String tfstring;
    private static History localHistory;
    private static Logger logger;

    public void addToolbarWidgets(JPanel jPanel) {
        int n;
        jPanel.setLayout(new GridBagLayout());
        jPanel.setAlignmentX(0.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 1;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setAlignmentX(0.0f);
        jToolBar.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        jToolBar.setFloatable(false);
        ClassLoader classLoader = this.getClass().getClassLoader();
        back = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/back.gif")));
        back.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/back_d.gif")));
        back.setMnemonic(37);
        back.setActionCommand("back");
        back.setEnabled(false);
        back.addActionListener(this);
        back.setToolTipText("Go back one document");
        jToolBar.add((Component)back, gridBagConstraints2);
        forward = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/forward.gif")));
        forward.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/forward_d.gif")));
        forward.setMnemonic(39);
        forward.setActionCommand("forward");
        forward.setEnabled(false);
        forward.addActionListener(this);
        forward.setToolTipText("Go forward one document");
        jToolBar.add((Component)forward, gridBagConstraints2);
        stop = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/stop.gif")));
        stop.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/stop_d.gif")));
        stop.setMnemonic(65);
        stop.setToolTipText("Stop loading (Esc)");
        stop.addActionListener(this);
        stop.setEnabled(false);
        stop.setActionCommand("stop");
        jToolBar.add((Component)stop, gridBagConstraints2);
        refresh = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/refresh.gif")));
        refresh.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/refresh_d.gif")));
        refresh.registerKeyboardAction(this, KeyStroke.getKeyStroke("control R"), 1);
        refresh.setActionCommand("Refresh");
        refresh.setEnabled(false);
        refresh.addActionListener(this);
        refresh.setToolTipText("Refresh display (Ctrl-R)");
        jToolBar.add((Component)refresh, gridBagConstraints2);
        jToolBar.addSeparator();
        bookmarksButton = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/bookmarks.gif")));
        bookmarksButton.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/bookmarks_d.gif")));
        bookmarksButton.setActionCommand("Bookmark Button");
        bookmarksButton.addActionListener(this);
        bookmarksButton.setToolTipText("Bookmarks (Ctrl-B)");
        jToolBar.add((Component)bookmarksButton, gridBagConstraints2);
        open = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/open.gif")));
        open.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/open_d.gif")));
        open.setActionCommand("Open");
        open.setEnabled(true);
        open.setToolTipText("Open document (Ctrl-O)");
        jToolBar.add(open);
        for (int i = 0; i < 2; ++i) {
            jToolBar.addSeparator();
        }
        jToolBar.add((Component)new JLabel("Address:  "), gridBagConstraints2);
        this.tf.setEditable(true);
        this.tf.setMaximumRowCount(5);
        this.tf.setMinimumSize(new Dimension(600, 25));
        this.tf.setPreferredSize(new Dimension(660, 25));
        this.tf.setActionCommand("URLentered");
        this.tf.setToolTipText("Enter URL here (e.g. http://.../somedocument.bioml");
        this.tf.addActionListener(this);
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 0.9;
        jToolBar.add((Component)this.tf, gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jToolBar, gridBagConstraints);
        editToolbar = new JToolBar();
        editToolbar.setAlignmentX(0.0f);
        editToolbar.setFloatable(false);
        undo = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/undo.gif")));
        undo.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/undo_d.gif")));
        undo.setActionCommand("Undo");
        undo.setEnabled(false);
        undo.setToolTipText("Undo action (Ctrl-Z)");
        editToolbar.add(undo);
        redo = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/redo.gif")));
        redo.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/redo_d.gif")));
        redo.setActionCommand("Redo");
        redo.setEnabled(false);
        redo.setToolTipText("Redo action (Ctrl-Y)");
        editToolbar.add(redo);
        editToolbar.addSeparator();
        JButton jButton = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/print.gif")));
        jButton.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/print_d.gif")));
        jButton.setActionCommand("Print");
        jButton.setEnabled(true);
        jButton.setToolTipText("Print screen (Ctrl-P)");
        jButton.addActionListener(this);
        editToolbar.add(jButton);
        for (n = 0; n < 2; ++n) {
            editToolbar.addSeparator();
        }
        for (n = 0; n < 8; ++n) {
            editToolbar.addSeparator();
        }
        JLabel jLabel = new JLabel(NO_ACTION_COMMAND);
        jLabel.setPreferredSize(new Dimension(200, 20));
        editToolbar.add(jLabel);
        editToolbar.add(dlist.getZoom());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)editToolbar, gridBagConstraints);
        animator = new AnimatorApplicationTimer(10, "Bluejay", isAnApplet, implCodeBase);
        animator.startAnimation();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)animator.getLabel(), gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        logger.debug("action performed " + actionEvent.getSource().toString());
        try {
            Object var2_2 = null;
            if (actionEvent.getActionCommand().equals("back")) {
                URL uRL = localHistory.previousLocation();
                if (uRL == null) {
                    uRL = new URL(localHistory.getRealURL().toString());
                }
                if (!uRL.toString().endsWith(".xml") && !uRL.toString().endsWith(".gz")) {
                    String string = uRL.toString() + ".xml";
                    uRL = new URL(string);
                }
                this.urlLoader.leavingPage();
                if (!this.checkIfComparedHistory(uRL)) {
                    this.urlLoader.gotoURL(uRL, false);
                }
            } else if (actionEvent.getActionCommand().equals("forward")) {
                URL uRL = localHistory.nextLocation();
                if (uRL == null) {
                    uRL = new URL(localHistory.getRealURL().toString());
                }
                if (!uRL.toString().endsWith(".xml") && !uRL.toString().endsWith(".gz")) {
                    String string = uRL.toString() + ".xml";
                    uRL = new URL(string);
                }
                this.urlLoader.leavingPage();
                if (!this.checkIfComparedHistory(uRL)) {
                    this.urlLoader.gotoURL(uRL, false);
                }
            } else if (actionEvent.getActionCommand().equals("Refresh")) {
                dlist.repaint(true);
            } else if (actionEvent.getActionCommand().equals("Bookmark Button")) {
                int n = ((JButton)actionEvent.getSource()).getSize().width;
                int n2 = ((JButton)actionEvent.getSource()).getSize().height;
                bookmarksMenu.getMenu2().getPopupMenu().show((Component)actionEvent.getSource(), 0, n2);
            } else if (actionEvent.getActionCommand().equals("URLentered") && this.tf.getSelectedItem() != null) {
                if (this.tf.getSelectedItem() != null) {
                    if (!this.tf.getSelectedItem().toString().equals(tfstring)) {
                        tfstring = this.tf.getSelectedItem().toString();
                        this.urlLoader.leavingPage();
                        if (actionEvent.getSource() instanceof JComboBox) {
                            this.urlLoader.gotoURL(new URL(tfstring), true);
                        }
                    }
                } else {
                    this.urlLoader.leavingPage();
                    if (actionEvent.getSource() instanceof JComboBox) {
                        this.urlLoader.gotoURL(new URL(tfstring), true);
                    }
                }
            } else if (actionEvent.getActionCommand().equals("Print")) {
                if (dlist.getSVGDocument() != null) {
                    JSVGPrintUtility.printDocument(dlist.getSVGDocument(), dlist.getRenderingTransform(), ((JViewport)dlist.getParent()).getExtentSize());
                } else {
                    dlist.getEventCoordinator().notify(8, " You must load a document before you can print its image");
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("Malformed URL: " + malformedURLException);
            bec.notify(6, "Malformed URL: " + malformedURLException);
        }
    }

    public void addUrlToTF(String string) {
        this.tf.addItem(new String(string));
        this.tf.setSelectedIndex(0);
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    public JComboBox getTF() {
        return this.tf;
    }

    public JButton getBack() {
        return back;
    }

    public JButton getForward() {
        return forward;
    }

    public JButton getRefresh() {
        return refresh;
    }

    public JButton getStop() {
        return stop;
    }

    public JButton getUndoButton() {
        return undo;
    }

    public JButton getRedoButton() {
        return redo;
    }

    public void setLocalHistory(History history) {
        localHistory = history;
    }

    public void setURLLoader(BluejayURLLoader bluejayURLLoader) {
        this.urlLoader = bluejayURLLoader;
    }

    public void setAnimator(AnimatorApplicationTimer animatorApplicationTimer) {
        animator = animatorApplicationTimer;
    }

    public AnimatorApplicationTimer getAnimator() {
        return animator;
    }

    public void setIsAnApplet(boolean bl) {
        isAnApplet = bl;
    }

    public void setCodeBase(CodeBase codeBase) {
        implCodeBase = codeBase;
    }

    public void setBEC(BluejayEventCoordinator bluejayEventCoordinator) {
        bec = bluejayEventCoordinator;
    }

    public void setBookmarksMenu(BookmarksMenuManager bookmarksMenuManager) {
        bookmarksMenu = bookmarksMenuManager;
    }

    public void setUndoEnabled(boolean bl) {
        undo.setEnabled(bl);
    }

    public void setRedoEnabled(boolean bl) {
        redo.setEnabled(bl);
    }

    public JToolBar getEditToolbar() {
        return editToolbar;
    }

    public JButton getOpenButton() {
        return open;
    }

    public void setOnline(boolean bl) {
        bookmarksButton.setEnabled(bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    private boolean checkIfComparedHistory(URL uRL) {
        dlist.getCompMenuMan().clearGenomePool(true);
        if (this.urlLoader.getComparisons(this.urlLoader.getCurrentPositionInHistory()) != null) {
            Vector vector = this.urlLoader.getComparisons(this.urlLoader.getCurrentPositionInHistory());
            if (vector.size() == 0) {
                return false;
            }
            this.urlLoader.gotoURL((URL)vector.elementAt(0), false);
            while (dlist.isNoWorker()) {
            }
            dlist.getCompMenuMan().setComparison(true);
            dlist.getCompMenuMan().setMasterURL((URL)vector.elementAt(0));
            for (int i = 1; i < vector.size(); ++i) {
                while (!dlist.isNoWorker()) {
                }
                dlist.getCompMenuMan().setSlaveURL((URL)vector.elementAt(i));
                dlist.getCompMenuMan().addToComparisonPool();
                dlist.getCompMenuMan().paintTargetGenome((URL)vector.elementAt(i), new Genome((URL)vector.elementAt(i), 1));
            }
            return true;
        }
        return false;
    }

    static {
        tfstring = NO_ACTION_COMMAND;
        logger = Logger.getLogger(ToolbarWidgets.class);
    }
}

