/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.FeatureRangeGUI;
import ca.ucalgary.bluejay.gui.MaskPainter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.apache.log4j.Logger;

public class VisibilityManager {
    public static final String FOCUS_PROPERTY = "target focus";
    public static final String VISIBLE_PROPERTY = "target visible range";
    public static final String DRAWN_PROPERTY = "target drawn range";
    public static final String SCALE_PROPERTY = "scale in bases per pixel";
    public static final double SCALE_MIN = 0.0;
    public static final double SCALE_FITSCREEN = -3.73;
    public static final double SCALE_UNAVAILABLE = -5.898;
    public static final int PROPAGATION_ID_NONE = -67;
    public static final int EVENT_ID_NONE = -76;
    public static final int FOCUS_UNAVAILABLE = Integer.MIN_VALUE;
    private int positionInFocus = Integer.MIN_VALUE;
    private int targetInFocus = 0;
    private int visibleRangeStart;
    private int visibleRangeEnd;
    private int drawnRangeStart;
    private int drawnRangeEnd;
    private int visibleRange;
    private double drawnToVisibleRatio = 1.0;
    private double scaleInBasesPerPixel = -5.898;
    private int desiredPositionInFocus = Integer.MIN_VALUE;
    private int desiredTargetInFocus;
    private int desiredVisibleRangeStart;
    private int desiredVisibleRangeEnd;
    private int desiredDrawnRangeStart;
    private int desiredDrawnRangeEnd;
    private double desiredScale = -5.898;
    private Vector focusChangeListeners = new Vector();
    private Vector visibleChangeListeners = new Vector();
    private Vector drawnChangeListeners = new Vector();
    private Vector scaleChangeListeners = new Vector();
    private int updateEventIdKey = -76;
    private boolean shouldPropagate = true;
    private int propagationId = -67;
    private boolean usePropagationId = false;
    private LinearTarget[] targets = null;
    private BluejayDObjectList dlist;
    private static Logger logger = Logger.getLogger(VisibilityManager.class);

    public void setPropagation(boolean bl) {
        this.shouldPropagate = bl;
    }

    public int usePropagationId(boolean bl) {
        this.usePropagationId = bl;
        if (bl) {
            return ++this.propagationId;
        }
        return -67;
    }

    public int getNumFeaturesVisible(int n) {
        return this.getNumFeatures(n, this.visibleRangeStart, this.visibleRangeEnd);
    }

    public int getNumFeatures(int n, int n2, int n3) {
        if (this.targets == null || n < 0 || n > this.targets.length) {
            return 0;
        }
        MaskPainter maskPainter = this.targets[n].getMaskPainter();
        if (maskPainter != null) {
            return maskPainter.getNumFeaturesVisible(n2, n3);
        }
        return 0;
    }

    public void addFeatures(FeatureRangeGUI featureRangeGUI, int n) {
        if (this.targets == null || n < 0 || n > this.targets.length) {
            return;
        }
        MaskPainter maskPainter = this.targets[n].getMaskPainter();
        if (maskPainter != null) {
            maskPainter.addFeatures(featureRangeGUI, this.visibleRangeStart, this.visibleRangeEnd);
        }
    }

    public LinearTarget[] getVisibleTargets() {
        return this.targets;
    }

    public void setVisibleTargets(LinearTarget[] linearTargetArray) {
        this.targets = linearTargetArray;
        this.positionInFocus = Integer.MIN_VALUE;
    }

    public void replaceVisibleTarget(int n, LinearTarget linearTarget) {
        this.targets[n] = linearTarget;
    }

    public void addVisibleTarget(LinearTarget linearTarget) {
        if (this.targets == null) {
            this.targets = new LinearTarget[1];
            this.targets[0] = linearTarget;
            return;
        }
        LinearTarget[] linearTargetArray = new LinearTarget[this.targets.length + 1];
        System.arraycopy(this.targets, 0, linearTargetArray, 0, this.targets.length);
        linearTargetArray[this.targets.length] = linearTarget;
        this.targets = linearTargetArray;
    }

    public void clearVisibleTargets() {
        this.targets = null;
        this.positionInFocus = Integer.MIN_VALUE;
    }

    public void setFocusPosition(int n, int n2) throws IllegalArgumentException {
        if (this.targets == null || this.targets.length == 0) {
            logger.error("IllegalArgumentException: Tried to set target focus position in VisibilityManager, but no targets are registered as visible (developer error: call setVisibleTargets first)");
            throw new IllegalArgumentException();
        }
        if (n >= this.targets.length) {
            logger.error("IllegalArgumentException: Tried to set target focus position in VisibilityManager, but requested target index " + n + " is out of the acceptable range [0," + (this.targets.length - 1) + "]");
            throw new IllegalArgumentException();
        }
        if (n2 < this.targets[n].getMinPosition() || n2 > this.targets[n].getMaxPosition()) {
            logger.error("IllegalArgumentException: Tried to set target focus position of " + n2 + " but the acceptable range for target " + n + " is [" + this.targets[n].getMinPosition() + ", " + this.targets[n].getMaxPosition() + "]");
            throw new IllegalArgumentException();
        }
        this.desiredTargetInFocus = n;
        this.desiredPositionInFocus = n2;
        this.desiredVisibleRangeStart = (int)((double)n2 - (double)this.visibleRange / 2.0);
        this.desiredVisibleRangeEnd = (int)((double)n2 + (double)this.visibleRange / 2.0) + 1;
        logger.info("desiredVisibleRangeStart = " + this.desiredVisibleRangeStart + "\ndesiredVisibleRangeEnd = " + this.desiredVisibleRangeEnd);
        boolean bl = false;
        if (this.targets[this.targetInFocus].getShape() == 112) {
            bl = true;
        }
        int n3 = 0;
        if (this.desiredVisibleRangeStart < this.targets[n].getMinPosition()) {
            if (bl) {
                this.desiredVisibleRangeStart = this.targets[n].getMaxPosition() + this.desiredVisibleRangeStart;
            } else {
                n3 = this.targets[n].getMinPosition() - this.desiredVisibleRangeStart;
                this.desiredVisibleRangeStart = this.targets[n].getMinPosition();
                this.desiredVisibleRangeEnd += n3;
            }
        }
        if (this.desiredVisibleRangeEnd > this.targets[n].getMaxPosition()) {
            if (bl) {
                this.desiredVisibleRangeEnd -= this.targets[n].getMaxPosition();
            } else {
                n3 = this.desiredVisibleRangeEnd - this.targets[n].getMaxPosition();
                this.desiredVisibleRangeEnd = this.targets[n].getMaxPosition();
                this.desiredVisibleRangeStart -= n3;
                if (this.desiredVisibleRangeStart < this.targets[n].getMinPosition()) {
                    this.desiredVisibleRangeStart = this.targets[n].getMinPosition();
                }
            }
        }
        if (this.desiredTargetInFocus == this.targetInFocus && this.drawnRangeStart <= this.desiredVisibleRangeStart && this.drawnRangeEnd >= this.desiredVisibleRangeEnd) {
            this.desiredVisibleRangeStart = this.visibleRangeStart;
            this.desiredVisibleRangeEnd = this.visibleRangeEnd;
            this.updateProperties();
            return;
        }
        this.updateProperties();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) throws IllegalArgumentException {
        if (string == null) {
            logger.error("IllegalArgumentException: VisibilityManager.addPropertyChangeListener called with null property name");
            throw new IllegalArgumentException();
        }
        if (string.equals(FOCUS_PROPERTY)) {
            this.focusChangeListeners.add(propertyChangeListener);
        } else if (string.equals(VISIBLE_PROPERTY)) {
            this.visibleChangeListeners.add(propertyChangeListener);
        } else if (string.equals(DRAWN_PROPERTY)) {
            this.drawnChangeListeners.add(propertyChangeListener);
        } else if (string.equals(SCALE_PROPERTY)) {
            this.scaleChangeListeners.add(propertyChangeListener);
        } else {
            logger.error("IllegalArgumentException: VisibilityManager.addPropertyChangeListener called with unrecognized property '" + string + "'");
            throw new IllegalArgumentException();
        }
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string == null) {
            return;
        }
        if (string.equals(FOCUS_PROPERTY)) {
            this.focusChangeListeners.remove(propertyChangeListener);
        } else if (string.equals(VISIBLE_PROPERTY)) {
            this.visibleChangeListeners.remove(propertyChangeListener);
        } else if (string.equals(DRAWN_PROPERTY)) {
            this.drawnChangeListeners.remove(propertyChangeListener);
        } else if (string.equals(SCALE_PROPERTY)) {
            this.scaleChangeListeners.remove(propertyChangeListener);
        }
    }

    private synchronized void updateProperties() {
        int n;
        PropertyChangeEvent propertyChangeEvent;
        boolean bl = this.positionInFocus != this.desiredPositionInFocus || this.targetInFocus != this.desiredTargetInFocus;
        boolean bl2 = this.drawnRangeStart != this.desiredDrawnRangeStart || this.drawnRangeEnd != this.desiredDrawnRangeEnd;
        boolean bl3 = this.visibleRangeStart != this.desiredVisibleRangeStart || this.visibleRangeEnd != this.desiredVisibleRangeEnd;
        boolean bl4 = this.scaleInBasesPerPixel != this.desiredScale;
        int[] nArray = new int[2];
        if (bl) {
            nArray[0] = this.targetInFocus;
            nArray[1] = this.positionInFocus;
            this.positionInFocus = this.desiredPositionInFocus;
            this.targetInFocus = this.desiredTargetInFocus;
        }
        int[] nArray2 = new int[2];
        if (bl2) {
            nArray2[0] = this.drawnRangeStart;
            nArray2[1] = this.drawnRangeEnd;
            this.drawnRangeStart = this.desiredDrawnRangeStart;
            this.drawnRangeEnd = this.desiredDrawnRangeEnd;
        }
        int[] nArray3 = new int[2];
        if (bl3) {
            nArray3[0] = this.visibleRangeStart;
            nArray3[1] = this.visibleRangeEnd;
            this.visibleRangeStart = this.desiredVisibleRangeStart;
            this.visibleRangeEnd = this.desiredVisibleRangeEnd;
            if (!bl2) {
                this.setDrawnRatio(this.getDrawnRatio());
            }
        }
        Double d = new Double(this.scaleInBasesPerPixel);
        if (bl4) {
            this.scaleInBasesPerPixel = this.desiredScale;
        }
        if (!this.shouldPropagate) {
            return;
        }
        Integer n2 = new Integer(++this.updateEventIdKey);
        if (bl && this.focusChangeListeners.size() != 0) {
            propertyChangeEvent = new PropertyChangeEvent(this, FOCUS_PROPERTY, nArray, n2);
            if (this.usePropagationId) {
                propertyChangeEvent.setPropagationId(new Integer(this.propagationId));
            }
            for (n = 0; n < this.focusChangeListeners.size(); ++n) {
                ((PropertyChangeListener)this.focusChangeListeners.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
        if (bl3 && this.visibleChangeListeners.size() != 0) {
            propertyChangeEvent = new PropertyChangeEvent(this, VISIBLE_PROPERTY, nArray3, n2);
            if (this.usePropagationId) {
                propertyChangeEvent.setPropagationId(new Integer(this.propagationId));
            }
            for (n = 0; n < this.visibleChangeListeners.size(); ++n) {
                ((PropertyChangeListener)this.visibleChangeListeners.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
        if (bl2 && this.drawnChangeListeners.size() != 0) {
            propertyChangeEvent = new PropertyChangeEvent(this, DRAWN_PROPERTY, nArray2, n2);
            if (this.usePropagationId) {
                propertyChangeEvent.setPropagationId(new Integer(this.propagationId));
            }
            for (n = 0; n < this.drawnChangeListeners.size(); ++n) {
                ((PropertyChangeListener)this.drawnChangeListeners.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
        if (bl4 && this.scaleChangeListeners.size() != 0) {
            propertyChangeEvent = new PropertyChangeEvent(this, SCALE_PROPERTY, d, n2);
            if (this.usePropagationId) {
                propertyChangeEvent.setPropagationId(new Integer(this.propagationId));
            }
            for (n = 0; n < this.scaleChangeListeners.size(); ++n) {
                ((PropertyChangeListener)this.scaleChangeListeners.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
    }

    public int getFocusPosition() {
        return this.positionInFocus;
    }

    public int getFocusTarget() {
        return this.targetInFocus;
    }

    public void setVisibleRange(int n, int n2, int n3) throws IllegalArgumentException {
        if (this.targets == null || this.targets.length == 0) {
            logger.error("IllegalArgumentException: Tried to set visible range in VisibilityManager, but no targets are registered as visible (developer error: call setVisibleTargets first)");
            throw new IllegalArgumentException();
        }
        if (n >= this.targets.length) {
            logger.error("IllegalArgumentException: Tried to set visible range in VisibilityManager, but requested target index " + n + " is out of the acceptable range [0," + (this.targets.length - 1) + "]");
            throw new IllegalArgumentException();
        }
        if (n2 < this.targets[n].getMinPosition() || n2 > this.targets[n].getMaxPosition()) {
            logger.error("IllegalArgumentException: Tried to set target visible range start to " + n2 + " but the acceptable range for target " + n + " is [" + this.targets[n].getMinPosition() + ", " + this.targets[n].getMaxPosition() + "]");
            throw new IllegalArgumentException();
        }
        if (n3 < this.targets[n].getMinPosition() || n3 > this.targets[n].getMaxPosition()) {
            logger.error("IllegalArgumentException: Tried to set target visible range end to " + n2 + " but the acceptable range for target " + n + " is [" + this.targets[n].getMinPosition() + ", " + this.targets[n].getMaxPosition() + "]");
            throw new IllegalArgumentException();
        }
        this.desiredTargetInFocus = n;
        this.desiredPositionInFocus = this.scaleInBasesPerPixel == -3.73 || this.scaleInBasesPerPixel == -5.898 || n2 == this.targets[n].getMinPosition() && n3 == this.targets[n].getMaxPosition() ? 1 : n2 + (n3 - n2) / 2;
        this.desiredVisibleRangeStart = n2;
        this.desiredVisibleRangeEnd = n3;
        if (this.desiredVisibleRangeStart == this.targets[n].getMinPosition() && this.desiredVisibleRangeEnd == this.targets[n].getMaxPosition() && this.desiredPositionInFocus == Integer.MIN_VALUE) {
            this.desiredPositionInFocus = 1;
        }
        if (this.desiredVisibleRangeStart > this.desiredVisibleRangeEnd) {
            this.desiredPositionInFocus = this.desiredVisibleRangeEnd / 2 - (this.targets[n].getMaxPosition() - this.desiredVisibleRangeStart + 1) / 2;
            if (this.desiredPositionInFocus == 0) {
                this.desiredPositionInFocus = 1;
            }
            if (this.desiredPositionInFocus < 1) {
                this.desiredPositionInFocus = this.targets[n].getMaxPosition() + this.desiredPositionInFocus;
            }
        }
        this.visibleRange = this.desiredVisibleRangeEnd - this.desiredVisibleRangeStart;
        if (this.visibleRange < 0) {
            this.visibleRange = this.targets[n].getMaxPosition() - this.targets[n].getMinPosition() + 1 + this.visibleRange;
        }
        this.updateProperties();
    }

    public boolean isCompleteTargetVisible(int n) {
        return n == this.targetInFocus && this.visibleRangeStart == this.targets[n].getMinPosition() && this.visibleRangeEnd == this.targets[n].getMaxPosition();
    }

    public boolean isCompleteTargetDrawn(int n) {
        return n == this.targetInFocus && this.drawnRangeStart == this.targets[n].getMinPosition() && this.drawnRangeEnd == this.targets[n].getMaxPosition();
    }

    public boolean isPositionVisible(int n, int n2) {
        return n == this.targetInFocus && this.visibleRangeStart <= n2 && this.visibleRangeEnd >= n2;
    }

    public boolean isPositionDrawn(int n, int n2) {
        return n == this.targetInFocus && this.drawnRangeStart <= n2 && this.drawnRangeEnd >= n2;
    }

    public int[] getVisibleRange() {
        int[] nArray = new int[]{this.visibleRangeStart, this.visibleRangeEnd};
        return nArray;
    }

    public int[] getDrawnRange() {
        int[] nArray = new int[]{this.drawnRangeStart, this.drawnRangeEnd};
        return nArray;
    }

    public void setDrawnRatio(double d) throws IllegalArgumentException {
        if (d < 1.0) {
            logger.error("IllegalArgumentException: Drawn to Visible ratio cannot be less than 1, request was " + d);
            throw new IllegalArgumentException();
        }
        if (d == this.drawnToVisibleRatio) {
            // empty if block
        }
        this.drawnToVisibleRatio = d;
        if (this.targets == null || this.targets.length == 0) {
            return;
        }
        int n = (int)((double)this.visibleRange * this.drawnToVisibleRatio) + 1;
        if (this.isCompleteTargetVisible(this.targetInFocus)) {
            this.desiredDrawnRangeStart = this.visibleRangeStart;
            this.desiredDrawnRangeEnd = this.visibleRangeEnd;
        } else {
            this.desiredDrawnRangeStart = (int)((double)this.positionInFocus - (double)n / 2.0);
            this.desiredDrawnRangeEnd = (int)((double)this.positionInFocus + (double)n / 2.0) + 1;
        }
        if (this.targets == null || this.targets.length == 0) {
            return;
        }
        boolean bl = false;
        if (this.targets[this.targetInFocus].getShape() == 112) {
            bl = true;
        }
        int n2 = 0;
        if (this.desiredDrawnRangeStart < this.targets[this.targetInFocus].getMinPosition()) {
            if (bl) {
                this.desiredDrawnRangeStart += this.targets[this.targetInFocus].getMaxPosition();
            } else {
                n2 = this.targets[this.targetInFocus].getMinPosition() - this.desiredDrawnRangeStart;
                this.desiredDrawnRangeStart = this.targets[this.targetInFocus].getMinPosition();
                this.desiredDrawnRangeEnd = this.desiredDrawnRangeStart + n;
                if (this.desiredDrawnRangeEnd > this.targets[this.targetInFocus].getMaxPosition()) {
                    this.desiredDrawnRangeEnd = this.targets[this.targetInFocus].getMaxPosition();
                }
            }
        }
        if (this.desiredDrawnRangeEnd > this.targets[this.targetInFocus].getMaxPosition()) {
            if (bl) {
                this.desiredDrawnRangeEnd -= this.targets[this.targetInFocus].getMaxPosition();
            } else {
                n2 = this.desiredDrawnRangeEnd - this.targets[this.targetInFocus].getMaxPosition();
                this.desiredDrawnRangeEnd = this.targets[this.targetInFocus].getMaxPosition();
                this.desiredDrawnRangeStart = this.desiredDrawnRangeEnd - n;
                if (this.desiredDrawnRangeStart < this.targets[this.targetInFocus].getMinPosition()) {
                    this.desiredDrawnRangeStart = this.targets[this.targetInFocus].getMinPosition();
                }
            }
        }
        if ((this.visibleRangeStart > this.visibleRangeEnd || this.visibleRangeStart == this.visibleRangeEnd + 1) && this.desiredDrawnRangeStart < this.desiredDrawnRangeEnd) {
            this.desiredDrawnRangeStart = this.targets[this.targetInFocus].getMinPosition();
            this.desiredDrawnRangeEnd = this.targets[this.targetInFocus].getMaxPosition();
        }
        this.updateProperties();
    }

    public double getDrawnRatio() {
        return this.drawnToVisibleRatio;
    }

    public void setScale(double d) throws IllegalArgumentException {
        if (d < 0.0 && d != -5.898 && d != -3.73) {
            logger.error("IllegalArgumentException: Scale cannot be less than 0.0, VisibilityManager.setScale(double) was given " + d + ", ignoring");
            throw new IllegalArgumentException();
        }
        this.desiredScale = d;
        this.updateProperties();
    }

    public double getScale() {
        return this.scaleInBasesPerPixel;
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
    }

    public BluejayDObjectList getDList() {
        return this.dlist;
    }

    public MaskPainter getMaskPainter(int n) {
        return this.targets[n].getMaskPainter();
    }
}

