/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.Logger;

public class XCheckBox
extends JCheckBox {
    public static final int IS_UNDO = 100;
    public static final int IS_NOT_UNDO = 101;
    private static Logger logger = Logger.getLogger(XCheckBox.class);
    private static CheckBoxIcon _checkBoxIcon = new CheckBoxIcon();
    private int _selected = 114;
    private boolean _has3State = true;

    public XCheckBox(String string) {
        this(string, 114);
    }

    public XCheckBox(String string, int n) throws IllegalArgumentException {
        super(string);
        this._selected = n;
        this.setIcon(_checkBoxIcon);
        if (n == 114) {
            this.setToolTipText("Click to make visible");
        } else if (n == 112) {
            this.setToolTipText("Click to ghost");
        } else if (n == 113) {
            this.setToolTipText("Click to make invisible");
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Attempt to set unknown data visibility mode");
            illegalArgumentException.printStackTrace();
            throw illegalArgumentException;
        }
    }

    public int getSelectionState() {
        return this._selected;
    }

    public void setSelectionState(int n) throws IllegalArgumentException {
        if (this._selected != n) {
            if (n == 112 || n == 113 || n == 114) {
                if (n == 113) {
                    this.set3State(true);
                }
                this._selected = n;
                this.repaint();
            } else {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Attempt to set unknown data visibility mode");
                illegalArgumentException.printStackTrace();
                throw illegalArgumentException;
            }
        }
    }

    public void set3State(boolean bl) {
        this._has3State = bl;
    }

    public boolean has3State() {
        return this._has3State;
    }

    public void updateVisualState(int n) {
        int n2 = this.getSelectionState();
        boolean bl = false;
        logger.debug("entered update selection state that changes checkbox state selection state is:" + n2);
        if (n == 100) {
            this._selected = this.has3State() ? (n2 == 114 ? 113 : (n2 == 113 ? 112 : 114)) : (n2 == 114 ? 114 : 112);
        } else if (n == 101) {
            this._selected = this.has3State() ? (n2 == 114 ? 112 : (n2 == 113 ? 114 : 113)) : (n2 == 114 ? 112 : 114);
        } else if (n == 112 || n == 113 || n == 114) {
            if (n == 113) {
                this.set3State(true);
            }
            bl = true;
            this._selected = n;
            this.repaint();
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Attempt to use unknown data visibility mode");
            illegalArgumentException.printStackTrace();
            throw illegalArgumentException;
        }
        if (!bl) {
            if (this._selected == 114) {
                this.setToolTipText("Click to make visible");
            } else if (this._selected == 112) {
                this.setToolTipText("Click to ghost");
            } else {
                this.setToolTipText("Click to make invisible");
            }
        } else if (this._selected == 114) {
            this.setToolTipText("Click to make all Legend items visible");
        } else if (this._selected == 112) {
            this.setToolTipText("Click to ghost all Legend items");
        } else {
            this.setToolTipText("Click to make all Legend items invisible");
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int CONTROL_SIZE = 13;

        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            XCheckBox xCheckBox = (XCheckBox)component;
            ButtonModel buttonModel = xCheckBox.getModel();
            int n3 = this.getControlSize();
            if (xCheckBox.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(n, n2, n3 - 1, n3 - 1);
                    this.drawPressed3DBorder(graphics, n, n2, n3, n3);
                } else {
                    this.drawFlush3DBorder(graphics, n, n2, n3, n3);
                }
                graphics.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n, n2, n3 - 1, n3 - 1);
            }
            if (xCheckBox.getSelectionState() != 114) {
                if (xCheckBox.getSelectionState() == 113) {
                    graphics.fillRect(n + 3, n2 + 5, 2, 2);
                    graphics.fillRect(n + 3, n2 + 8, 2, 2);
                    graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 4);
                    graphics.drawLine(n + 8, n2 + 4, n + 8, n2 + 4);
                    graphics.drawLine(n + 7, n2 + 6, n + 6, n2 + 6);
                    graphics.drawLine(n + 6, n2 + 7, n + 6, n2 + 7);
                } else {
                    graphics.fillRect(n + 3, n2 + 5, 2, n3 - 8);
                    graphics.drawLine(n + (n3 - 4), n2 + 3, n + 5, n2 + (n3 - 6));
                    graphics.drawLine(n + (n3 - 4), n2 + 4, n + 5, n2 + (n3 - 5));
                }
            }
        }

        void drawFlush3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawRect(1, 1, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(0, n4 - 1, 1, n4 - 2);
            graphics.drawLine(n3 - 1, 0, n3 - 2, 1);
            graphics.translate(-n, -n2);
        }

        void drawPressed3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            this.drawFlush3DBorder(graphics, 0, 0, n3, n4);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(1, 1, 1, n4 - 2);
            graphics.drawLine(1, 1, n3 - 2, 1);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

