/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDMarkupSpecifier;
import ca.ucalgary.bluejay.client.URLLoader;
import ca.ucalgary.bluejay.client.impl.BluejayEntityResolver;
import ca.ucalgary.bluejay.client.impl.BluejayURLLoader;
import ca.ucalgary.bluejay.client.impl.XbelMarkupSpecifier;
import ca.ucalgary.bluejay.gui.BluejayAbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.menu.ViewMenuManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XbelBookmarksGUI
implements ActionListener {
    protected DocumentBuilder docBuilder = null;
    URLLoader browser = null;
    private Hashtable bmhashtable = null;
    private static Logger logger = Logger.getLogger(XbelBookmarksGUI.class);
    private URL u;
    private ComparisonMenuManager comparisonMenuMgr;
    private ViewMenuManager viewMenuMgr;
    private BluejayDObjectList dlist;

    public XbelBookmarksGUI() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            this.docBuilder = documentBuilderFactory.newDocumentBuilder();
            DTDMarkupSpecifier[] dTDMarkupSpecifierArray = new DTDMarkupSpecifier[]{new XbelMarkupSpecifier()};
            this.docBuilder.setEntityResolver(new BluejayEntityResolver(dTDMarkupSpecifierArray));
            this.bmhashtable = new Hashtable();
            this.u = null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error("Yikes! No parser available! " + parserConfigurationException);
        }
    }

    public JMenu readFile(Object object, JMenu jMenu) throws SAXException, IOException {
        Document document = this.getDocument(object);
        if (document != null) {
            Element element = document.getDocumentElement();
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                jMenu = this.createMenuItems((Element)node, jMenu);
            }
        }
        return jMenu;
    }

    public Document getDocument(Object object) throws SAXException, IOException {
        Document document = null;
        document = object instanceof URL ? this.docBuilder.parse(((URL)object).openConnection().getInputStream()) : this.docBuilder.parse(new ByteArrayInputStream(((String)object).getBytes()));
        return document;
    }

    private JMenu createMenuItems(Element element, JMenu jMenu) {
        if (element.getTagName().equals("folder")) {
            Node node;
            String string = new String();
            JMenu jMenu2 = new JMenu();
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node.getFirstChild() instanceof Text)) continue;
                string = ((Text)node.getFirstChild()).getData();
                jMenu2.setText(string);
                jMenu.add(jMenu2);
                break;
            }
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                jMenu2 = this.createMenuItems((Element)node, jMenu2);
            }
        } else if (element.getTagName().equals("bookmark")) {
            Object object;
            String string = new String();
            String string2 = new String();
            string2 = element.getAttribute("href");
            for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (!(object.getFirstChild() instanceof Text)) continue;
                string = ((Text)object.getFirstChild()).getData();
            }
            object = new JMenuItem(string);
            this.bmhashtable.put(string, string2);
            ((AbstractButton)object).setActionCommand("Bookmark");
            ((AbstractButton)object).addActionListener(this);
            jMenu.add((JMenuItem)object);
        }
        return jMenu;
    }

    public void addBookmark(JMenu jMenu, String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand("Bookmark");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.bmhashtable.put(string, string2);
    }

    public void setURLLoader(URLLoader uRLLoader) {
        this.browser = uRLLoader;
    }

    public String getURL(String string) {
        Object v = this.bmhashtable.get(string);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            logger.debug("In XBEL Bookmarks");
            if (actionEvent.getActionCommand().equals("Bookmark")) {
                if (actionEvent.getSource() instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string = jMenuItem.getText();
                    this.u = new URL(this.getURL(string));
                    if (this.dlist.getWaypointsWidget().getNumWaypoints() > 0) {
                        this.dlist.getWaypointsWidget().selectAllWaypoints(true);
                        this.dlist.getWaypointsWidget().removeSelectedWaypoints(false);
                        if (this.dlist.getWaypointsTab() != null) {
                            this.viewMenuMgr.getTabbedPane().remove(this.dlist.getWaypointsTab());
                        }
                        this.dlist.setWaypointsTab(null);
                    }
                    if (this.dlist.getAbstractLinearGraphics().isInTextMode()) {
                        this.viewMenuMgr.setDefaultView();
                    }
                    this.viewMenuMgr.enableInitiallyDisabledViewMenus();
                    if (ComparisonMenuManager.isComparison) {
                        this.comparisonMenuMgr.clearGenomePool(true);
                    }
                    this.comparisonMenuMgr.setMasterURL(this.u);
                    this.comparisonMenuMgr.enableAddMenu();
                    if (!this.comparisonMenuMgr.getComparisonPool().isPoolEmpty()) {
                        this.comparisonMenuMgr.getComparisonPool().emptyPool();
                        this.comparisonMenuMgr.disableUnloadAndSpecifyMenus();
                    }
                    ((BluejayAbstractLinearGraphics)this.dlist.getAbstractLinearGraphics()).getLLPainter().setGCPoolSingle(new Hashtable());
                    ((BluejayAbstractLinearGraphics)this.dlist.getAbstractLinearGraphics()).getLLPainter().setDeiPool(new Hashtable());
                    ((BluejayAbstractLinearGraphics)this.dlist.getAbstractLinearGraphics()).getLLPainter().setShowingParsomes(new Hashtable<String, Boolean>());
                    ((BluejayAbstractLinearGraphics)this.dlist.getAbstractLinearGraphics()).getLLPainter().setShowingFamilies(new Hashtable<Integer, Boolean>());
                    this.comparisonMenuMgr.getParalogyMenuManager().setLoadingNewDocument(true);
                    logger.debug("Bookmark URL = " + this.u);
                    ((BluejayURLLoader)this.browser).leavingPage();
                    this.browser.gotoURL(this.u, true);
                }
            } else {
                logger.debug("For some reason, we're in XbelBookmarks.");
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.error(malformedURLException.getMessage());
            malformedURLException.printStackTrace();
        }
    }

    public Hashtable getBookmarkHashTable() {
        return this.bmhashtable;
    }

    public void setComparisonMenuMgr(ComparisonMenuManager comparisonMenuManager) {
        this.comparisonMenuMgr = comparisonMenuManager;
    }

    public ComparisonMenuManager getComparisonMenuMgr() {
        return this.comparisonMenuMgr;
    }

    public void setViewMenuMgr(ViewMenuManager viewMenuManager) {
        this.viewMenuMgr = viewMenuManager;
    }

    public ViewMenuManager getViewMenuMgr() {
        return this.viewMenuMgr;
    }

    public URL getURL() {
        return this.u;
    }

    public BluejayURLLoader getURLLoader() {
        return (BluejayURLLoader)this.browser;
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
    }
}

