/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.comparison;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.painter.LinkingLinePainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JPanel;

public class GenomeLabelPainter
extends JPanel {
    private BluejayDObjectList bjDlist;

    public GenomeLabelPainter(BluejayDObjectList bluejayDObjectList) {
        this.bjDlist = bluejayDObjectList;
    }

    public void paint(Graphics graphics, Dimension dimension) {
        Object object;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 6;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n5 = (int)((double)fontMetrics.getHeight() * 0.6);
        ComparisonPool comparisonPool = this.bjDlist.getComparisonPool();
        Vector<Genome> vector = comparisonPool.getSeqsFromPool();
        int n6 = comparisonPool.getPoolSize();
        String[] stringArray = new String[n6];
        String[] stringArray2 = new String[n6];
        for (n = 0; n < n6; ++n) {
            object = vector.elementAt(n).getGenomeName();
            if (((String)object).contains("~")) {
                stringArray2[n] = "";
                object = ((String)object).replaceFirst("~", " {").replaceAll("_", ", ") + "}";
            } else {
                stringArray2[n] = n == 0 ? "[M] " : "[S" + n + "] ";
                object = ((String)object).replaceAll("_", " ");
            }
            stringArray[n] = "  " + (String)object;
            int n7 = fontMetrics.stringWidth(stringArray2[n]);
            int n8 = fontMetrics.stringWidth(stringArray[n]);
            if (n7 > n2) {
                n2 = n7;
            }
            if (n8 <= n3) continue;
            n3 = n8;
        }
        graphics.translate(dimension.width - n2 - n5 - n3 - 5, 15);
        for (n = 0; n < n6; ++n) {
            object = vector.elementAt(n).getGenomeColor();
            graphics.setColor((Color)object);
            graphics.fillOval(n2, (n6 - n - 1) * (n5 + n4) - n5, n5, n5);
            graphics.setColor(Color.black);
            graphics.drawString(stringArray2[n], 0, (n6 - n - 1) * (n5 + n4));
            graphics.drawString(stringArray[n], n2 + n5, (n6 - n - 1) * (n5 + n4));
        }
    }

    public void paintChrLegend(Graphics graphics, Dimension dimension, LinkingLinePainter linkingLinePainter) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 6;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n7 = (int)((double)fontMetrics.getHeight() * 0.7);
        int n8 = this.bjDlist.getChrNames().length;
        String[] stringArray = new String[n8];
        String[] stringArray2 = new String[n8];
        String string = this.bjDlist.getOrganism();
        for (n3 = 0; n3 < n8; ++n3) {
            String string2 = this.bjDlist.getChrNames()[n3];
            stringArray2[n3] = "";
            stringArray[n3] = "  " + string2;
            n2 = fontMetrics.stringWidth(stringArray2[n3]);
            n = fontMetrics.stringWidth(stringArray[n3]);
            if (n2 > n4) {
                n4 = n2;
            }
            if (n <= n5) continue;
            n5 = n;
        }
        n5 = Math.max(n5, fontMetrics.stringWidth("Centromere"));
        n3 = n4 + n7 + n5 + 10;
        graphics.translate(dimension.width - n3, 15);
        graphics.setColor(Color.BLUE);
        graphics.drawString(string.substring(0, 1).toUpperCase() + string.substring(1), n4, 0);
        graphics.drawString("chromosomes", n4, n7 + n6);
        int n9 = 0;
        n2 = 2;
        n = 20;
        for (int i = 0; i < n8; ++i) {
            if (i == n) {
                n9 = n3 / 2 + 1;
                n2 = 2;
            }
            graphics.setColor(this.bjDlist.getChrColors()[i]);
            graphics.fillOval(n9 + n4, n2 * (n7 + n6) - n7, n7, n7);
            graphics.setColor(Color.BLACK);
            graphics.drawString(stringArray2[i], 0, (i + 2) * (n7 + n6));
            graphics.drawString(stringArray[i], n9 + n4 + n7, n2 * (n7 + n6));
            ++n2;
        }
        n2 = Math.min(n8, n) + 2;
        if (this.bjDlist.isDrawingCentromeres()) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(n4 + 1, n2 * (n7 + n6) - n7 / 2, n7 - 1, n7 / 4);
            graphics.drawString("  Centromere", n4 + n7, n2 * (n7 + n6));
            ++n2;
        }
        ++n2;
        if (linkingLinePainter.isLinkingSelf()) {
            int n10;
            graphics.setColor(Color.BLUE);
            graphics.drawString("Paralogous", n4, n2 * (n7 + n6));
            graphics.drawString("regions", n4, ++n2 * (n7 + n6));
            ++n2;
            graphics.setColor(Color.black);
            String[] stringArray3 = this.bjDlist.getParNames();
            for (n10 = 0; n10 < stringArray3.length; ++n10) {
                if (linkingLinePainter.isShowingParsome(stringArray3[n10])) {
                    graphics.setColor(this.bjDlist.getParColor(stringArray3[n10]));
                    graphics.fillOval(n4, n2 * (n7 + n6) - n7, n7, n7);
                    graphics.setColor(Color.black);
                } else {
                    graphics.drawOval(n4 + 1, n2 * (n7 + n6) - n7 + 1, n7 - 2, n7 - 2);
                }
                graphics.drawString("  " + stringArray3[n10], n4 + n7, n2 * (n7 + n6));
                ++n2;
            }
            graphics.setColor(Color.BLUE);
            graphics.drawString("Copy numbers", n4, ++n2 * (n7 + n6));
            ++n2;
            graphics.setColor(Color.black);
            n10 = 2;
            while (n10 <= linkingLinePainter.getMaxCopyNumber()) {
                if (linkingLinePainter.isShowingFamily(n10)) {
                    graphics.fillOval(n4, n2 * (n7 + n6) - n7, n7, n7);
                } else {
                    graphics.drawOval(n4 + 1, n2 * (n7 + n6) - n7 + 1, n7 - 2, n7 - 2);
                }
                String string3 = "  " + Integer.toString(n10);
                if (n10 == linkingLinePainter.getMaxCopyNumber()) {
                    string3 = string3 + " or more";
                }
                graphics.drawString(string3, n4 + n7, n2 * (n7 + n6));
                ++n10;
                ++n2;
            }
        }
    }
}

