/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.cpane;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class TextToolBar
extends JToolBar
implements ItemListener {
    public static String NO_SELECTION = "None";
    public static String TWO_FRAME_SELECTION = "Two Frame";
    public static String SIX_FRAME_SELECTION = "Six Frame";
    public static String THREE_LETTER_AA_CODES = "Three Letter Amino Acid Codes";
    public static String ONE_LETTER_AA_CODES = "One Letter Amino Acid Codes";
    private static TextToolBar toolbar = null;
    private JButton cut;
    private JButton copy;
    private JButton paste;
    private JButton geneticCodeSelector;
    private JComboBox translationList;
    private JComboBox codeList;
    private EventListener listener;
    private JComponent contentPane;

    private TextToolBar() {
        this.setFloatable(false);
        this.setPreferredSize(new Dimension(100, 30));
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.cut = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/cut.gif")));
        this.cut.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/cut_d.gif")));
        this.cut.setActionCommand("Cut");
        this.cut.setEnabled(false);
        this.cut.setToolTipText("Cut the selected portion of genome");
        this.add(this.cut);
        this.copy = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/copy.gif")));
        this.copy.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/copy_d.gif")));
        this.copy.setActionCommand("Copy");
        this.copy.setEnabled(false);
        this.copy.setToolTipText("Copy the selected portion of genome");
        this.add(this.copy);
        this.paste = new JButton(new ImageIcon(classLoader.getResource("images/ToolbarIcons/paste.gif")));
        this.paste.setDisabledIcon(new ImageIcon(classLoader.getResource("images/ToolbarIcons/paste_d.gif")));
        this.paste.setActionCommand("Paste");
        this.paste.setEnabled(false);
        this.paste.setToolTipText("Paste a portion of genome");
        this.add(this.paste);
        this.addSeparator();
        JLabel jLabel = new JLabel("Protein Translation:   ");
        this.translationList = new JComboBox();
        this.translationList.addItem(NO_SELECTION);
        this.translationList.addItem(TWO_FRAME_SELECTION);
        this.translationList.addItem(SIX_FRAME_SELECTION);
        this.translationList.addItemListener(this);
        this.add(jLabel);
        this.add(this.translationList);
        this.codeList = new JComboBox();
        this.codeList.addItem(THREE_LETTER_AA_CODES);
        this.codeList.addItem(ONE_LETTER_AA_CODES);
        this.codeList.setEnabled(false);
        this.add(this.codeList);
        this.geneticCodeSelector = new JButton("Select Genetic Code");
        this.geneticCodeSelector.setActionCommand("select_genetic_code");
        this.geneticCodeSelector.setEnabled(false);
        this.geneticCodeSelector.setToolTipText("Select a different genetic code");
        this.add(this.geneticCodeSelector);
        this.setVisible(false);
    }

    public static TextToolBar getInstance() {
        if (toolbar == null) {
            toolbar = new TextToolBar();
        }
        return toolbar;
    }

    public boolean hasListener() {
        return this.listener != null;
    }

    public void addListener(EventListener eventListener) {
        if (this.listener == null) {
            this.listener = eventListener;
            if (this.listener instanceof ActionListener) {
                this.cut.addActionListener((ActionListener)this.listener);
                this.copy.addActionListener((ActionListener)this.listener);
                this.paste.addActionListener((ActionListener)this.listener);
                this.geneticCodeSelector.addActionListener((ActionListener)this.listener);
            }
            if (this.listener instanceof ItemListener) {
                this.translationList.addItemListener((ItemListener)this.listener);
                this.codeList.addItemListener((ItemListener)this.listener);
            }
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.contentPane != null) {
            ((JSplitPane)this.contentPane).resetToPreferredSizes();
        }
    }

    public void setContentPane(JComponent jComponent) {
        this.contentPane = jComponent;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JComboBox jComboBox = (JComboBox)itemEvent.getSource();
        if (jComboBox.getSelectedItem() == NO_SELECTION) {
            this.codeList.setEnabled(false);
            this.geneticCodeSelector.setEnabled(false);
        } else {
            this.codeList.setEnabled(true);
            this.geneticCodeSelector.setEnabled(true);
        }
    }
}

