/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.gui.menu.BluejayMenuManager;
import ca.ucalgary.bluejay.gui.util.CodeBase;
import ca.ucalgary.bluejay.gui.util.Debug;
import edu.stanford.ejalbert.BrowserLauncher;
import java.applet.AppletContext;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpMenuManager
implements BluejayMenuManager,
ActionListener,
HyperlinkListener {
    private static HelpBroker mainHelpBroker = null;
    private static CSH.DisplayHelpFromSource csh = null;
    private static final String mainHelpSetName = "helpset/BluejayHelp.hs";
    private JMenuItem helpItem = null;
    public static boolean isAnApplet;
    private boolean notSigned;
    private static JFrame main_frame;
    private static CodeBase implCodeBase;
    private static AppletContext currAppletContext;

    public JMenu createMenu() {
        JMenu jMenu = new JMenu("Help");
        this.helpItem = new JMenuItem("Help Browser");
        this.helpItem.addActionListener(this);
        this.helpItem.setActionCommand("helpbrowser");
        jMenu.add(this.helpItem);
        JMenuItem jMenuItem = new JMenuItem("Quick Start");
        jMenuItem.setEnabled(false);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("About Bluejay");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("identity");
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    private void initHelpSystem(ActionEvent actionEvent) {
        if (mainHelpBroker == null) {
            HelpSet helpSet = null;
            Object var3_3 = null;
            try {
                URL uRL = null;
                if (this.notSigned) {
                    uRL = HelpSet.findHelpSet(this.getClass().getClassLoader(), mainHelpSetName);
                    System.out.println("we are in an applet for help" + uRL);
                } else {
                    uRL = HelpSet.findHelpSet(this.getClass().getClassLoader(), mainHelpSetName);
                    System.out.println("hsURL is" + uRL);
                }
                if (uRL == null) {
                    System.out.println("HelpSet helpset/BluejayHelp.hs not found.");
                } else {
                    helpSet = new HelpSet(this.getClass().getClassLoader(), uRL);
                }
            }
            catch (HelpSetException helpSetException) {
                System.out.println("HelpSet helpset/BluejayHelp.hs could not be opened.");
                System.out.println(helpSetException.getMessage());
            }
            if (helpSet != null) {
                mainHelpBroker = helpSet.createHelpBroker();
            }
            if (mainHelpBroker != null) {
                csh = new CSH.DisplayHelpFromSource(mainHelpBroker);
            }
        }
        if (csh != null) {
            System.out.println("About to add HELP action Listener");
            this.helpItem.addActionListener(csh);
            this.helpItem.removeActionListener(this);
            csh.actionPerformed(actionEvent);
        }
    }

    public void setIsAnApplet(boolean bl) {
        isAnApplet = bl;
    }

    public void setNotSigned(boolean bl) {
        this.notSigned = bl;
    }

    public void setMainFrame(JFrame jFrame) {
        main_frame = jFrame;
    }

    public void setCodeBase(CodeBase codeBase) {
        implCodeBase = codeBase;
    }

    public void setAppletContext(AppletContext appletContext) {
        currAppletContext = appletContext;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Debug.DEBUG) {
            System.out.println("action performed " + actionEvent.getSource().toString());
        }
        if (actionEvent.getActionCommand().equals("helpbrowser")) {
            this.initHelpSystem(actionEvent);
        } else if (actionEvent.getActionCommand().equals("identity")) {
            try {
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setEditable(false);
                jEditorPane.setContentType("text/html");
                jEditorPane.setPage(this.getClass().getClassLoader().getResource("docs/identity.html"));
                jEditorPane.addHyperlinkListener(this);
                JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                jScrollPane.setPreferredSize(new Dimension(350, 500));
                JOptionPane.showMessageDialog(main_frame, jScrollPane, "About Bluejay", -1);
            }
            catch (IOException iOException) {
                System.err.println("About display problem " + iOException.getStackTrace());
            }
            catch (Exception exception) {
                System.err.println("About general exception:" + exception.getMessage());
            }
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        try {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                BrowserLauncher.openURL(hyperlinkEvent.getURL().toString());
            }
        }
        catch (IOException iOException) {
            System.err.println("Cannot open URL " + hyperlinkEvent.getURL().toString() + " due to I/O exception: " + iOException);
        }
    }
}

