/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayAbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.menu.BluejayMenuManager;
import ca.ucalgary.bluejay.gui.painter.LinkingLinePainter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class ParalogyMenuManager
implements BluejayMenuManager,
ActionListener,
ItemListener {
    private JMenu paralogy;
    private JCheckBoxMenuItem vizParalogy;
    private JMenuItem selectParsomes;
    private JCheckBox showAllPars;
    private JCheckBox hideAllPars;
    private JCheckBox[] showPars;
    private JMenuItem selectFamilies;
    private JCheckBox showAllFams;
    private JCheckBox hideAllFams;
    private JCheckBox[] showFams;
    private JRadioButtonMenuItem useParsomeColors;
    private JRadioButtonMenuItem useGeneColors;
    private BluejayDObjectList dlist;
    private AbstractLinearGraphics alg;
    private String[] parNames;
    private int[] copyNumbers;
    private boolean loadingNewDocument = false;
    private static final String VIZ_PARALOGY = "Visualize Gene Paralogy";
    private static final String SELECT_PARSOMES = "Show/Hide Paralogous Regions";
    private static final String SHOW_ALL_PARSOMES = "Show All Regions";
    private static final String HIDE_ALL_PARSOMES = "Hide All Regions";
    private static final String SHOW_PARSOME_PREFIX = "Show Region ";
    private static final String SELECT_FAMILIES = "Show/Hide Gene Families";
    private static final String SHOW_ALL_FAMILIES = "Show All Families";
    private static final String HIDE_ALL_FAMILIES = "Hide All Families";
    private static final String SHOW_FAMILY_PREFIX = "Show Families with Copy Number ";
    private static final String USE_PARSOME_COLORS = "Use Paralogous Region Colors for Links";
    private static final String USE_GENE_COLORS = "Use Gene Colors for Links";

    public JMenu createMenu() {
        this.vizParalogy = new JCheckBoxMenuItem(VIZ_PARALOGY);
        this.vizParalogy.setMnemonic(86);
        this.vizParalogy.setAccelerator(KeyStroke.getKeyStroke("control V"));
        this.vizParalogy.addItemListener(this);
        this.vizParalogy.setSelected(false);
        this.vizParalogy.setEnabled(false);
        this.selectParsomes = new JMenuItem(SELECT_PARSOMES);
        this.selectParsomes.setMnemonic(80);
        this.selectParsomes.setAccelerator(KeyStroke.getKeyStroke("control P"));
        this.selectParsomes.setActionCommand(SELECT_PARSOMES);
        this.selectParsomes.addActionListener(this);
        this.selectParsomes.setEnabled(false);
        this.selectFamilies = new JMenuItem(SELECT_FAMILIES);
        this.selectFamilies.setMnemonic(71);
        this.selectFamilies.setAccelerator(KeyStroke.getKeyStroke("control G"));
        this.selectFamilies.setActionCommand(SELECT_FAMILIES);
        this.selectFamilies.addActionListener(this);
        this.selectFamilies.setEnabled(false);
        this.useParsomeColors = new JRadioButtonMenuItem(USE_PARSOME_COLORS);
        this.useParsomeColors.setMnemonic(65);
        this.useParsomeColors.setActionCommand(USE_PARSOME_COLORS);
        this.useParsomeColors.addActionListener(this);
        this.useParsomeColors.setSelected(true);
        this.useParsomeColors.setEnabled(false);
        this.useGeneColors = new JRadioButtonMenuItem(USE_GENE_COLORS);
        this.useGeneColors.setMnemonic(69);
        this.useGeneColors.setActionCommand(USE_GENE_COLORS);
        this.useGeneColors.addActionListener(this);
        this.useGeneColors.setSelected(false);
        this.useGeneColors.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useParsomeColors);
        buttonGroup.add(this.useGeneColors);
        this.paralogy = new JMenu("Paralogy");
        this.paralogy.setMnemonic(65);
        this.paralogy.add(this.vizParalogy);
        this.paralogy.addSeparator();
        this.paralogy.add(this.selectParsomes);
        this.paralogy.add(this.selectFamilies);
        this.paralogy.addSeparator();
        this.paralogy.add(this.useParsomeColors);
        this.paralogy.add(this.useGeneColors);
        return this.paralogy;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        block18: {
            boolean bl;
            String string;
            block21: {
                block20: {
                    block19: {
                        block17: {
                            string = "";
                            if (itemEvent.getItem() instanceof JCheckBoxMenuItem) {
                                string = ((JCheckBoxMenuItem)itemEvent.getSource()).getText();
                            } else if (itemEvent.getItem() instanceof JCheckBox) {
                                string = ((JCheckBox)itemEvent.getSource()).getText();
                            } else {
                                System.err.printf("ParalogyMenuManager.itemStateChanged(): Shouldn't be here.", new Object[0]);
                            }
                            bl = itemEvent.getStateChange() == 1;
                            LinkingLinePainter linkingLinePainter = ((BluejayAbstractLinearGraphics)this.alg).getLLPainter();
                            String[] stringArray = this.dlist.getParNames();
                            if (!string.equals(VIZ_PARALOGY)) break block17;
                            linkingLinePainter.setLinkingSelf(bl);
                            this.paralogySetEnabled(bl);
                            if (this.loadingNewDocument) {
                                this.initCheckBoxes();
                                this.loadingNewDocument = false;
                            }
                            this.dlist.repaint(true);
                            break block18;
                        }
                        if (!string.equals(SHOW_ALL_PARSOMES)) break block19;
                        if (bl) {
                            this.hideAllPars.setSelected(false);
                        }
                        for (JCheckBox jCheckBox : this.showPars) {
                            if (bl) {
                                jCheckBox.setSelected(true);
                            }
                            jCheckBox.setEnabled(!bl);
                        }
                        break block18;
                    }
                    if (!string.equals(HIDE_ALL_PARSOMES)) break block20;
                    if (bl) {
                        this.showAllPars.setSelected(false);
                    }
                    for (JCheckBox jCheckBox : this.showPars) {
                        if (bl) {
                            jCheckBox.setSelected(false);
                        }
                        jCheckBox.setEnabled(!bl);
                    }
                    break block18;
                }
                if (!string.equals(SHOW_ALL_FAMILIES)) break block21;
                if (bl) {
                    this.hideAllFams.setSelected(false);
                }
                for (JCheckBox jCheckBox : this.showFams) {
                    if (bl) {
                        jCheckBox.setSelected(true);
                    }
                    jCheckBox.setEnabled(!bl);
                }
                break block18;
            }
            if (!string.equals(HIDE_ALL_FAMILIES)) break block18;
            if (bl) {
                this.showAllFams.setSelected(false);
            }
            for (JCheckBox jCheckBox : this.showFams) {
                if (bl) {
                    jCheckBox.setSelected(false);
                }
                jCheckBox.setEnabled(!bl);
            }
        }
    }

    private void initCheckBoxes() {
        int n;
        LinkingLinePainter linkingLinePainter = ((BluejayAbstractLinearGraphics)this.alg).getLLPainter();
        this.parNames = this.dlist.getParNames();
        this.showPars = new JCheckBox[this.parNames.length];
        for (n = 0; n < this.parNames.length; ++n) {
            this.showPars[n] = new JCheckBox(SHOW_PARSOME_PREFIX + this.parNames[n]);
            this.showPars[n].addItemListener(this);
            linkingLinePainter.setShowingParsome(this.parNames[n], true);
        }
        this.showAllPars = new JCheckBox(SHOW_ALL_PARSOMES);
        this.hideAllPars = new JCheckBox(HIDE_ALL_PARSOMES);
        this.showAllPars.addItemListener(this);
        this.showAllPars.setSelected(true);
        this.hideAllPars.addItemListener(this);
        this.hideAllPars.setSelected(false);
        this.copyNumbers = new int[]{2, 3, 4, 5};
        linkingLinePainter.setMaxCopyNumber(5);
        this.showFams = new JCheckBox[this.copyNumbers.length];
        for (n = 0; n < this.copyNumbers.length; ++n) {
            if (n < this.copyNumbers.length - 1) {
                this.showFams[n] = new JCheckBox(SHOW_FAMILY_PREFIX + Integer.toString(this.copyNumbers[n]));
                this.showFams[n].setSelected(true);
                linkingLinePainter.setShowingFamily(this.copyNumbers[n], true);
            } else {
                this.showFams[n] = new JCheckBox(SHOW_FAMILY_PREFIX + Integer.toString(this.copyNumbers[n]) + " or more");
                this.showFams[n].setSelected(false);
                linkingLinePainter.setShowingFamily(this.copyNumbers[n], false);
            }
            this.showFams[n].addItemListener(this);
        }
        this.showAllFams = new JCheckBox(SHOW_ALL_FAMILIES);
        this.hideAllFams = new JCheckBox(HIDE_ALL_FAMILIES);
        this.showAllFams.addItemListener(this);
        this.showAllFams.setSelected(false);
        this.hideAllFams.addItemListener(this);
        this.hideAllFams.setSelected(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(SELECT_PARSOMES)) {
            this.showHideParsomes();
        } else if (actionEvent.getActionCommand().equals(SELECT_FAMILIES)) {
            this.showHideFamilies();
        } else if (actionEvent.getActionCommand().equals(USE_GENE_COLORS)) {
            ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setUsingParsomeColors(false);
            this.dlist.repaint(true);
        } else if (actionEvent.getActionCommand().equals(USE_PARSOME_COLORS)) {
            ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setUsingParsomeColors(true);
            this.dlist.repaint(true);
        }
    }

    private void showHideParsomes() {
        int n;
        boolean bl;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.showAllPars);
        jPanel.add(this.hideAllPars);
        for (bl = false; bl < this.parNames.length; bl += 1) {
            jPanel.add(this.showPars[bl]);
        }
        bl = this.showAllPars.isSelected();
        boolean bl2 = this.hideAllPars.isSelected();
        boolean[] blArray = new boolean[this.parNames.length];
        for (n = 0; n < this.parNames.length; ++n) {
            blArray[n] = this.showPars[n].isSelected();
        }
        n = JOptionPane.showOptionDialog(this.dlist.getFrame(), jPanel, SELECT_PARSOMES, 2, -1, null, new String[]{"Okay", "Cancel"}, "Okay");
        if (n == 0) {
            boolean bl3 = false;
            for (int i = 0; i < this.parNames.length; ++i) {
                if (blArray[i] == this.showPars[i].isSelected()) continue;
                bl3 = true;
                ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setShowingParsome(this.parNames[i], this.showPars[i].isSelected());
            }
            if (bl3) {
                this.dlist.repaint(true);
            }
        } else {
            this.showAllPars.setSelected(bl);
            this.hideAllPars.setSelected(bl2);
            for (int i = 0; i < this.parNames.length; ++i) {
                this.showPars[i].setSelected(blArray[i]);
            }
        }
    }

    private void showHideFamilies() {
        int n;
        boolean bl;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.showAllFams);
        jPanel.add(this.hideAllFams);
        for (bl = false; bl < this.copyNumbers.length; bl += 1) {
            jPanel.add(this.showFams[bl]);
        }
        bl = this.showAllFams.isSelected();
        boolean bl2 = this.hideAllFams.isSelected();
        boolean[] blArray = new boolean[this.copyNumbers.length];
        for (n = 0; n < this.copyNumbers.length; ++n) {
            blArray[n] = this.showFams[n].isSelected();
        }
        n = JOptionPane.showOptionDialog(this.dlist.getFrame(), jPanel, SELECT_FAMILIES, 2, -1, null, new String[]{"Okay", "Cancel"}, "Okay");
        if (n == 0) {
            boolean bl3 = false;
            for (int i = 0; i < this.copyNumbers.length; ++i) {
                if (blArray[i] == this.showFams[i].isSelected()) continue;
                bl3 = true;
                ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setShowingFamily(this.copyNumbers[i], this.showFams[i].isSelected());
            }
            if (bl3) {
                this.dlist.repaint(true);
            }
        } else {
            this.showAllFams.setSelected(bl);
            this.hideAllFams.setSelected(bl2);
            for (int i = 0; i < this.copyNumbers.length; ++i) {
                this.showFams[i].setSelected(blArray[i]);
            }
        }
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
    }

    public BluejayDObjectList getDList() {
        return this.dlist;
    }

    public void setGraphics(AbstractLinearGraphics abstractLinearGraphics) {
        this.alg = abstractLinearGraphics;
    }

    public AbstractLinearGraphics getGraphics() {
        return this.alg;
    }

    public void paralogySetEnabled(boolean bl) {
        this.selectParsomes.setEnabled(bl);
        this.selectFamilies.setEnabled(bl);
        this.useParsomeColors.setEnabled(bl);
        this.useGeneColors.setEnabled(bl);
    }

    public JCheckBoxMenuItem getVizParalogy() {
        return this.vizParalogy;
    }

    public void setLoadingNewDocument(boolean bl) {
        this.loadingNewDocument = bl;
    }
}

