/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.client.IOController;
import ca.ucalgary.bluejay.client.impl.BluejayEventCoordinator;
import ca.ucalgary.bluejay.client.impl.BluejayURLLoader;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.DisplayOptions;
import ca.ucalgary.bluejay.gui.FontColourSelect;
import ca.ucalgary.bluejay.gui.menu.BluejayMenuManager;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.gui.util.DiagnosticsAppender;
import ca.ucalgary.bluejay.session.SessionManager;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class ProgramMenuManager
implements BluejayMenuManager,
ActionListener {
    private static BluejayEventCoordinator bec;
    private static BluejayDObjectList dlist;
    private static IOController io;
    private static DisplayOptions dos;
    private static JScrollPane errorPane;
    private static JFrame main_frame;
    private static BluejayURLLoader bjURLLoader;
    private boolean notSigned;
    private static boolean usingXLinkFilter;
    private static boolean isAnApplet;
    private static boolean scheduledToResetMainParser;
    private SessionManager sessionManager;

    public JMenu createMenu() {
        JMenu jMenu = new JMenu("Program");
        jMenu.setMnemonic(80);
        JMenuItem jMenuItem = new JMenuItem("Drawing Prefs");
        jMenuItem.setMnemonic(68);
        jMenuItem.setEnabled(true);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Draw Prefs");
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Memory Prefs");
        jMenu2.setMnemonic(77);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Use less memory but run slower");
        jRadioButtonMenuItem.setMnemonic(76);
        jRadioButtonMenuItem.setActionCommand("Memory_less");
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setSelected(dlist.isMemorySavingMode());
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Run faster but use more memory");
        jRadioButtonMenuItem.setMnemonic(77);
        jRadioButtonMenuItem.setActionCommand("Memory_more");
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setSelected(!dlist.isMemorySavingMode());
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu("Storage Prefs");
        jMenu3.setMnemonic(83);
        JMenuItem jMenuItem2 = new JMenuItem("Web Disk Cache");
        jMenuItem2.setMnemonic(87);
        JMenuItem jMenuItem3 = new JMenuItem("Local Disk Cache");
        jMenuItem3.setMnemonic(76);
        jMenuItem2.setActionCommand("Disk Cache");
        jMenuItem3.setActionCommand("DC2");
        jMenu3.add(jMenuItem2);
        jMenu3.add(jMenuItem3);
        jMenuItem2.addActionListener(this);
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenu3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Diagnostics");
        jMenuItem4.setMnemonic(68);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke("control D"));
        jMenuItem4.addActionListener(this);
        jMenuItem4.setActionCommand("Diagnostics");
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Upgrade");
        jMenuItem5.setEnabled(false);
        if (!this.notSigned) {
            jMenu.addSeparator();
            JMenuItem jMenuItem6 = new JMenuItem("Exit");
            jMenuItem6.setMnemonic(88);
            jMenuItem6.addActionListener(this);
            jMenuItem6.setActionCommand("exit");
            jMenu.add(jMenuItem6);
        }
        return jMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Debug.DEBUG) {
            System.out.println("action performed " + actionEvent.getSource().toString());
        }
        if (actionEvent.getActionCommand().equals("Draw Prefs")) {
            try {
                bec.notify(8, "Finish selecting drawing Preferences");
                Frame frame = JOptionPane.getFrameForComponent(main_frame);
                if (frame == null) {
                    frame = new Frame();
                }
                FontColourSelect fontColourSelect = new FontColourSelect(frame, "Drawing Preferences", dos);
                fontColourSelect.setDList(dlist);
                if (fontColourSelect.OKSelected()) {
                    dlist.repaint(true);
                }
                bec.notify(8, "");
                fontColourSelect.dispose();
            }
            catch (Exception exception) {
                System.err.println("we have a dialog issue " + exception.getMessage());
            }
        } else if (actionEvent.getActionCommand().equals("Disk Cache")) {
            io.showCacheGUI(main_frame);
        } else if (actionEvent.getActionCommand().equals("DC2")) {
            io.showDiskCacheGui(main_frame);
        } else if (actionEvent.getActionCommand().startsWith("XLinks_")) {
            if (actionEvent.getActionCommand().equals("XLinks_minimal")) {
                usingXLinkFilter = false;
            } else if (actionEvent.getActionCommand().equals("XLinks_full")) {
                usingXLinkFilter = true;
            }
            scheduledToResetMainParser = true;
        } else if (actionEvent.getActionCommand().startsWith("Memory_")) {
            if (actionEvent.getActionCommand().equals("Memory_less")) {
                dlist.setMemorySavingMode(true);
            } else if (actionEvent.getActionCommand().equals("Memory_more")) {
                dlist.setMemorySavingMode(false);
            }
        } else if (actionEvent.getActionCommand().equals("Diagnostics")) {
            try {
                Frame frame = JOptionPane.getFrameForComponent(main_frame);
                if (frame == null) {
                    frame = new Frame();
                }
                DiagnosticsAppender diagnosticsAppender = DiagnosticsAppender.getInstance();
                diagnosticsAppender.showDialog(frame);
            }
            catch (Exception exception) {
                System.err.println("we have a dialog issue " + exception.getMessage());
            }
        } else if (actionEvent.getActionCommand().equals("exit")) {
            if (this.sessionManager != null) {
                this.sessionManager.saveUserInfo();
            }
            bec.notify(8, "Caching page appearance...");
            bjURLLoader.leavingPage();
            if (isAnApplet) {
                main_frame.dispose();
                main_frame = null;
            } else {
                System.exit(0);
            }
        }
    }

    public void setIO(IOController iOController) {
        io = iOController;
    }

    public void setEventCoordinator(BluejayEventCoordinator bluejayEventCoordinator) {
        bec = bluejayEventCoordinator;
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    public void setUsingXLinkFilter(boolean bl) {
        usingXLinkFilter = bl;
    }

    public void setDos(DisplayOptions displayOptions) {
        dos = displayOptions;
    }

    public void setNotSigned(boolean bl) {
        this.notSigned = bl;
    }

    public void setIsAnApplet(boolean bl) {
        isAnApplet = bl;
    }

    public void setScheduledToResetMainParser(boolean bl) {
        scheduledToResetMainParser = bl;
    }

    public void setErrorPane(JScrollPane jScrollPane) {
        errorPane = jScrollPane;
    }

    public void setMainFrame(JFrame jFrame) {
        main_frame = jFrame;
    }

    public void setBJURLLoader(BluejayURLLoader bluejayURLLoader) {
        bjURLLoader = bluejayURLLoader;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }
}

