/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.ExpressionSliderWidget;
import ca.ucalgary.bluejay.gui.FeatureRangeGUI;
import ca.ucalgary.bluejay.gui.TextToolBarListener;
import ca.ucalgary.bluejay.gui.ToolbarWidgets;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.cpane.TextToolBar;
import ca.ucalgary.bluejay.gui.menu.BluejayMenuManager;
import ca.ucalgary.bluejay.gui.menu.CleavagePanel;
import ca.ucalgary.bluejay.gui.menu.LaneLayoutPanel;
import ca.ucalgary.bluejay.gui.microarray.DistanceSliderWidget;
import ca.ucalgary.bluejay.gui.microarray.player.ExperimentSelectorWidget;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.gui.util.History;
import ca.ucalgary.seahawk.gui.MobyContentGUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.batik.apps.svgbrowser.ThumbnailDialog;
import org.tigr.microarray.mev.MultipleArrayViewer;

public class ViewMenuManager
implements BluejayMenuManager,
ActionListener,
ItemListener,
PropertyChangeListener {
    public static final String MOBY_BROWSER_OPTION = "Show MOBY Browser";
    public static final String MOBY_BROWSER_TOOLTIP = "Displays the Seahawk browser for executing MOBY-enabled remote Web services";
    private FeatureRangeGUI featGUI;
    private VisibilityManager vizMgr;
    private static BluejayDObjectList dlist;
    private static JFrame main_frame;
    private JMenuItem refreshItem;
    private JMenuItem stopItem;
    private JMenu textMenu;
    private JMenu chartMenu;
    private JRadioButtonMenuItem rbTwoFrame = new JRadioButtonMenuItem("Two Frame");
    private JRadioButtonMenuItem rb_arrowShape;
    private JRadioButtonMenuItem rb_boxShape = new JRadioButtonMenuItem("Show Box Shape");
    private JRadioButtonMenuItem fullLegend;
    private JRadioButtonMenuItem partialLegend;
    private static JCheckBoxMenuItem cbFeatureEdit;
    private static JCheckBoxMenuItem cbShape;
    private static JCheckBoxMenuItem cbOrientation;
    private static JCheckBoxMenuItem cbWaypoints;
    private static JCheckBoxMenuItem cbAG_checkBox;
    private static JCheckBoxMenuItem cbGC_checkBox;
    private static JCheckBoxMenuItem gcSkew_checkBox;
    private static JCheckBoxMenuItem cbRestr_checkBox;
    private static JCheckBoxMenuItem cbAnalysis;
    private static JCheckBoxMenuItem cbMicroArray;
    private static JCheckBoxMenuItem cbDistanceAnalysis;
    private static JCheckBoxMenuItem cbExperiment;
    private JMenuItem mobyBrowserItem;
    private JMenuItem configureSitesItem;
    private JMenuItem configureLanes;
    private static JTabbedPane tabbedPane;
    private static JScrollPane mainspane;
    private static JPanel fontZoom;
    private static ToolbarWidgets bjWidgets;
    private static ThumbnailDialog thumbnailDialog;
    private static MultipleArrayViewer arrayViewer;
    private static ExpressionSliderWidget arrayPanel;
    private static DistanceSliderWidget distancePanel;
    private static ExperimentSelectorWidget experimentSelectorPanel;
    private MobyContentGUI mobyContentGUI;
    private static final Icon NO_ICON;
    private static final String NO_TOOL_TIP;
    private static History localHistory;

    public ViewMenuManager() {
        this.rb_arrowShape = new JRadioButtonMenuItem("Show Arrow Shape");
        this.fullLegend = new JRadioButtonMenuItem("Show Full Legend");
        this.partialLegend = new JRadioButtonMenuItem("Show Partial Legend");
    }

    public void setVisibilityManager(VisibilityManager visibilityManager) {
        this.vizMgr = visibilityManager;
    }

    public JMenu createMenu() {
        arrayPanel = dlist.getExpressionWidget();
        distancePanel = dlist.getDistanceWidget();
        experimentSelectorPanel = dlist.getExperimentSelector();
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic(86);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.refreshItem = new JMenuItem("Refresh");
        this.refreshItem.setMnemonic(82);
        this.refreshItem.setAccelerator(KeyStroke.getKeyStroke("control R"));
        this.refreshItem.setActionCommand("Refresh");
        this.refreshItem.addActionListener(this);
        this.refreshItem.setEnabled(false);
        jMenu.add(this.refreshItem);
        this.stopItem = new JMenuItem("Stop");
        this.stopItem.setAccelerator(KeyStroke.getKeyStroke("ESCAPE"));
        this.stopItem.addActionListener(this);
        this.stopItem.setEnabled(false);
        jMenu.addSeparator();
        this.rbTwoFrame.setActionCommand("Two Frame");
        this.rbTwoFrame.setAccelerator(KeyStroke.getKeyStroke("control 2"));
        this.rbTwoFrame.addActionListener(this);
        this.rbTwoFrame.setSelected(true);
        buttonGroup.add(this.rbTwoFrame);
        jMenu.add(this.rbTwoFrame);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Single Frame");
        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke("control 1"));
        jRadioButtonMenuItem.setActionCommand("Single Frame");
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setSelected(false);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Six Frame");
        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke("control 6"));
        jRadioButtonMenuItem.setActionCommand("Six Frame");
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setSelected(false);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.textMenu = new JMenu("Text");
        this.textMenu.setMnemonic(84);
        this.textMenu.setEnabled(false);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Horizontal Sequential");
        jRadioButtonMenuItem.setMnemonic(72);
        jRadioButtonMenuItem.setActionCommand("Horizontal Sequential Text");
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setEnabled(true);
        buttonGroup.add(jRadioButtonMenuItem);
        this.textMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Horizontal Interleaved");
        jRadioButtonMenuItem.setMnemonic(73);
        jRadioButtonMenuItem.setActionCommand("Interleaved Text");
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setEnabled(true);
        buttonGroup.add(jRadioButtonMenuItem);
        this.textMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Vertical Sequential");
        jRadioButtonMenuItem.setMnemonic(86);
        jRadioButtonMenuItem.setActionCommand("Vertical Sequential Text");
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setEnabled(true);
        buttonGroup.add(jRadioButtonMenuItem);
        this.textMenu.add(jRadioButtonMenuItem);
        jMenu.add(this.textMenu);
        this.chartMenu = new JMenu("Chart");
        this.chartMenu.setMnemonic(67);
        this.chartMenu.setEnabled(false);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Bar Chart");
        jRadioButtonMenuItem.setMnemonic(66);
        jRadioButtonMenuItem.setActionCommand("Bar Chart");
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setEnabled(true);
        buttonGroup.add(jRadioButtonMenuItem);
        this.chartMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Pie Chart");
        jRadioButtonMenuItem.setMnemonic(80);
        jRadioButtonMenuItem.setActionCommand("Pie Chart");
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setEnabled(true);
        buttonGroup.add(jRadioButtonMenuItem);
        this.chartMenu.add(jRadioButtonMenuItem);
        jMenu.add(this.chartMenu);
        jMenu.addSeparator();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.rb_boxShape.setActionCommand("Show_Box_Shape");
        this.rb_boxShape.setMnemonic(66);
        this.rb_boxShape.addActionListener(this);
        this.rb_boxShape.setSelected(true);
        buttonGroup2.add(this.rb_boxShape);
        jMenu.add(this.rb_boxShape);
        this.rb_arrowShape.setActionCommand("Show_Arrow_Shape");
        this.rb_arrowShape.setMnemonic(65);
        this.rb_arrowShape.addActionListener(this);
        buttonGroup2.add(this.rb_arrowShape);
        jMenu.add(this.rb_arrowShape);
        jMenu.addSeparator();
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.fullLegend.setActionCommand("Full_Legend");
        this.fullLegend.setMnemonic(70);
        this.fullLegend.addActionListener(this);
        this.fullLegend.setSelected(true);
        buttonGroup3.add(this.fullLegend);
        jMenu.add(this.fullLegend);
        this.partialLegend.setActionCommand("Partial_Legend");
        this.partialLegend.setMnemonic(80);
        this.partialLegend.addActionListener(this);
        buttonGroup3.add(this.partialLegend);
        jMenu.add(this.partialLegend);
        jMenu.addSeparator();
        cbFeatureEdit = new JCheckBoxMenuItem("Show Feature Editor");
        cbFeatureEdit.setMnemonic(69);
        cbFeatureEdit.setActionCommand("Show_Feature_Editor");
        cbFeatureEdit.setSelected(false);
        cbFeatureEdit.setEnabled(false);
        jMenu.add(cbFeatureEdit);
        this.featGUI = new FeatureRangeGUI(this.vizMgr, dlist, cbFeatureEdit);
        cbFeatureEdit.addActionListener(this.featGUI);
        cbShape = new JCheckBoxMenuItem("Show Shape Tab");
        cbShape.setMnemonic(83);
        cbShape.setActionCommand("Show_Tab_Shape");
        cbShape.addItemListener(this);
        cbShape.setSelected(false);
        jMenu.add(cbShape);
        cbOrientation = new JCheckBoxMenuItem("Show Orientation Tab");
        cbOrientation.setMnemonic(79);
        cbOrientation.setActionCommand("Show_Tab_Orientation");
        cbOrientation.addItemListener(this);
        cbOrientation.setSelected(false);
        jMenu.add(cbOrientation);
        cbWaypoints = new JCheckBoxMenuItem("Show Waypoints Tab");
        cbWaypoints.setMnemonic(87);
        cbWaypoints.setActionCommand("Show_Tab_Waypoints");
        cbWaypoints.addItemListener(this);
        cbWaypoints.setSelected(false);
        jMenu.add(cbWaypoints);
        jMenu.addSeparator();
        cbAnalysis = new JCheckBoxMenuItem("Show Analysis Tab");
        cbAnalysis.setMnemonic(78);
        cbAnalysis.setActionCommand("Show_Tab_Analysis");
        cbAnalysis.addItemListener(this);
        cbAnalysis.setEnabled(false);
        cbAnalysis.setSelected(false);
        jMenu.add(cbAnalysis);
        cbMicroArray = new JCheckBoxMenuItem("Show Expression Range Tab");
        cbMicroArray.setMnemonic(88);
        cbMicroArray.setActionCommand("Show_Tab_Expression");
        cbMicroArray.addItemListener(this);
        cbMicroArray.setEnabled(false);
        cbMicroArray.setSelected(false);
        jMenu.add(cbMicroArray);
        cbDistanceAnalysis = new JCheckBoxMenuItem("Show Distance Tab");
        cbDistanceAnalysis.setMnemonic(68);
        cbDistanceAnalysis.setActionCommand("Show_Tab_Distance");
        cbDistanceAnalysis.addItemListener(this);
        cbDistanceAnalysis.setEnabled(false);
        cbDistanceAnalysis.setSelected(false);
        jMenu.add(cbDistanceAnalysis);
        cbExperiment = new JCheckBoxMenuItem("Show Experiment Tab");
        cbExperiment.setMnemonic(88);
        cbExperiment.setActionCommand("Show_Experiment_Tab");
        cbExperiment.addItemListener(this);
        cbExperiment.setEnabled(false);
        cbExperiment.setSelected(false);
        jMenu.add(cbExperiment);
        jMenu.addSeparator();
        cbGC_checkBox = new JCheckBoxMenuItem("Show G+C % Level");
        cbGC_checkBox.setActionCommand("Show_Level_G+C");
        cbGC_checkBox.addItemListener(this);
        cbGC_checkBox.setSelected(false);
        dlist.getAbstractLinearGraphics().setGCLevelShown(false);
        jMenu.add(cbGC_checkBox);
        cbAG_checkBox = new JCheckBoxMenuItem("Show A+G % Level");
        cbAG_checkBox.setActionCommand("Show_Level_A+G");
        cbAG_checkBox.addItemListener(this);
        cbAG_checkBox.setSelected(false);
        dlist.getAbstractLinearGraphics().setAGLevelShown(false);
        jMenu.add(cbAG_checkBox);
        gcSkew_checkBox = new JCheckBoxMenuItem("Show GC Skew");
        gcSkew_checkBox.setActionCommand("Show_GCSkew");
        gcSkew_checkBox.addItemListener(this);
        gcSkew_checkBox.setSelected(false);
        dlist.getAbstractLinearGraphics().setGCSkewShown(false);
        jMenu.add(gcSkew_checkBox);
        dlist.getAbstractLinearGraphics().addPropertyChangeListener(this);
        boolean bl = dlist.getAbstractLinearGraphics().getLOD() == 80;
        cbAG_checkBox.setEnabled(bl);
        cbGC_checkBox.setEnabled(bl);
        gcSkew_checkBox.setEnabled(bl);
        cbRestr_checkBox = new JCheckBoxMenuItem("Show Restriction Sites");
        cbRestr_checkBox.setActionCommand("Show_restriction_sites");
        cbRestr_checkBox.addItemListener(this);
        cbRestr_checkBox.setSelected(false);
        cbRestr_checkBox.setEnabled(false);
        dlist.getAbstractLinearGraphics().setCleavageShown(false);
        jMenu.add(cbRestr_checkBox);
        jMenu.addSeparator();
        this.mobyBrowserItem = new JMenuItem(MOBY_BROWSER_OPTION);
        this.mobyBrowserItem.setActionCommand(MOBY_BROWSER_OPTION);
        this.mobyBrowserItem.setToolTipText(MOBY_BROWSER_TOOLTIP);
        this.mobyBrowserItem.addActionListener(this);
        this.mobyBrowserItem.setEnabled(true);
        jMenu.add(this.mobyBrowserItem);
        jMenu.addSeparator();
        this.configureSitesItem = new JMenuItem("Configure Restriction Map");
        this.configureSitesItem.setActionCommand("Configure_restriction_map");
        this.configureSitesItem.addActionListener(this);
        this.configureSitesItem.setEnabled(true);
        jMenu.add(this.configureSitesItem);
        this.configureLanes = new JMenuItem("Configure Lane Layout");
        this.configureLanes.setMnemonic(76);
        this.configureLanes.setAccelerator(KeyStroke.getKeyStroke("control L"));
        this.configureLanes.setActionCommand("Configure_lane_layout");
        this.configureLanes.addActionListener(this);
        this.configureLanes.setEnabled(true);
        jMenu.add(this.configureLanes);
        return jMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (Debug.DEBUG) {
            System.out.println("action performed " + actionEvent.getSource().toString());
        }
        if ((string = actionEvent.getActionCommand()).equals("Refresh")) {
            dlist.repaint(true);
        } else if (string.equals("Configure_restriction_map")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CleavagePanel.createAndShowGUI(dlist);
                }
            });
        } else if (string.equals("Configure_lane_layout")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LaneLayoutPanel.createAndShowGUI(dlist);
                }
            });
        } else {
            this.setViewChoice(string);
        }
    }

    public void setViewChoice(String string) {
        boolean bl;
        boolean bl2 = bl = localHistory != null && localHistory.historySize() > 0;
        if (string.equals("Horizontal Sequential Text") || string.equals("Interleaved Text") || string.equals("Vertical Sequential Text")) {
            TextToolBar textToolBar = TextToolBar.getInstance();
            if (!textToolBar.isVisible()) {
                textToolBar.setVisible(true);
            }
            if (!textToolBar.hasListener()) {
                TextToolBarListener textToolBarListener = new TextToolBarListener(dlist, dlist.getAbstractLinearGraphics(), main_frame);
                textToolBar.addListener(textToolBarListener);
            }
            if (string.equals("Horizontal Sequential Text")) {
                dlist.textHMode(bl, false);
            } else if (string.equals("Vertical Sequential Text")) {
                dlist.textVMode(bl);
            } else if (string.equals("Interleaved Text")) {
                dlist.textHMode(bl, true);
            }
        } else {
            TextToolBar.getInstance().setVisible(false);
            if (string.equals("Bar Chart")) {
                dlist.BarChartMode(bl);
            } else if (string.equals("Pie Chart")) {
                dlist.PieChartMode(bl);
            } else if (string.equals("Single Frame")) {
                dlist.singleFrameMode(bl);
            } else if (string.equals("Two Frame")) {
                dlist.twoFrameMode(bl);
            } else if (string.equals("Six Frame")) {
                dlist.sixFrameMode(bl);
            } else if (string.equals("Show_Arrow_Shape")) {
                dlist.arrowShapeMode(bl);
            } else if (string.equals("Show_Box_Shape")) {
                dlist.rectShapeMode(bl);
            } else if (string.equals("Full_Legend")) {
                dlist.setWholeLegendPrinted(true);
                dlist.repaint(bl);
            } else if (string.equals("Partial_Legend")) {
                dlist.setWholeLegendPrinted(false);
                dlist.repaint(bl);
            }
        }
        dlist.setEnableRotateInteractor(!dlist.getAbstractLinearGraphics().isInTextMode());
    }

    public void setDefaultView() {
        TextToolBar.getInstance().setVisible(false);
        dlist.twoFrameMode(false);
        this.rbTwoFrame.setSelected(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItem() instanceof JCheckBoxMenuItem) {
            boolean bl;
            boolean bl2 = itemEvent.getStateChange() == 1;
            String string = ((JCheckBoxMenuItem)itemEvent.getSource()).getActionCommand();
            boolean bl3 = bl = localHistory != null && localHistory.historySize() > 0;
            if (string.equals("Show_Tab_Shape")) {
                if (bl2) {
                    tabbedPane.insertTab("Shape", NO_ICON, dlist.getGeometryWidget(), NO_TOOL_TIP, 0);
                    dlist.setShapeTab(dlist.getGeometryWidget());
                    tabbedPane.setSelectedIndex(0);
                } else {
                    if (dlist.getShapeTab() != null) {
                        tabbedPane.remove(dlist.getShapeTab());
                    }
                    dlist.setShapeTab(null);
                }
            } else if (string.equals("Show_Tab_Orientation")) {
                if (bl2) {
                    tabbedPane.insertTab("Orientation", NO_ICON, dlist.getOrientationWidget(), NO_TOOL_TIP, 0);
                    dlist.setOrientationTab(dlist.getOrientationWidget());
                    tabbedPane.setSelectedIndex(0);
                } else {
                    if (dlist.getOrientationTab() != null) {
                        tabbedPane.remove(dlist.getOrientationTab());
                    }
                    dlist.setOrientationTab(null);
                }
            } else if (string.equals("Show_Tab_Waypoints")) {
                if (bl2) {
                    tabbedPane.insertTab("Waypoints", NO_ICON, dlist.getWaypointsWidget(), NO_TOOL_TIP, 0);
                    dlist.setWaypointsTab(dlist.getWaypointsWidget());
                    tabbedPane.setSelectedIndex(0);
                } else {
                    if (dlist.getWaypointsTab() != null) {
                        tabbedPane.remove(dlist.getWaypointsTab());
                    }
                    dlist.setWaypointsTab(null);
                }
            } else if (string.equals("Show_Tab_Analysis")) {
                if (bl2) {
                    tabbedPane.insertTab("Analysis", NO_ICON, arrayViewer.getTreeScrollPane(), NO_TOOL_TIP, 0);
                    tabbedPane.setSelectedIndex(0);
                } else {
                    tabbedPane.remove(arrayViewer.getTreeScrollPane());
                }
            } else if (string.equals("Show_Tab_Expression")) {
                if (bl2) {
                    tabbedPane.insertTab("Expression Range", NO_ICON, arrayPanel, NO_TOOL_TIP, 0);
                    tabbedPane.setSelectedIndex(0);
                } else {
                    tabbedPane.remove(arrayPanel);
                }
            } else if (string.equals("Show_Tab_Distance")) {
                if (bl2) {
                    tabbedPane.insertTab("Distance", NO_ICON, distancePanel, NO_TOOL_TIP, 0);
                    tabbedPane.setSelectedIndex(0);
                } else {
                    tabbedPane.remove(distancePanel);
                    dlist.getDistanceWidget().resetWidget();
                    dlist.restoreMicroArrayInfo();
                }
            } else if (string.equals("Show_Experiment_Tab")) {
                if (bl2) {
                    tabbedPane.insertTab("Experiments", NO_ICON, experimentSelectorPanel, NO_TOOL_TIP, 0);
                    tabbedPane.setSelectedIndex(0);
                } else {
                    tabbedPane.remove(experimentSelectorPanel);
                }
            } else if (string.equals("Show_Level_A+G")) {
                dlist.getAbstractLinearGraphics().setAGLevelShown(bl2);
                dlist.repaint(bl);
            } else if (string.equals("Show_Level_G+C")) {
                dlist.getAbstractLinearGraphics().setGCLevelShown(bl2);
                dlist.repaint(bl);
            } else if (string.equals("Show_GCSkew")) {
                dlist.getAbstractLinearGraphics().setGCSkewShown(bl2);
                dlist.repaint(bl);
            } else if (string.equals("Show_restriction_sites")) {
                dlist.getAbstractLinearGraphics().setCleavageShown(bl2);
                dlist.repaint(bl);
            } else {
                System.err.println("Warning: detected an unknown item state change event command " + string);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("LOD")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            boolean bl = n == 80;
            cbAG_checkBox.setEnabled(bl);
            cbGC_checkBox.setEnabled(bl);
            gcSkew_checkBox.setEnabled(bl);
        } else {
            System.err.println("Warning: detected an unknown property change " + propertyChangeEvent.getPropertyName());
        }
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    public void setTabbedPane(JTabbedPane jTabbedPane) {
        tabbedPane = jTabbedPane;
    }

    public JTabbedPane getTabbedPane() {
        return tabbedPane;
    }

    public JCheckBoxMenuItem getcbAnalysis() {
        return cbAnalysis;
    }

    public JCheckBoxMenuItem getcbMicroArray() {
        return cbMicroArray;
    }

    public JCheckBoxMenuItem getcbDistanceAnalysis() {
        return cbDistanceAnalysis;
    }

    public JCheckBoxMenuItem getcbExperiment() {
        return cbExperiment;
    }

    public void setLocalHistory(History history) {
        localHistory = history;
    }

    public void setMainsPane(JScrollPane jScrollPane) {
        mainspane = jScrollPane;
    }

    public void setToolbarWidgets(ToolbarWidgets toolbarWidgets) {
        bjWidgets = toolbarWidgets;
    }

    public void setThumbnailDialog(ThumbnailDialog thumbnailDialog) {
        ViewMenuManager.thumbnailDialog = thumbnailDialog;
    }

    public void setMultipleArrayViewer(MultipleArrayViewer multipleArrayViewer) {
        arrayViewer = multipleArrayViewer;
    }

    public void disableMicroArrayTabs() {
        cbAnalysis.setEnabled(false);
        cbDistanceAnalysis.setEnabled(false);
        cbMicroArray.setEnabled(false);
        cbExperiment.setEnabled(false);
        tabbedPane.remove(arrayViewer.getTreeScrollPane());
        tabbedPane.remove(arrayPanel);
        tabbedPane.remove(distancePanel);
        tabbedPane.remove(experimentSelectorPanel);
    }

    public void enableMicroArrayTabs() {
        cbAnalysis.setEnabled(true);
        cbDistanceAnalysis.setEnabled(true);
        cbMicroArray.setEnabled(true);
        cbExperiment.setEnabled(true);
        if (cbExperiment.isSelected()) {
            tabbedPane.insertTab("Experiments", NO_ICON, experimentSelectorPanel, NO_TOOL_TIP, 0);
            tabbedPane.setSelectedIndex(0);
        }
        if (cbDistanceAnalysis.isSelected()) {
            tabbedPane.insertTab("Distance", NO_ICON, distancePanel, NO_TOOL_TIP, 0);
            tabbedPane.setSelectedIndex(0);
        }
        if (cbAnalysis.isSelected()) {
            tabbedPane.insertTab("Analysis", NO_ICON, arrayViewer.getTreeScrollPane(), NO_TOOL_TIP, 0);
            tabbedPane.setSelectedIndex(0);
        }
        if (cbMicroArray.isSelected()) {
            tabbedPane.insertTab("Microarray", NO_ICON, arrayPanel, NO_TOOL_TIP, 0);
            tabbedPane.setSelectedIndex(0);
        }
    }

    public void showWaypointsTab(boolean bl) {
        if (bl && !cbWaypoints.isSelected()) {
            cbWaypoints.doClick();
        }
    }

    public JRadioButtonMenuItem getRbArrowShape() {
        return this.rb_arrowShape;
    }

    public JRadioButtonMenuItem getRbBoxShape() {
        return this.rb_boxShape;
    }

    public JRadioButtonMenuItem getFullLegend() {
        return this.fullLegend;
    }

    public JRadioButtonMenuItem getPartialLegend() {
        return this.partialLegend;
    }

    public void setMainFrame(JFrame jFrame) {
        main_frame = jFrame;
    }

    public void enableInitiallyDisabledViewMenus() {
        this.refreshItem.setEnabled(true);
        this.textMenu.setEnabled(true);
        this.chartMenu.setEnabled(true);
        cbFeatureEdit.setEnabled(true);
        cbRestr_checkBox.setEnabled(true);
    }

    public void enableViewMenus(String string) {
        if (string == "Frame") {
            this.textMenu.setEnabled(true);
            this.rb_arrowShape.setEnabled(true);
            this.rb_boxShape.setEnabled(true);
            this.fullLegend.setEnabled(true);
            this.partialLegend.setEnabled(true);
            cbFeatureEdit.setEnabled(true);
            cbShape.setEnabled(true);
            cbOrientation.setEnabled(true);
            cbWaypoints.setEnabled(true);
            cbRestr_checkBox.setEnabled(true);
            this.configureSitesItem.setEnabled(true);
            this.configureLanes.setEnabled(true);
        } else if (string == "Text") {
            this.textMenu.setEnabled(true);
            this.rb_arrowShape.setEnabled(false);
            this.rb_boxShape.setEnabled(false);
            this.fullLegend.setEnabled(true);
            this.partialLegend.setEnabled(true);
            cbFeatureEdit.setEnabled(true);
            cbShape.setEnabled(false);
            cbOrientation.setEnabled(true);
            cbWaypoints.setEnabled(true);
            cbAG_checkBox.setEnabled(true);
            cbGC_checkBox.setEnabled(true);
            gcSkew_checkBox.setEnabled(true);
            cbRestr_checkBox.setEnabled(true);
            this.configureSitesItem.setEnabled(true);
            this.configureLanes.setEnabled(false);
        } else if (string == "Chart") {
            this.textMenu.setEnabled(false);
            this.rb_arrowShape.setEnabled(false);
            this.rb_boxShape.setEnabled(false);
            this.fullLegend.setEnabled(false);
            this.partialLegend.setEnabled(false);
            cbFeatureEdit.setEnabled(false);
            cbShape.setEnabled(false);
            cbOrientation.setEnabled(false);
            cbWaypoints.setEnabled(false);
            cbAG_checkBox.setEnabled(false);
            cbGC_checkBox.setEnabled(false);
            gcSkew_checkBox.setEnabled(false);
            cbRestr_checkBox.setEnabled(false);
            this.configureSitesItem.setEnabled(false);
            this.configureLanes.setEnabled(false);
        } else {
            System.err.println("=> ViewMenuManager.enableViewMenuItems(): " + string + "is not a valid view mode group; doing nothing");
        }
    }

    static {
        NO_ICON = null;
        NO_TOOL_TIP = null;
    }
}

