/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.microarray.MicroarrayFunctions;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.util.Enumeration;

public class AnalysisMonitor {
    private static AbstractLinearGraphics alg;
    private static BluejayDObjectList dlist;
    private static MicroarrayFunctions microArrayFunctions;
    private static boolean clusterDataShown;
    private static boolean distanceAnalysisShown;
    private static boolean clusterLegendInfoShown;
    private int[] shownClusterIndices = null;

    public boolean isMicroArrayElementPaintable(String string) {
        return this.isMicroArrayElementPaintable(string, dlist.getArrayViewer().getCurrentSlide());
    }

    public boolean isMicroArrayElementPaintable(String string, int n) {
        boolean bl = true;
        try {
            Object v = alg.getxPtrToGBMap().get(string);
            Integer n2 = (Integer)dlist.getArrayViewer().getGBToLocMap().get(v);
            float f = dlist.getArrayViewer().getLogRatio(n2, n);
            if ((double)f < dlist.getArrayViewer().getHighExpressionBoundary() && (double)f > dlist.getArrayViewer().getLowExpressionBoundary()) {
                if (Debug.DEBUG) {
                    System.err.println("##### Ratio - false");
                }
                bl = false;
            }
            if (clusterDataShown && this.shownClusterIndices != null && bl) {
                bl = false;
                for (int i = 0; i < this.shownClusterIndices.length; ++i) {
                    if (n2 != this.shownClusterIndices[i]) continue;
                    bl = true;
                    break;
                }
            }
            if (distanceAnalysisShown && bl) {
                if (Debug.DEBUG) {
                    System.err.println("##### ACA Chekcing distanceAnalysis");
                }
                String string2 = microArrayFunctions.getDistanceWidget().getElementIDLabel().getText();
                Integer n3 = (Integer)dlist.getArrayViewer().getGBToLocMap().get(string2);
                int n4 = dlist.getArrayViewer().getMenuBar().getDistanceMenu().getDistanceFunction();
                double d = new Double(microArrayFunctions.getDistanceWidget().getSlider().getValue()) / 1000.0;
                bl = microArrayFunctions.getDistanceWidget().isWithinBounds(new Float(d).floatValue(), n2, n3, n4);
            }
            if (Debug.DEBUG) {
                System.err.println("##### ACA Printable :: " + bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void setALG(AbstractLinearGraphics abstractLinearGraphics) {
        alg = abstractLinearGraphics;
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    public void setMicroArrayFunctions(MicroarrayFunctions microarrayFunctions) {
        microArrayFunctions = microarrayFunctions;
    }

    public void setClusterDataShown(boolean bl, int[][] nArray) {
        if (nArray == null) {
            this.setClusterDataShown(bl, (int[])null);
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null) continue;
            n += nArray[i].length;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null) continue;
            System.arraycopy(nArray[i], 0, nArray2, n2, nArray[i].length);
            n2 += nArray[i].length;
        }
        this.setClusterDataShown(bl, nArray2);
    }

    public void setClusterDataShown(boolean bl, int[] nArray) {
        clusterDataShown = bl;
        this.shownClusterIndices = nArray;
        if (!bl) {
            Enumeration enumeration = microArrayFunctions.getClassColorMappingTable().keys();
            while (enumeration.hasMoreElements()) {
                dlist.getAbstractLinearGraphics().getLegend().removeItem(enumeration.nextElement());
            }
            dlist.getAbstractLinearGraphics().getLegend().sort();
            microArrayFunctions.resetMicroArrayLegendHashTables();
            clusterLegendInfoShown = false;
        }
    }

    public void setDistanceAnalysisShown(boolean bl) {
        distanceAnalysisShown = bl;
    }

    public boolean isDistanceAnalysisShown() {
        return distanceAnalysisShown;
    }

    public boolean isClusterDataShown() {
        return clusterDataShown;
    }

    public void setClustersInLegend(boolean bl) {
        clusterLegendInfoShown = bl;
    }

    public boolean isClustersInLegend() {
        return clusterLegendInfoShown;
    }

    static {
        clusterDataShown = false;
        distanceAnalysisShown = false;
        clusterLegendInfoShown = false;
    }
}

