/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.util.FloatMatrix;

public class DistanceSliderWidget
extends JPanel
implements ChangeListener,
MouseListener {
    private static JLabel elementIDLabel;
    private static JLabel elementID;
    private static JLabel distanceForumlaLabel;
    private static JLabel distanceFormula;
    private static JSlider distanceSlider;
    private static AbstractLinearGraphics alg;
    private static BluejayDObjectList dlist;
    private float factor = 1.0f;
    private boolean absolute = false;
    private FloatMatrix experiment;

    public DistanceSliderWidget() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(400, 70));
        this.setMinimumSize(new Dimension(200, 70));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(5, 20));
        jPanel.setMinimumSize(new Dimension(5, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel();
        jLabel.setText("Right-click on a microarray element");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("to perform the analysis");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)jLabel2, gridBagConstraints);
        jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(5, 20));
        jPanel.setMinimumSize(new Dimension(5, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        distanceForumlaLabel = new JLabel();
        distanceForumlaLabel.setText("  Distance : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)distanceForumlaLabel, gridBagConstraints);
        distanceFormula = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)distanceFormula, gridBagConstraints);
        elementIDLabel = new JLabel();
        elementIDLabel.setText("  Gene : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)elementIDLabel, gridBagConstraints);
        elementID = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)elementID, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(5, 20));
        jPanel2.setMinimumSize(new Dimension(5, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel2, gridBagConstraints);
        distanceSlider = new JSlider(0, -3000, 3000, 0);
        distanceSlider.setPaintLabels(true);
        distanceSlider.setPaintTicks(true);
        distanceSlider.addMouseListener(this);
        distanceSlider.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)distanceSlider, gridBagConstraints);
    }

    public void resetWidget() {
        distanceSlider.setValue(0);
        dlist.getAnalysisMonitor().setDistanceAnalysisShown(false);
    }

    public JLabel getElementIDLabel() {
        return elementID;
    }

    public JLabel getDistanceFormulaLabel() {
        return distanceFormula;
    }

    public JSlider getSlider() {
        return distanceSlider;
    }

    public void setElementIDLabel(JLabel jLabel) {
        elementIDLabel = jLabel;
    }

    public void setDistanceFormulaLabel(JLabel jLabel) {
        distanceFormula = jLabel;
    }

    public void setALG(AbstractLinearGraphics abstractLinearGraphics) {
        alg = abstractLinearGraphics;
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        JSlider jSlider = (JSlider)mouseEvent.getSource();
        if (jSlider.hashCode() == distanceSlider.hashCode()) {
            this.firePropertyChange("distanceSlider", new Double(-1000.0), new Double(distanceSlider.getValue()));
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public boolean isWithinBounds(float f, int n, int n2, int n3) {
        float f2 = ExperimentUtil.geneDistance(this.experiment, null, n, n2, n3, this.factor, this.absolute);
        return f2 <= f;
    }

    public float[] getMaxDistance(int n) {
        float[] fArray = new float[2];
        this.experiment = dlist.getArrayViewer().getData().getExperiment().getMatrix();
        int[] nArray = this.getRowsUsed();
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f = ExperimentUtil.geneDistance(this.experiment, null, nArray[i], nArray[j], n, this.factor, this.absolute);
                if (Debug.DEBUG) {
                    System.out.println("(" + nArray[i] + "," + nArray[j] + ") : " + f);
                }
                if (i == 0 && j == 0) {
                    fArray[0] = f;
                    fArray[1] = f;
                }
                if (f < fArray[0]) {
                    fArray[0] = f;
                }
                if (!(f > fArray[1])) continue;
                fArray[1] = f;
            }
        }
        return fArray;
    }

    public int[] getRowsUsed() {
        Object[] objectArray = alg.getxPtrToGBMap().values().toArray();
        int[] nArray = new int[objectArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            Integer n2;
            if (objectArray[i] == null || (n2 = (Integer)dlist.getArrayViewer().getGBToLocMap().get(objectArray[i])) == null) continue;
            nArray[n++] = n2;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public void prepareDistanceSliderWidget(String string) {
        IDistanceMenu iDistanceMenu = alg.getArrayViewer().getMenuBar().getDistanceMenu();
        this.resetWidget();
        if (alg.getxPtrToGBMap().get(string) != null) {
            dlist.getAnalysisMonitor().setDistanceAnalysisShown(true);
            int n = iDistanceMenu.getDistanceFunction();
            String string2 = iDistanceMenu.getFunctionName(n);
            String string3 = (String)alg.getxPtrToGBMap().get(string);
            this.getElementIDLabel().setText(string3);
            this.getDistanceFormulaLabel().setText(string2);
            float[] fArray = this.getMaxDistance(n);
            if (!new Float(fArray[0]).isNaN() && !new Float(fArray[1]).isNaN()) {
                BigDecimal bigDecimal = new BigDecimal(Float.toString(fArray[0])).setScale(3, 1);
                BigDecimal bigDecimal2 = new BigDecimal(Float.toString(fArray[1])).setScale(3, 0);
                this.getSlider().setEnabled(true);
                this.getSlider().setMinimum(new Float((double)bigDecimal.floatValue() * 1000.0).intValue());
                this.getSlider().setMaximum(new Float((double)bigDecimal2.floatValue() * 1000.0).intValue());
                this.getSlider().setMajorTickSpacing(new Double((bigDecimal2.doubleValue() - bigDecimal.doubleValue()) * 1000.0 / 4.0).intValue());
                int n2 = new Float(fArray[0] * 1000.0f).intValue();
                int n3 = new Float(fArray[1] * 1000.0f).intValue();
                Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
                hashtable.put(new Integer(n2), new JLabel(bigDecimal.toString()));
                hashtable.put(new Integer(n3), new JLabel(bigDecimal2.toString()));
                this.getSlider().setLabelTable(hashtable);
                this.performDistanceAnalysis(this.getSlider().getValue());
                dlist.refreshDisplay();
            } else {
                this.getSlider().setEnabled(false);
            }
        }
    }

    public void performDistanceAnalysis(float f) {
        String string = this.getElementIDLabel().getText();
        if (dlist.getArrayViewer().getGBToLocMap().containsKey(string)) {
            int n = (Integer)dlist.getArrayViewer().getGBToLocMap().get(string);
            int[] nArray = this.getRowsUsed();
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = dlist.getArrayViewer().getMenuBar().getDistanceMenu().getDistanceFunction();
                boolean bl = this.isWithinBounds(f, n, nArray[i], n3);
                Object v = dlist.getArrayViewer().getLocToGbMap().get(new Integer(nArray[i]));
                String string2 = (String)alg.getGBToXPtrMap().get(v);
                if (Debug.DEBUG) {
                    System.err.println(bl);
                }
                if (Debug.DEBUG) {
                    System.err.println();
                }
                if (bl) {
                    dlist.setVisibilityForNode(string2, 112);
                    continue;
                }
                dlist.setVisibilityForNode(string2, 113);
            }
        }
    }
}

