/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import ca.ucalgary.bluejay.gui.microarray.CustomClusterGenerator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCInfoViewer;
import org.tigr.util.FloatMatrix;

public class ManualGUI
implements IClusterGUI {
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private boolean clusterGenes;
    private FloatMatrix expMatrix;
    private int number_of_samples;
    private int validN;

    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Vector vector = CustomClusterGenerator.getClusters();
        int n = vector.size();
        this.clusterGenes = true;
        if (n < 1) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of clusters must be greater than 0!", "Error", 0);
            return null;
        }
        this.experiment = iFramework.getData().getExperiment();
        this.expMatrix = this.experiment.getMatrix();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        this.clusters = new int[n][];
        for (int i = 0; i < n; ++i) {
            this.clusters[i] = (int[])vector.elementAt(i);
        }
        this.means = this.getMeans(this.clusters);
        this.variances = this.getVariances(this.clusters, this.means);
        GeneralInfo generalInfo = new GeneralInfo();
        generalInfo.clusters = n;
        return this.createResultTree(generalInfo);
    }

    private FloatMatrix getMeans(int[][] nArray) {
        FloatMatrix floatMatrix = new FloatMatrix(nArray.length, this.number_of_samples);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i].length;
            for (int j = 0; j < this.number_of_samples; ++j) {
                float f = 0.0f;
                this.validN = 0;
                for (int k = 0; k < n; ++k) {
                    float f2 = this.expMatrix.get(nArray[i][k], j);
                    if (Float.isNaN(f2)) continue;
                    f += f2;
                    ++this.validN;
                }
                floatMatrix.A[i][j] = f / (float)this.validN;
            }
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(int[][] nArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(nArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(int[] nArray, int n, float f) {
        int n2 = nArray.length;
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get(nArray[i], n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(int[] nArray, int n, float f) {
        if (this.validN > 1) {
            return (float)Math.sqrt(this.getSampleNormalizedSum(nArray, n, f) / (float)(this.validN - 1));
        }
        return 0.0f;
    }

    private DefaultMutableTreeNode createResultTree(GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("Manual clustering - genes") : new DefaultMutableTreeNode("Manual clustering - experiments");
        this.addResultNodes(defaultMutableTreeNode, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        JPanel jPanel = this.clusterGenes ? new KMCExperimentViewer(this.experiment, this.clusters) : new KMCExperimentClusterViewer(this.experiment, this.clusters);
        for (int i = 0; i < this.clusters.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)((Object)jPanel), new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", new KMCInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Experiments in Clusters (#,%)", new KMCInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            KMCCentroidViewer kMCCentroidViewer = new KMCCentroidViewer(this.experiment, this.clusters);
            kMCCentroidViewer.setMeans(this.means.A);
            kMCCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCCentroidViewer, new CentroidUserObject(i, 1))));
            }
            KMCCentroidsViewer kMCCentroidsViewer = new KMCCentroidsViewer(this.experiment, this.clusters);
            kMCCentroidsViewer.setMeans(this.means.A);
            kMCCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCCentroidsViewer, new Integer(1))));
        } else {
            KMCExperimentCentroidViewer kMCExperimentCentroidViewer = new KMCExperimentCentroidViewer(this.experiment, this.clusters);
            kMCExperimentCentroidViewer.setMeans(this.means.A);
            kMCExperimentCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCExperimentCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCExperimentCentroidViewer, new CentroidUserObject(i, 1))));
            }
            KMCExperimentCentroidsViewer kMCExperimentCentroidsViewer = new KMCExperimentCentroidsViewer(this.experiment, this.clusters);
            kMCExperimentCentroidsViewer.setMeans(this.means.A);
            kMCExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCExperimentCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCExperimentCentroidsViewer, new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Clusters: " + generalInfo.clusters));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private class GeneralInfo {
        public int clusters = 1;

        private GeneralInfo() {
        }
    }
}

